/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label;

import com.google.common.collect.Maps;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hrcs.common.constants.label.FunctionConstants;
import kd.hr.hrcs.common.utils.TreeViewSearchTool;

public class LabelValueRuleFunctionPlugin
extends HRBaseDataCommonEdit
implements FunctionConstants,
SearchEnterListener {
    private FunctionTypes commonFunctionTypes = null;
    private static final String FUNC_FILE_BOS_COMMON = "/label_function/LabelFunctionTypes.xml";
    private boolean changeFlag;
    private static final String KEY_DISPLAY_EXPR = "displayExpression";
    private static final String CHANGE_FLAG = "changeFlag";
    private static final String CONTROL_EXPRESSION = "expressioncontrol";
    private static final String CONTROL_TARGET_TYPE_GROUP = "targettypegroup";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.commonFunctionTypes == null) {
            this.commonFunctionTypes = LabelValueRuleFunctionPlugin.initAllFunctions();
        }
        this.constructFunctionTreeView();
        this.getPageCache().put(CHANGE_FLAG, "true");
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        TreeView tv1 = (TreeView)this.getView().getControl("functiontreeview");
        tv1.addTreeNodeClickListener(this.getTreeNodeClickListener());
        Search search = (Search)this.getControl("searchfunction");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeView tv = (TreeView)this.getView().getControl("functiontreeview");
        TreeViewSearchTool.search((String)searchText, (TreeView)tv, (IPageCache)this.getPageCache(), (String)"functiontreeview");
    }

    private void constructFunctionTreeView() {
        TreeView tv = (TreeView)this.getView().getControl("functiontreeview");
        String rootId = "0";
        TreeNode rootNode = new TreeNode(null, "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"LabelValueRuleFunctionPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), true);
        rootNode.setIsOpened(true);
        for (FunctionGroup group : this.commonFunctionTypes.getFunctionGroups()) {
            if (group == null) continue;
            TreeNode tn1 = new TreeNode("0", group.getId(), group.getName().getLocaleValue(), true);
            tn1.setIsOpened(true);
            for (FunctionType functionType : this.commonFunctionTypes.getFunctionTypes()) {
                if (!HRStringUtils.equals((String)group.getId(), (String)functionType.getGroupId())) continue;
                TreeNode tn2 = new TreeNode(group.getId(), functionType.getId(), functionType.getName().getLocaleValue(), false);
                tn2.setLeaf(true);
                tn1.addChild(tn2);
            }
            rootNode.addChild(tn1);
        }
        tv.addNode(rootNode);
        this.getPageCache().put(tv.getKey(), SerializationUtils.toJsonString((Object)rootNode));
    }

    private TreeNodeClickListener getTreeNodeClickListener() {
        final OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                if (OperationStatus.VIEW.equals((Object)status)) {
                    return;
                }
                Optional function = LabelValueRuleFunctionPlugin.this.findFunctionByNodeId((String)evt.getNodeId());
                if (!function.isPresent()) {
                    return;
                }
                LabelValueRuleFunctionPlugin.this.showFunctionMsg((FunctionType)function.get());
                String locked = LabelValueRuleFunctionPlugin.this.getPageCache().get("isNotLocked");
                if (locked != null && !Boolean.parseBoolean(locked)) {
                    return;
                }
                HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
                dataMap.put(LabelValueRuleFunctionPlugin.KEY_DISPLAY_EXPR, " " + ((FunctionType)function.get()).getDef() + " ");
                LabelValueRuleFunctionPlugin.this.changeFlag = Boolean.parseBoolean(LabelValueRuleFunctionPlugin.this.getPageCache().get(LabelValueRuleFunctionPlugin.CHANGE_FLAG));
                dataMap.put(LabelValueRuleFunctionPlugin.CHANGE_FLAG, LabelValueRuleFunctionPlugin.this.changeFlag);
                CustomControl customcontrol = (CustomControl)LabelValueRuleFunctionPlugin.this.getView().getControl(LabelValueRuleFunctionPlugin.CONTROL_EXPRESSION);
                customcontrol.setData((Object)dataMap);
                LabelValueRuleFunctionPlugin.this.changeFlag = !LabelValueRuleFunctionPlugin.this.changeFlag;
                LabelValueRuleFunctionPlugin.this.getPageCache().put(LabelValueRuleFunctionPlugin.CHANGE_FLAG, String.valueOf(LabelValueRuleFunctionPlugin.this.changeFlag));
            }
        };
    }

    private void showFunctionMsg(FunctionType function) {
        String[] descSp = function.getDesc().getLocaleValue().split("\\\\n");
        this.getModel().setValue("funcdescription", (Object)descSp[0]);
        this.getModel().setValue("format", (Object)descSp[1]);
        this.getModel().setValue("param", (Object)descSp[2]);
        this.getModel().setValue("example", (Object)descSp[3]);
    }

    private Optional<FunctionType> findFunctionByNodeId(String nodeId) {
        if (this.commonFunctionTypes == null) {
            this.commonFunctionTypes = LabelValueRuleFunctionPlugin.initAllFunctions();
        }
        return this.commonFunctionTypes.getFunctionTypes().stream().filter(functionType -> functionType != null && HRStringUtils.equals((String)functionType.getId(), (String)nodeId)).findFirst();
    }

    protected List<String> getUnCheckField() {
        List uncheckFieldList = super.getUnCheckField();
        uncheckFieldList.add("funcdescription");
        uncheckFieldList.add("format");
        uncheckFieldList.add("param");
        uncheckFieldList.add("example");
        uncheckFieldList.add(CONTROL_TARGET_TYPE_GROUP);
        return uncheckFieldList;
    }

    public static FunctionTypes initAllFunctions() {
        FunctionTypes functionTypes = new FunctionTypes();
        URL commonFunctionUrl = FunctionTypes.class.getResource(FUNC_FILE_BOS_COMMON);
        FunctionTypes sysCommonFunctionTypes = FunctionTypes.get((URL)commonFunctionUrl, (boolean)false);
        functionTypes.getFunctionGroups().addAll(sysCommonFunctionTypes.getFunctionGroups());
        functionTypes.getFunctionTypes().addAll(sysCommonFunctionTypes.getFunctionTypes());
        return functionTypes;
    }
}

