/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label.dataprovider;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class LabelValueProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(LabelValueProvider.class);

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows == null || rows.size() == 0) {
            return rows;
        }
        List labelIdList = rows.stream().map(item -> item.getLong("label.id")).collect(Collectors.toList());
        LOGGER.info(String.format(" label numbers [%s]", labelIdList == null ? 0 : labelIdList.size()));
        HRBaseServiceHelper valueServiceHelper = new HRBaseServiceHelper("hrcs_labelvalue");
        QFilter[] filters = new QFilter[]{new QFilter("label", "in", labelIdList)};
        DynamicObject[] valueList = valueServiceHelper.query("label,value", filters);
        Map<Long, List<DynamicObject>> labelValueMap = Arrays.stream(valueList).collect(Collectors.groupingBy(item -> item.getLong("label.id")));
        LOGGER.info("program add the field,  labelbalue");
        DynamicObjectType dynamicObjectType = rows.getDynamicObjectType();
        dynamicObjectType.registerProperty("labelvalue", String.class, (Object)"", false);
        for (DynamicObject row : rows) {
            row.set("labelvalue", (Object)labelValueMap.get(row.getLong("label.id")).stream().map(r -> r.getString("value")).collect(Collectors.joining(",")));
        }
        return rows;
    }
}

