/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label.task;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.hr.hrcs.bussiness.service.label.excel.LabelTemplateExcelWriter;
import kd.hr.hrcs.common.constants.label.LblStrategyConstants;
import kd.hr.hrcs.formplugin.web.perm.init.task.AbstractPermTask;
import org.apache.commons.lang3.tuple.Triple;

public class LabelTemplateExportTask
extends AbstractPermTask
implements LblStrategyConstants {
    @Override
    protected void doExecute(RequestContext requestContext, Map<String, Object> map, Consumer<Triple<String, Long, Long>> feedbackProgress) throws KDException {
        DynamicObject log = this.buildExportLogObj(map);
        String tempUrl = null;
        try {
            tempUrl = this.downloadTemplate(feedbackProgress, map);
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream inputStream = tempFileCache.getInputStream(tempUrl);
            String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6253\u6807\u6570\u636e\u6a21\u677f%s", (String)"LabelTemplateExportTask_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ".xlsx");
            RequestContext rc = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)"hrcs", (String)("hrcs_lblstrategy" + UUID.randomUUID().toString()), (String)fileName);
            FileService service = FileServiceFactory.getAttachmentFileService();
            String url = service.upload(new FileItem(fileName, path, inputStream));
            log.set("downloadurl", (Object)UrlService.getAttachmentFullUrl((String)url));
            log.set("complete", (Object)1);
        }
        catch (Exception e) {
            log.set("logs", (Object)e.getMessage());
            log.set("complete", (Object)0);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[]{null});
        }
        finally {
            log.set("total", (Object)1);
            this.saveExportLog(log);
            HashMap data = Maps.newHashMapWithExpectedSize((int)1);
            data.put("logid", log.getPkValue());
            data.put("exportUrl", tempUrl);
            ExecutorService.getInstance().getObjectFactory().getTaskDao().updateCustomData(this.taskId, (Map)data);
        }
    }

    private String downloadTemplate(Consumer<Triple<String, Long, Long>> feedbackProgress, Map<String, Object> map) throws IOException {
        feedbackProgress.accept((Triple<String, Long, Long>)Triple.of((Object)ResManager.loadKDString((String)"\u4e0b\u8f7d\u4e2d", (String)"PermSheetHelper_63", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)90L));
        LabelTemplateExcelWriter writer = new LabelTemplateExcelWriter(map);
        writer.addDecSheet(ResManager.loadKDString((String)"\u5bfc\u5165\u8bf4\u660e", (String)"LabelTemplateExportTask_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        writer.addDataSheet(ResManager.loadKDString((String)"\u6253\u6807\u6570\u636e", (String)"LabelTemplateExportTask_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        return writer.writeFile(ResManager.loadKDString((String)"\u6253\u6807\u6570\u636e\u6a21\u677f", (String)"LabelTemplateExportTask_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject buildExportLogObj(Map<String, Object> map) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject obj = (DynamicObject)objType.createInstance();
        obj.set("bizobject", map.get("entityname"));
        obj.set("billstatus", (Object)"C");
        obj.set("exportstatus", (Object)"0");
        obj.set("createtime", (Object)TimeServiceHelper.now());
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_exportlog", obj, null);
        obj.set("billno", (Object)billno);
        obj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        return obj;
    }

    private void saveExportLog(DynamicObject log) {
        log.set("exportstatus", (Object)"1");
        log.set("finishtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((IDataEntityType)log.getDataEntityType(), (Object[])new DynamicObject[]{log});
    }
}

