/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.label.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LblStrategyServiceHelper;

public class LabelObjectTipUtil {
    public static List<String> getTips(DynamicObject[] dys, List<String> selectedFieldAlias, long lblObjId, boolean lblObjCfgRef, Map entityInfo) {
        Set<String> entityNumbers = Arrays.stream(dys).map(dy -> dy.getString("param.entitynumber")).collect(Collectors.toSet());
        Map<String, String> entityNameMap = LabelObjectTipUtil.getEntityNames(entityNumbers);
        Map<String, String[]> fieldDyMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getString("param.fieldalias"), dy -> {
            String fieldAlias = dy.getString("param.fieldalias");
            String fieldName = dy.getString("param.fieldname");
            String entityNumber = dy.getString("param.entitynumber");
            String entityName = (String)entityNameMap.get(entityNumber);
            if (fieldAlias.startsWith(entityNumber + "\u03b4")) {
                entityName = entityName + fieldAlias.replaceFirst(entityNumber + "\u03b4", "").split("\\.")[0];
            }
            return new String[]{entityName, fieldName};
        }, (x, y) -> x));
        ArrayList<DynamicObject> labelRef = new ArrayList<DynamicObject>(dys.length);
        ArrayList<DynamicObject> policyRef = new ArrayList<DynamicObject>(dys.length);
        for (DynamicObject dy2 : dys) {
            if (selectedFieldAlias.contains(dy2.getString("param.fieldalias"))) continue;
            if ("10".equals(dy2.getString("source"))) {
                labelRef.add(dy2);
                continue;
            }
            policyRef.add(dy2);
        }
        Map<Object, Object> fieldLabelNameMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(labelRef)) {
            fieldLabelNameMap = labelRef.stream().collect(Collectors.toMap(dy -> dy.getString("param.fieldalias"), dy -> Lists.newArrayList((Object[])new String[]{dy.getString("label.name")}), (newValueList, oldValueList) -> {
                oldValueList.addAll(newValueList);
                return oldValueList;
            }));
        }
        HashMap fieldPolicyNumberMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(policyRef)) {
            Map<String, List> fieldLabelIdMap = policyRef.stream().collect(Collectors.toMap(dy -> dy.getString("param.fieldalias"), dy -> Lists.newArrayList((Object[])new String[]{dy.getString("label.id")}), (newValueList, oldValueList) -> {
                oldValueList.addAll(newValueList);
                return oldValueList;
            }));
            List labelIds = policyRef.stream().map(dy -> dy.getLong("label.id")).collect(Collectors.toList());
            DynamicObject[] policyDys = LblStrategyServiceHelper.getLabelPolicies((Long)lblObjId, labelIds);
            Map<String, String> labelPolicyMap = Arrays.stream(policyDys).collect(Collectors.toMap(dy -> dy.getString("label.id"), dy -> dy.getString("number")));
            for (Map.Entry<String, Object> entry : fieldLabelIdMap.entrySet()) {
                ArrayList<String> policyNumber = new ArrayList<String>(10);
                for (String labelId : (List)entry.getValue()) {
                    policyNumber.add(labelPolicyMap.get(labelId));
                }
                fieldPolicyNumberMap.put(entry.getKey(), policyNumber);
            }
        }
        ArrayList<String> tips = new ArrayList<String>(10);
        ArrayList<String> fieldLabelNameTips = new ArrayList<String>(10);
        ArrayList<String> fieldPolicyNumberTips = new ArrayList<String>(10);
        ArrayList<String> labelAndPolicyTips = new ArrayList<String>(10);
        for (Map.Entry<String, String[]> entry : fieldDyMap.entrySet()) {
            String msg;
            String key = entry.getKey();
            String entityName = entry.getValue()[0];
            String fieldName = entry.getValue()[1];
            if (fieldLabelNameMap.containsKey(key) && fieldPolicyNumberMap.containsKey(key)) {
                msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e1a\u52a1\u5bf9\u8c61\u4e2d\u7684\u201c%2$s\u201d\u5b57\u6bb5\u5df2\u88ab\u201c%3$s\u201d\u6807\u7b7e\uff0c\u4ee5\u53ca\u201c%4$s\u201d\u6253\u6807\u7b56\u7565\u5f15\u7528\u3002", (String)"LabelObjectPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), entityName, fieldName, LabelObjectTipUtil.list2String((List)fieldLabelNameMap.get(key)), LabelObjectTipUtil.list2String((List)fieldPolicyNumberMap.get(key)));
                labelAndPolicyTips.add(msg);
                continue;
            }
            if (fieldLabelNameMap.containsKey(key)) {
                msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e1a\u52a1\u5bf9\u8c61\u4e2d\u7684\u201c%2$s\u201d\u5b57\u6bb5\u5df2\u88ab\u201c%3$s\u201d\u6807\u7b7e\u5f15\u7528\u3002", (String)"LabelObjectPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), entityName, fieldName, LabelObjectTipUtil.list2String((List)fieldLabelNameMap.get(key)));
                fieldLabelNameTips.add(msg);
                continue;
            }
            if (!fieldPolicyNumberMap.containsKey(key)) continue;
            msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e1a\u52a1\u5bf9\u8c61\u4e2d\u7684\u201c%2$s\u201d\u5b57\u6bb5\u5df2\u88ab\u201c%3$s\u201d\u6253\u6807\u7b56\u7565\u5f15\u7528\u3002", (String)"LabelObjectPlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), entityName, fieldName, LabelObjectTipUtil.list2String((List)fieldPolicyNumberMap.get(key)));
            fieldPolicyNumberTips.add(msg);
        }
        if (lblObjCfgRef) {
            String entityNameAlias = (String)entityInfo.get("displayName");
            String string = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e1a\u52a1\u5bf9\u8c61\u4e2d\u7684\u5b57\u6bb5\u5df2\u88ab\u7528\u4e8e\u6253\u6807\u80fd\u529b\u914d\u7f6e\u3002", (String)"LabelObjectPlugin_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), entityNameAlias);
            tips.add(string);
        }
        tips.addAll(fieldLabelNameTips);
        tips.addAll(fieldPolicyNumberTips);
        tips.addAll(labelAndPolicyTips);
        return tips;
    }

    private static String list2String(List<String> stringList) {
        return String.join((CharSequence)"\",\"", stringList);
    }

    private static Map<String, String> getEntityNames(Set<String> entityNumbers) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject[] dys = helper.query("name,number", new QFilter[]{new QFilter("number", "in", entityNumbers)});
        return Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString("name")));
    }
}

