/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.managestrategy;

import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public abstract class ManageStrategyQueryPlugin
extends HRDataBaseList {
    private static final String ADMINORG_NUMBER = "orgteam_number";
    private static final String BILLLIST = "billlistap";
    private static final String BAR_VIEWCHANGE = "bar_viewchange";
    private boolean showDisable = false;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{BAR_VIEWCHANGE});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        String pageIdSuffix = "";
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            Set ids = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            pageIdSuffix = ids.toString();
        }
        if (BAR_VIEWCHANGE.equals(key)) {
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setBillFormId(this.getChangeRecordPageName());
            String pageId = HRStringUtils.isEmpty((String)pageIdSuffix) ? this.getView().getPageId() + "_" + formShowParameter.getBillFormId() + pageIdSuffix : "strategyhis_" + pageIdSuffix;
            formShowParameter.setPageId(pageId);
            formShowParameter.setListSelectedRowCollection(selectedRows);
            formShowParameter.getCustomParams().put("chkshowdisable", this.showDisable);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List qFilters = event.getQFilters();
        if (!CollectionUtils.isEmpty((Collection)qFilters)) {
            for (QFilter filter : qFilters) {
                if (filter == null || !filter.getProperty().equals("orgteam.enable")) continue;
                this.showDisable = !Boolean.parseBoolean(filter.getValue().toString());
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)ADMINORG_NUMBER, (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            this.clickRow();
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        this.clickRow();
    }

    private void clickRow() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        if (selectedRow == null) {
            return;
        }
        this.showManageStrategyEditForm(selectedRow.getPrimaryKeyValue());
    }

    private void showManageStrategyEditForm(Object pkId) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCloseCallBack(this.genClosedCallBack((IFormPlugin)this, OperationStatus.VIEW.name()));
        formShowParameter.setPkId(pkId);
        formShowParameter.setFormId(this.getEntityName());
        String pageId = this.getView().getPageId() + "_" + formShowParameter.getFormId() + "_" + formShowParameter.getPkId();
        formShowParameter.setPageId(pageId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private CloseCallBack genClosedCallBack(IFormPlugin plugin, String actionId) {
        CloseCallBack closeCallBack = new CloseCallBack(plugin, actionId);
        return closeCallBack;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ((ListView)this.getView()).refresh();
    }

    public abstract String getEntityName();

    public abstract String getChangeRecordPageName();
}

