/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.managestrategy;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRAdminOrgTreeList;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;

@ExcludeFromJacocoGeneratedReport
public class ManageStrategyTreeListPlugin
extends HRAdminOrgTreeList
implements TabSelectListener,
TreeNodeClickListener {
    private static final String ADMINORG_ID = "adminorg.id";

    public static List<Long> getSubAdminOrgListNotIncludeGrand(List<Long> orgIds, boolean isEnabled) {
        QFilter[] filters;
        if (orgIds == null || orgIds.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter orgStructFilter = new QFilter("structproject", "=", (Object)ManageStrategyConstants.ADMINORG_STRUCT_PROJECT);
        QFilter filter = new QFilter("parentorg", "in", orgIds);
        filter = filter.or(new QFilter(ADMINORG_ID, "in", orgIds));
        if (isEnabled) {
            filters = new QFilter[]{filter, currentFilter, orgStructFilter};
        } else {
            QFilter enableFilter = new QFilter("adminorg.enable", "!=", (Object)"0");
            filters = new QFilter[]{filter, enableFilter, currentFilter, orgStructFilter};
        }
        DataSet dataSet = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryDataSet("ManageStrategyTreeListPlugin.getSubAdminOrgListNotIncludeGrand_query", ADMINORG_ID, filters);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        while (dataSet.hasNext()) {
            ids.add(dataSet.next().getLong(0));
        }
        return ids;
    }

    public static List<Long> getSubOrgIdIncludeGrand(List<Long> orgIds, Boolean isEnabled) {
        QFilter[] filters;
        if (orgIds == null || orgIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        QFilter orgIdFilter = new QFilter(ADMINORG_ID, "in", orgIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter orgStructFilter = new QFilter("structproject", "=", (Object)ManageStrategyConstants.ADMINORG_STRUCT_PROJECT);
        DynamicObject[] focusNodeDys = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").query("structlongnumber", new QFilter[]{orgIdFilter, currentFilter, orgStructFilter});
        if (focusNodeDys == null) {
            return new ArrayList<Long>();
        }
        for (DynamicObject focusNodeDy : focusNodeDys) {
            String longNumber = (String)focusNodeDy.get("structlongnumber");
            QFilter filter = new QFilter("structlongnumber", "like", (Object)(longNumber + "!" + "%"));
            orgIdFilter.or(filter);
        }
        if (isEnabled.booleanValue()) {
            filters = new QFilter[]{orgIdFilter, currentFilter, orgStructFilter};
        } else {
            QFilter enableFilter = new QFilter("adminorg.enable", "!=", (Object)"0");
            filters = new QFilter[]{orgIdFilter, currentFilter, orgStructFilter, enableFilter};
        }
        DataSet dataSet = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryDataSet("ManageStrategyTreeListPlugin.getSubOrgIdIncludeGrand_query", ADMINORG_ID, filters);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        while (dataSet.hasNext()) {
            ids.add(dataSet.next().getLong(0));
        }
        return ids;
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btntreefilter"});
        this.addClickListeners(new String[]{"btncardedit"});
        TreeView tv = (TreeView)this.getView().getControl("treeview");
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"chkshowdisable"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key)) {
            this.getPageCache().put("treeOrgIds", null);
            this.getPageCache().put("permorgids", null);
            this.getPageCache().put("permfilter", null);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        this.findParentNode();
        if ("btntreefilter".equals(control.getKey().toLowerCase(Locale.ROOT))) {
            this.showTreeFilterDialog();
        }
    }

    private void showTreeFilterDialog() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey("btntreefilter");
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("140px");
        cssValue.setHeight("50px");
        openStyle.setInlineStyleCss(cssValue);
        formShowParameter.setCloseCallBack(this.genClosedCallBack((IFormPlugin)this, "treefilteroperation"));
        formShowParameter.setFormId("hbp_orgtreefiter");
        String chkShowDisable = this.getPageCache().get("chkshowdisable");
        formShowParameter.setCustomParam("chkshowdisable", (Object)chkShowDisable);
        this.getView().showForm(formShowParameter);
    }

    private CloseCallBack genClosedCallBack(IFormPlugin plugin, String actionId) {
        return new CloseCallBack(plugin, actionId);
    }

    private void findParentNode() {
        String nodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId();
        QFilter filter = new QFilter(ADMINORG_ID, "=", (Object)Long.valueOf(nodeId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject parent = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOne("adminorg.parentorg", filters);
        if (parent != null) {
            String parentId = parent.getString("adminorg.parentorg.id");
            this.getPageCache().put("parentId", parentId);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if ("chkincludechild".equals(args.getProperty().getName())) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            if (StringUtils.isNotBlank((Object)currentNodeId)) {
                this.treeListView.getTreeView().treeNodeClick("", currentNodeId.toString());
            }
        } else if ("chkshowdisable".equals(args.getProperty().getName())) {
            boolean isShowDisable = Boolean.parseBoolean(this.getModel().getValue("chkshowdisable").toString());
            Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
            customParamMap.put("chkshowdisable", isShowDisable);
            this.treeListView.refresh();
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        if (this.getListFilterArrayByFilterParams(this.isShowDepartment(), this.isShowDisable(), this.isShowUnUsing()).size() > 0) {
            event.getQFilters().addAll(this.getListFilterArrayByFilterParams(this.isShowDepartment(), this.isShowDisable(), this.isShowUnUsing()));
        }
        event.setOrderBy("orgteam.level ASC,orgteam.boid ASC,entryentity.bussinessfield.index ASC");
    }

    private List<QFilter> getListFilterArrayByFilterParams(boolean isShowDepartment, boolean isShowDisable, boolean isShowUnUsing) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)20);
        if (!isShowUnUsing) {
            QFilter unUsingFilter = new QFilter("enable", "!=", (Object)"2");
            qFilters.add(unUsingFilter);
        }
        if (isShowDepartment == Boolean.FALSE) {
            HashSet<Long> idSet = new HashSet<Long>();
            idSet.add(Long.valueOf("1020"));
            idSet.add(Long.valueOf("1010"));
            idSet.add(Long.valueOf("1030"));
            QFilter companyTypeFilter = new QFilter("orgteam.orgtype.adminorgtypestd", "in", idSet);
            if (isShowDisable) {
                qFilters.add(companyTypeFilter);
            } else {
                QFilter filterShowEnable = new QFilter("orgteam.enable", "!=", (Object)"0");
                qFilters.add(companyTypeFilter);
                qFilters.add(filterShowEnable);
            }
        } else if (!isShowDisable) {
            QFilter filterShowEnable = new QFilter("orgteam.enable", "!=", (Object)"0");
            qFilters.add(filterShowEnable);
        }
        qFilters.add(new QFilter("orgteam.initstatus", "in", (Object)"2"));
        ArrayList dstatus = Lists.newArrayListWithExpectedSize((int)16);
        dstatus.add("1");
        dstatus.add("2");
        qFilters.add(new QFilter("orgteam.datastatus", "in", (Object)dstatus));
        return qFilters;
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent event) {
        String curNodeId = event.getNodeId().toString();
        boolean isRootNode = ((TreeListModel)event.getSource()).getRoot().getId().equals(curNodeId);
        return this.getBillListFilter(event.getNodeId().toString(), isRootNode);
    }

    private QFilter getBillListFilter(String nodeId, Boolean isRootNode) {
        QFilter listFilter = null;
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return listFilter;
        }
        List<Long> subOrgList = this.getSubOrgId(Collections.singletonList(Long.valueOf(nodeId)), this.isIncludeGrand(), this.isIncludeFreeze(), isRootNode);
        return new QFilter("orgteam.id", "in", subOrgList);
    }

    private boolean isIncludeGrand() {
        boolean isIncludeGrand = true;
        Object includeChild = this.getModel().getValue("chkincludechild");
        if (includeChild != null) {
            isIncludeGrand = Boolean.parseBoolean(includeChild.toString());
        }
        return isIncludeGrand;
    }

    public boolean isIncludeFreeze() {
        return true;
    }

    private List<Long> getSubOrgId(List<Long> orgIds, boolean isIncludeGrand, boolean isEnabled, Boolean isRootNode) {
        if (isIncludeGrand) {
            if (isRootNode.booleanValue()) {
                QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                QFilter orgStructFilter = new QFilter("structproject", "=", (Object)ManageStrategyConstants.ADMINORG_STRUCT_PROJECT);
                DataSet dataSet = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryDataSet("ManageStrategyTreeListPlugin.getSubAdminOrgListNotIncludeGrand_query", ADMINORG_ID, new QFilter[]{currentFilter, orgStructFilter});
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
                while (dataSet.hasNext()) {
                    ids.add(dataSet.next().getLong(0));
                }
                return ids;
            }
            return ManageStrategyTreeListPlugin.getSubOrgIdIncludeGrand(orgIds, isEnabled);
        }
        return ManageStrategyTreeListPlugin.getSubAdminOrgListNotIncludeGrand(orgIds, isEnabled);
    }

    public void tabSelected(TabSelectEvent arg0) {
    }

    public void refreshNode(RefreshNodeEvent event) {
        String nodeId = event.getNodeId().toString();
        if (this.hasNodes(nodeId)) {
            super.refreshNode(event);
        } else {
            String parentId = this.getPageCache().get("parentId");
            if (!HRStringUtils.isEmpty((String)parentId)) {
                event.setNodeId((Object)parentId);
                this.getTreeModel().setCurrentNodeId((Object)parentId);
                TreeNode parentNode = this.getTreeModel().refreshNode((Object)parentId);
                this.getTreeListView().getTreeView().updateNode(parentNode);
                this.getTreeListView().getTreeView().focusNode(parentNode);
                super.refreshNode(event);
            }
        }
    }

    private boolean hasNodes(String nodeId) {
        QFilter filter = new QFilter(ADMINORG_ID, "=", (Object)Long.valueOf(nodeId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection nodeCollection = QueryServiceHelper.query((String)this.getEntityName(), (String)"id", (QFilter[])filters);
        return nodeCollection.size() != 0;
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (!StringUtils.isBlank((CharSequence)searchText)) {
            List treeNodes;
            TreeNode rootNode = this.getTreeModel().getRoot();
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
            String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
            String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
            String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
            String oldSearchText = pageCache.get(oldSearchTextCacheKey);
            pageCache.put(oldSearchTextCacheKey, searchText);
            String matchNodesCache = pageCache.get(matchNodesCacheKey);
            TreeView treeView = this.getTreeListView().getTreeView();
            if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache)) {
                String searchNodesCache = pageCache.get(searchNodesCacheKey);
                treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            } else {
                treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, arg_0 -> ((ManageStrategyTreeListPlugin)this).loadChildNodes(arg_0), 100);
                pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
                if (treeNodes.isEmpty()) {
                    this.searchTreeNodesByKey(searchText, treeNodes);
                }
            }
            if (treeNodes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"StandardTreeListPlugin_6", (String)"bos-form-core", (Object[])new Object[0]));
            } else {
                if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                    int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                    if (indexCache == treeNodes.size()) {
                        indexCache = 0;
                    }
                    this.addNodeAndfocus(treeView, (TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.addNodeAndfocus(treeView, (TreeNode)treeNodes.get(0));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            }
        }
    }

    private void searchTreeNodesByKey(String searchText, List<TreeNode> treeNodes) {
        QFilter qFilter = new QFilter("adminorg.name", "ilike", (Object)(searchText + "%"));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryColl("adminorg.id,adminorg.name,adminorg,structlongnumber,parentorg", new QFilter[]{qFilter}, "structlongnumber");
        dynCol.forEach(dy -> treeNodes.add(this.createTreeNode((DynamicObject)dy, ADMINORG_ID, "adminorg.name", "structlongnumber")));
    }

    private void addNodeAndfocus(TreeView treeView, TreeNode searchTreeNode) {
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        String searchLongNumber = searchTreeNode.getLongNumber();
        if (StringUtils.isBlank((CharSequence)searchLongNumber)) {
            this.focusNode(treeView, searchTreeNode);
            return;
        }
        String[] split = searchTreeNode.getLongNumber().split("!");
        HashSet longNumber = Sets.newHashSetWithExpectedSize((int)split.length);
        for (int index = 0; index < split.length - 1; ++index) {
            longNumber.add(searchLongNumber.substring(0, searchLongNumber.indexOf(split[index + 1]) - 1));
        }
        QFilter qFilter = new QFilter("structlongnumber", "in", (Object)longNumber);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and("structproject", "=", (Object)ManageStrategyConstants.ADMINORG_STRUCT_PROJECT);
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryColl("adminorg.id,adminorg.name,adminorg,structlongnumber,parentorg", new QFilter[]{qFilter}, "structlongnumber");
        dynCol.forEach(dy -> {
            DynamicObjectCollection parentNodes = super.getTreeViewCollection("haos_adminorgstruct", dy.getString(ADMINORG_ID));
            parentNodes.forEach(childDy -> treeView.addNode(this.createTreeNode((DynamicObject)childDy, "id", "name", "longnumber")));
        });
        DynamicObjectCollection sameLevelNodes = super.getTreeViewCollection("haos_adminorgstruct", searchTreeNode.getParentid());
        sameLevelNodes.stream().filter(node -> !node.getString("id").equals(searchTreeNode.getId())).forEach(sameLevelNode -> {
            treeView.addNode(this.createTreeNode((DynamicObject)sameLevelNode, "id", "name", "longnumber"));
            DynamicObjectCollection childrenSecond = super.getTreeViewCollection("haos_adminorgstruct", sameLevelNode.getString("id"));
            childrenSecond.forEach(dy3 -> treeView.addNode(this.createTreeNode((DynamicObject)dy3, "id", "name", "longnumber")));
        });
        treeView.addNode(searchTreeNode);
        DynamicObjectCollection children = super.getTreeViewCollection("haos_adminorgstruct", searchTreeNode.getId());
        children.forEach(dy2 -> {
            treeView.addNode(this.createTreeNode((DynamicObject)dy2, "id", "name", "longnumber"));
            DynamicObjectCollection childrenSecond = super.getTreeViewCollection("haos_adminorgstruct", dy2.getString("id"));
            childrenSecond.forEach(dy3 -> treeView.addNode(this.createTreeNode((DynamicObject)dy3, "id", "name", "longnumber")));
        });
        this.focusNode(treeView, searchTreeNode);
    }

    private void focusNode(TreeView treeView, TreeNode searchTreeNode) {
        treeView.showNode(searchTreeNode.getId());
        treeView.treeNodeClick(searchTreeNode.getParentid(), searchTreeNode.getId());
        treeView.checkNode(searchTreeNode);
        treeView.focusNode(searchTreeNode);
    }

    private TreeNode createTreeNode(DynamicObject dy, String idKey, String nameKey, String longNumKey) {
        TreeNode treeNode = new TreeNode(dy.getString("parentorg"), dy.getString(idKey), dy.getString(nameKey));
        treeNode.setLongNumber(dy.getString(longNumKey));
        return treeNode;
    }

    protected boolean isShowDisable() {
        return true;
    }

    protected String getListPermProKey() {
        return "orgteam";
    }
}

