/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.service.operatelog.OperateLogService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

@ExcludeFromJacocoGeneratedReport
public class AdminSettingListPlugin
extends HRDataBaseList {
    public static final String ADD_ADMIN = "newadmin";
    private static final String ADMIN_USERID = "adminuserid";
    private static final String HRCS_APPID = PermCommonUtil.getAppIdFromSuspectedAppNum((String)"hrcs");

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "newadmin": {
                this.openBosUserF7();
                break;
            }
        }
    }

    private void openBosUserF7() {
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true, (int)0, (boolean)true);
        fsp.setCloseCallBack(new CloseCallBack());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setMultiSelect(true);
        fsp.setShowTitle(false);
        fsp.setHasRight(true);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_ADMIN));
        this.getView().showForm((FormShowParameter)fsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (!ADD_ADMIN.equalsIgnoreCase(event.getActionId())) {
            return;
        }
        Optional.ofNullable(returnData).ifPresent(data -> {
            ListSelectedRowCollection listRowData = (ListSelectedRowCollection)returnData;
            DynamicObjectCollection pubLogDys = new DynamicObjectCollection();
            ArrayList userIds = Lists.newArrayListWithCapacity((int)10);
            long[] pkIds = DBServiceHelper.genLongIds((String)"hrcs_msgadminsetting", (int)listRowData.size());
            for (int i = 0; i < listRowData.size(); ++i) {
                ListSelectedRow row = listRowData.get(i);
                String name = row.getName();
                String number = row.getNumber();
                long userId = Long.parseLong(String.valueOf(row.getPrimaryKeyValue()));
                DynamicObject pubMsgLogDyn = BusinessDataServiceHelper.newDynamicObject((String)"hrcs_msgadminsetting");
                pubMsgLogDyn.set("id", (Object)pkIds[i]);
                pubMsgLogDyn.set(ADMIN_USERID, (Object)userId);
                pubMsgLogDyn.set("number", (Object)number);
                pubMsgLogDyn.set("name", (Object)name);
                pubMsgLogDyn.set("createtime", (Object)new Date());
                pubMsgLogDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
                pubMsgLogDyn.set("status", (Object)"C");
                pubMsgLogDyn.set("enable", (Object)"1");
                pubLogDys.add((Object)pubMsgLogDyn);
                userIds.add(userId);
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgadminsetting");
            DynamicObject[] dynamicObjects = serviceHelper.query(ADMIN_USERID, new QFilter[]{new QFilter(ADMIN_USERID, "in", (Object)userIds)});
            if (null != dynamicObjects && dynamicObjects.length > 0) {
                Map<Long, String> names = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getDynamicObject(ADMIN_USERID).getLong("id"), dy -> dy.getDynamicObject(ADMIN_USERID).getString("name"), (k1, k2) -> k1));
                pubLogDys.removeIf(dy -> names.containsKey(dy.getLong(ADMIN_USERID)));
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0},\u5df2\u5b58\u5728\u6e05\u5355\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u65b0\u589e", (String)"AdminSettingListPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), names.values()));
            }
            if (pubLogDys.size() > 0) {
                serviceHelper.save(pubLogDys);
                OperateLogService.commonWriteLog((String)HRCS_APPID, (String)"hrcs_msgadminsetting", (String)"save", (MultiLangEnumBridge)new MultiLangEnumBridge("F7\u786e\u5b9a\u4fdd\u5b58", "AdminSettingListPlugin_2", "hrmp-hrcs-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("F7\u786e\u5b9a\u4fdd\u5b58\u6210\u529f\u3002", "AdminSettingListPlugin_3", "hrmp-hrcs-formplugin"), (String[])new String[0]);
            }
        });
        this.getView().invokeOperation("refresh");
    }
}

