/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnWriteOut;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;

@ExcludeFromJacocoGeneratedReport
public class HrMsgIEarlyWarnWriteOut
implements IEarlyWarnWriteOut {
    private static final String DAY_THREE = "A";
    private static final String DAY_SEVEN = "B";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOut(DynamicObjectCollection dynamicObjectCollection, EarlyWarnContext earlyWarnContext) {
        if (dynamicObjectCollection.isEmpty()) {
            return;
        }
        Date date = new Date();
        Date sendTime = (Date)((DynamicObject)dynamicObjectCollection.get(0)).get("sendtime");
        long durationToDatabase = HRDateTimeUtils.dateDiff((String)"d", (Date)sendTime, (Date)date);
        String warningType = DAY_SEVEN;
        if (durationToDatabase > 7L) {
            warningType = DAY_THREE;
        }
        try {
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgexceptionlog");
            List idList = dynamicObjectCollection.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            DynamicObject[] result = serviceHelper.query("id,createtime,entryentity,entryentity.warningtype,entryentity.warningtime", new QFilter[]{new QFilter("msgcenter.id", "in", idList)}, "createtime desc");
            if (result.length > 0) {
                DynamicObjectCollection entryDyns = result[0].getDynamicObjectCollection("entryentity");
                DynamicObject entry = new DynamicObject(entryDyns.getDynamicObjectType());
                entry.set("warningtype", (Object)warningType);
                entry.set("warningtime", (Object)date);
                entryDyns.add((Object)entry);
                serviceHelper.saveOne(result[0]);
            }
        }
        finally {
            CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        }
    }
}

