/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;

public class MsgPubLogList
extends HRDataBaseList
implements ClickListener {
    private Map<Long, DynamicObject> processDataMap = new HashMap<Long, DynamicObject>();
    private static final Log LOGGER = LogFactory.getLog(MsgPubLogList.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"publogdetail"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"operdetail")) {
            this.openLog();
        }
    }

    private void openLog() {
        IListView listview = (IListView)this.getView();
        String currentPkId = listview.getFocusRowPkId().toString();
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("980px");
        css.setHeight("500px");
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        formShowParameter.setFormId("hrcs_pubmsglog");
        formShowParameter.setPkId((Object)currentPkId);
        formShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs listDataProviderArgs) {
        listDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection objectCollection = super.getData(start, limit);
                if (objectCollection.isEmpty()) {
                    return objectCollection;
                }
                ArrayList<Long> idList = new ArrayList<Long>();
                for (DynamicObject row : objectCollection) {
                    idList.add(row.getLong("id"));
                }
                if (!idList.isEmpty()) {
                    MsgPubLogList.this.processDataMap = MsgCenterServiceHelper.getPubInfoListByPubLogId(idList);
                }
                return objectCollection;
            }
        });
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        if (this.processDataMap == null) {
            return;
        }
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvent.getSource();
        String fieldKey = columnDesc.getFieldKey();
        Long rowId = (Long)packageDataEvent.getRowData().get("id");
        DynamicObject dy = this.processDataMap.get(rowId);
        if (dy != null) {
            if (HRStringUtils.equals((String)fieldKey, (String)"actioncloud.name")) {
                packageDataEvent.setFormatValue(dy.get("actioncloud.name"));
            } else if (HRStringUtils.equals((String)fieldKey, (String)"actionapp.name")) {
                packageDataEvent.setFormatValue(dy.get("actionapp.name"));
            } else if (HRStringUtils.equals((String)fieldKey, (String)"publishbd.name")) {
                packageDataEvent.setFormatValue(dy.get("publishbd.name"));
            }
        }
    }
}

