/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.common.util.ActivityUtil;

public class MsgTempContextPlugin
extends HRDynamicFormBasePlugin {
    private static final Log log = LogFactory.getLog(MsgTempContextPlugin.class.getClass());
    public static final String INSERT_EXPRESSION = "insertexpression";
    public static final String INSERT_FIELD = "insertfield";
    public static final String CONFIRM = "confirm";
    public static final String CANCEL = "cancel";
    public static final String FROM = "FROM";
    public static final String NUMBER_MAP_NAME = "numberMapName";
    private static final String CONTENT = "content";
    public static final String PAGE_CACHE_SAMPLE_MAP = "sampleMap";
    public static final String SAMPLE = "sample";
    public static final String EXPRESSION = "expression";
    private static final List<String> insertFields = Lists.newArrayList((Object[])new String[]{"number", "msgtitle", "msgtag", "sendtime", "msgdesc"});

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{CONFIRM, CANCEL, INSERT_EXPRESSION});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "insertexpression": {
                this.showExpressionForm();
                break;
            }
            case "confirm": {
                this.getPageCache().remove(FROM);
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put("value", this.getModel().getValue(CONTENT));
                returnData.put(SAMPLE, this.getPageCache().get(PAGE_CACHE_SAMPLE_MAP));
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getPageCache().remove(FROM);
                this.getView().close();
                break;
            }
        }
    }

    private void showExpressionForm() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String comeFrom = (String)showParameter.getCustomParam(FROM);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("bpmnModel", showParameter.getCustomParam("modelJson"));
        content.put("entityNumber", showParameter.getCustomParam("entityNumber"));
        content.put("ruleType", ConditionalRuleType.skip);
        content.put("fromSubjectModelAndApp", "fromSubjectModelAndApp");
        if (MsgTempContextPlugin.isNotEmptyString(comeFrom) && "MSG".equals(comeFrom)) {
            String type = (String)showParameter.getCustomParam("type");
            if (!"cosmic".equals(type) && !"custom".equals(type)) {
                content.put("ruleType", ConditionalRuleType.sequenceFlow);
            } else {
                content.put("ruleType", "EventConfig");
                content.put("eventnumber", showParameter.getCustomParam("eventnumber"));
            }
        }
        this.showForm(INSERT_EXPRESSION, "hrcs_msgtempcontextexp", content);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (!INSERT_EXPRESSION.equals(key)) {
            return;
        }
        Map map = (Map)closedCallBackEvent.getReturnData();
        if (map == null || ActivityUtil.isNullObject(map.get(EXPRESSION)) && ActivityUtil.isEmptyString(map.get("prop"))) {
            return;
        }
        Map propMap = (Map)SerializationUtils.fromJsonString((String)map.get("prop").toString(), Map.class);
        Object content = this.getModel().getValue(CONTENT);
        content = ActivityUtil.isNotEmptyString((Object)content) ? content : "";
        String expression = "{" + map.get(EXPRESSION) + "}";
        if (ActivityUtil.isEmpty((String)this.getPageCache().get(FROM)) && ActivityUtil.isNotEmpty((String)((String)propMap.get("name")))) {
            String propName = ActivityUtil.isEmpty((String)((String)propMap.get("fullName"))) ? (String)propMap.get("name") : (String)propMap.get("fullName");
            expression = propName + "\uff1a" + expression;
            if (ActivityUtil.isNotEmptyString(propMap.get(SAMPLE))) {
                HashMap sampleMap = ActivityUtil.isNotEmpty((String)this.getPageCache().get(PAGE_CACHE_SAMPLE_MAP)) ? (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PAGE_CACHE_SAMPLE_MAP), Map.class) : new HashMap(16);
                sampleMap.put(map.get(EXPRESSION).toString(), propMap.get(SAMPLE));
                this.getPageCache().put(PAGE_CACHE_SAMPLE_MAP, SerializationUtils.toJsonString(sampleMap));
            }
            if (ActivityUtil.isNotEmptyString((Object)content)) {
                expression = "/" + expression;
            }
        }
        if ((content = content + expression).toString().length() > 500) {
            content = this.subSequence(content.toString());
        }
        this.getModel().setValue(CONTENT, content);
    }

    public void afterCreateNewData(EventObject event) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam("entityNumber");
        if (MsgTempContextPlugin.isNotEmptyString(parameter.getCustomParam(FROM))) {
            this.getPageCache().put(FROM, (String)parameter.getCustomParam(FROM));
        }
        if (HRStringUtils.isEmpty((String)((String)parameter.getCustomParam("type")))) {
            if (HRStringUtils.isEmpty((String)entityNumber)) {
                log.error("\u6a21\u677f\u53c2\u6570\u51fa\u9519--\u53c2\u6570\u4e3a\u7a7a\uff01{},{},", (Object)"MsgTempContextPlugin", (Object)entityNumber);
            } else {
                this.setFieldComboItems(entityNumber);
            }
        } else if (MsgTempContextPlugin.isNotEmptyString(entityNumber)) {
            this.setFieldComboItems(entityNumber);
        }
        if (MsgTempContextPlugin.isNotEmptyString(parameter.getCustomParam("value"))) {
            this.getModel().setValue(CONTENT, parameter.getCustomParam("value"));
        }
    }

    private void setFieldComboItems(String entityNumber) {
        HashMap<String, String> numberMapName = new HashMap<String, String>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Iterator iter = entityType.getAllFields().values().iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        while (true) {
            if (!iter.hasNext()) {
                ComboEdit fieldCombo = (ComboEdit)this.getControl(INSERT_FIELD);
                this.getPageCache().put(NUMBER_MAP_NAME, SerializationUtils.toJsonString(numberMapName));
                fieldCombo.setComboItems(items);
                return;
            }
            ComboItem item = new ComboItem();
            IDataEntityProperty fieldProp = (IDataEntityProperty)iter.next();
            if (HRStringUtils.isEmpty((String)fieldProp.getAlias()) || !(fieldProp instanceof IFieldHandle) || HRStringUtils.isNotEmpty((String)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName()) || fieldProp instanceof MulBasedataProp) continue;
            if (!(fieldProp instanceof BasedataProp) && !(fieldProp instanceof AttachmentProp) && insertFields.contains(fieldProp.getName())) {
                item.setValue(fieldProp.getName());
                item.setCaption(((IFieldHandle)fieldProp).getDisplayName());
                numberMapName.put(item.getValue(), item.getCaption().toString());
            }
            items.add(item);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        Object fieldObj;
        String propertyName = event.getProperty().getName().toLowerCase();
        if (INSERT_FIELD.endsWith(propertyName) && MsgTempContextPlugin.isNotEmptyString(fieldObj = this.getModel().getValue(INSERT_FIELD))) {
            Object content = this.getModel().getValue(CONTENT);
            content = MsgTempContextPlugin.isNotEmptyString(content) ? content : "";
            String fieldValue = "{" + fieldObj + "}";
            if (HRStringUtils.isEmpty((String)this.getPageCache().get(FROM))) {
                String numberMapNameStr = this.getPageCache().get(NUMBER_MAP_NAME);
                if (HRStringUtils.isNotEmpty((String)numberMapNameStr)) {
                    Map numberMapName = (Map)SerializationUtils.fromJsonString((String)numberMapNameStr, Map.class);
                    String name = (String)numberMapName.get(fieldObj);
                    fieldValue = name + "\uff1a" + fieldValue;
                }
                if (MsgTempContextPlugin.isNotEmptyString(content)) {
                    fieldValue = "/" + fieldValue;
                }
            }
            if ((content = content + fieldValue).toString().length() > 500) {
                CharSequence content1 = this.subSequence(content.toString());
                content = content1.toString();
            }
            this.getModel().setValue(CONTENT, content);
        }
    }

    public void showForm(String key, String formId, Map<String, Object> params) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(params);
        parameter.setHasRight(true);
        parameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        this.getView().showForm(parameter);
    }

    private CharSequence subSequence(String content) {
        return content.subSequence(0, 255);
    }

    public static boolean isNotEmptyString(Object value) {
        return value == null ? false : HRStringUtils.isNotEmpty((String)value.toString());
    }
}

