/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.msgcenter.filter;

import java.util.Date;
import kd.bos.dataentity.SqlParameter;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.IConditionVariableAnalysis;
import kd.bos.service.KDDateUtils;
import kd.hr.hrcs.formplugin.web.msgcenter.filter.DateTimeAnalysisUtils;
import org.apache.commons.lang3.time.DateUtils;

abstract class DateRangeAnalysis
implements IConditionVariableAnalysis {
    private static final String FINISH_DATE_COMPARE_TYPE = "<";

    DateRangeAnalysis() {
    }

    abstract Date getStartDate();

    abstract Date getFinishDate();

    Date getBaseToday() {
        return KDDateUtils.today();
    }

    Date addDays(int diff) {
        return DateUtils.addDays((Date)this.getBaseToday(), (int)diff);
    }

    public void getVariableFilter(ConditionVariableContext ctx) {
        DateTimeAnalysisUtils dta = new DateTimeAnalysisUtils(ctx.isParam());
        DateRange dateRange = this.getDateRange();
        if (ctx.isParam() && dateRange.getFinishDate() != null) {
            SqlParameter sqlParam2 = new SqlParameter(ctx.getFieldName(), ctx.getColType(), (Object)dateRange.getFinishDate());
            ctx.getParam().add(sqlParam2);
        }
        if (dateRange.getStartDate() == null && dateRange.getFinishDate() != null) {
            ctx.setFilter(dta.getUnaryString(ctx.getFieldName(), FINISH_DATE_COMPARE_TYPE, dateRange.getFinishDate()));
            ctx.setQFilter(dta.getUnaryQFilter(ctx.getFieldName(), FINISH_DATE_COMPARE_TYPE, dateRange.getFinishDate()));
        }
    }

    public void getScriptFilter(ConditionVariableContext conditionVariableContext) {
    }

    private DateRange getDateRange() {
        Date date2;
        Date date1;
        Date startDate = this.getStartDate();
        Date finishDate = this.getFinishDate();
        if (startDate != null && finishDate != null && startDate.after(finishDate)) {
            date1 = finishDate;
            date2 = startDate;
        } else {
            date1 = startDate;
            date2 = finishDate;
        }
        return new DateRange(date1, date2);
    }

    static class DateRange {
        Date startDate;
        Date finishDate;

        public DateRange(Date startDate, Date finishDate) {
            this.startDate = startDate;
            this.finishDate = finishDate;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getFinishDate() {
            return this.finishDate;
        }
    }
}

