/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.multimpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.TreeListBizAppsPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class MultiEntityImpTmpTreeList
extends TreeListBizAppsPlugin {
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        root.setIsOpened(true);
        root.setChildren(this.getCloudNodes());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(nodeId, 20);
        List<TreeNode> childNodes = this.getChildNodes(root, parent);
        e.setChildNodes(childNodes);
        if (parent != null) {
            this.getTreeListView().getTreeView().expand(nodeId);
        }
    }

    private List<TreeNode> getChildNodes(TreeNode root, TreeNode parent) {
        String key;
        if (StringUtils.equals((CharSequence)parent.getId(), (CharSequence)root.getId())) {
            return this.getCloudNodes();
        }
        switch (key = (String)parent.getData()) {
            case "cloud": {
                return this.getAppNodesBy(parent.getId());
            }
            case "app": {
                return this.getBillNodesBy(this.getAppIdsBy(parent.getId()));
            }
        }
        return new ArrayList<TreeNode>();
    }

    private List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            return StringUtils.equals((CharSequence)"0", (CharSequence)tType) ? app.getString("id") : app.getString("masterid");
        }).orElse("");
        return StringUtils.isBlank((CharSequence)masterId) ? new ArrayList<String>() : allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    private List<TreeNode> getCloudNodes() {
        HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hbss_cloud");
        DynamicObject[] hrClouds = cloudHelper.queryOriginalArray("cloud", new QFilter[0], "index");
        Object[] hrCloudIds = Arrays.stream(hrClouds).map(el -> el.getString("cloud")).toArray();
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])((String[])Arrays.copyOf(hrCloudIds, hrCloudIds.length, String[].class)), null, null, (String)"cloud");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> cloudOrderNodes = new ArrayList<TreeNode>();
        for (Object cloudId : hrCloudIds) {
            for (TreeNode cloudNode : clouds) {
                if (!cloudId.equals(cloudNode.getId())) continue;
                cloudNode.setChildren(new ArrayList());
                cloudOrderNodes.add(cloudNode);
            }
        }
        return cloudOrderNodes;
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        evt.addCustomQFilter(new QFilter("mainentitytmpl.bizobject.number", "in", this.getBillNumbers()));
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        String nodeId = evt.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 20);
        QFilter filter = this.getFilter(node);
        evt.addQFilter(filter);
        evt.setCancel(true);
    }

    private QFilter getFilter(TreeNode node) {
        String nodeId = node.getId();
        if (this.isTopNode(nodeId)) {
            return null;
        }
        switch ((String)node.getData()) {
            case "cloud": {
                return new QFilter("mainentitytmpl.bizobject.number", "in", (Object)this.getBillIdInCloud(nodeId));
            }
            case "app": {
                return new QFilter("mainentitytmpl.bizobject.number", "in", (Object)this.getBillIdInApp(nodeId));
            }
        }
        return new QFilter("mainentitytmpl.bizobject.number", "=", (Object)nodeId);
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        super.beforeShowBill(evt);
        BillShowParameter param = evt.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains("cloud_") || currentNodeId.contains("app_") || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam("mainentitytmpl.bizobject.number", (Object)currentNodeId);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getTreeModel().setNodeClickExpand(false);
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 10);
        if (node.getChildren() == null) {
            this.getPageCache().put("_IMPORTTEMPLATETREELIST_BIZOBJID_", node.getData().toString());
        }
        super.treeNodeClick(treenodeevent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBillNumbers() {
        String fields = "number";
        String orderby = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImport = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImport};
        ArrayList<String> billNumbers = new ArrayList<String>();
        try (DataSet ds = ORM.create().queryDataSet("bos_entityobject", "bos_entityobject", fields, filters, orderby);){
            for (Row row : ds) {
                billNumbers.add(row.getString("number"));
            }
        }
        return billNumbers;
    }
}

