/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.PermDimFuncService;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import org.apache.commons.collections.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class EntitySpecFuncList
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(PermCheckService.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String from = formOperate.getOption().getVariableValue("from");
        if ("donothing_initcal".equalsIgnoreCase(formOperate.getOperateKey())) {
            this.genAllEntityFuncIds(from);
        }
    }

    private void genAllEntityFuncIds(String from) {
        HashSet hrclouds = this.getHRCloudIds();
        if (HRStringUtils.isNotEmpty((String)from) && HRStringUtils.equals((String)from, (String)"ut")) {
            hrclouds = Sets.newHashSet((Object[])new String[]{"0PEIU203SX4Y"});
        }
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        QFilter[] qfilters = new QFilter[]{new QFilter("bizappid.bizcloud.id", "in", (Object)hrclouds), new QFilter("istemplate", "=", (Object)"0"), new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"))};
        DynamicObjectCollection entityColl = entityHelper.queryOriginalCollection("number,name,bizappid.id", qfilters);
        HRBaseServiceHelper specFuncHelper = new HRBaseServiceHelper("hrcs_entityspecfuncgen");
        DynamicObjectCollection coll = new DynamicObjectCollection();
        Map<String, Long> appFuncIdMap = EntitySpecFuncList.getAppFuncIdMap();
        Map<String, List<String>> entityReleaseAppMap = this.getEntityReleaseAppMap();
        for (DynamicObject entity : entityColl) {
            Long entityFuncId;
            String entityNumber;
            block9: {
                entityNumber = entity.getString("number");
                entityFuncId = null;
                try {
                    entityFuncId = PermDimFuncService.getEntityFuncId((String)entityNumber);
                    if (entityFuncId == null) {
                    }
                    break block9;
                }
                catch (Exception ex) {
                    LOGGER.error("entity:" + entityNumber + " not exist.", (Throwable)ex);
                }
                continue;
            }
            DynamicObject newDyno = specFuncHelper.generateEmptyDynamicObject();
            Long newId = EntitySpecFuncList.genIdByEntityNumber("hrcs_entityspecfuncgen");
            newDyno.set("id", (Object)newId);
            newDyno.set("entity", (Object)entityNumber);
            newDyno.set("bucafunc", (Object)entityFuncId);
            String appId = entity.getString("bizappid.id");
            newDyno.set("app", (Object)appId);
            newDyno.set("issyspreset", (Object)"1");
            Long appFuncId = appFuncIdMap.get(appId);
            newDyno.set("appbucafunc", (Object)appFuncId);
            appFuncId = appFuncId == null || appFuncId == 0L ? HRCSBaseConstants.DEF_HR_FUNCID : appFuncId;
            List<String> releaseAppList = entityReleaseAppMap.get(entityNumber);
            if (CollectionUtils.isNotEmpty(releaseAppList)) {
                newDyno.set("releaseappname", (Object)releaseAppList.toString());
            }
            if (entityFuncId.equals(appFuncId)) {
                newDyno.set("isappsame", (Object)"1");
            } else {
                newDyno.set("isappsame", (Object)"0");
            }
            coll.add((Object)newDyno);
        }
        if (coll.size() == 0) {
            return;
        }
        specFuncHelper.deleteByFilter(null);
        specFuncHelper.save(coll);
    }

    private static long genIdByEntityNumber(String entityNumber) {
        return ORM.create().genLongId(entityNumber);
    }

    private static Map<String, Long> getAppFuncIdMap() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_appbusinesstype");
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")};
        DynamicObject[] dynos = helper.query("app.id,businesstype.controlfuntype", qFilters);
        HashMap appFuncIdMap = Maps.newHashMapWithExpectedSize((int)dynos.length);
        for (DynamicObject dyno : dynos) {
            appFuncIdMap.put(dyno.getString("app.id"), dyno.getLong("businesstype.controlfuntype.id"));
        }
        return appFuncIdMap;
    }

    private Set<String> getHRCloudIds() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_hrcloud");
        DynamicObject[] hrclouds = helper.queryOriginalArray("id", null);
        return Arrays.stream(hrclouds).map(dyno -> dyno.getString("id")).collect(Collectors.toSet());
    }

    private Map<String, List<String>> getEntityReleaseAppMap() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_bizobjapp");
        DynamicObjectCollection releaseColl = helper.queryOriginalCollection("bizobj.number,bizapp.id,bizapp.name", null);
        HashMap entityReleaseAppMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject release : releaseColl) {
            String entityNumber = release.getString("bizobj.number");
            List appNameList = (List)entityReleaseAppMap.get(entityNumber);
            if (appNameList == null) {
                appNameList = Lists.newArrayListWithExpectedSize((int)16);
                entityReleaseAppMap.put(entityNumber, appNameList);
            }
            appNameList.add(release.getString("bizapp.name"));
        }
        return entityReleaseAppMap;
    }
}

