/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class DynamicFormCtrlListPlugin
extends HRDataBaseList {
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("baritem_generatesql".equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            Object[] pkIds = selectedRows.getPrimaryKeyValues();
            Map objs = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)"hrcs_dynaformctrl");
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : objs.entrySet()) {
                DynamicObject obj = (DynamicObject)entry.getValue();
                String itemSql = this.generateSql(obj);
                if (!StringUtils.isNotEmpty((String)itemSql)) continue;
                sb.append(itemSql);
            }
            this.exportSql(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void exportSql(byte[] sql) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("kd_X.X.X_hrcs_dynaformctrl.sql", sql, 5000);
        this.getView().openUrl(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f!", (String)"DynamicFormCtrlListPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
    }

    private String generateSql(DynamicObject obj) {
        Date date;
        Object pkValue = obj.getPkValue();
        String entity = obj.getString("entitytype.id");
        String app = obj.getString("app.id");
        if (HRStringUtils.isEmpty((String)entity) || HRStringUtils.isEmpty((String)app)) {
            return " ";
        }
        String description = obj.getString("description");
        if (HRStringUtils.isEmpty((String)description)) {
            description = " ";
        }
        String createTime = HRDateTimeUtils.format((Date)((date = obj.getDate("createtime")) != null ? date : new Date()), (String)"yyyy-MM-dd HH:mm:ss");
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM T_HRCS_DYNAFORMCTRL WHERE FID = ").append(pkValue).append(";\r\n");
        sql.append("INSERT INTO T_HRCS_DYNAFORMCTRL (FID, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FDESCRIPTION, FAPPID, FENTITYTYPEID) VALUES (");
        sql.append(pkValue).append(", ");
        sql.append("1, ");
        sql.append("{ts'").append(createTime).append("'}, ");
        sql.append("1, ");
        sql.append("{ts'").append(createTime).append("'}, '");
        sql.append(description).append("', '");
        sql.append(app).append("', '");
        sql.append(entity).append("'");
        sql.append(");\r\n");
        String mainLangPkId = DBServiceHelper.genStringId();
        sql.append("DELETE FROM T_HRCS_DYNAFORMCTRL_L WHERE FPKID = '").append(mainLangPkId).append("';\r\n");
        sql.append("INSERT INTO T_HRCS_DYNAFORMCTRL_L (FID, FPKID, FLOCALEID, FDESCRIPTION) VALUES (");
        sql.append(pkValue).append(", '");
        sql.append(mainLangPkId).append("', '");
        sql.append("zh_CN', '");
        sql.append(description).append("');");
        sql.append("\r\n\r\n");
        DynamicObjectCollection collection = obj.getDynamicObjectCollection("entryentity");
        if (collection.size() <= 0) {
            return sql.toString();
        }
        StringBuilder filedSb = new StringBuilder();
        String[] filedIds = DBServiceHelper.genStringIds((String)"t_hrcs_dynaformfield_l", (int)collection.size());
        for (int index = 0; index < collection.size(); ++index) {
            DynamicObject row = (DynamicObject)collection.get(index);
            Object entryId = row.get("id");
            sql.append("DELETE FROM T_HRCS_DYNAFORMFIELD WHERE FENTRYID = ").append(entryId).append(";\r\n");
            sql.append("INSERT INTO T_HRCS_DYNAFORMFIELD (FID, FENTRYID, FSEQ, FPROPKEY, FBDTYPE, FISSYSPRESET, FPROPNAME) VALUES (");
            sql.append(pkValue).append(", ");
            sql.append(entryId).append(", ");
            sql.append(row.getString("seq")).append(", '");
            sql.append(row.getString("propkey")).append("', '");
            sql.append(HRStringUtils.isNotEmpty((String)row.getString("bdtype.id")) ? row.getString("bdtype.id") : " ").append("', '");
            sql.append('1').append("', '");
            String propName = row.getString("propname");
            sql.append(propName).append("');\n");
            String langPkId = filedIds[index];
            filedSb.append("DELETE FROM T_HRCS_DYNAFORMFIELD_L WHERE FPKID = '").append(langPkId).append("';\r\n");
            filedSb.append("INSERT INTO T_HRCS_DYNAFORMFIELD_L (FPKID, FENTRYID, FLOCALEID, FPROPNAME) VALUES ('");
            filedSb.append(langPkId).append("', ");
            filedSb.append(entryId).append(", '");
            filedSb.append("zh_CN', '");
            filedSb.append(propName).append("');\n");
        }
        sql.append("\r\n\r\n");
        filedSb.append("\r\n\r\n");
        sql.append((CharSequence)filedSb);
        return sql.toString();
    }
}

