/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.dimension.EntityOrgFieldBuQueryService;
import kd.hr.hrcs.bussiness.service.perm.log.EntityCtrlLogService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.common.constants.perm.log.DimRoleInfoModel;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlEntryRowModel;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlModel;
import org.apache.commons.collections.CollectionUtils;

public class EntityCtrlEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(EntityCtrlEdit.class);
    private static final String BAR_ADD_ROWS = "addrows";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject entityType = (DynamicObject)this.getModel().getValue("entitytype");
        if (entityType == null) {
            return;
        }
        if (!EntityCtrlServiceHelper.checkModelType((DynamicObject)entityType)) {
            this.putMainOrgFieldProp(entityType);
        } else {
            this.putDynaFormCtrlInfo(entityType);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        Map entityFieldMap = EntityCtrlServiceHelper.getEntityFieldMap((DynamicObject)entityType);
        List noDBProps = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("noDBProps"), List.class);
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject dy = (DynamicObject)entryEntity.get(index);
            String propKey = dy.getString("propkey");
            if (noDBProps.contains(propKey)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"authrange"});
            }
            dy.set("propname", entityFieldMap.get(propKey));
            if (dy.getLong("id") == 0L) continue;
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"propname", "dimension", "issyspreset"});
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List mustSelectedDim = entryEntity.stream().filter(it -> it.getBoolean("ismust")).map(it -> it.getLong("id")).collect(Collectors.toList());
        String mustSelectedDimStr = SerializationUtils.toJsonString(mustSelectedDim);
        this.getPageCache().put("changedMustDim", mustSelectedDimStr);
        this.getPageCache().put("existMustDim", mustSelectedDimStr);
        Map<String, Long> originPropDimInfo = this.getEntryInfo(entryEntity);
        this.getPageCache().put("originPropDimInfo", SerializationUtils.toJsonString(originPropDimInfo));
        List<EntityCtrlEntryRowModel> entryDetail = this.getEntryDetail(entryEntity);
        this.getPageCache().put("beforeOpData", JSONArray.toJSONString(entryDetail));
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Toolbar control = (Toolbar)this.getView().getControl("toolbarap");
        control.addItemClickListener((ItemClickListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("entitytype");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dimension = (BasedataEdit)this.getView().getControl("dimension");
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
        if (HRStringUtils.equals((String)"entitytype", (String)name)) {
            QFilter filter = this.buildFilter();
            lsp.getListFilterParameter().setFilter(filter);
            lsp.setFormId("bos_listf7");
        } else if (HRStringUtils.equals((String)"dimension", (String)name)) {
            DynamicObject entityType = (DynamicObject)this.getModel().getValue("entitytype");
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String propKey = this.getModel().getValue("propkey", rowIndex).toString();
            Map bdPropInfos = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("bdPropInfos"), Map.class);
            String entityNum = entityType.getString("id");
            String orgInfoStr = this.getView().getPageCache().get("orgInfos");
            Map orgInfos = HRStringUtils.isNotEmpty((String)orgInfoStr) ? (Map)SerializationUtils.fromJsonString((String)orgInfoStr, Map.class) : null;
            QFilter otBdFilter = new QFilter("datasource", "=", (Object)"basedata").and("entitytype", "in", Arrays.asList("haos_adminorghr", "haos_projectteamhr", "haos_adminorgteam"));
            QFilter filter = null;
            if (bdPropInfos.containsKey(propKey)) {
                if (null != orgInfos && orgInfos.containsKey(propKey)) {
                    Integer buId = (Integer)orgInfos.get(propKey);
                    filter = new QFilter("datasource", "=", (Object)"hrbu");
                    if (buId != null && buId != Integer.MAX_VALUE && buId != 0) {
                        if (buId == 1) {
                            filter = new QFilter("datasource", "=", (Object)"orgteam").and("teamtype", "=", (Object)1010L);
                        } else {
                            filter.and("hrbu", "=", (Object)buId);
                        }
                    }
                } else {
                    List<Long> teamTypeIds = this.queryEntityPropTeamTypeIds(entityNum, propKey);
                    if (CollectionUtils.isNotEmpty(teamTypeIds)) {
                        filter = new QFilter("teamtype", "in", teamTypeIds);
                        if (teamTypeIds.contains(1010L)) {
                            filter.or(otBdFilter);
                        }
                    } else {
                        filter = new QFilter("entitytype", "=", bdPropInfos.get(propKey));
                    }
                }
            } else if (!(HRStringUtils.equals((String)propKey, (String)"ID") || HRStringUtils.equals((String)propKey, (String)"boid") || propKey.endsWith(".id"))) {
                filter = new QFilter("datasource", "!=", (Object)"orgteam");
            }
            logger.info("EntityCtrl dimensionFilter = {}", (Object)(filter == null ? "{}" : filter.toString()));
            lsp.getListFilterParameter().setFilter(filter);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimensionCallBack"));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private List<Long> queryEntityPropTeamTypeIds(String entity, String propKey) {
        List structProjects = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStructProjectService", (String)"queryStructProConfig", (Object[])new Object[]{entity, propKey, null});
        ArrayList<Long> teamTypeIds = new ArrayList<Long>(10);
        if (CollectionUtils.isEmpty((Collection)structProjects)) {
            return teamTypeIds;
        }
        Map structProjectMap = (Map)structProjects.get(0);
        if (null != structProjectMap.get("teamtype")) {
            teamTypeIds.add((Long)structProjectMap.get("teamtype"));
        } else {
            List structProjectMapList = (List)structProjectMap.get("structproject");
            structProjectMapList.stream().forEach(it -> teamTypeIds.add((Long)it.get("teamtype")));
        }
        return teamTypeIds;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (operateKey.equals("save")) {
            if (collection.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ef4\u5ea6\u6620\u5c04\u6570\u636e\u3002", (String)"EntityCtrlEdit_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("modifytime", (Object)new Date());
            Map<String, Long> propDimInfo = this.getEntryInfo(collection);
            Map originPropDimInfo = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("originPropDimInfo"), Map.class);
            ArrayList effectDimRoleInfoModelList = Lists.newArrayListWithExpectedSize((int)10);
            List<DimRoleInfoModel> dimRoleInfoModelList = this.addItemPostProcessing(propDimInfo, originPropDimInfo);
            if (CollectionUtils.isNotEmpty(dimRoleInfoModelList)) {
                effectDimRoleInfoModelList.addAll(dimRoleInfoModelList);
            }
            this.deleteRowsPostProcessing(args, propDimInfo, originPropDimInfo, effectDimRoleInfoModelList);
            this.resolvePermLog(effectDimRoleInfoModelList);
        } else if (operateKey.equals("deleteentry")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (collection.size() > 0 && selectRows.length > 0) {
                for (int selectRow : selectRows) {
                    boolean isSysPreSet = ((DynamicObject)collection.get(selectRow)).getBoolean("issyspreset");
                    if (!isSysPreSet) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u65e0\u6cd5\u5220\u9664\u3002", (String)"EntityCtrlEdit_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            DynamicObject entityType = this.getModel().getDataEntity().getDynamicObject("entitytype");
            String buId = HRBuCaServiceHelper.getBuCaFuncFromSpec((String)entityType.getString("id"), (String)entityType.getString("bizappid.id"));
            HashMap dimRoles = new HashMap(selectRows.length);
            EntityCtrlServiceHelper.getDimRelRoles((DynamicObject)entityType, (DynamicObjectCollection)collection, (int[])selectRows, dimRoles, (String)buId);
            boolean hasRoles = dimRoles.entrySet().stream().anyMatch(it -> ((List)it.getValue()).size() > 0);
            if (!hasRoles) {
                return;
            }
            EntityCtrlServiceHelper.showDelTip(dimRoles, (IFormView)this.getView(), (IFormPlugin)this);
            args.setCancel(true);
        }
    }

    private void resolvePermLog(List<DimRoleInfoModel> effectDimRoleInfoModelList) {
        List<EntityCtrlEntryRowModel> afterOpData;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String beforeOpDataStr = this.getPageCache().get("beforeOpData");
        List beforeOpData = JSONArray.parseArray((String)beforeOpDataStr, EntityCtrlEntryRowModel.class);
        if (CollectionUtils.isEqualCollection((Collection)beforeOpData, afterOpData = this.getEntryDetail(dataEntity.getDynamicObjectCollection("entryentity")))) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String entityNum = dataEntity.getString("entitytype.id");
        EntityCtrlModel entityCtrlModel = new EntityCtrlModel(entityNum);
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            entityCtrlModel.setLogType(Long.valueOf(4010L));
        } else {
            entityCtrlModel.setLogType(Long.valueOf(4015L));
        }
        ArrayList existRoles = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList effectDimRoleInfoModelListDistinct = Lists.newArrayListWithExpectedSize((int)10);
        for (DimRoleInfoModel dimRoleInfoModel : effectDimRoleInfoModelList) {
            String roleId = dimRoleInfoModel.getRoleId();
            if (existRoles.contains(roleId)) continue;
            effectDimRoleInfoModelListDistinct.add(dimRoleInfoModel);
            existRoles.add(roleId);
        }
        entityCtrlModel.setEffectDimRoleList((List)effectDimRoleInfoModelListDistinct);
        entityCtrlModel.setBeforeEntryRows(beforeOpData);
        entityCtrlModel.setAfterEntryRows(afterOpData);
        EntityCtrlLogService.resolveLog((List)Lists.newArrayList((Object[])new EntityCtrlModel[]{entityCtrlModel}));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operateKey.equals("save") && operationResult.isSuccess()) {
            HRPermCacheMgr.clearAllCache();
        }
    }

    private void deleteRowsPostProcessing(BeforeDoOperationEventArgs args, Map<String, Long> propDimInfo, Map<String, Long> originPropDimInfo, List<DimRoleInfoModel> effectDimRoleInfoModelList) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String entityNum = dataEntity.getDynamicObject("entitytype").getString("number");
        String appId = dataEntity.getString("bizapp.id");
        if (HRStringUtils.isEmpty((String)entityNum) || HRStringUtils.isEmpty((String)appId)) {
            return;
        }
        Long buId = Long.valueOf(HRBuCaServiceHelper.getBuCaFuncFromSpec((String)entityNum, (String)appId));
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        for (Map.Entry<String, Long> entry : originPropDimInfo.entrySet()) {
            boolean success;
            String propKey = entry.getKey();
            if (HRStringUtils.equals((String)String.valueOf(entry.getValue()), (String)"0")) continue;
            Long dimensionId = entry.getValue();
            if (propDimInfo.get(propKey) != null && dimensionId.equals(propDimInfo.get(propKey)) || (success = EntityCtrlServiceHelper.deleteRoleRange((HRBaseServiceHelper)roleDimHelper, (long)dimensionId, (String)entityNum, (String)propKey, (Long)buId, (IFormView)this.getView(), (BeforeDoOperationEventArgs)args, effectDimRoleInfoModelList))) continue;
            args.setCancel(true);
        }
    }

    private List<EntityCtrlEntryRowModel> getEntryDetail(DynamicObjectCollection collection) {
        ArrayList entryDetails = Lists.newArrayListWithExpectedSize((int)collection.size());
        for (DynamicObject row : collection) {
            EntityCtrlEntryRowModel entityCtrlEntryRowModel = new EntityCtrlEntryRowModel(row.getString("propkey"), row.getString("dimension.name"), row.getString("authrange"), row.getBoolean("ismust"));
            entryDetails.add(entityCtrlEntryRowModel);
        }
        return entryDetails;
    }

    private Map<String, Long> getEntryInfo(DynamicObjectCollection collection) {
        HashMap<String, Long> propDimInfo = new HashMap<String, Long>(collection.size());
        collection.forEach(it -> propDimInfo.put(it.getString("propkey"), it.getLong("dimension.id")));
        return propDimInfo;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals(BAR_ADD_ROWS)) {
            DynamicObject entityType = (DynamicObject)this.getModel().getValue("entitytype");
            if (entityType == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"EntityCtrlEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            } else {
                String number = entityType.getString("number");
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_objecttype");
                QFilter filter = new QFilter("number", "=", (Object)number);
                boolean exists = serviceHelper.isExists(new QFilter[]{filter});
                if (exists) {
                    this.showFieldForm(entityType);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u6ca1\u6709\u5c5e\u6027\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EntityCtrlEdit_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        DynamicObject dy = evt.getChangeSet()[0].getDataEntity();
        if (HRStringUtils.equals((String)"entitytype", (String)name)) {
            this.getModel().deleteEntryData("entryentity");
            DynamicObject entityType = dy.getDynamicObject("entitytype");
            if (null == entityType) {
                this.getModel().setValue("bizapp", (Object)"");
                return;
            }
            this.bindAppCloud(entityType);
            if (!EntityCtrlServiceHelper.checkModelType((DynamicObject)entityType)) {
                this.putMainOrgFieldProp(entityType);
            } else {
                this.putDynaFormCtrlInfo(entityType);
            }
        } else if (HRStringUtils.equals((String)"ismust", (String)name)) {
            List changedMustDim = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("changedMustDim"), List.class);
            Boolean newValue = (Boolean)evt.getChangeSet()[0].getNewValue();
            if (dy.getLong("id") != 0L) {
                if (newValue.booleanValue()) {
                    changedMustDim.add(dy.getLong("id"));
                } else {
                    changedMustDim.remove(dy.getLong("id"));
                }
                this.getPageCache().put("changedMustDim", SerializationUtils.toJsonString((Object)changedMustDim));
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void putDynaFormCtrlInfo(DynamicObject entityType) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaformctrl");
        DynamicObject entity = serviceHelper.queryOne("entryentity.propkey,entryentity.bdtype,entryentity.bucafunc", new QFilter[]{new QFilter("entitytype", "=", (Object)entityType.getString("number"))});
        if (null == entity) {
            return;
        }
        DynamicObjectCollection collection = entity.getDynamicObjectCollection("entryentity");
        HashMap<String, String> bdPropInfos = new HashMap<String, String>(16);
        HashMap<String, Integer> orgInfos = new HashMap<String, Integer>(16);
        for (DynamicObject row : collection) {
            String bdType = row.getString("bdtype.number");
            String propKey = row.getString("propkey");
            if (!HRStringUtils.isNotEmpty((String)bdType)) continue;
            bdPropInfos.put(propKey, bdType);
            if (!HRStringUtils.equals((String)"bos_org", (String)bdType)) continue;
            orgInfos.put(propKey, row.getInt("bucafunc.id"));
        }
        this.getView().getPageCache().put("bdPropInfos", SerializationUtils.toJsonString(bdPropInfos));
        this.getPageCache().put("orgInfos", SerializationUtils.toJsonString(orgInfos));
        this.getView().getPageCache().put("noDBProps", SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)0)));
    }

    private void putMainOrgFieldProp(DynamicObject entityType) {
        Map orgInfos = new EntityOrgFieldBuQueryService().getPropBuMap(entityType.getString("id"));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityType.getString("id"));
        Map allFields = mainEntityType.getAllFields();
        if (mainEntityType instanceof QueryEntityType) {
            QueryEntityType mainEntity = (QueryEntityType)mainEntityType;
            List list = mainEntity.getAllJoinEntityType();
            for (MainEntityType type : list) {
                String joinEntityName = type.getName();
                Map tempAllFields = type.getAllFields();
                tempAllFields.forEach((key, value) -> allFields.put(joinEntityName + "." + key, value));
            }
        } else {
            this.getPageCache().put("mainorgfield", mainEntityType.getMainOrg());
        }
        for (Map.Entry entry : allFields.entrySet()) {
            String orgFunc;
            if (!(entry.getValue() instanceof OrgProp) || (orgFunc = ((OrgProp)entry.getValue()).getOrgFunc()) == null) continue;
            orgInfos.put(entry.getKey(), Integer.valueOf(orgFunc));
        }
        this.getView().getPageCache().put("orgInfos", SerializationUtils.toJsonString((Object)orgInfos));
        HashMap<String, String> queryCondition = new HashMap<String, String>(2);
        queryCondition.put("param_ifShowBaseDataProp", "true");
        queryCondition.put("param_ifShowAllBaseDataProp", "true");
        ChoiceFieldPageCustomQueryService choiceFieldPageCustomQueryService = new ChoiceFieldPageCustomQueryService();
        ArrayList noDBProps = new ArrayList(10);
        List maps = choiceFieldPageCustomQueryService.parsePropertySub((IDataEntityType)mainEntityType, null, queryCondition, "1=1", noDBProps);
        Map<String, String> bdPropInfos = maps.stream().filter(it -> it.containsKey("field_entityNum")).collect(Collectors.toMap(it -> (String)it.get("field_id"), it -> (String)it.get("field_entityNum"), (newVal, oldVal) -> newVal));
        this.getView().getPageCache().put("bdPropInfos", SerializationUtils.toJsonString(bdPropInfos));
        this.getView().getPageCache().put("noDBProps", SerializationUtils.toJsonString(noDBProps));
    }

    private void showFieldForm(DynamicObject entityType) {
        HRBaseServiceHelper serviceHelper;
        boolean exists;
        boolean isDynamicFormType = EntityCtrlServiceHelper.checkModelType((DynamicObject)entityType);
        if (isDynamicFormType && !(exists = (serviceHelper = new HRBaseServiceHelper("hrcs_dynaformctrl")).isExists(new QFilter("entitytype", "=", (Object)entityType.getString("id"))))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u52a8\u6001\u8868\u5355\u63a7\u6743\u914d\u7f6e\u4e2d\u7ef4\u62a4\u76f8\u5173\u6570\u636e\uff0c\u4ee5\u914d\u7f6e\u5c5e\u6027\u3002", (String)"EntityCtrlEdit_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        int listRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int index = 0; index < listRowCount; ++index) {
            String id = (String)this.getModel().getValue("propkey", index);
            String name = (String)this.getModel().getValue("propname", index);
            ListSelectedRow listSelectedRow = new ListSelectedRow((Object)(id + "||" + name), Boolean.FALSE);
            listSelectedRow.setName(name);
            listSelectedRow.setNumber(id);
            if (!StringUtils.isNotEmpty((String)id)) continue;
            idSet.add(id);
        }
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"hrcs_choosefield_page", (boolean)false, (int)0, (boolean)true);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "perm_choosefieldpage"));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("paramEntityName", (Object)entityType.getString("number"));
        fsp.setCustomParam("isDynamicFormType", (Object)isDynamicFormType);
        fsp.setCustomParam("paramAllReadySelectedPropertyNameSet", idSet);
        String mainOrgField = this.getPageCache().get("mainorgfield");
        if (mainOrgField != null) {
            fsp.setCustomParam("mainorgfield", (Object)mainOrgField);
        }
        fsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)fsp);
    }

    @ExcludeFromJacocoGeneratedReport
    public void closedCallBack(ClosedCallBackEvent evt) {
        Map map;
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("perm_choosefieldpage".equals(actionId)) {
            ListSelectedRowCollection res = (ListSelectedRowCollection)returnData;
            if (res.size() <= 0) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Set keys = entryEntity.stream().map(entry -> entry.getString("propkey")).collect(Collectors.toSet());
            Iterator iterator = res.iterator();
            int idx = this.getModel().getEntryRowCount("entryentity");
            while (iterator.hasNext()) {
                ListSelectedRow next = (ListSelectedRow)iterator.next();
                String id2Name = next.getPrimaryKeyValue().toString();
                String[] infos = id2Name.split("\\|\\|");
                String fieldNum = infos[0];
                if (!keys.contains(fieldNum)) {
                    this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("propkey", (Object)infos[0], idx);
                    this.getModel().setValue("propname", (Object)infos[1], idx);
                }
                if (infos.length < 3 || !HRStringUtils.equals((String)"true", (String)infos[2])) continue;
                this.getModel().setValue("authrange", (Object)"2", idx);
                this.getView().setEnable(Boolean.FALSE, idx, new String[]{"authrange"});
            }
        } else if ("dimensionCallBack".equals(actionId)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            ListSelectedRowCollection res = (ListSelectedRowCollection)returnData;
            if (res.size() <= 0) {
                return;
            }
            Long dimensionId = (Long)res.get(0).getPrimaryKeyValue();
            this.getModel().setValue("dimension", (Object)dimensionId, rowIndex);
        } else if (actionId.equals("delete_confirm") && (map = (Map)returnData).get("confirmResult") != null && ((String)map.get("confirmResult")).equals("yes")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            this.getModel().deleteEntryRows("entryentity", selectRows);
            this.getView().updateView("entryentity");
        }
    }

    private QFilter buildFilter() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject[] entityCtrls = serviceHelper.query("entitytype", null);
        List numbers = Arrays.stream(entityCtrls).filter(dy -> dy.get("entitytype.bizappid") != null).map(entity -> entity.getString("entitytype.number")).collect(Collectors.toList());
        numbers.add("bos_org");
        numbers.add("hbss_hrbu");
        HashSet forBidEntity = new HashSet(16);
        EntityCtrlServiceHelper.queryEntityForBidInfo(forBidEntity, null, null);
        numbers.addAll(forBidEntity);
        QFilter filter1 = EntityCtrlServiceHelper.buildFilterForF7((boolean)false);
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel", "DynamicFormModel", "ReportFormModel"));
        return filter1.and(modelTypeFilter).and("id", "not in", numbers);
    }

    private void bindAppCloud(DynamicObject entityType) {
        DynamicObject app = entityType.getDynamicObject("bizappid");
        this.getModel().setValue("bizapp", (Object)app.getString("id"));
    }

    private List<DimRoleInfoModel> addItemPostProcessing(Map<String, Long> propDimInfo, Map<String, Long> originPropDimInfo) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject entity = dataEntity.getDynamicObject("entitytype");
        if (null == entity) {
            return null;
        }
        String entityId = entity.getString("id");
        String appId = entity.getString("bizappid.id");
        Integer buCaFuncId = Integer.valueOf(HRBuCaServiceHelper.getBuCaFunc((String)entityId, (String)appId));
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
        this.addItemTip(entity, entry);
        Set permRoleIds = EntityCtrlServiceHelper.queryPermRoleIds();
        HRBaseServiceHelper rolePermHelper = new HRBaseServiceHelper("perm_roleperm");
        QFilter filter = new QFilter("roleperm.entity.number", "=", (Object)entityId).and("roleid.id", "in", (Object)permRoleIds);
        DynamicObject[] roles = rolePermHelper.query("roleid", new QFilter[]{filter});
        if (roles.length == 0) {
            return null;
        }
        HRBaseServiceHelper hrRoleServiceHelper = new HRBaseServiceHelper("hrcs_role");
        Set hrRoleIdSet = Arrays.stream(hrRoleServiceHelper.query("id", new QFilter[]{new QFilter("id", "in", (Object)permRoleIds)})).map(it -> it.getString("id")).collect(Collectors.toSet());
        Set roleIds = Arrays.stream(roles).filter(it -> it.getString("roleid.id") != null).map(it -> it.getString("roleid.id")).collect(Collectors.toSet());
        logger.info("kd.hr.hrcs.formplugin.web.perm.dimension.EntityCtrlEdit.addItemPostProcessing roleIds = {}", roleIds);
        List changedMustDim = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("changedMustDim"), List.class);
        List existMustDim = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("existMustDim"), List.class);
        List entryIds = changedMustDim.stream().filter(it -> changedMustDim.indexOf(it) == changedMustDim.lastIndexOf(it) && !existMustDim.contains(it)).collect(Collectors.toList());
        List changedEntryInfos = entry.stream().filter(it -> entryIds.contains(it.getLong("id")) || it.getLong("id") == 0L && it.getBoolean("ismust")).collect(Collectors.toList());
        Set mustDimIds = changedEntryInfos.stream().map(it -> it.getLong("dimension.id")).collect(Collectors.toSet());
        changedEntryInfos = entry.stream().filter(it -> (entryIds.contains(it.getLong("id")) || it.getLong("id") == 0L) && mustDimIds.contains(it.getLong("dimension.id"))).collect(Collectors.toList());
        ArrayList effectDimRoleInfoModelList = Lists.newArrayListWithExpectedSize((int)10);
        StringBuilder finalMsg = new StringBuilder();
        for (DynamicObject entryInfo : changedEntryInfos) {
            StringBuilder msg = new StringBuilder();
            long dimensionId = entryInfo.getLong("dimension.id");
            for (DynamicObject role : roles) {
                String roleId = role.getString("roleid.id");
                if (!hrRoleIdSet.contains(roleId) || roleId == null || !roleIds.contains(roleId)) continue;
                boolean addItem = this.changeMustDimPostProcessing(buCaFuncId, role, entryInfo, msg, appId, entityId);
                DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel();
                dimRoleInfoModel.setBuId((long)buCaFuncId.intValue());
                dimRoleInfoModel.setDimensionId(dimensionId);
                dimRoleInfoModel.setRoleId(roleId);
                dimRoleInfoModel.setOpType(addItem ? "add" : "modify");
                effectDimRoleInfoModelList.add(dimRoleInfoModel);
            }
            if (msg.length() <= 0) continue;
            String substring = msg.toString().substring(0, msg.toString().lastIndexOf(12289));
            String mulMsg = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u89d2\u8272\u672a\u8bbe\u7f6e\u201d%1$s\u201c\u7ef4\u5ea6\u8303\u56f4\uff0c\u8bf7\u5728\u89d2\u8272\u7ba1\u7406\u4e2d\u7ef4\u62a4\u89d2\u8272\u3002\n\u89d2\u8272\u5982\u4e0b\uff1a%2$s\n", (String)"EntityCtrlEdit_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), entryInfo.getString("dimension.name"), substring);
            finalMsg.append(mulMsg).append('\uff1b');
        }
        if (!finalMsg.toString().isEmpty()) {
            this.getView().showMessage(finalMsg.toString());
        }
        logger.info("kd.hr.hrcs.formplugin.web.perm.dimension.EntityCtrlEdit.addItemPostProcessing step one  effectDimRoleInfoModelList= {}", (Object)JSONArray.toJSONString((Object)effectDimRoleInfoModelList));
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        for (Map.Entry<String, Long> propDimEntry : propDimInfo.entrySet()) {
            DynamicObject[] query;
            String propKey = propDimEntry.getKey();
            if (originPropDimInfo.containsKey(propKey)) continue;
            Long dimensionId = propDimEntry.getValue();
            QFilter dimFilter = new QFilter("dimension.id", "=", (Object)dimensionId).and(new QFilter("bucafunc.id", "=", (Object)buCaFuncId));
            QFilter roleFilter = new QFilter("role", "in", roleIds);
            for (DynamicObject dy : query = roleDimHelper.query("id,role,entry.app,entry.entitytype,entry.propkey,entry.enable", new QFilter[]{dimFilter, roleFilter})) {
                String roleId = dy.getString("role.id");
                DynamicObjectCollection collection = dy.getDynamicObjectCollection("entry");
                boolean isSynced = false;
                for (DynamicObject row : collection) {
                    if (!HRStringUtils.equals((String)row.getString("propkey"), (String)propKey)) continue;
                    row.set("enable", (Object)"1");
                    DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel();
                    dimRoleInfoModel.setBuId((long)buCaFuncId.intValue());
                    dimRoleInfoModel.setDimensionId(dimensionId.longValue());
                    dimRoleInfoModel.setRoleId(roleId);
                    dimRoleInfoModel.setOpType("modify");
                    effectDimRoleInfoModelList.add(dimRoleInfoModel);
                    isSynced = true;
                    break;
                }
                if (isSynced) continue;
                DynamicObject entryRow = collection.addNew();
                entryRow.set("app", (Object)appId);
                entryRow.set("entitytype", (Object)entityId);
                entryRow.set("propkey", (Object)propKey);
                entryRow.set("enable", (Object)"1");
                DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel();
                dimRoleInfoModel.setBuId((long)buCaFuncId.intValue());
                dimRoleInfoModel.setDimensionId(dimensionId.longValue());
                dimRoleInfoModel.setRoleId(roleId);
                dimRoleInfoModel.setOpType("add");
                effectDimRoleInfoModelList.add(dimRoleInfoModel);
            }
            roleDimHelper.save(query);
        }
        logger.info("kd.hr.hrcs.formplugin.web.perm.dimension.EntityCtrlEdit.addItemPostProcessing step two  effectDimRoleInfoModelList= {}", (Object)JSONArray.toJSONString((Object)effectDimRoleInfoModelList));
        for (DynamicObject entryInfo : changedEntryInfos) {
            for (String roleId : roleIds) {
                this.addDimScope(entityId, appId, buCaFuncId, roleId, entryInfo);
                long dimensionId = entryInfo.getLong("dimension.id");
                DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel();
                dimRoleInfoModel.setBuId((long)buCaFuncId.intValue());
                dimRoleInfoModel.setDimensionId(dimensionId);
                dimRoleInfoModel.setOpType("add");
                effectDimRoleInfoModelList.add(dimRoleInfoModel);
            }
        }
        logger.info("kd.hr.hrcs.formplugin.web.perm.dimension.EntityCtrlEdit.addItemPostProcessing step three  effectDimRoleInfoModelList= {}", (Object)JSONArray.toJSONString((Object)effectDimRoleInfoModelList));
        return effectDimRoleInfoModelList;
    }

    private void addItemTip(DynamicObject entity, DynamicObjectCollection entry) {
        List collect = entry.stream().filter(it -> it.getLong("id") == 0L).collect(Collectors.toList());
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        StringBuilder tips = new StringBuilder();
        for (DynamicObject dy : collect) {
            tips.append(this.addDimTip(entity, dy, roleDimHelper));
        }
        if (tips.length() > 0) {
            this.getView().showMessage(tips.toString());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private String addDimTip(DynamicObject entity, DynamicObject dimension, HRBaseServiceHelper roleDimHelper) {
        StringBuilder msg = new StringBuilder();
        QFilter filter = new QFilter("dimension.id", "=", (Object)dimension.getLong("id")).and("entry.entitytype.id", "=", (Object)entity.getString("id")).and("entry.enable", "=", (Object)"0");
        DynamicObject[] roleDims = roleDimHelper.query("id,role.name", new QFilter[]{filter});
        for (int idx = 0; idx < roleDims.length; ++idx) {
            msg.append(roleDims[idx].getLocaleString("role.name").getLocaleValue());
            if (idx == roleDims.length - 1) continue;
            msg.append('\u3001');
        }
        if (msg.length() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u89d2\u8272%1$s\u7684\u5b9e\u4f53%2$s\u5c06\u6309%3$s\u7ef4\u5ea6\u63a7\u6743\u3002", (String)"EntityCtrlEdit_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), msg.toString(), entity.getString("name"), dimension.getString("name")));
        }
        return msg.toString();
    }

    private boolean changeMustDimPostProcessing(int buCaFuncId, DynamicObject role, DynamicObject entryInfo, StringBuilder msg, String appId, String entityId) {
        DynamicObject dimension = entryInfo.getDynamicObject("dimension");
        Long dimensionId = dimension.getLong("id");
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        String roleId = role.getString("roleid.id");
        DynamicObject dy = this.queryRoleDimension(roleDimHelper, roleId, dimensionId, buCaFuncId);
        if (null == dy) {
            dy = roleDimHelper.generateEmptyDynamicObject();
            dy.set("role", (Object)roleId);
            dy.set("dimension", (Object)dimensionId);
            dy.set("bucafunc", (Object)buCaFuncId);
            DynamicObjectCollection coll = roleDimHelper.generateEmptyEntryCollection(dy, "entry");
            DynamicObject entryRow = coll.addNew();
            entryRow.set("app", (Object)appId);
            entryRow.set("entitytype", (Object)entityId);
            entryRow.set("propkey", (Object)entryInfo.getString("propkey"));
            entryRow.set("enable", (Object)"1");
            roleDimHelper.saveOne(dy);
            msg.append(role.getString("roleid.name")).append('\u3001');
            return false;
        }
        return true;
    }

    private void addDimScope(String entityId, String appId, Integer buCaFuncId, String roleId, DynamicObject entryInfo) {
        Long dimensionId = entryInfo.getLong("dimension.id");
        String propKey = entryInfo.getString("propkey");
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObject dy = this.queryRoleDimension(roleDimHelper, roleId, dimensionId, buCaFuncId);
        if (dy == null) {
            dy = roleDimHelper.generateEmptyDynamicObject();
            dy.set("role", (Object)roleId);
            dy.set("dimension", (Object)dimensionId);
            dy.set("bucafunc", (Object)buCaFuncId);
        }
        DynamicObjectCollection collection = dy.getDynamicObjectCollection("entry");
        DynamicObject entry = collection.addNew();
        entry.set("app", (Object)appId);
        entry.set("entitytype", (Object)entityId);
        entry.set("propkey", (Object)propKey);
        entry.set("enable", (Object)"1");
        roleDimHelper.saveOne(dy);
    }

    private DynamicObject queryRoleDimension(HRBaseServiceHelper roleDimHelper, String roleId, Long dimensionId, Integer buCaFuncId) {
        QFilter filter = new QFilter("role.id", "=", (Object)roleId).and(new QFilter("dimension.id", "=", (Object)dimensionId)).and(new QFilter("bucafunc.id", "=", (Object)buCaFuncId));
        return roleDimHelper.queryOne("id,entry.id,entry.app,entry.entitytype,entry.propkey,entry.enable", new QFilter[]{filter});
    }
}

