/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.log.EntityCtrlLogService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlEntryRowModel;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@ExcludeFromJacocoGeneratedReport
public class EntityCtrlTreeListPlugin
extends AbstractTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(EntityCtrlTreeListPlugin.class);

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        evt.getQFilters().add(new QFilter("entitytype.number", "is not null", null));
        Set noExistedEntityNumbers = EntityCtrlServiceHelper.getAllNoExistEntityCtrlNumbers();
        if (CollectionUtils.isNotEmpty((Collection)noExistedEntityNumbers)) {
            LOGGER.warn("hrcs_entityctrl noExistedEntityNumbers:{}", (Object)noExistedEntityNumbers);
            evt.getQFilters().add(new QFilter("entitytype", "not in", (Object)noExistedEntityNumbers));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("delete")) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Set ids = listSelectedData.stream().map(it -> Long.valueOf(String.valueOf(it.getPrimaryKeyValue()))).collect(Collectors.toSet());
            Set entryIds = listSelectedData.stream().map(it -> Long.valueOf(String.valueOf(it.getEntryPrimaryKeyValue()))).collect(Collectors.toSet());
            HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
            DynamicObject[] selectData = entityCtrlHelper.query("id,entitytype,bizapp,entryentity.dimension,entryentity.propkey,entryentity.authrange,entryentity.ismust,entryentity.issyspreset,entryentity.seq", new QFilter[]{new QFilter("id", "in", ids)});
            HashMap dimRoles = new HashMap(listSelectedData.size());
            ArrayList<String> toDelDimRoleRanges = new ArrayList<String>(16);
            ArrayList entityCtrlLogInfos = Lists.newArrayListWithExpectedSize((int)selectData.length);
            for (DynamicObject selectDatum : selectData) {
                DynamicObject entityType = selectDatum.getDynamicObject("entitytype");
                if (Objects.isNull(entityType)) {
                    LOGGER.info("entityType not exist.");
                    continue;
                }
                String appId = selectDatum.getString("bizapp.id");
                String entityNum = entityType.getString("number");
                String buId = HRBuCaServiceHelper.getBuCaFuncFromSpec((String)entityNum, (String)appId);
                DynamicObjectCollection collection = selectDatum.getDynamicObjectCollection("entryentity");
                ArrayList<Integer> selectRows = new ArrayList<Integer>(collection.size());
                EntityCtrlModel entityCtrlModel = new EntityCtrlModel(entityNum);
                ArrayList beforeEntryRows = Lists.newArrayListWithExpectedSize((int)collection.size());
                Map entityFieldMap = RolePermLogServiceHelper.getEntityFieldMap((String)entityNum);
                for (DynamicObject entryRow : collection) {
                    if (!entryIds.contains(entryRow.getLong("id"))) continue;
                    if (entryRow.getBoolean("issyspreset")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u65e0\u6cd5\u5220\u9664\u3002", (String)"EntityCtrlTreeListPlugin_01", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    selectRows.add(entryRow.getInt("seq") - 1);
                    long dimId = entryRow.getLong("dimension.id");
                    String propKey = entryRow.getString("propkey");
                    toDelDimRoleRanges.add(dimId + "|" + entityNum + "|" + propKey + "|" + buId);
                    EntityCtrlEntryRowModel tmp = new EntityCtrlEntryRowModel((String)entityFieldMap.get(propKey), entryRow.getString("dimension.name"), entryRow.getString("authrange"), entryRow.getBoolean("ismust"));
                    beforeEntryRows.add(tmp);
                }
                int[] rows = new int[selectRows.size()];
                for (int index = 0; index < selectRows.size(); ++index) {
                    rows[index] = (Integer)selectRows.get(index);
                }
                List effectDimRoleInfoModelList = EntityCtrlServiceHelper.getDimRelRoles((DynamicObject)entityType, (DynamicObjectCollection)collection, (int[])rows, dimRoles, (String)buId);
                entityCtrlModel.setBeforeEntryRows((List)beforeEntryRows);
                entityCtrlModel.setEffectDimRoleList(effectDimRoleInfoModelList);
                entityCtrlModel.setLogType(Long.valueOf(4020L));
                entityCtrlLogInfos.add(entityCtrlModel);
            }
            this.getPageCache().put("toDelDimRoleRanges", SerializationUtils.toJsonString(toDelDimRoleRanges));
            this.getPageCache().put("logInfos", JSONArray.toJSONString((Object)entityCtrlLogInfos));
            boolean hasRoles = dimRoles.entrySet().stream().anyMatch(it -> ((List)it.getValue()).size() > 0);
            if (!hasRoles) {
                return;
            }
            EntityCtrlServiceHelper.showDelTip(dimRoles, (IFormView)this.getView(), (IFormPlugin)this);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operateKey.equals("delete") && operationResult.isSuccess()) {
            HRPermCacheMgr.clearAllCache();
            this.resolvePermLog();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId.equals("delete_confirm") && (map = (Map)returnData).get("confirmResult") != null && ((String)map.get("confirmResult")).equals("yes")) {
            IPageCache pageCache = this.getPageCache();
            List toDelDimRoleRanges = (List)SerializationUtils.fromJsonString((String)pageCache.get("toDelDimRoleRanges"), List.class);
            HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
            for (String toDelDimRoleRange : toDelDimRoleRanges) {
                String[] split = toDelDimRoleRange.split("\\|");
                boolean success = EntityCtrlServiceHelper.deleteRoleRange((HRBaseServiceHelper)roleDimHelper, (long)Long.parseLong(split[0]), (String)split[1], (String)split[2], (Long)Long.valueOf(split[3]), (IFormView)this.getView(), null);
                pageCache.remove("toDelDimRoleRanges");
                if (!success) continue;
                IListView listView = (IListView)this.getView();
                Object[] ids = listView.getSelectedRows().getPrimaryKeyValues();
                DeleteServiceHelper.delete((String)"hrcs_entityctrl", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                listView.refresh();
                listView.clearSelection();
            }
            this.resolvePermLog();
        }
    }

    private void resolvePermLog() {
        String logInfoStr = this.getPageCache().get("logInfos");
        if (HRStringUtils.isNotEmpty((String)logInfoStr)) {
            List entityCtrlLogInfos = JSONArray.parseArray((String)logInfoStr, EntityCtrlModel.class);
            EntityCtrlLogService.resolveLog((List)entityCtrlLogInfos);
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent evt) {
        IPageCache pageCache = this.getPageCache();
        String entityFieldNameMapStr = pageCache.get("entityFieldNameMap");
        HashMap<String, Map<String, String>> entityFieldNameMap = HRStringUtils.isNotEmpty((String)entityFieldNameMapStr) ? (HashMap<String, Map<String, String>>)SerializationUtils.fromJsonString((String)entityFieldNameMapStr, Map.class) : new HashMap<String, Map<String, String>>(16);
        IHRAppCache appCache = HRAppCache.get((String)"hrcs");
        HashMap<String, Set<String>> entityFields = (HashMap<String, Set<String>>)appCache.get("entityFields", Map.class);
        if (MapUtils.isEmpty((Map)entityFields)) {
            entityFields = new HashMap<String, Set<String>>(16);
        }
        DynamicObject[] entityCtrls = evt.getQueryValues();
        ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (DynamicObject entityCtrl : entityCtrls) {
            String entity = entityCtrl.getString("entitytype.id");
            Map<String, String> fieldMap = (Map<String, String>)entityFieldNameMap.get(entity);
            if (MapUtils.isEmpty((Map)fieldMap)) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                fieldMap = customQuery.parsePropertySub((IDataEntityType)mainEntityType, null, customParams, "1=1", new ArrayList(10)).stream().collect(Collectors.toMap(it -> (String)it.get("field_id"), it -> (String)it.get("field_name"), (newVal, oldVal) -> oldVal));
                entityFieldNameMap.put(entity, fieldMap);
                entityFields.put(entity, fieldMap.keySet());
            }
            DynamicObjectCollection collection = entityCtrl.getDynamicObjectCollection("entryentity");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DynamicObject row;
                String propKey = (row = (DynamicObject)iterator.next()).getString("propkey");
                String propName = fieldMap.get(propKey);
                row.set("propname", (Object)(HRStringUtils.isEmpty((String)propName) ? propKey : propName));
            }
        }
        pageCache.put("entityFieldNameMap", SerializationUtils.toJsonString(entityFieldNameMap));
        appCache.put("entityFields", entityFields);
    }
}

