/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class EntityForBidPlugin
extends HRDataBaseEdit {
    private static final String KEY_TO_ADD_FORBID_INFOS = "toAddForBidInfos";
    private static final String KEY_TO_REMOVE_FORBID_INFOS = "toRemoveForBidInfos";
    private static final String KEY_ADDED_FORBID_INFOS = "addedForBidInfos";
    private static final String KEY_ADDED_FORBID_IDS = "addedForBidIds";
    private static final String KEY_ASSIGNED_ENTITYENTITY = "assignedentryentity";

    public void loadData(LoadDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void createNewData(BizDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void afterCreateNewData(EventObject evt) {
        this.queryExistedForBidInfo();
        this.getModel().setValue("forbidtype", (Object)"2");
        this.rebuildForbidEntry("2");
        this.getModel().setDataChanged(false);
    }

    private void queryExistedForBidInfo() {
        EntityCtrlServiceHelper.queryExistedForBidInfo((IFormView)this.getView());
        this.getPageCache().put(KEY_TO_ADD_FORBID_INFOS, SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)10)));
        this.getPageCache().put(KEY_TO_REMOVE_FORBID_INFOS, SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)10)));
        this.getPageCache().put(KEY_ADDED_FORBID_INFOS, SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)10)));
        this.getPageCache().put(KEY_ADDED_FORBID_IDS, SerializationUtils.toJsonString((Object)Maps.newHashMapWithExpectedSize((int)16)));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        ChangeData changeData = changeSet[0];
        if (HRStringUtils.equals((String)name, (String)"forbidtype")) {
            int rowCount = this.getModel().getEntryRowCount(KEY_ASSIGNED_ENTITYENTITY);
            if (rowCount > 0) {
                String tip = ResManager.loadKDString((String)"\u5207\u6362\u7c7b\u578b\u5c06\u6e05\u7a7a\u5df2\u9009\u7684\u6570\u636e\uff0c\u786e\u5b9a\u5207\u6362\u5417\uff1f", (String)"EntityForBidPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(tip, MessageBoxOptions.YesNo, new ConfirmCallBackListener("changeTypeConfirm", (IFormPlugin)this));
                this.getPageCache().put("oldType", (String)changeData.getOldValue());
                return;
            }
            String forbidType = (String)changeSet[0].getNewValue();
            this.rebuildAssignedEntry(forbidType);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (HRStringUtils.equals((String)"changeTypeConfirm", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                String forbidType = this.getModelValStr("forbidtype");
                this.rebuildAssignedEntry(forbidType);
            } else {
                String oldType = this.getPageCache().get("oldType");
                this.getModel().beginInit();
                this.getModel().setValue("forbidtype", (Object)oldType);
                this.getModel().endInit();
                this.getView().updateView("forbidtype");
            }
        } else if (HRStringUtils.equals((String)"closeConfirm", (String)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.getPageCache().put("closeConfirmed", "1");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        List addForbidInfos = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TO_ADD_FORBID_INFOS), List.class);
        List toRemoveForbidIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TO_REMOVE_FORBID_INFOS), List.class);
        String closeConfirmed = this.getPageCache().get("closeConfirmed");
        if (HRStringUtils.isNotEmpty((String)closeConfirmed)) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)addForbidInfos) || CollectionUtils.isNotEmpty((Collection)toRemoveForbidIds)) {
            String tip = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u9000\u51fa\u540e\u5c06\u4e0d\u4fdd\u5b58\u6570\u636e\u3002\u662f\u5426\u9000\u51fa\uff1f", (String)"EntityForBidPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tip, MessageBoxOptions.YesNo, new ConfirmCallBackListener("closeConfirm", (IFormPlugin)this));
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"add", (String)operateKey)) {
            this.addDataToAssignedEntry();
            this.getModel().setDataChanged(false);
        } else if (HRStringUtils.equals((String)"remove", (String)operateKey)) {
            this.removeData();
            this.getModel().setDataChanged(false);
        } else if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            int rowCount = this.getModel().getEntryRowCount(KEY_ASSIGNED_ENTITYENTITY);
            IPageCache pageCache = this.getPageCache();
            List addForbidList = (List)SerializationUtils.fromJsonString((String)pageCache.get(KEY_TO_ADD_FORBID_INFOS), List.class);
            List toRemoveForbidIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TO_REMOVE_FORBID_INFOS), List.class);
            if (rowCount <= 0 && CollectionUtils.isEmpty((Collection)addForbidList) && CollectionUtils.isEmpty((Collection)toRemoveForbidIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"EntityForBidPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.saveForbidInfo(addForbidList, toRemoveForbidIds);
            this.getView().setEnable(Boolean.FALSE, new String[]{"forbidtype"});
        }
    }

    private void saveForbidInfo(List<String> addForbidList, List<Long> toRemoveForbidIds) {
        IPageCache pageCache = this.getPageCache();
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ASSIGNED_ENTITYENTITY);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityforbid");
        ArrayList toSaveRows = Lists.newArrayListWithCapacity((int)collection.size());
        String forbidType = (String)this.getModel().getValue("forbidtype");
        long currUserId = RequestContext.get().getCurrUserId();
        for (String rowKey : addForbidList) {
            String[] forbidInfo = rowKey.split("#");
            DynamicObject temp = serviceHelper.generateEmptyDynamicObject();
            temp.set("forbidtype", (Object)forbidType);
            temp.set("app", (Object)forbidInfo[0]);
            temp.set("entitytypeid", (Object)forbidInfo[1]);
            temp.set("permitem", (Object)forbidInfo[2]);
            temp.set("creator", (Object)currUserId);
            toSaveRows.add(temp);
        }
        serviceHelper.save(toSaveRows.toArray(new DynamicObject[0]));
        pageCache.put(KEY_TO_ADD_FORBID_INFOS, SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)10)));
        Map forBidMap = (Map)SerializationUtils.fromJsonString((String)pageCache.get(KEY_ADDED_FORBID_IDS), Map.class);
        for (int index = 0; index < addForbidList.size(); ++index) {
            forBidMap.put(addForbidList.get(index), ((DynamicObject)toSaveRows.get(index)).getLong("id"));
        }
        pageCache.put(KEY_ADDED_FORBID_IDS, SerializationUtils.toJsonString((Object)forBidMap));
        if (CollectionUtils.isNotEmpty(toRemoveForbidIds)) {
            serviceHelper.delete((Object[])toRemoveForbidIds.toArray(new Long[0]));
        }
        this.getPageCache().put(KEY_TO_REMOVE_FORBID_INFOS, SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)10)));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"EntityForBidPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void removeData() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ASSIGNED_ENTITYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ASSIGNED_ENTITYENTITY);
        ArrayList selectedList = Lists.newArrayListWithCapacity((int)selectRows.length);
        for (int selectRow : selectRows) {
            selectedList.add(selectRow + 1);
        }
        List addForbidInfos = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TO_ADD_FORBID_INFOS), List.class);
        List toRemoveForbidIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TO_REMOVE_FORBID_INFOS), List.class);
        Map forbidMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_ADDED_FORBID_IDS), Map.class);
        for (DynamicObject row : collection) {
            if (!selectedList.contains(row.getInt("seq"))) continue;
            String appId = row.getString("assignedapp.id");
            String entityId = row.getString("assignedentity.id");
            String permId = row.getString("assignedpermitem.id");
            String rowKey = appId + "#" + entityId + "#" + permId;
            addForbidInfos.remove(rowKey);
            if (!forbidMap.containsKey(rowKey)) continue;
            toRemoveForbidIds.add(forbidMap.get(rowKey));
        }
        this.getPageCache().put(KEY_TO_ADD_FORBID_INFOS, SerializationUtils.toJsonString((Object)addForbidInfos));
        this.getPageCache().put(KEY_ADDED_FORBID_INFOS, SerializationUtils.toJsonString((Object)addForbidInfos));
        this.getPageCache().put(KEY_TO_REMOVE_FORBID_INFOS, SerializationUtils.toJsonString((Object)toRemoveForbidIds));
        this.getModel().deleteEntryRows(KEY_ASSIGNED_ENTITYENTITY, selectRows);
        entryGrid.selectRows(new int[0], 0);
    }

    private void addDataToAssignedEntry() {
        TableValueSetter setter;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList selectedList = Lists.newArrayListWithCapacity((int)selectRows.length);
        for (int selectRow : selectRows) {
            selectedList.add(selectRow);
        }
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e", (String)"EntityForBidPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        List addForbidInfos = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_TO_ADD_FORBID_INFOS), List.class);
        List addedForbidInfos = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_ADDED_FORBID_INFOS), List.class);
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        ArrayList toAddRows = Lists.newArrayListWithExpectedSize((int)selectRows.length);
        ArrayList addForbidNew = Lists.newArrayListWithExpectedSize((int)selectRows.length);
        for (DynamicObject row2 : collection) {
            String appId = row2.getString("bizapp.id");
            String entityId = row2.getString("entity.id");
            String permId = row2.getString("permitemid.id");
            int seq = row2.getInt("seq") - 1;
            String rowKey = appId + "#" + entityId + "#" + permId;
            if (!selectedList.contains(seq) || addedForbidInfos.contains(rowKey)) continue;
            addForbidNew.add(rowKey);
            toAddRows.add(row2);
        }
        addedForbidInfos.addAll(addForbidNew);
        addForbidInfos.addAll(addForbidNew);
        this.getPageCache().put(KEY_TO_ADD_FORBID_INFOS, SerializationUtils.toJsonString((Object)addForbidInfos));
        this.getPageCache().put(KEY_ADDED_FORBID_INFOS, SerializationUtils.toJsonString((Object)addedForbidInfos));
        String forbidType = (String)this.getModel().getValue("forbidtype");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        if (HRStringUtils.equals((String)"1", (String)forbidType) || HRStringUtils.equals((String)"3", (String)forbidType)) {
            setter = new TableValueSetter(new String[]{"assignedcloud", "assignedapp", "assignedentity"});
            toAddRows.forEach(row -> setter.addRow(new Object[]{row.getString("cloud.id"), row.getString("bizapp.id"), row.getString("entity.id")}));
        } else if (HRStringUtils.equals((String)"2", (String)forbidType)) {
            setter = new TableValueSetter(new String[]{"assignedcloud", "assignedapp"});
            toAddRows.forEach(row -> setter.addRow(new Object[]{row.getString("cloud.id"), row.getString("bizapp.id")}));
        } else {
            setter = new TableValueSetter(new String[]{"assignedcloud", "assignedapp", "assignedentity", "assignedpermitem"});
            toAddRows.forEach(row -> setter.addRow(new Object[]{row.getString("cloud.id"), row.getString("bizapp.id"), row.getString("entity.id"), row.getString("permitemid.id")}));
        }
        model.batchCreateNewEntryRow(KEY_ASSIGNED_ENTITYENTITY, setter);
        model.endInit();
        this.getView().updateView(KEY_ASSIGNED_ENTITYENTITY);
        entryGrid.selectRows(new int[0], 0);
    }

    private void rebuildAssignedEntry(String forbidType) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d\u4e2d", (String)"EntityForBidPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])));
        this.rebuildForbidEntry(forbidType);
        this.getPageCache().put(KEY_TO_ADD_FORBID_INFOS, SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)10)));
        this.getPageCache().put(KEY_ADDED_FORBID_INFOS, SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)10)));
        this.getView().hideLoading();
    }

    private void rebuildForbidEntry(String forbidType) {
        this.clearEntryFilter("entryentity");
        this.clearEntryFilter(KEY_ASSIGNED_ENTITYENTITY);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData(KEY_ASSIGNED_ENTITYENTITY);
        this.getView().updateView("entryentity");
        this.getView().updateView(KEY_ASSIGNED_ENTITYENTITY);
        switch (forbidType) {
            case "1": {
                this.buildEntityEntry(false, false);
                break;
            }
            case "2": {
                this.buildAppEntry();
                break;
            }
            case "3": {
                this.buildEntityEntry(true, false);
                break;
            }
            case "4": {
                this.buildEntityEntry(false, true);
                break;
            }
            case "5": {
                this.buildEntityEntry(true, true);
            }
        }
    }

    private void clearEntryFilter(String entryKey) {
        EntryQueryParam entryQueryParam = this.getModel().getEntryQueryParam(entryKey);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)10);
        for (EntryFilterItemInfo filterItem : entryQueryParam.getFilterItems()) {
            HashMap temp = Maps.newHashMapWithExpectedSize((int)3);
            temp.put("FieldName", Lists.newArrayList((Object[])new Object[]{filterItem.getPropName()}));
            temp.put("Compare", Lists.newArrayListWithExpectedSize((int)0));
            temp.put("Value", Lists.newArrayListWithExpectedSize((int)0));
            filters.add(temp);
        }
        entryGrid.getGridDataByFilter((List)filters);
        if (entryQueryParam.needFilterAndSort()) {
            if (CollectionUtils.isNotEmpty((Collection)entryQueryParam.getFilterItems())) {
                this.callClientActionResetFilter(new Object[0], entryKey);
            }
            if (CollectionUtils.isNotEmpty((Collection)entryQueryParam.getSortItems())) {
                this.callClientActionSetGridSorting(new Object[0], entryKey);
            }
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.remove("entryQueryParam." + entryKey);
            this.getView().updateView(entryKey);
        }
    }

    private void callClientActionSetGridSorting(Object parameter, String entryKey) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.removeInvokeControlMethod(entryKey, "setGridSorting");
        clientViewProxy.invokeControlMethod(entryKey, "setGridSorting", new Object[]{parameter});
    }

    private void callClientActionResetFilter(Object parameter, String entryKey) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.removeInvokeControlMethod(entryKey, "resetFilter");
        clientViewProxy.invokeControlMethod(entryKey, "resetFilter", new Object[]{parameter});
    }

    private void buildAppEntry() {
        Map<String, String> appInfos = this.queryAppInfos(false);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[]{"cloud", "bizapp"});
        for (Map.Entry<String, String> appEntry : appInfos.entrySet()) {
            setter.addRow(new Object[]{appEntry.getValue(), appEntry.getKey()});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        this.getView().setVisible(Boolean.FALSE, new String[]{"entity", "entitynum", "permitemid"});
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().setVisible(Boolean.FALSE, new String[]{"assignedentity", "assignedentitynum", "assignedpermitem"});
        this.getView().updateView(KEY_ASSIGNED_ENTITYENTITY);
    }

    private void buildEntityEntry(boolean containsDeploy, boolean showPerm) {
        TableValueSetter setter;
        Map<String, String> appInfos = this.queryAppInfos();
        Map<String, List<String>> entityInfos = this.queryEntityInfos(appInfos.keySet(), containsDeploy);
        Map<Object, Object> entityPermMap = Maps.newHashMapWithExpectedSize((int)16);
        if (showPerm) {
            HashSet entitySet = Sets.newHashSetWithExpectedSize((int)16);
            entityInfos.forEach((key, value) -> entitySet.addAll(value));
            entityPermMap = this.queryHRFuncItemGroup(entitySet);
            setter = new TableValueSetter(new String[]{"cloud", "bizapp", "entity", "permitemid"});
        } else {
            setter = new TableValueSetter(new String[]{"cloud", "bizapp", "entity"});
        }
        Map<Object, Object> allPermRelate = Maps.newHashMapWithExpectedSize((int)16);
        if (containsDeploy && showPerm) {
            allPermRelate = this.queryAllPermRelateInfo();
        }
        Map appEntityPerm = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("appEntityPerm"), Map.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (Map.Entry<String, String> appEntry : appInfos.entrySet()) {
            String appId = appEntry.getKey();
            List<String> entitySet = entityInfos.get(appId);
            boolean containsApp = appEntityPerm.containsKey(appId);
            if (CollectionUtils.isEmpty(entitySet)) continue;
            Map relateEntityPerm = (Map)allPermRelate.get(appId);
            boolean relateNotEmpty = MapUtils.isNotEmpty((Map)relateEntityPerm);
            if (!showPerm) {
                for (String entity : entitySet) {
                    setter.addRow(new Object[]{appEntry.getValue(), appId, entity});
                }
                continue;
            }
            for (String entity : entitySet) {
                boolean containsEntity;
                boolean bl = containsEntity = containsApp && ((Map)appEntityPerm.get(appId)).containsKey(entity);
                List permItems = (List)entityPermMap.get(entity);
                if (CollectionUtils.isEmpty((Collection)permItems)) continue;
                if (relateNotEmpty && relateEntityPerm.containsKey(entity)) {
                    permItems.removeAll((Collection)relateEntityPerm.get(entity));
                }
                for (String permItem : permItems) {
                    if (containsEntity && ((List)((Map)appEntityPerm.get(appId)).get(entity)).contains(permItem)) continue;
                    setter.addRow(new Object[]{appEntry.getValue(), appId, entity, permItem});
                }
            }
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        this.getView().setVisible(Boolean.TRUE, new String[]{"entity", "entitynum"});
        this.getView().setVisible(Boolean.valueOf(showPerm), new String[]{"permitemid"});
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().setVisible(Boolean.TRUE, new String[]{"assignedentity", "assignedentitynum"});
        this.getView().setVisible(Boolean.valueOf(showPerm), new String[]{"assignedpermitem"});
        this.getView().updateView(KEY_ASSIGNED_ENTITYENTITY);
    }

    public Map<String, List<String>> queryHRFuncItemGroup(Set<String> entityNumSet) {
        IPageCache pageCache = this.getPageCache();
        String itemGroupStr = pageCache.get("itemGroup");
        Map itemGroup = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)itemGroupStr)) {
            itemGroup = (Map)SerializationUtils.fromJsonString((String)itemGroupStr, Map.class);
        } else {
            Map entityPerm = (Map)SerializationUtils.fromJsonString((String)pageCache.get("entityPerm"), Map.class);
            Map<String, String> permItemMap = this.getFuncPermInfo(entityNumSet, itemGroup, entityPerm);
            pageCache.put("itemGroup", SerializationUtils.toJsonString((Object)itemGroup));
            pageCache.put("permItemMap", SerializationUtils.toJsonString(permItemMap));
        }
        return itemGroup;
    }

    private Map<String, String> getFuncPermInfo(Set<String> entityNumSet, Map<String, List<String>> itemGroup, Map<String, List<String>> entityPerm) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_functionperm");
        DynamicObjectCollection collection = serviceHelper.queryOriginalCollection("permitem.id,permitem.number,entitytype.id", new QFilter[]{new QFilter("entitytype", "in", entityNumSet)}, "seq");
        HashMap permItemMap = Maps.newHashMapWithExpectedSize((int)collection.size());
        for (DynamicObject row : collection) {
            String entity = row.getString("entitytype.id");
            String permItem = row.getString("permitem.id");
            String permItemNum = row.getString("permitem.number");
            if (!permItemMap.containsKey(permItemNum)) {
                permItemMap.put(permItemNum, permItem);
            }
            if (entityPerm.containsKey(entity) && (!entityPerm.containsKey(entity) || entityPerm.get(entity).contains(permItem))) continue;
            List funcs = itemGroup.computeIfAbsent(entity, key -> Lists.newArrayListWithExpectedSize((int)10));
            funcs.add(permItem);
        }
        permItemMap.remove(null);
        return permItemMap;
    }

    private Map<String, List<String>> queryEntityInfos(Set<String> appSet, boolean containsDeploy) {
        IPageCache pageCache = this.getPageCache();
        String forBidEntityStr = pageCache.get("forbidEntity#" + containsDeploy);
        Map<String, List<String>> appEntity = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)forBidEntityStr)) {
            appEntity = (Map)SerializationUtils.fromJsonString((String)forBidEntityStr, Map.class);
            return appEntity;
        }
        List entityNums = (List)SerializationUtils.fromJsonString((String)pageCache.get("entityNums"), List.class);
        Map forBidAppEntity = (Map)SerializationUtils.fromJsonString((String)pageCache.get("appEntity"), Map.class);
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        QFilter filter = new QFilter("bizappid.id", "in", appSet);
        if (CollectionUtils.isNotEmpty((Collection)entityNums)) {
            filter = filter.and("id", "not in", (Object)entityNums);
        }
        DynamicObjectCollection collection = entityHelper.queryOriginalCollection("id,bizappid.id", new QFilter[]{filter});
        Map<String, String> appParentMap = this.queryAppMasterId();
        for (DynamicObject row : collection) {
            String appId = row.getString("bizappid.id");
            appId = appParentMap.getOrDefault(appId, appId);
            String entity = row.getString("id");
            if (forBidAppEntity.containsKey(appId) && (!forBidAppEntity.containsKey(appId) || ((List)forBidAppEntity.get(appId)).contains(entity))) continue;
            List entitySet = appEntity.computeIfAbsent(appId, key -> Lists.newArrayListWithExpectedSize((int)10));
            entitySet.add(entity);
        }
        if (!containsDeploy) {
            pageCache.put("forbidEntity#" + containsDeploy, SerializationUtils.toJsonString((Object)appEntity));
            return appEntity;
        }
        HRBaseServiceHelper objAPPHelper = new HRBaseServiceHelper("perm_bizobjapp");
        QFilter forBidFilter = new QFilter("bizapp.id", "in", appSet);
        if (CollectionUtils.isNotEmpty((Collection)entityNums)) {
            forBidFilter = forBidFilter.and("bizobj.id", "not in", (Object)entityNums);
        }
        DynamicObjectCollection objAppColl = objAPPHelper.queryOriginalCollection("bizobj.id,bizapp.id", new QFilter[]{forBidFilter});
        for (DynamicObject row : objAppColl) {
            String appId = row.getString("bizapp.id");
            String entity = row.getString("bizobj.id");
            if (forBidAppEntity.containsKey(appId) && (!forBidAppEntity.containsKey(appId) || ((List)forBidAppEntity.get(appId)).contains(entity))) continue;
            List entitySet = appEntity.computeIfAbsent(appId, key -> Lists.newArrayListWithExpectedSize((int)10));
            entitySet.add(entity);
        }
        pageCache.put("forbidEntity#" + containsDeploy, SerializationUtils.toJsonString(appEntity));
        return appEntity;
    }

    private Map<String, String> queryAppInfos() {
        Map appInfos;
        String appInfoStr = this.getPageCache().get("appInfos");
        if (HRStringUtils.isNotEmpty((String)appInfoStr)) {
            appInfos = (Map)SerializationUtils.fromJsonString((String)appInfoStr, Map.class);
        } else {
            appInfos = this.queryAppInfos(true);
            this.getPageCache().put("appInfos", SerializationUtils.toJsonString((Object)appInfos));
        }
        return appInfos;
    }

    private Map<String, String> queryAppInfos(boolean containsExt) {
        List apps;
        Set allHRCloudId = HRCloudServiceHelper.getAllHRCloudId();
        HRBaseServiceHelper bizAppHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)10);
        filterList.add(new QFilter("bizcloud.id", "in", (Object)allHRCloudId));
        filterList.add(new QFilter("deploystatus", "=", (Object)"2"));
        if (!containsExt) {
            filterList.add(new QFilter("parentid", "=", (Object)" "));
        }
        if (CollectionUtils.isNotEmpty((Collection)(apps = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("apps"), List.class)))) {
            filterList.add(new QFilter("id", "not in", (Object)apps));
        }
        DynamicObjectCollection collection = bizAppHelper.queryOriginalCollection("bizcloud.id,id", filterList.toArray(new QFilter[0]));
        return collection.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("bizcloud.id"), (newVal, oldVal) -> newVal));
    }

    private Map<String, String> queryAppMasterId() {
        Set allHRCloudId = HRCloudServiceHelper.getAllHRCloudId();
        HRBaseServiceHelper bizAppHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)10);
        filterList.add(new QFilter("bizcloud.id", "in", (Object)allHRCloudId));
        filterList.add(new QFilter("deploystatus", "=", (Object)"2"));
        filterList.add(new QFilter("parentid", "!=", (Object)" "));
        DynamicObjectCollection collection = bizAppHelper.queryOriginalCollection("id,masterid", filterList.toArray(new QFilter[0]));
        return collection.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("masterid"), (newVal, oldVal) -> newVal));
    }

    private Map<String, Map<String, List<String>>> queryAllPermRelateInfo() {
        IPageCache pageCache = this.getPageCache();
        String allPermRelateStr = pageCache.get("allPermRelate");
        if (HRStringUtils.isNotEmpty((String)allPermRelateStr)) {
            return (Map)SerializationUtils.fromJsonString((String)allPermRelateStr, Map.class);
        }
        Map permItemMap = (Map)SerializationUtils.fromJsonString((String)pageCache.get("permItemMap"), Map.class);
        HRBaseServiceHelper permRelateHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] allRelateArr = permRelateHelper.loadDynamicObjectArray(new QFilter[0]);
        HashMap allRelateMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : allRelateArr) {
            String mainAppId = dy.getString("bizapp.id");
            String mainEntityId = dy.getString("entitytype.id");
            String mainPermItemId = dy.getString("mainpermitem");
            if (HRStringUtils.isNotEmpty((String)mainAppId) && HRStringUtils.isNotEmpty((String)mainEntityId) && HRStringUtils.isNotEmpty((String)mainPermItemId)) {
                Map entityPermMap = allRelateMap.computeIfAbsent(mainAppId, key -> Maps.newHashMapWithExpectedSize((int)16));
                List permNums = entityPermMap.computeIfAbsent(mainEntityId, key -> Lists.newArrayListWithExpectedSize((int)10));
                permNums.add(permItemMap.get(mainPermItemId));
            }
            DynamicObjectCollection coll = dy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : coll) {
                String appId = entryRow.getString("app.id");
                String entityId = entryRow.getString("entitytypeid.id");
                String permItemStr = entryRow.getString("permitem");
                if (!HRStringUtils.isNotEmpty((String)appId) || !HRStringUtils.isNotEmpty((String)entityId) || !HRStringUtils.isNotEmpty((String)permItemStr)) continue;
                String[] permItemIdArr = permItemStr.split(",");
                List permIds = Arrays.stream(permItemIdArr).map(it -> (String)permItemMap.get(it)).collect(Collectors.toList());
                Map entityPermMapTemp = allRelateMap.computeIfAbsent(appId, key -> Maps.newHashMapWithExpectedSize((int)16));
                List permNumsTemp = entityPermMapTemp.computeIfAbsent(entityId, key -> Lists.newArrayListWithExpectedSize((int)10));
                permNumsTemp.addAll(permIds);
            }
        }
        pageCache.put("allPermRelate", SerializationUtils.toJsonString((Object)allRelateMap));
        return allRelateMap;
    }
}

