/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class EntityForbidListPlugin
extends HRDataBaseList {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"generatesql", (String)operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            Object[] pkIds = selectedRows.getPrimaryKeyValues();
            Map objs = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)"hrcs_entityforbid");
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : objs.entrySet()) {
                DynamicObject obj = (DynamicObject)entry.getValue();
                String itemSql = this.generateSql(obj);
                if (!StringUtils.isNotEmpty((String)itemSql)) continue;
                sb.append(itemSql);
            }
            this.exportSql(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private String generateSql(DynamicObject obj) {
        Object pkValue = obj.getPkValue();
        String forbidType = obj.getString("forbidtype");
        if (HRStringUtils.isEmpty((String)forbidType)) {
            return " ";
        }
        String app = HRStringUtils.isNotEmpty((String)obj.getString("app.id")) ? obj.getString("app.id") : " ";
        String entity = HRStringUtils.isNotEmpty((String)obj.getString("entitytypeid.id")) ? obj.getString("entitytypeid.id") : " ";
        String permItemId = HRStringUtils.isNotEmpty((String)obj.getString("permitem.id")) ? obj.getString("permitem.id") : " ";
        Date date = obj.getDate("createtime");
        String createTime = HRDateTimeUtils.format((Date)(date != null ? date : new Date()), (String)"yyyy-MM-dd HH:mm:ss");
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM T_HRCS_ENTITYFORBID WHERE FID = ").append(pkValue).append(";\r\n");
        sql.append("INSERT INTO T_HRCS_ENTITYFORBID (FID, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FAPPID, FENTITYTYPEID, FPERMITEMID, FFORBIDTYPE, FISSYSPRESET) VALUES (");
        sql.append(pkValue).append(", ");
        sql.append("1, ");
        sql.append("{ts'").append(createTime).append("'}, ");
        sql.append("1, ");
        sql.append("{ts'").append(createTime).append("'}, '");
        sql.append(app).append("', '");
        sql.append(entity).append("', '");
        sql.append(permItemId).append("', '");
        sql.append(forbidType).append("', '");
        sql.append("1'");
        sql.append(");\r\n");
        return sql.toString();
    }

    private void exportSql(byte[] sql) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("kd_X.X.X_hrcs_entityforbid.sql", sql, 5000);
        this.getView().openUrl(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f!", (String)"EntityForbidListPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
    }
}

