/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.dimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hrcs.bussiness.service.perm.dimension.PermRtSyncService;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper;
import kd.hr.hrcs.common.model.RelatePermInfo;

@ExcludeFromJacocoGeneratedReport
public class PermRelateList
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(PermRelateList.class);
    private static final String FIELD_PERM_ITEM = "mainpermitem";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
        FormOperate source = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)source.getOperateKey())) {
            QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
            Set permRelateCfgs = PermRelateServiceHelper.queryPermRelates((QFilter)filter);
            this.getPageCache().put("deleteRows", SerializationUtils.toJsonString((Object)permRelateCfgs));
        } else if (HRStringUtils.equals((String)source.getOperateKey(), (String)"auth")) {
            ListShowParameter fsp = new ListShowParameter();
            fsp.setBillFormId("hrcs_permrelatcfg");
            fsp.setFormId("bos_list");
            fsp.setPageId("hrcs_permrelatcfg@" + this.getView().getPageId());
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_objecttype");
            DynamicObject[] objs = serviceHelper.query("number", new QFilter[0]);
            List numbers = Arrays.stream(objs).map(it -> it.getString("number")).collect(Collectors.toList());
            QFilter filter = new QFilter("entitytype.id", "in", numbers);
            fsp.getListFilterParameter().getQFilters().add(filter);
            this.getView().showForm((FormShowParameter)fsp);
        } else if (StringUtils.equals((CharSequence)"btnsycrole", (CharSequence)source.getOperateKey())) {
            MultiLangEnumBridge sycRoleName = new MultiLangEnumBridge("\u540c\u6b65\u89d2\u8272", "PermRelateList_06", "hrmp-hrcs-formplugin");
            MultiLangEnumBridge sycOpt = new MultiLangEnumBridge("\u540c\u6b65\u89d2\u8272\u64cd\u4f5c\u6267\u884c\u6210\u529f\u3002", "PermRelateList_07", "hrmp-hrcs-formplugin");
            MultiLangEnumBridge sycOpf = new MultiLangEnumBridge("\u540c\u6b65\u89d2\u8272\u64cd\u4f5c", "PermRelateList_08", "hrmp-hrcs-formplugin");
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            Set pkIdSet = selectedRows.stream().map(it -> Long.parseLong(String.valueOf(it.getPrimaryKeyValue()))).collect(Collectors.toSet());
            if (pkIdSet.size() == 0) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("syncAllRtPermRole", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u540c\u6b65\u5173\u8054\u6743\u9650\u9879\u5230\u76f8\u5173\u7684\u89d2\u8272\u4e2d\uff0c\u6570\u636e\u91cf\u5927\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\uff0c\u786e\u8ba4\u662f\u5426\u540c\u6b65\uff1f", (String)"PermRelateList_05", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBackListener);
                PermRtSyncService.writeOpLog((boolean)false, (String)this.getView().getFormShowParameter().getAppId(), (String)"hrcs_permrelat", (MultiLangEnumBridge)sycRoleName, (MultiLangEnumBridge)sycOpt, (MultiLangEnumBridge)sycOpf, (String)source.getOperateKey());
                return;
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permrelat");
            DynamicObject[] permRelates = serviceHelper.query("entitytype,bizapp,mainpermitem,entryentity.entitytypeid,entryentity.app,entryentity.permitemid", new QFilter[]{new QFilter("id", "in", pkIdSet)});
            ArrayList relatePermInfoList = Lists.newArrayListWithExpectedSize((int)permRelates.length);
            ArrayList mainPermInfoList = Lists.newArrayListWithExpectedSize((int)permRelates.length);
            Arrays.stream(permRelates).forEach(it -> {
                if (!(HRStringUtils.isEmpty((String)it.getString("entitytype.number")) || HRStringUtils.isEmpty((String)it.getString("bizapp.id")) || HRStringUtils.isEmpty((String)it.getString(FIELD_PERM_ITEM)))) {
                    mainPermInfoList.add(new RelatePermInfo(null, null, null, it.getString("entitytype.number"), it.getString("bizapp.id"), it.getString(FIELD_PERM_ITEM)));
                }
                DynamicObjectCollection entryEntity = it.getDynamicObjectCollection("entryentity");
                entryEntity.forEach(itm -> {
                    String perm = itm.getString("permitemid");
                    if (perm.contains(",")) {
                        String[] split;
                        for (String permStr : split = perm.split(",")) {
                            RelatePermInfo relatePermInfo = new RelatePermInfo(itm.getString("entitytypeid.number"), itm.getString("app.id"), permStr.trim(), it.getString("entitytype.number"), it.getString("bizapp.id"), it.getString(FIELD_PERM_ITEM));
                            relatePermInfoList.add(relatePermInfo);
                        }
                    } else {
                        RelatePermInfo relatePermInfo = new RelatePermInfo(itm.getString("entitytypeid.number"), itm.getString("app.id"), perm.trim(), it.getString("entitytype.number"), it.getString("bizapp.id"), it.getString(FIELD_PERM_ITEM));
                        relatePermInfoList.add(relatePermInfo);
                    }
                });
            });
            if (pkIdSet.size() > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u8d85\u51fa10\u884c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PermRelateList_02", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                PermRtSyncService.writeOpLog((boolean)false, (String)this.getView().getFormShowParameter().getAppId(), (String)"hrcs_permrelat", (MultiLangEnumBridge)sycRoleName, (MultiLangEnumBridge)sycOpt, (MultiLangEnumBridge)sycOpf, (String)source.getOperateKey());
                return;
            }
            QFilter qFilter = null;
            for (RelatePermInfo rp : relatePermInfoList) {
                if (qFilter == null) {
                    qFilter = new QFilter("app", "=", (Object)rp.getAppId()).and(new QFilter("entitytype", "=", (Object)rp.getEntityNum())).and(new QFilter("permitem.number", "=", (Object)rp.getPermId()));
                    continue;
                }
                qFilter.or(new QFilter("app", "=", (Object)rp.getAppId()).and(new QFilter("entitytype", "=", (Object)rp.getEntityNum())).and(new QFilter("permitem.number", "=", (Object)rp.getPermId())));
            }
            HRBaseServiceHelper authHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
            DynamicObject[] rows = authHelper.query("id,app.id,entitytype.number,permitem.number,isassign", new QFilter[]{qFilter});
            List alonePermsList = Arrays.stream(rows).filter(it -> HRStringUtils.equals((String)it.getString("isassign"), (String)"1")).map(it -> new RelatePermInfo(it.getString("entitytype.number"), it.getString("app.id"), it.getString("permitem.number"), null)).collect(Collectors.toList());
            relatePermInfoList.removeIf(it -> alonePermsList.stream().anyMatch(elm -> elm.getPermId().equals(it.getPermId()) && elm.getAppId().equals(it.getAppId()) && elm.getEntityNum().equals(it.getEntityNum())));
            Map permInfoMap = PermRelateServiceHelper.getPermInfo();
            relatePermInfoList.removeIf(it -> permInfoMap.get(it.getPermId()) == null);
            if (relatePermInfoList.size() == 0) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("syncRoleBtn", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u6743\u9650\u9879\u4e3a\u5141\u8bb8\u72ec\u7acb\u6388\u6743\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u89d2\u8272\u3002", (String)"PermRelateList_03", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBackListener);
                PermRtSyncService.writeOpLog((boolean)false, (String)this.getView().getFormShowParameter().getAppId(), (String)"hrcs_permrelat", (MultiLangEnumBridge)sycRoleName, (MultiLangEnumBridge)sycOpt, (MultiLangEnumBridge)sycOpf, (String)source.getOperateKey());
                return;
            }
            long startTime = System.currentTimeMillis();
            LinkedHashMap resultRolePermMap = PermRtSyncService.calcRtPermRole((List)relatePermInfoList, (List)mainPermInfoList);
            LOGGER.info("permRelateList.beforeDoOperation calcRtPermRole cost time:{}", (Object)(System.currentTimeMillis() - startTime));
            if (CollectionUtils.isEmpty((Map)resultRolePermMap)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("syncRoleBtn", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u89d2\u8272\u5df2\u5305\u542b\u5173\u8054\u6743\u9650\u9879\uff0c\u65e0\u9700\u540c\u6b65\u3002", (String)"PermRelateList_04", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBackListener);
                PermRtSyncService.writeOpLog((boolean)false, (String)this.getView().getFormShowParameter().getAppId(), (String)"hrcs_permrelat", (MultiLangEnumBridge)sycRoleName, (MultiLangEnumBridge)sycOpt, (MultiLangEnumBridge)sycOpf, (String)source.getOperateKey());
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrcs_syncroleperm");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("roleInfo", (Object)SerializationUtils.toJsonString((Object)resultRolePermMap));
            showParameter.setCustomParam("roleCount", (Object)resultRolePermMap.keySet().size());
            showParameter.setCustomParam("permCount", (Object)relatePermInfoList.size());
            this.getView().showForm(showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)"delete", (String)operateKey) && args.getOperationResult().isSuccess()) {
            String deleteRowsStr = this.getPageCache().get("deleteRows");
            if (HRStringUtils.isEmpty((String)deleteRowsStr)) {
                return;
            }
            Set deleteRows = (Set)SerializationUtils.fromJsonString((String)deleteRowsStr, Set.class);
            PermRelateServiceHelper.deletePermRelateConfigs((Set)deleteRows);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new PermItemProvider());
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        evt.getParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "incPermTips"));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult() == MessageBoxResult.Yes && StringUtils.equals((CharSequence)"syncAllRtPermRole", (CharSequence)event.getCallBackId())) {
            this.startJob();
        }
    }

    private void startJob() {
        JobInfo jobInfo = new JobInfo();
        HashMap<String, Integer> params = new HashMap<String, Integer>(1);
        params.put("syncAll", 1);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "syncAllRtPermRole");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobInfo.setAppId("hrcs");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByLang(RequestContext.get().getLang());
        jobFormInfo.setTimeout(1200);
        jobFormInfo.setCanStop(false);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setTaskClassname("kd.hr.hrcs.bussiness.service.perm.dimension.HRRelatePermTask");
        String sycRoleName = ResManager.loadKDString((String)"\u540c\u6b65\u89d2\u8272\u5173\u8054\u6743\u9650\u9879", (String)"PermRelateList_09", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        jobInfo.setName(sycRoleName);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Map returnData = (Map)evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (actionId.equals("incPermTips")) {
            if (returnData.containsKey("syncRole")) {
                Object roleInfo = returnData.get("resultRolePermMap");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("hrcs_syncrolesel");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("roleInfo", (Object)SerializationUtils.toJsonString(roleInfo));
                this.getView().showForm(showParameter);
            }
            if (returnData.get("changed") != null) {
                ListView listView = (ListView)this.getView();
                listView.clearSelection();
                listView.refresh();
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        String isShowFilter = (String)this.getView().getFormShowParameter().getCustomParam("isNotShowFilter");
        if (HRStringUtils.isNotEmpty((String)isShowFilter)) {
            for (IListColumn listColumn : listColumns) {
                if (!listColumn.getListFieldKey().equals("entitytype.number")) continue;
                listColumn.setHyperlink(false);
                return;
            }
        }
    }

    static class PermItemProvider
    extends ListDataProvider {
        PermItemProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                return rows;
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_permitem");
            DynamicObject[] query = serviceHelper.query("number,name", new QFilter[0]);
            HashMap<String, String> permMap = new HashMap<String, String>(query.length);
            for (DynamicObject dy : query) {
                permMap.put(dy.getString("number"), dy.getString("name"));
            }
            DataEntityPropertyCollection properties = rows.getDynamicObjectType().getProperties();
            boolean hasEntityTypeId = properties.containsKey((Object)"entitytype_id");
            boolean hasPermItemId = properties.containsKey((Object)"entryentity.permitemid");
            for (DynamicObject row : rows) {
                String permItemIds;
                if (hasEntityTypeId) {
                    String entityNum = row.getString("entitytype.id");
                    if (entityNum == null) {
                        row.set("description", (Object)(row.getString("description") + "  " + row.getString("entitytype_id") + " not  exist"));
                    }
                    if (properties.containsKey((Object)PermRelateList.FIELD_PERM_ITEM)) {
                        String mainPermItemId = row.getString(PermRelateList.FIELD_PERM_ITEM);
                        String permName = (String)permMap.get(mainPermItemId);
                        row.set(PermRelateList.FIELD_PERM_ITEM, (Object)permName);
                        LOGGER.info("entityNum = {} , hasEntityTypeId = {} , hasPermItemId = {}  ,mainPermItemId = {} , mainPermName = {}", new Object[]{entityNum, hasEntityTypeId, hasPermItemId, mainPermItemId, permName});
                    }
                }
                if (!hasPermItemId || (permItemIds = row.getString("entryentity.permitemid")) == null) continue;
                String[] ids = permItemIds.split(",");
                StringBuilder permItemStr = new StringBuilder();
                for (int idx = 0; idx < ids.length; ++idx) {
                    permItemStr.append((String)permMap.get(ids[idx]));
                    if (idx == ids.length - 1) continue;
                    permItemStr.append(", ");
                }
                row.set("entryentity.permitemid", (Object)permItemStr);
                LOGGER.info("entityNum = {} ,permItemIds = {} , relatePermItem = {}", new Object[]{row.getDynamicObject("entryentity.entitytypeid") == null ? row.getDynamicObject("entryentity.entitytypeid") : row.getDynamicObject("entryentity.entitytypeid").get("id"), permItemIds, permItemStr});
            }
            return rows;
        }
    }
}

