/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.hradmin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.service.perm.hradmin.AdminGroupService;
import kd.hr.hrcs.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.hradmin.HRAdminGroupPermHelper;
import kd.hr.hrcs.formplugin.web.perm.hradmin.AdminGroupPermEdit;

@ExcludeFromJacocoGeneratedReport
public class AdminGroupBatchAuthPlugin
extends HRDataBaseEdit
implements TreeNodeQueryListener,
TreeNodeClickListener,
TreeNodeCheckListener,
BeforeF7SelectListener,
TabSelectListener {
    private static final String FIELD_PARENT_GROUP_ID = "parentgroupid";
    private static final String FIELD_TARGET_ADMIN_GROUP_IDS = "targetadmingroupids";
    private static final String FIELD_ORG_RANGE = "orgrange";
    private static final String FIELD_ORG_NAME = "orgname";
    private static final String FIELD_BUCA_RANGE = "bucarange";
    private static final String FIELD_BU_TYPE = "butype";
    private static final String FIELD_BU_CLASS = "buclass";
    private static final String FIELD_ADMIN_GROUP = "admingroup";
    private static final String ALL_ASSIGNED_HR_BUCA = "allAssignedHRBuCa";
    private static final String BU_CHANGE = "bu_change";
    private static final String BU_REDRAWN = "bu_redrawn";
    private static final String ORG_CHANGE = "org_change";
    private static final String PAGECACHE_ORIGIN_ORGDATA = "orignAdminOrgIds";
    private static final String PAGECACHE_ORIGIN_BUDADATA = "orignBuData";
    private static final String TAB_ORG_LOADED = "tabOrgLoaded";
    private static final String KEY_BU_ENTRY = "buentry";
    private static final String KEY_ORG_ENTRY = "orgentry";
    private static final Log LOGGER = LogFactory.getLog(AdminGroupPermEdit.class);
    private static final String KEY_STRUCT = "struct";
    private static final String KEY_STRUCT_ID = "struct.id";
    private static final String KEY_ADMINORG_ID = "adminorg.id";
    private static final String KEY_ADMINORG = "adminorg";
    private AdminGroupService adminGroupService;
    private Long virtualAdminGroupId = 1L;

    public void initialize() {
        String bizRightSourceStr;
        super.initialize();
        this.adminGroupService = new AdminGroupService((AbstractBasePlugIn)this, LOGGER, true);
        this.adminGroupService.initialize();
        this.addClickListeners(new String[]{"targetadmingroup"});
        String sysRightSourceStr = this.getPageCache().get("sysRightSource");
        if (HRStringUtils.isEmpty((String)sysRightSourceStr)) {
            this.getPageCache().put("sysRightSource", SerializationUtils.toJsonString((Object)Maps.newHashMapWithExpectedSize((int)0)));
        }
        if (HRStringUtils.isEmpty((String)(bizRightSourceStr = this.getPageCache().get("bizRightSource")))) {
            this.getPageCache().put("bizRightSource", SerializationUtils.toJsonString((Object)Lists.newArrayListWithExpectedSize((int)0)));
        }
    }

    public void afterCreateNewData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String adminGroupStr = (String)customParams.get("adminGroupParentId");
        String levelStr = (String)customParams.get("level");
        long adminGroupId = Long.parseLong(adminGroupStr);
        long level = Long.parseLong(levelStr);
        this.getModel().setValue(FIELD_PARENT_GROUP_ID, (Object)adminGroupId);
        this.getModel().setValue("level", (Object)level);
        this.adminGroupService.initSysLeftTree(Long.valueOf(adminGroupId), level, this.getView());
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpage_sys".equals(tabKey)) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String adminGroupStr = (String)customParams.get("adminGroupParentId");
        String levelStr = (String)customParams.get("level");
        long adminGroupId = Long.parseLong(adminGroupStr);
        long level = Long.parseLong(levelStr);
        if ("tabpage_bizunit".equals(tabKey)) {
            String treeLoaded = this.getPageCache().get("tree_bizunit_loaded");
            if (StringUtils.isNotEmpty((String)treeLoaded)) {
                return;
            }
            this.adminGroupService.initBizUnitMap();
            this.adminGroupService.initUnitTree("11", Long.valueOf(adminGroupId), level, false);
            this.getPageCache().put("tree_bizunit_loaded", "true");
        } else if ("tabpage_app".equals(tabKey)) {
            String treeLoaded = this.getPageCache().get("tree_app_loaded");
            if (StringUtils.isNotEmpty((String)treeLoaded)) {
                return;
            }
            if (this.targetAdminGroupEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ba1\u7406\u5458\u5206\u7ec4\u3002", (String)"AdminGroupBatchAuthPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                Tab tabAp = (Tab)this.getView().getControl("tabap");
                tabAp.activeTab("tabpage_sys");
                return;
            }
            this.adminGroupService.rebuildAppTree();
        } else if ("tabpage_adminorg".equals(tabKey)) {
            String tabOrgLoaded = this.getPageCache().get(TAB_ORG_LOADED);
            if (StringUtils.isNotEmpty((String)tabOrgLoaded)) {
                return;
            }
            this.initDataAuthRange();
            this.getPageCache().put(TAB_ORG_LOADED, "true");
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        this.adminGroupService.treeNodeCheck(event);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        String adminGroupStr = (String)this.getView().getFormShowParameter().getCustomParam("adminGroupParentId");
        Long adminGroupId = Long.parseLong(adminGroupStr);
        TreeView tv = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        switch (tv.getKey()) {
            case "orgtree": {
                String topBizTree = this.getPageCache().get("11_super");
                if (StringUtils.isNotEmpty((String)topBizTree)) {
                    this.adminGroupService.commonQueryTreeNodeChildren(tv, nodeId, "11", Long.valueOf(0L), "orgTreeLeftRoot", true, "orgTreeLeftNodeIds");
                    break;
                }
                this.adminGroupService.commonQueryTreeNodeChildren(tv, nodeId, "11", adminGroupId, "orgTreeLeftRoot", true, "orgTreeLeftNodeIds");
                break;
            }
            case "selectedorgtree": {
                this.adminGroupService.commonQueryTreeNodeChildren(tv, nodeId, "11", this.virtualAdminGroupId, "orgTreeRightRoot", false, "orgTreeRightNodeIds");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        this.adminGroupService.beforeF7Select(beforeF7SelectEvent);
    }

    public void click(EventObject evt) {
        String ctrlKey;
        long level = this.getModel().getDataEntity().getLong("level");
        Control c = (Control)evt.getSource();
        switch (ctrlKey = c.getKey()) {
            case "btn_addorg": {
                this.adminGroupService.addOrg(this.virtualAdminGroupId, Long.valueOf(level), "11");
                break;
            }
            case "btn_deleteorg": {
                this.adminGroupService.removeSelOrg(this.virtualAdminGroupId, Long.valueOf(level), "11");
                break;
            }
            case "btn_addapp": {
                this.adminGroupService.addApp();
                this.initDataAuthRange();
                break;
            }
            case "btn_delapp": {
                this.adminGroupService.removeSelApp();
                this.initDataAuthRange();
                break;
            }
            case "btn_addsys": {
                this.adminGroupService.addSys();
                break;
            }
            case "btn_delsys": {
                this.adminGroupService.removeSys();
                break;
            }
            case "orgname": {
                this.adminGroupService.showOrgF7();
                break;
            }
            case "targetadmingroup": {
                this.showTargetAdminGroup();
                break;
            }
        }
    }

    private void showTargetAdminGroup() {
        DynamicObject adminGroup = this.getModel().getDataEntity().getDynamicObject(FIELD_PARENT_GROUP_ID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrcs_targetadmingroup");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("adminGroupLongNumber", (Object)adminGroup.getString("longnumber"));
        parameter.setCustomParam("adminGroupId", (Object)adminGroup.getString("id"));
        parameter.setCustomParam("adminGroupName", (Object)adminGroup.getString("name"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "targetAdminGroup"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"targetAdminGroup")) {
            List targetAdminGroups = (List)evt.getReturnData();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)targetAdminGroups)) {
                return;
            }
            String idStr = targetAdminGroups.stream().map(Object::toString).collect(Collectors.joining(";"));
            this.getModel().setValue(FIELD_TARGET_ADMIN_GROUP_IDS, (Object)idStr);
        } else if (HRStringUtils.equals((String)"haos_customortreelistf7", (String)actionId)) {
            Object returnData = evt.getReturnData();
            this.adminGroupService.setOrgName(returnData);
        }
    }

    private void setTargetAdminGroupName(List<Long> targetAdminGroups) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_admingroup");
        String adminNames = serviceHelper.queryOriginalCollection("name", new QFilter[]{new QFilter("id", "in", targetAdminGroups)}).stream().map(it -> it.getString("name")).collect(Collectors.joining(";"));
        this.getModel().setValue("targetadmingroup", (Object)adminNames);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") && !this.dataVerify()) {
            args.setCancel(true);
        }
    }

    private boolean dataVerify() {
        if (this.targetAdminGroupEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ba1\u7406\u5458\u5206\u7ec4\u3002", (String)"AdminGroupBatchAuthPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        IPageCache pageCache = this.getPageCache();
        String sys_add_set = pageCache.get("sys_add_ids");
        String app_add_set = pageCache.get("app_add_ids");
        String add_set = pageCache.get("biz_add_ids");
        boolean orgNotEmpty = this.orgNotEmpty();
        boolean buNotEmpty = this.buNotEmpty();
        if (HRStringUtils.isNotEmpty((String)sys_add_set) || HRStringUtils.isNotEmpty((String)app_add_set) || HRStringUtils.isNotEmpty((String)add_set) || orgNotEmpty || buNotEmpty) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5df2\u5206\u914d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (String)"AdminGroupBatchAuthPlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        return false;
    }

    private boolean orgNotEmpty() {
        DynamicObjectCollection orgEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ORG_ENTRY);
        return orgEntry.stream().anyMatch(it -> HRStringUtils.isNotEmpty((String)it.getString(FIELD_ORG_RANGE)));
    }

    private boolean buNotEmpty() {
        DynamicObjectCollection buEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_BU_ENTRY);
        return buEntry.stream().anyMatch(it -> it.getDynamicObjectCollection(FIELD_BUCA_RANGE).size() > 0);
    }

    private boolean targetAdminGroupEmpty() {
        return HRStringUtils.isEmpty((String)this.getModelValStr(FIELD_TARGET_ADMIN_GROUP_IDS));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String property = args.getProperty().getName();
        if (HRStringUtils.equals((String)FIELD_TARGET_ADMIN_GROUP_IDS, (String)property)) {
            ChangeData changeData = args.getChangeSet()[0];
            String oldValue = (String)changeData.getOldValue();
            String newValue = (String)changeData.getNewValue();
            if (!HRStringUtils.isEmpty((String)oldValue) || !HRStringUtils.isNotEmpty((String)newValue)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u7ba1\u7406\u5458\u5206\u7ec4\u5c06\u6e05\u7a7a\u5df2\u9009\u7684\u201c\u5e94\u7528\u8303\u56f4\u201d\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"AdminGroupBatchAuthPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeTarget", (IFormPlugin)this));
                this.getPageCache().put("oldTargetIds", oldValue);
                return;
            }
            String[] oldTargetIds = newValue.split(";");
            List<Long> targetAdminGroups = Arrays.stream(oldTargetIds).map(Long::parseLong).collect(Collectors.toList());
            this.setTargetAdminGroupName(targetAdminGroups);
            this.adminGroupService.rebuildAppTree();
        } else if (HRStringUtils.equals((String)"targetadmingroup", (String)property)) {
            ChangeData changeData = args.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            if (HRStringUtils.isEmpty((String)newValue)) {
                this.getModel().setValue(FIELD_TARGET_ADMIN_GROUP_IDS, (Object)"");
            }
        } else if (HRStringUtils.equals((String)property, (String)FIELD_ORG_RANGE)) {
            this.getPageCache().put(ORG_CHANGE, "true");
            this.getPageCache().put("dataChanged", "true");
        } else if (HRStringUtils.equals((String)property, (String)FIELD_BUCA_RANGE)) {
            this.getPageCache().put(BU_CHANGE, "true");
            this.getPageCache().put("dataChanged", "true");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"changeTarget")) {
            String oldTargetIdStr = this.getPageCache().get("oldTargetIds");
            if (evt.getResult().equals((Object)MessageBoxResult.Yes)) {
                String targetIdStr = this.getModelValStr(FIELD_TARGET_ADMIN_GROUP_IDS);
                List<Object> ids = Lists.newArrayListWithExpectedSize((int)0);
                if (HRStringUtils.isNotEmpty((String)targetIdStr)) {
                    String[] targetIds = targetIdStr.split(";");
                    ids = Arrays.stream(targetIds).map(Long::parseLong).collect(Collectors.toList());
                }
                this.setTargetAdminGroupName(ids);
                this.adminGroupService.rebuildAppTree();
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(FIELD_TARGET_ADMIN_GROUP_IDS, (Object)oldTargetIdStr);
                if (HRStringUtils.isNotEmpty((String)oldTargetIdStr)) {
                    String[] targetIds = oldTargetIdStr.split(";");
                    List<Long> ids = Arrays.stream(targetIds).map(Long::parseLong).collect(Collectors.toList());
                    this.setTargetAdminGroupName(ids);
                }
                this.getModel().endInit();
                this.getView().updateView("targetadmingroup");
                this.getView().updateView(FIELD_TARGET_ADMIN_GROUP_IDS);
            }
        } else if (HRStringUtils.equals((String)callBackId, (String)"saveConfirm") && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.save();
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") && args.getOperationResult().isSuccess()) {
            IPageCache pageCache = this.getPageCache();
            String sys_add_set = pageCache.get("sys_add_ids");
            String app_add_set = pageCache.get("app_add_ids");
            String add_set = pageCache.get("biz_add_ids");
            boolean orgNotEmpty = this.orgNotEmpty();
            boolean buNotEmpty = this.buNotEmpty();
            ArrayList tabList = Lists.newArrayListWithExpectedSize((int)4);
            if (HRStringUtils.isNotEmpty((String)sys_add_set)) {
                tabList.add(ResManager.loadKDString((String)"\u201c\u7ba1\u7406\u5458\u529f\u80fd\u8303\u56f4\u201d\u7684\u6743\u9650\u9879", (String)"AdminGroupBatchAuthPlugin_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)app_add_set)) {
                tabList.add(ResManager.loadKDString((String)"\u201c\u5e94\u7528\u6388\u6743\u8303\u56f4\u201d\u7684\u5e94\u7528", (String)"AdminGroupBatchAuthPlugin_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            if (orgNotEmpty || buNotEmpty) {
                tabList.add(ResManager.loadKDString((String)"\u201c\u6570\u636e\u6388\u6743\u8303\u56f4\u201d\u7684\u6570\u636e", (String)"AdminGroupBatchAuthPlugin_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)add_set)) {
                tabList.add(ResManager.loadKDString((String)"\u201c\u6743\u9650\u6863\u6848\u8303\u56f4\u201d\u7684\u7ec4\u7ec7", (String)"AdminGroupBatchAuthPlugin_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            String join = String.join((CharSequence)"\u3001", tabList);
            int groupNameLength = Optional.ofNullable((String)this.getModel().getValue(FIELD_TARGET_ADMIN_GROUP_IDS)).orElse("").split(";").length;
            String groupNames = ((String)this.getModel().getValue("targetadmingroup")).replace(";", "\u3001");
            if (groupNames.length() > 50) {
                groupNames = groupNames.substring(0, 50) + "...";
            }
            String tip = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6dfb\u52a0\u4e86%1$s\uff0c\u5c06\u6279\u91cf\u5206\u914d\u7ed9%2$s\u4e2a\u76ee\u6807\u7ba1\u7406\u5458\u5206\u7ec4(%3$s)\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminGroupBatchAuthPlugin_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), join, groupNameLength, groupNames);
            this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("saveConfirm", (IFormPlugin)this));
        }
    }

    private void initDataAuthRange() {
        this.setOrgRange();
        String buRedrawn = this.getPageCache().get(BU_REDRAWN);
        if (buRedrawn != null && !HRStringUtils.equals((String)"true", (String)buRedrawn)) {
            return;
        }
        long adminGroupId = this.getModel().getDataEntity().getLong("parentgroupid.id");
        long level = this.getModel().getDataEntity().getLong("level");
        Set<Long> funcs = level > 2L ? this.adminGroupBu(adminGroupId) : HRBUExtServiceHelper.getVersionView((boolean)true);
        List allAssignedHRBuCa = HRStringUtils.isNotEmpty((String)this.getPageCache().get(ALL_ASSIGNED_HR_BUCA)) ? (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL_ASSIGNED_HR_BUCA), List.class) : Lists.newArrayListWithExpectedSize((int)0);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(KEY_BU_ENTRY);
        int index = 0;
        for (Long buId : funcs) {
            this.getModel().createNewEntryRow(KEY_BU_ENTRY);
            this.getModel().setValue(FIELD_BU_TYPE, (Object)buId, index);
            this.getModel().setValue(FIELD_BU_CLASS, (Object)(allAssignedHRBuCa.contains(buId.toString()) ? "1" : "0"), index);
            ++index;
        }
        this.getPageCache().put(BU_REDRAWN, "false");
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
        this.getView().updateView(KEY_BU_ENTRY);
    }

    private Set<Long> adminGroupBu(long adminGroupId) {
        HRBaseServiceHelper funcHelper = new HRBaseServiceHelper("hrcs_admingroupfunc");
        QFilter filter = new QFilter("admingroup.id", "=", (Object)adminGroupId);
        return funcHelper.queryOriginalCollection("bucafunc.id", new QFilter[]{filter}).stream().map(it -> it.getLong("bucafunc.id")).collect(Collectors.toSet());
    }

    private void setOrgRange() {
        String orgChange = this.getPageCache().get(ORG_CHANGE);
        if (orgChange != null && HRStringUtils.equals((String)"true", (String)orgChange)) {
            return;
        }
        long adminGroupId = this.getModel().getDataEntity().getLong("parentgroupid.id");
        long level = this.getModel().getDataEntity().getLong("level");
        String parentOrgIdsStr = this.getPageCache().get("parentOrgIds");
        HashMap parentOrgMap = Maps.newHashMapWithExpectedSize((int)16);
        if (null == parentOrgIdsStr) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject dynamicObject : dynamicObjects = HRAdminGroupPermHelper.queryDataRange((long)adminGroupId)) {
                long structId = dynamicObject.getLong(KEY_STRUCT_ID);
                long adminOrgId = dynamicObject.getLong(KEY_ADMINORG_ID);
                List orgIdList = parentOrgMap.getOrDefault(structId, Lists.newArrayListWithExpectedSize((int)dynamicObjects.length));
                orgIdList.add(adminOrgId);
                parentOrgMap.put(structId, orgIdList);
            }
            this.getPageCache().put("parentOrgIds", SerializationUtils.toJsonString((Object)parentOrgMap));
        }
        String adminOrgIdsStr = this.getPageCache().get(PAGECACHE_ORIGIN_ORGDATA);
        if (!Boolean.TRUE.toString().equals(adminOrgIdsStr)) {
            List orgStructList = this.adminGroupService.getOrgStructList();
            DynamicObject[] dynamicObjects = HRAdminGroupPermHelper.queryDataRange((long)adminGroupId);
            Map<Long, List<DynamicObject>> orgGroup = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dyn -> dyn.getLong(KEY_STRUCT_ID)));
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ORG_ENTRY);
            this.getModel().beginInit();
            for (DynamicObject dynamicObject : orgStructList) {
                long structId = dynamicObject.getLong("id");
                List<DynamicObject> orgList = orgGroup.get(structId);
                if (CollectionUtils.isEmpty(orgList) && level > 2L) continue;
                DynamicObject row = dynamicObjectCollection.addNew();
                row.set(KEY_STRUCT, (Object)dynamicObject);
            }
            this.getModel().endInit();
            this.getPageCache().put(PAGECACHE_ORIGIN_ORGDATA, Boolean.TRUE.toString());
            this.getView().updateView(KEY_ORG_ENTRY);
        }
        this.getModel().setDataChanged(false);
    }

    private void save() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long level = dataEntity.getLong("level");
        List<Long> adminGroupIds = this.getTargetAdminGroupIds();
        IPageCache pageCache = this.getPageCache();
        if (!HRStringUtils.equals((String)pageCache.get("dataChanged"), (String)"true")) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                String app_change;
                String sys_change = pageCache.get("sys_change");
                if (StringUtils.isNotEmpty((String)sys_change)) {
                    this.saveSysPerm(adminGroupIds);
                    pageCache.remove("sysTreeRightRoot");
                }
                if (StringUtils.isNotEmpty((String)(app_change = pageCache.get("app_change")))) {
                    this.saveApp(adminGroupIds);
                    pageCache.remove("Current_AppData");
                    this.adminGroupService.buildSelectedAppTree(this.virtualAdminGroupId, Long.valueOf(level));
                }
            }
            catch (Exception e) {
                LOGGER.error("\u7ba1\u7406\u5458\u6743\u9650\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25," + e.getMessage(), (Throwable)e);
                txHandle.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AdminGroupBatchAuthPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        txHandle = TX.requiresNew();
        var7_6 = null;
        try {
            try {
                String buRangeChange;
                String biz_change;
                String orgChange = pageCache.get(ORG_CHANGE);
                if (StringUtils.isNotEmpty((String)orgChange) && orgChange.equals("true")) {
                    this.saveOrg(adminGroupIds);
                    pageCache.remove(ORG_CHANGE);
                }
                if (StringUtils.isNotEmpty((String)(biz_change = pageCache.get("biz_change")))) {
                    this.saveUnit(adminGroupIds);
                    pageCache.remove("orgTreeRightRoot");
                    pageCache.remove(this.virtualAdminGroupId + "_current_BizDatas");
                    this.adminGroupService.buildSelectedOrgTree(this.virtualAdminGroupId, "11", level);
                }
                if (StringUtils.isNotEmpty((String)(buRangeChange = pageCache.get(BU_CHANGE))) && buRangeChange.equals("true")) {
                    this.saveBuRange(adminGroupIds);
                    pageCache.remove(BU_CHANGE);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdminGroupBatchAuthPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            catch (Exception e) {
                LOGGER.error("\u7ba1\u7406\u5458\u6743\u9650\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25," + e.getMessage(), (Throwable)e);
                txHandle.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AdminGroupBatchAuthPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (txHandle != null) {
                if (var7_6 != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
    }

    private List<Long> getTargetAdminGroupIds() {
        String adminGroupIdStr = this.getModel().getDataEntity().getString(FIELD_TARGET_ADMIN_GROUP_IDS);
        if (HRStringUtils.isEmpty((String)adminGroupIdStr)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        String[] targetAdminGroupIdArr = adminGroupIdStr.split(";");
        List<Long> adminGroupIds = Arrays.stream(targetAdminGroupIdArr).map(Long::parseLong).collect(Collectors.toList());
        return adminGroupIds;
    }

    private void saveBuRange(List<Long> adminGroupIds) {
        DynamicObjectCollection buEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_BU_ENTRY);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_admingroupfunc");
        DynamicObject[] dys = serviceHelper.query("admingroup,bucafunc,entryentity.org", new QFilter[]{new QFilter(FIELD_ADMIN_GROUP, "in", adminGroupIds)});
        Map<String, DynamicObject> subBuMap = Arrays.stream(dys).collect(Collectors.toMap(it -> it.getString("admingroup.id") + "#" + it.getString("bucafunc.id"), it -> it, (newVal, oldVal) -> newVal));
        DynamicObjectCollection updateDynCol = new DynamicObjectCollection();
        DynamicObjectCollection addDynCol = new DynamicObjectCollection();
        for (DynamicObject row : buEntry) {
            List buRange;
            String buType = row.getString("butype.id");
            if (buType == null || org.apache.commons.collections.CollectionUtils.isEmpty(buRange = row.getDynamicObjectCollection(FIELD_BUCA_RANGE).stream().map(it -> it.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) continue;
            for (Long adminGroupId : adminGroupIds) {
                DynamicObjectCollection coll;
                String key = adminGroupId + "#" + buType;
                if (subBuMap.containsKey(key)) {
                    DynamicObject dynamicObject = subBuMap.get(key);
                    coll = dynamicObject.getDynamicObjectCollection("entryentity");
                    List existOrgIds = coll.stream().map(it -> it.getLong("org.id")).collect(Collectors.toList());
                    for (Long org : buRange) {
                        if (existOrgIds.contains(org)) continue;
                        DynamicObject newRow = coll.addNew();
                        newRow.set("org", (Object)org);
                    }
                    updateDynCol.add((Object)dynamicObject);
                    continue;
                }
                DynamicObject funcDy = serviceHelper.generateEmptyDynamicObject();
                funcDy.set(FIELD_ADMIN_GROUP, (Object)adminGroupId);
                funcDy.set("bucafunc", (Object)Long.parseLong(buType));
                coll = serviceHelper.generateEmptyEntryCollection(funcDy, "entryentity");
                for (Long org : buRange) {
                    DynamicObject newRow = coll.addNew();
                    newRow.set("org", (Object)org);
                }
                funcDy.set("entryentity", (Object)coll);
                addDynCol.add((Object)funcDy);
            }
        }
        serviceHelper.save((DynamicObject[])updateDynCol.toArray((Object[])new DynamicObject[0]));
        serviceHelper.save((DynamicObject[])addDynCol.toArray((Object[])new DynamicObject[0]));
    }

    private void saveOrg(List<Long> adminGroupIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_admingrouporg");
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ORG_ENTRY);
        DynamicObjectCollection addDynCol = new DynamicObjectCollection();
        QFilter deleteFilter = null;
        for (DynamicObject dynamicObject : collection) {
            String orgRangeStr = dynamicObject.getString(FIELD_ORG_RANGE);
            if (HRStringUtils.isBlank((CharSequence)orgRangeStr)) continue;
            long structId = dynamicObject.getLong(KEY_STRUCT_ID);
            String[] orgRange = orgRangeStr.split(";");
            List orgList = Arrays.stream(orgRange).map(Long::parseLong).collect(Collectors.toList());
            QFilter curFilter = new QFilter(KEY_STRUCT, "=", (Object)structId).and(KEY_ADMINORG, "in", orgList);
            deleteFilter = null == deleteFilter ? curFilter : deleteFilter.or(curFilter);
            for (Long adminGroupId : adminGroupIds) {
                Iterator iterator = orgList.iterator();
                while (iterator.hasNext()) {
                    long orgId = (Long)iterator.next();
                    DynamicObject newOrg = serviceHelper.generateEmptyDynamicObject();
                    newOrg.set(FIELD_ADMIN_GROUP, (Object)adminGroupId);
                    newOrg.set(KEY_STRUCT, (Object)structId);
                    newOrg.set(KEY_ADMINORG, (Object)orgId);
                    addDynCol.add((Object)newOrg);
                }
            }
        }
        if (null != deleteFilter) {
            deleteFilter = deleteFilter.and(new QFilter(FIELD_ADMIN_GROUP, "in", adminGroupIds));
            serviceHelper.deleteByFilter(new QFilter[]{deleteFilter});
        }
        serviceHelper.save((DynamicObject[])addDynCol.toArray((Object[])new DynamicObject[0]));
    }

    private void saveUnit(List<Long> targetAdminGroups) {
        IPageCache pageCache = this.getPageCache();
        String add_set = pageCache.get("biz_add_ids");
        if (StringUtils.isNotEmpty((String)add_set)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hrcs_admingroupfile");
            Set addOrgs = (Set)SerializationUtils.fromJsonString((String)add_set, Set.class);
            QFilter adminGroupQfilter = new QFilter(FIELD_ADMIN_GROUP, "in", targetAdminGroups);
            QFilter orgQfilter = new QFilter("org", "in", addOrgs.stream().map(Long::parseLong).collect(Collectors.toList()));
            DeleteServiceHelper.delete((String)"hrcs_admingroupfile", (QFilter[])new QFilter[]{adminGroupQfilter, orgQfilter});
            ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(10);
            for (Long adminGroupId : targetAdminGroups) {
                for (String orgId : addOrgs) {
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
                    dynamicObject.set(FIELD_ADMIN_GROUP, (Object)adminGroupId);
                    dynamicObject.set("org", (Object)orgId);
                    addList.add(dynamicObject);
                }
            }
            if (addList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
            }
        }
    }

    private void saveSysPerm(List<Long> adminGroupIds) {
        IPageCache pageCache = this.getPageCache();
        String sys_add_set = pageCache.get("sys_add_ids");
        if (StringUtils.isNotEmpty((String)sys_add_set)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"perm_admingroupfunperm");
            Set addPerms = (Set)SerializationUtils.fromJsonString((String)sys_add_set, Set.class);
            QFilter adminGroupQfilter = new QFilter("usergroup", "in", adminGroupIds);
            QFilter multiPermItemQfilter = null;
            int count = 0;
            int allCount = 0;
            for (String addPerm : addPerms) {
                String[] info = addPerm.split("\\|");
                QFilter permItemQfilter = new QFilter("app", "=", (Object)info[0]);
                permItemQfilter.and(new QFilter("entitynum", "=", (Object)info[1]));
                permItemQfilter.and(new QFilter("permitem", "=", (Object)info[2]));
                if (multiPermItemQfilter == null) {
                    multiPermItemQfilter = permItemQfilter;
                } else {
                    multiPermItemQfilter.or(permItemQfilter);
                }
                if (++count < 500 && ++allCount != addPerms.size()) continue;
                DeleteServiceHelper.delete((String)"perm_admingroupfunperm", (QFilter[])new QFilter[]{adminGroupQfilter, multiPermItemQfilter});
                multiPermItemQfilter = null;
                count = 0;
            }
            ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(10);
            for (Long adminGroupId : adminGroupIds) {
                for (String delPerm : addPerms) {
                    String[] info = delPerm.split("\\|");
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
                    dynamicObject.set("usergroup", (Object)adminGroupId);
                    dynamicObject.set("app", (Object)info[0]);
                    dynamicObject.set("entitynum", (Object)info[1]);
                    dynamicObject.set("permitem", (Object)info[2]);
                    addList.add(dynamicObject);
                }
            }
            if (addList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
            }
        }
    }

    private void saveApp(List<Long> targetAdminGroups) {
        IPageCache pageCache = this.getPageCache();
        String app_add_set = pageCache.get("app_add_ids");
        if (StringUtils.isNotEmpty((String)app_add_set)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"perm_admingroupapp");
            Set addApps = (Set)SerializationUtils.fromJsonString((String)app_add_set, Set.class);
            List appIds = addApps.stream().map(it -> it.split("\\|")[1]).collect(Collectors.toList());
            ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(appIds.size() * targetAdminGroups.size());
            for (Long adminGroupId : targetAdminGroups) {
                for (String app : appIds) {
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
                    dynamicObject.set("usergroup", (Object)adminGroupId);
                    dynamicObject.set("app", (Object)app);
                    addList.add(dynamicObject);
                }
            }
            if (addList.size() > 0) {
                DeleteServiceHelper.delete((String)"perm_admingroupapp", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", targetAdminGroups).and("app", "in", appIds)});
                SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
            }
        }
    }
}

