/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class PermExportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(PermExportProgressPlugin.class);
    private static final String CUSTOM_PARAM_CONTEXT = "requestcontext";
    private static final String CUSTOM_PARAM_ENTITY_NAME = "entityname";
    private static final String CACHE_KEY_JOB_FORM_INFO = "export_jobforminfo";
    private static final String CACHE_KEY_TASK_ID = "export_taskid";
    private static final String TASK_CLASS = "taskClassName";
    private static final String CACHE_KEY_IS_START = "isstart";
    private static final String CACHE_KEY_IS_FINISHED = "isfinished";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_BILL_NAME = "listname";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_INIT_TIPS = "inittips";
    private static final String KEY_PROGRESS_DATA = "progressdatas";

    private boolean checkCustomParams() {
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s", (String)"ExportDataProgressFormPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), CUSTOM_PARAM_ENTITY_NAME));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.getTaskClass())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570\uff1a%s", (String)"ExportDataProgressFormPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), TASK_CLASS));
            return false;
        }
        return true;
    }

    private String getEntityName() {
        return (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_PARAM_ENTITY_NAME);
    }

    private String getTaskClass() {
        return (String)this.getView().getFormShowParameter().getCustomParam(TASK_CLASS);
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHE_KEY_TASK_ID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_TASK_ID);
        }
        return this.getPageCache().get(CACHE_KEY_TASK_ID);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHE_KEY_TASK_ID, taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHE_KEY_IS_START);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHE_KEY_IS_START, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHE_KEY_IS_FINISHED);
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHE_KEY_IS_FINISHED, String.valueOf(finished));
    }

    private JobFormInfo buildJobFormInfo() {
        if (!this.checkCustomParams()) {
            return null;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa - %s", (String)"ExportDataProgressFormPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), this.getEntityName()));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setTaskClassname((String)this.getView().getFormShowParameter().getCustomParam(TASK_CLASS));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CUSTOM_PARAM_CONTEXT, RequestContext.get());
        params.put("parentpageid", this.getView().getFormShowParameter().getParentPageId());
        params.put("EXPORT_LIST_TYPE", this.getView().getFormShowParameter().getCustomParam("EXPORT_LIST_TYPE"));
        params.put("clientFullContextPathFromContext", RequestContext.get().getClientFullContextPath());
        jobInfo.setParams(params);
        jobInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(false);
        jobFormInfo.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        if (this.getView().getFormShowParameter().getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.expt.ExportCallBack", "background_actionid");
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.plugin.expt.ExportTaskClick");
        return jobFormInfo;
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHE_KEY_JOB_FORM_INFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHE_KEY_JOB_FORM_INFO, str);
        }
    }

    public void registerListener(EventObject eventObject) {
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Label title = (Label)this.getControl(KEY_BILL_NAME);
        String text = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa%s\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"ExportDataProgressFormPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), this.getEntityName());
        title.setText(text);
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            bar.setPercent(progress);
            this.showExportDetails(taskInfo);
        }
    }

    public void onProgress(ProgressEvent evt) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
            return;
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, evt);
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            evt.setProgress(progress);
            this.showExportDetails(taskInfo);
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void closeForm() {
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
    }

    private void showExportDetails(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        if (data.isEmpty()) {
            return;
        }
        String desc = String.valueOf(data.get("desc"));
        if (data.containsKey(KEY_TOTAL)) {
            ((Label)this.getControl(KEY_INIT_TIPS)).setText(desc);
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata(KEY_PROGRESS_DATA, notHidden);
        }
    }

    private Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
        result.put("taskinfo", taskInfoStr);
        result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        return result;
    }

    private void complete(TaskInfo taskInfo, ProgressEvent progressEvent) {
        String url;
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        Map<String, Object> taskData = this.getTaskCustData(taskInfo);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            LOGGER.warn("export_perm_progress fail, status:{},statusDesc:{},desc:{},failureReason:{},taskData:{}", new Object[]{taskInfo.getStatus(), taskInfo.getStatusDesc(), taskInfo.getDesc(), taskInfo.getFailureReason(), taskInfo.getData()});
            String errMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ExportDataProgressFormPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            this.stopBar();
            return;
        }
        if (taskData.containsKey("fail")) {
            boolean fail = (Boolean)taskData.get("fail");
            String failmessage = (String)taskData.get("failmessage");
            if (fail && StringUtils.isNotBlank((CharSequence)failmessage)) {
                this.getView().showErrorNotification(failmessage);
                this.stopBar();
                return;
            }
        }
        if (!isFinished) {
            progressEvent.setProgress(99);
            this.showExportDetails(taskInfo);
            return;
        }
        this.getView().returnDataToParent(this.packageReturnResult(taskInfo));
        if (taskData.containsKey("downloadurl") && StringUtils.isNotBlank((CharSequence)(url = (String)taskData.get("downloadurl")))) {
            this.getView().download(url);
        }
        progressEvent.setProgress(100);
        this.stopBar();
        this.closeForm();
        this.createOperationLogByExportDetail(Boolean.TRUE, taskInfo);
    }

    private void createOperationLogByExportDetail(Boolean success, TaskInfo taskInfo) {
        Map<String, Object> data = this.getTaskCustData(taskInfo);
        String completeCount = data.containsKey("complete") ? String.valueOf(data.get("complete")) : "Unknown";
        String opName = ImportOperationLog.OperationEnum.DOWNLOAD_FROM_VIEW_EXPORT_RESULT_SUCCESS.getOpName();
        String opDesc = success != false ? String.format(ImportOperationLog.OperationEnum.DOWNLOAD_FROM_VIEW_EXPORT_RESULT_SUCCESS.getOpDescFormat(), completeCount) : ImportOperationLog.OperationEnum.DOWNLOAD_FROM_VIEW_EXPORT_RESULT_FAIL.getOpDescFormat();
        ImportOperationLog.getInstance().createAppLog("hrcs_exportperm", opName, opDesc);
    }

    private Map<String, Object> getTaskCustData(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(controlKey)) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"ExportDataProgressFormPlugin_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            this.setStart(false);
            this.closeForm();
        }
    }
}

