/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.HRSheetHandler;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleTemplateFieldMap;
import kd.hr.hrcs.common.model.perminit.DataRangeInitValidateBO;
import kd.hr.hrcs.common.model.perminit.DimAndDataRangeBaseModel;
import kd.hr.hrcs.common.model.perminit.DimInitValidateBO;
import kd.hr.hrcs.common.model.perminit.ExcelCellInfo;
import kd.hr.hrcs.common.model.perminit.PermRoleInitValidateBO;
import kd.hr.hrcs.common.model.perminit.RowData;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.xml.sax.SAXException;

@ExcludeFromJacocoGeneratedReport
public class PermImportRoleFailedSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(PermImportRoleFailedSheetHandler.class);
    private Set<String> sheetSet = Sets.newHashSetWithExpectedSize((int)4);
    private boolean hasErrorCol;
    private static final String COLOR = "color";
    private Map<String, CellStyle> styles = new HashMap<String, CellStyle>(16);
    private SXSSFWorkbook book;
    private ImportContext ctx;
    private SheetHandler.ParsedRow currentRow;
    private Map<String, XSSFSheet> sheets = new HashMap<String, XSSFSheet>(16);
    private Table<String, Integer, List<ExcelCellInfo>> rowAddData = HashBasedTable.create();
    private Map<String, List<String>> dimMap;
    private int importRoleDimCount = 0;
    private int importRoleDataRangeCount = 0;
    private Map<String, ImportLogger> importLoggerMap;
    private Map<String, String> urlMap;
    private ExportSheetStyle styles1;
    private Font originalFont;
    private String impFileName;
    private PermRoleInitImportService permRoleInitImportService = new PermRoleInitImportService();
    private String errCellValue = ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportFailedSheetHandler_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    private Table<String, Integer, List<ExcelCellInfo>> headerTb;
    private PermRoleInitValidateBO validateBo;
    private Map<String, List<RowData>> rowDtMap = Maps.newHashMapWithExpectedSize((int)2);
    private static final int THRESHOLD = 1000;

    public PermImportRoleFailedSheetHandler(ImportContext ctx, Map<String, ImportLogger> importLoggerMap, Map<String, String> urlMap, String impFileName, Table<String, Integer, List<ExcelCellInfo>> headerTb, PermRoleInitValidateBO validateBo, Map<String, Integer> countMap, Map<String, List<String>> dimMustMap) {
        this.setInterrupt(false);
        this.ctx = ctx;
        this.importLoggerMap = importLoggerMap;
        this.urlMap = urlMap;
        this.impFileName = impFileName;
        this.headerTb = headerTb;
        this.validateBo = validateBo;
        this.importRoleDimCount = countMap.get("importRoleDim");
        this.importRoleDataRangeCount = countMap.get("importRoleDataRange");
        this.dimMap = dimMustMap;
    }

    private void initStyle() {
        XSSFCellStyle tipsCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle();
        XSSFFont tipsFont = tipsCellStyle.getFont();
        tipsFont.setBold(true);
        tipsFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle("header");
        headerCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCellStyle.setBorderTop(BorderStyle.THIN);
        headerCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerCellFont = headerCellStyle.getFont();
        headerCellFont.setBold(true);
        headerCellFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerMustInputCellStyle = (XSSFCellStyle)this.styles1.getTitleMustInputStyle();
        headerMustInputCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerMustInputCellStyle.setBorderTop(BorderStyle.THIN);
        headerMustInputCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderRight(BorderStyle.THIN);
        headerMustInputCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderBottom(BorderStyle.THIN);
        headerMustInputCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderLeft(BorderStyle.THIN);
        headerMustInputCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerMustInputFont = headerMustInputCellStyle.getFont();
        headerMustInputFont.setBold(true);
        headerMustInputFont.setFontHeightInPoints((short)12);
        headerMustInputFont.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle headerCenterCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle("header-center");
        headerCenterCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCenterCellStyle.setBorderTop(BorderStyle.THIN);
        headerCenterCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderRight(BorderStyle.THIN);
        headerCenterCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCenterCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCenterCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont headerCenterCellFont = headerCenterCellStyle.getFont();
        headerCenterCellFont.setBold(true);
        headerCenterCellFont.setFontHeightInPoints((short)12);
        CellStyle commonCellStyle1 = this.styles1.getTextStyle("body-common1");
        commonCellStyle1.setFont(this.originalFont);
        commonCellStyle1.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBorderTop(BorderStyle.THIN);
        commonCellStyle1.setBorderRight(BorderStyle.THIN);
        commonCellStyle1.setBorderBottom(BorderStyle.THIN);
        commonCellStyle1.setBorderLeft(BorderStyle.THIN);
        CellStyle redFontCellStyle = this.styles1.getTextStyle("body-redfont");
        redFontCellStyle.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        redFontCellStyle.setBorderTop(BorderStyle.THIN);
        redFontCellStyle.setBorderRight(BorderStyle.THIN);
        redFontCellStyle.setBorderBottom(BorderStyle.THIN);
        redFontCellStyle.setBorderLeft(BorderStyle.THIN);
        Font redFont = this.book.createFont();
        redFont.setFontHeightInPoints((short)12);
        redFont.setColor(IndexedColors.RED.getIndex());
        redFontCellStyle.setFont(redFont);
    }

    private Cell addMergeRegionWithWhiteBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cellRange = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.WHITE.getIndex(), (CellRangeAddress)cellRange, (Sheet)sheet);
        sheet.addMergedRegion(cellRange);
        return sheet.getRow(firstRow).getCell(firstCol);
    }

    private Cell addMergedRegionWithWhiteBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle, String cellValue, String tips) {
        Cell cell = this.addMergedRegionWithWhiteBorder(sheet, firstRow, lastRow, firstCol, lastCol, cellStyle, cellValue);
        Drawing p = sheet.createDrawingPatriarch();
        Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, firstCol, firstRow, firstCol + 4, firstRow + 6));
        XSSFRichTextString xssRichTextString = new XSSFRichTextString(tips);
        this.originalFont = this.book.createFont();
        this.originalFont.setFontHeightInPoints((short)12);
        xssRichTextString.applyFont(this.originalFont);
        comment.setString((RichTextString)xssRichTextString);
        cell.setCellComment(comment);
        return cell;
    }

    private Cell addMergedRegionWithWhiteBorder(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addMergeRegionWithWhiteBorder(sheet, firstRow, lastRow, firstCol, lastCol);
        for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
            for (int colIndex = firstCol; colIndex <= lastCol; ++colIndex) {
                sheet.getRow(rowIndex).getCell(colIndex).setCellStyle(cellStyle);
            }
        }
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 1000) {
                cv = cv.substring(0, 1000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        String sheetKey = PermRoleTemplateFieldMap.getRoleTemplateSheetName((String)row.getSheetName());
        XSSFSheet sheet = this.sheets.get(sheetKey);
        if (sheet == null) {
            if (this.book == null) {
                this.book = new SXSSFWorkbook(10000);
                this.book.setCompressTempFiles(true);
            }
            if (!this.checkSheetName(row.getSheetName())) {
                return;
            }
            sheet = this.book.getXSSFWorkbook().createSheet(row.getSheetName());
            sheet.setColumnWidth(0, 10000);
            this.styles1 = new ExportSheetStyle(this.book, null);
            this.originalFont = this.book.createFont();
            this.originalFont.setFontHeightInPoints((short)12);
            this.initStyle();
            this.sheets.put(sheetKey, sheet);
        }
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        XSSFRow curRow = this.getRow(sheet, currRowNum);
        curRow.getCTRow().setHidden(row.isHideRow());
        this.handleWorkSheet(row, sheet);
    }

    private boolean checkSheetName(String sheetName) {
        return this.permRoleInitImportService.containsValue(sheetName);
    }

    private void handleWorkSheet(SheetHandler.ParsedRow row, XSSFSheet sheet) {
        String sheetKey = PermRoleTemplateFieldMap.getRoleTemplateSheetName((String)this.getSheetName());
        this.initRoleListHeader(row, sheet, sheetKey);
        this.initRoleFuncHeader(row, sheet, sheetKey);
        this.initRoleDimHeader(row, sheet, sheetKey);
        this.initRoleDataRangeHeader(row, sheet, sheetKey);
        this.initRoleFieldHeader(row, sheet, sheetKey);
        this.writeRoleListErrorExcelMsg(row, sheet, sheetKey);
        this.writeRoleFuncErrorExcelMsg(row, sheet, sheetKey);
        this.writeRoleDimErrorExcelMsg(row, sheet, sheetKey);
        this.writeRoleDataRangeErrorExcelMsg(row, sheet, sheetKey);
        this.writeRoleFieldErrorExcelMsg(row, sheet, sheetKey);
    }

    private void writeRoleFieldErrorExcelMsg(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        if ("importRoleFp".equals(sheetKey) && row.getRowNum() > 2) {
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            Map fieldErrMsgMap = this.validateBo.getFieldPermInitValidateBO().getErrMsgMap();
            if (fieldErrMsgMap != null) {
                XSSFCell sxssfCell = this.getRow(sheet, row.getRowNum()).createCell(0);
                sxssfCell.setCellStyle(this.getCellStyle(styleObj));
                sxssfCell.setCellValue((String)fieldErrMsgMap.get(row.getRowNum()));
            }
            for (Map.Entry<Integer, String> entry : row.getData().entrySet()) {
                if (this.hasErrorCol) {
                    if ((Integer)entry.getKey() == 0) continue;
                    this.putRoleListSheet(sheet, entry);
                    continue;
                }
                this.putSXSSFSheet(sheet, entry);
            }
        }
    }

    private void writeRoleDataRangeErrorExcelMsg(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        if ("importRoleDataRange".equals(sheetKey) && row.getRowNum() > 4) {
            Map integerStringMap;
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            DataRangeInitValidateBO dataRangeInitValidateBO = this.validateBo.getDataRangeInitValidateBO();
            if (dataRangeInitValidateBO != null && (integerStringMap = dataRangeInitValidateBO.getErrMsgMap()) != null) {
                String error = (String)integerStringMap.get(row.getRowNum());
                XSSFCell xSSFCell = this.getRow(sheet, row.getRowNum()).createCell(0);
                xSSFCell.setCellStyle(this.getCellStyle(styleObj));
                xSSFCell.setCellValue(error);
            }
            ArrayList rowDataList = Lists.newArrayListWithExpectedSize((int)16);
            for (Map.Entry entry : row.getData().entrySet()) {
                if ((Integer)entry.getKey() == 0 && this.hasErrorCol) continue;
                ExcelCellInfo excelCellInfo = new ExcelCellInfo();
                rowDataList.add(excelCellInfo);
                excelCellInfo.setColIndex(this.hasErrorCol ? (Integer)entry.getKey() - 1 : (Integer)entry.getKey());
                excelCellInfo.setRowIndex(row.getRowNum());
                excelCellInfo.setValue((String)entry.getValue());
                excelCellInfo.setRed(false);
            }
            RowData rd = new RowData();
            rd.setColList((List)rowDataList);
            rd.setRowNum(row.getRowNum());
            this.rowDtMap.computeIfAbsent(sheetKey, key -> new ArrayList(16)).add(rd);
        }
    }

    private void writeRoleFuncErrorExcelMsg(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        block4: {
            block5: {
                Map integerStringMap;
                if (!"importRoleFunc".equals(sheetKey) || row.getRowNum() <= 3) break block4;
                JSONObject styleObj = new JSONObject();
                styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
                Map functionItemErrMsgMap = this.validateBo.getFunctionItemErrMsgMap();
                if (functionItemErrMsgMap != null && (integerStringMap = (Map)functionItemErrMsgMap.get(row.getRowNum())) != null) {
                    for (Map.Entry entry : integerStringMap.entrySet()) {
                        XSSFCell sxssfCell = this.hasErrorCol ? (row.getRowNum() == 5 ? this.getRow(sheet, row.getRowNum() - 1).createCell(((Integer)entry.getKey()).intValue()) : (row.getRowNum() == 4 ? this.getRow(sheet, row.getRowNum()).createCell(((Integer)entry.getKey()).intValue()) : this.getRow(sheet, row.getRowNum()).createCell(this.getFuncColIndex((Integer)entry.getKey())))) : (row.getRowNum() > 4 || row.getRowNum() == 4 && (Integer)entry.getKey() == 0 ? this.getRow(sheet, row.getRowNum() + 1).createCell(((Integer)entry.getKey()).intValue()) : this.getRow(sheet, row.getRowNum()).createCell(this.getFuncColIndex((Integer)entry.getKey())));
                        sxssfCell.setCellStyle(this.getCellStyle(styleObj));
                        sxssfCell.setCellValue((String)entry.getValue());
                    }
                }
                if (!this.hasErrorCol) break block5;
                if (row.getRowNum() <= 4) break block4;
                for (Map.Entry<Integer, String> entry : row.getData().entrySet()) {
                    this.putErrorRoleFuncSheet(sheet, entry, row);
                }
                break block4;
            }
            for (Map.Entry<Integer, String> entry : row.getData().entrySet()) {
                this.putRoleFuncSheet(sheet, entry, row);
            }
        }
    }

    private int getFuncColIndex(Integer key) {
        if (key.equals(0)) {
            return 0;
        }
        return key + 1;
    }

    private void writeRoleDimErrorExcelMsg(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        if ("importRoleDim".equals(sheetKey) && row.getRowNum() > 3) {
            Map integerStringMap;
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            DimInitValidateBO dimErrMsgBO = this.validateBo.getDimErrMsgBO();
            if (dimErrMsgBO != null && (integerStringMap = dimErrMsgBO.getErrMsgMap()) != null) {
                String error = (String)integerStringMap.get(row.getRowNum());
                XSSFCell xSSFCell = this.getRow(sheet, row.getRowNum()).createCell(0);
                xSSFCell.setCellStyle(this.getCellStyle(styleObj));
                xSSFCell.setCellValue(error);
            }
            ArrayList rowDataList = Lists.newArrayListWithExpectedSize((int)16);
            for (Map.Entry entry : row.getData().entrySet()) {
                if ((Integer)entry.getKey() == 0 && this.hasErrorCol) continue;
                ExcelCellInfo excelCellInfo = new ExcelCellInfo();
                rowDataList.add(excelCellInfo);
                excelCellInfo.setColIndex(this.hasErrorCol ? (Integer)entry.getKey() - 1 : (Integer)entry.getKey());
                excelCellInfo.setRowIndex(row.getRowNum());
                excelCellInfo.setValue((String)entry.getValue());
                excelCellInfo.setRed(false);
            }
            RowData rd = new RowData();
            rd.setColList((List)rowDataList);
            rd.setRowNum(row.getRowNum());
            this.rowDtMap.computeIfAbsent(sheetKey, key -> new ArrayList(16)).add(rd);
        }
    }

    private CellStyle getCellStyle(JSONObject style) {
        String defaultFmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short backGround = style.getShort("bg");
        Short titleColor = style.getShort(COLOR);
        String styleStr = String.format(Locale.ROOT, "%s_-_%d_-_%d_-_%s", defaultFmt, backGround, titleColor, align);
        CellStyle customCellStyle = this.styles.get(styleStr);
        if (customCellStyle == null) {
            customCellStyle = HRSheetHandler.getCellStyle((String)defaultFmt, (Short)backGround, (Short)titleColor, (String)styleStr, this.styles, (SXSSFWorkbook)this.book);
        }
        return customCellStyle;
    }

    private void writeRoleListErrorExcelMsg(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        if ("importRoleList".equals(sheetKey) && row.getRowNum() > 3) {
            XSSFCell sxssfCell = this.getRow(sheet, row.getRowNum()).createCell(0);
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            sxssfCell.setCellStyle(this.getCellStyle(styleObj));
            sxssfCell.setCellValue((String)this.validateBo.getRoleErrMsgMap().get(row.getRowNum()));
            for (Map.Entry<Integer, String> entry : row.getData().entrySet()) {
                if (this.hasErrorCol) {
                    if ((Integer)entry.getKey() == 0) continue;
                    this.putRoleListSheet(sheet, entry);
                    continue;
                }
                this.putSXSSFSheet(sheet, entry);
            }
        }
    }

    private Cell addCellRegion(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue, String tips) {
        Cell cell = this.addCellRegion(sheet, rowIndex, colIndex);
        if (HRStringUtils.isNotEmpty((String)tips)) {
            Drawing p = sheet.createDrawingPatriarch();
            Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(10, 10, 0, 0, colIndex, rowIndex, colIndex + 4, rowIndex + 6));
            XSSFRichTextString xssRichTextString = new XSSFRichTextString(tips);
            this.originalFont = this.book.createFont();
            this.originalFont.setFontHeightInPoints((short)12);
            xssRichTextString.applyFont(this.originalFont);
            comment.setString((RichTextString)xssRichTextString);
            cell.setCellComment(comment);
        }
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 1000) {
                cv = cv.substring(0, 1000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    private void initRoleFieldHeader(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        block7: {
            CellStyle cellStyle;
            CellStyle mustCellStyle;
            List excelCellInfos;
            block9: {
                block8: {
                    if (!"importRoleFp".equals(sheetKey) || row.getRowNum() >= 3) break block7;
                    excelCellInfos = (List)this.headerTb.get((Object)sheetKey, (Object)row.getRowNum());
                    if (CollectionUtils.isEmpty((Collection)excelCellInfos)) {
                        return;
                    }
                    mustCellStyle = this.styles1.getTitleMustInputStyle();
                    mustCellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cellStyle = this.styles1.getTitleStyle("header");
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cellStyle.setWrapText(true);
                    mustCellStyle.setWrapText(true);
                    if (row.getRowNum() != 0) break block8;
                    this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles1.getTitleStyle(), ((ExcelCellInfo)excelCellInfos.get(0)).getName());
                    break block7;
                }
                if (row.getRowNum() != 1) break block9;
                for (ExcelCellInfo info : excelCellInfos) {
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1).setCellValue(info.getName());
                }
                break block7;
            }
            if (row.getRowNum() != 2) break block7;
            this.addCellRegion((Sheet)sheet, row.getRowNum(), 0, mustCellStyle, this.errCellValue);
            sheet.setColumnWidth(1, this.errCellValue.getBytes().length * 120);
            String numTip = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u9875\u7b7e\u7684\u89d2\u8272", (String)"RoleTemplateExcelWriter_56", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            String appTip = ResManager.loadKDString((String)"\u53ef\u53c2\u8003\u300a\u89d2\u8272\u529f\u80fd\u6743\u9650\u300b\u9875\u7b7e", (String)"RoleTemplateExcelWriter_45", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            String viewTip = ResManager.loadKDString((String)"\u8f93\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\u3002", (String)"RoleTemplateExcelWriter_51", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            String editTip = ResManager.loadKDString((String)"\u5f55\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\n\u5f55\u5165\u8981\u6c42\uff1a\u4e0d\u5141\u8bb8\u67e5\u770b\u65f6\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"RoleTemplateExcelWriter_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            HashMap styleMap = Maps.newHashMapWithExpectedSize((int)2);
            styleMap.put(0, numTip);
            styleMap.put(2, appTip);
            styleMap.put(4, appTip);
            styleMap.put(8, viewTip);
            styleMap.put(9, editTip);
            for (ExcelCellInfo info : excelCellInfos) {
                if (info.getName().contains("*")) {
                    if (styleMap.containsKey(info.getColIndex())) {
                        this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1, mustCellStyle, info.getName(), (String)styleMap.get(info.getColIndex()));
                    } else {
                        this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1, mustCellStyle, info.getName());
                    }
                } else {
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1, cellStyle, info.getName());
                }
                sheet.setColumnWidth(info.getColIndex() + 1, info.getName().getBytes().length * 220);
            }
        }
    }

    private void initRoleDataRangeHeader(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        if ("importRoleDataRange".equals(sheetKey) && row.getRowNum() < 5) {
            List excelCellInfos = (List)this.headerTb.get((Object)sheetKey, (Object)row.getRowNum());
            if (CollectionUtils.isEmpty((Collection)excelCellInfos)) {
                return;
            }
            CellStyle mustCellStyle = this.styles1.getTitleMustInputStyle();
            CellStyle cellStyle = this.styles1.getTitleStyle("header");
            mustCellStyle.setWrapText(true);
            mustCellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setWrapText(true);
            CellStyle centerCellStyle = this.styles1.getTitleStyle("header-center");
            centerCellStyle.setWrapText(true);
            if (row.getRowNum() == 0) {
                this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles1.getTitleStyle(), ((ExcelCellInfo)excelCellInfos.get(0)).getName());
            } else if (row.getRowNum() == 1) {
                for (ExcelCellInfo info : excelCellInfos) {
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1).setCellValue(info.getName());
                }
            } else if (row.getRowNum() == 2) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, row.getRowNum(), row.getRowNum() + 2, 0, 0, mustCellStyle, this.errCellValue);
                sheet.setColumnWidth(1, this.errCellValue.getBytes().length * 40);
                String dimTip = ResManager.loadKDString((String)"\u6839\u636e\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\uff0c\u83b7\u53d6\u89d2\u8272\u5404\u804c\u80fd\u4e0b\u7684\u7ef4\u5ea6\u3002", (String)"RoleTemplateExcelWriter_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                String numTip = ResManager.loadKDString((String)"1\u3001\u5fc5\u987b\u662f\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u9875\u7b7e\u7684\u89d2\u8272\n2\u3001\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u4e2d\u8bbe\u7f6e\u4e86\u201c\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u201d\u7684\u89d2\u8272\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6570\u636e\u8303\u56f4\uff1b\u201c\u5141\u8bb8\u81ea\u5b9a\u4e49\u201d\u7684\u89d2\u8272\u6309\u9700\u8bbe\u7f6e\u6570\u636e\u8303\u56f4", (String)"RoleTemplateExcelWriter_37", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                String typeTip = ResManager.loadKDString((String)"\u4fdd\u6301\u4e0e\u201c\u89d2\u8272\u7ef4\u5ea6\u201d\u9875\u7b7e\u6807\u8bb0\u7684\u804c\u80fd\u4e00\u81f4\u3002", (String)"RoleTemplateExcelWriter_59", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                String orgTip = ResManager.loadKDString((String)"\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u4e2d\uff0c\u5982\u679c\u89d2\u8272\u88ab\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\uff0c\u5219\u5fc5\u987b\u4e3a\u5176\u8bbe\u7f6e\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\uff1b\u5982\u679c\u89d2\u8272\u88ab\u8bbe\u7f6e\u4e3a\u201c\u5141\u8bb8\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\uff0c\u5219\u53ef\u4ee5\u6839\u636e\u9700\u8981\u8bbe\u7f6e\u6570\u636e\u8303\u56f4\u3002\n\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u4e1a\u52a1\u7ec4\u7ec7\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002", (String)"RoleTemplateExcelWriter_55", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                HashMap styleMap = Maps.newHashMapWithExpectedSize((int)2);
                styleMap.put(0, numTip);
                styleMap.put(2, typeTip);
                styleMap.put(3, orgTip);
                int size = ((List)this.headerTb.get((Object)sheetKey, (Object)1)).size() - 4;
                for (ExcelCellInfo exc : excelCellInfos) {
                    if (exc.getColIndex() < 4) {
                        if (exc.getName().contains("*")) {
                            this.addMergedRegionWithWhiteBorder((Sheet)sheet, exc.getRowIndex(), exc.getRowIndex() + 2, exc.getColIndex() + 1, exc.getColIndex() + 1, mustCellStyle, exc.getName(), (String)styleMap.get(exc.getColIndex()));
                        } else {
                            this.addMergedRegionWithWhiteBorder((Sheet)sheet, exc.getRowIndex(), exc.getRowIndex() + 2, exc.getColIndex() + 1, exc.getColIndex() + 1, centerCellStyle, exc.getName());
                        }
                    } else if (size > 1) {
                        this.addMergedRegionWithWhiteBorder((Sheet)sheet, exc.getRowIndex(), exc.getRowIndex(), exc.getColIndex() + 1, 4 + size, centerCellStyle, exc.getName(), dimTip);
                    } else {
                        this.addCellRegionWithWhiteBorder((Sheet)sheet, exc.getRowIndex(), exc.getColIndex() + 1, centerCellStyle, exc.getName(), dimTip);
                    }
                    sheet.setColumnWidth(exc.getColIndex() + 1, exc.getName().getBytes().length * 180);
                }
            } else if (row.getRowNum() == 3) {
                List rowHeadList = (List)this.headerTb.get((Object)sheetKey, (Object)1);
                HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
                rowHeadList.stream().filter(it -> it.getName().contains("#")).forEach(it -> {
                    String dim = it.getName().split("#")[0];
                    Integer integer = (Integer)countMap.get(dim);
                    if (integer == null) {
                        countMap.put(dim, 1);
                    } else {
                        Integer n = integer;
                        Integer n2 = integer = Integer.valueOf(integer + 1);
                        countMap.put(dim, integer);
                    }
                });
                for (ExcelCellInfo info : excelCellInfos) {
                    Optional<ExcelCellInfo> any = rowHeadList.stream().filter(it -> it.getColIndex() == info.getColIndex()).findAny();
                    if (!any.isPresent()) continue;
                    Integer mergeCount = (Integer)countMap.get(any.get().getName().split("#")[0]);
                    if (any.get().getName().contains("#")) {
                        if (mergeCount == 1) {
                            this.addMergedRegionWithWhiteBorder((Sheet)sheet, info.getRowIndex(), info.getRowIndex() + 1, info.getColIndex() + 1, info.getColIndex() + 1, centerCellStyle, info.getName());
                            continue;
                        }
                        this.addMergedRegionWithWhiteBorder((Sheet)sheet, info.getRowIndex(), info.getRowIndex(), info.getColIndex() + 1, info.getColIndex() + mergeCount, centerCellStyle, info.getName());
                        continue;
                    }
                    this.addMergedRegionWithWhiteBorder((Sheet)sheet, info.getRowIndex(), info.getRowIndex() + 1, info.getColIndex() + 1, info.getColIndex() + 1, centerCellStyle, info.getName());
                }
            } else if (row.getRowNum() == 4) {
                for (ExcelCellInfo info : excelCellInfos) {
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1, centerCellStyle, info.getName());
                }
                sheet.createFreezePane(5, 5);
            }
        }
    }

    private void initRoleDimHeader(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        if ("importRoleDim".equals(sheetKey) && row.getRowNum() < 4) {
            List excelCellInfos = (List)this.headerTb.get((Object)sheetKey, (Object)row.getRowNum());
            if (CollectionUtils.isEmpty((Collection)excelCellInfos)) {
                return;
            }
            CellStyle mustCellStyle = this.styles1.getTitleMustInputStyle();
            CellStyle cellStyle = this.styles1.getTitleStyle("header");
            mustCellStyle.setWrapText(true);
            mustCellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setWrapText(true);
            CellStyle centerCellStyle = this.styles1.getTitleStyle("header-center");
            centerCellStyle.setWrapText(true);
            if (row.getRowNum() == 0) {
                this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles1.getTitleStyle(), ((ExcelCellInfo)excelCellInfos.get(0)).getName());
            } else if (row.getRowNum() == 1) {
                for (ExcelCellInfo info : excelCellInfos) {
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1).setCellValue(info.getName());
                }
            } else if (row.getRowNum() == 2) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, row.getRowNum(), row.getRowNum() + 1, 0, 0, mustCellStyle, this.errCellValue);
                sheet.setColumnWidth(1, this.errCellValue.getBytes().length * 40);
                String dimTip = ResManager.loadKDString((String)"\u6839\u636e\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\uff0c\u83b7\u53d6\u89d2\u8272\u5404\u804c\u80fd\u4e0b\u7684\u7ef4\u5ea6\u3002", (String)"RoleTemplateExcelWriter_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                String numTip = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u9875\u7b7e\u7684\u89d2\u8272", (String)"RoleTemplateExcelWriter_56", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                String typeTip = ResManager.loadKDString((String)"\u53ef\u6839\u636e\u300a\u89d2\u8272\u529f\u80fd\u6743\u9650\u300b\u9875\u7b7e\u83b7\u53d6\u89d2\u8272\u7684\u804c\u80fd\u7c7b\u578b", (String)"PermImportRoleFailedSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                HashMap styleMap = Maps.newHashMapWithExpectedSize((int)2);
                styleMap.put(0, numTip);
                styleMap.put(2, typeTip);
                List cellInfoList = (List)this.headerTb.get((Object)sheetKey, (Object)3);
                for (ExcelCellInfo exc : excelCellInfos) {
                    if (exc.getColIndex() < 3) {
                        if (exc.getName().contains("*")) {
                            this.addMergedRegionWithWhiteBorder((Sheet)sheet, exc.getRowIndex(), exc.getRowIndex() + 1, exc.getColIndex() + 1, exc.getColIndex() + 1, mustCellStyle, exc.getName(), (String)styleMap.get(exc.getColIndex()));
                        } else {
                            this.addMergedRegionWithWhiteBorder((Sheet)sheet, exc.getRowIndex(), exc.getRowIndex() + 1, exc.getColIndex() + 1, exc.getColIndex() + 1, centerCellStyle, exc.getName());
                        }
                    } else if (CollectionUtils.isNotEmpty((Collection)cellInfoList)) {
                        int size = cellInfoList.size();
                        if (size > 1) {
                            this.addMergedRegionWithWhiteBorder((Sheet)sheet, exc.getRowIndex(), exc.getRowIndex(), exc.getColIndex() + 1, 3 + size, centerCellStyle, exc.getName(), dimTip);
                        } else {
                            this.addCellRegionWithWhiteBorder((Sheet)sheet, exc.getRowIndex(), exc.getColIndex() + 1, centerCellStyle, exc.getName(), dimTip);
                        }
                    }
                    sheet.setColumnWidth(exc.getColIndex() + 1, exc.getName().getBytes().length * 180);
                }
            } else if (row.getRowNum() == 3) {
                for (ExcelCellInfo info : excelCellInfos) {
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1, centerCellStyle, info.getName());
                }
                CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(4, 99999, 4, excelCellInfos.size() + 3);
                this.fillGouCombo((Sheet)sheet, cellRangeAddressList);
                sheet.createFreezePane(4, 4);
            }
        }
    }

    private Cell addCellRegionWithWhiteBorder(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue, String tips) {
        Cell cell = this.addCellRegionWithWhiteBorder(sheet, rowIndex, colIndex, cellStyle, cellValue);
        if (HRStringUtils.isNotEmpty((String)tips)) {
            Drawing p = sheet.createDrawingPatriarch();
            Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(10, 10, 0, 0, colIndex, rowIndex, colIndex + 4, rowIndex + 6));
            XSSFRichTextString xssRichTextString = new XSSFRichTextString(tips);
            this.originalFont = this.book.createFont();
            this.originalFont.setFontHeightInPoints((short)12);
            xssRichTextString.applyFont(this.originalFont);
            comment.setString((RichTextString)xssRichTextString);
            cell.setCellComment(comment);
        }
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 1000) {
                cv = cv.substring(0, 1000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    private Cell addCellRegion(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addCellRegion(sheet, rowIndex, colIndex);
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 1000) {
                cv = cv.substring(0, 1000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    private void initRoleFuncHeader(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        if ("importRoleFunc".equals(sheetKey) && row.getRowNum() < 4) {
            List excelCellInfos = (List)this.headerTb.get((Object)sheetKey, (Object)row.getRowNum());
            if (CollectionUtils.isEmpty((Collection)excelCellInfos)) {
                return;
            }
            XSSFCellStyle centerCellStyle = (XSSFCellStyle)this.styles1.getTitleStyle("header-center2");
            centerCellStyle.setBorderBottom(BorderStyle.THIN);
            centerCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
            centerCellStyle.setBorderTop(BorderStyle.THIN);
            centerCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
            centerCellStyle.setBorderRight(BorderStyle.THIN);
            centerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
            centerCellStyle.setBorderLeft(BorderStyle.THIN);
            centerCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
            centerCellStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFFont headerCellFont = centerCellStyle.getFont();
            headerCellFont.setBold(true);
            headerCellFont.setFontHeightInPoints((short)12);
            CellStyle mustCellStyle = this.styles1.getTitleMustInputStyle();
            mustCellStyle.setAlignment(HorizontalAlignment.CENTER);
            if (row.getRowNum() == 0) {
                this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles1.getTitleStyle(), ((ExcelCellInfo)excelCellInfos.get(0)).getName());
            } else if (row.getRowNum() == 1) {
                for (ExcelCellInfo info : excelCellInfos) {
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1).setCellValue(info.getName());
                }
            } else if (row.getRowNum() == 2) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, row.getRowNum(), row.getRowNum() + 1, 0, 0, mustCellStyle, this.errCellValue);
                sheet.setColumnWidth(1, this.errCellValue.getBytes().length * 120);
                String tip = ResManager.loadKDString((String)"\u8bf7\u52ff\u4fee\u6539\u7070\u8272\u5217\uff0c\u8be5\u5217\u4e3a\u7cfb\u7edf\u6570\u636e\u3002", (String)"PermImportRoleFailedSheetHandler_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                ExcelCellInfo excelCellInfo = (ExcelCellInfo)excelCellInfos.get(0);
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, excelCellInfo.getRowIndex(), excelCellInfo.getRowIndex(), excelCellInfo.getColIndex() + 1, excelCellInfo.getColIndex() + 9, (CellStyle)centerCellStyle, excelCellInfo.getName(), tip);
            } else if (row.getRowNum() == 3) {
                for (ExcelCellInfo info : excelCellInfos) {
                    if (info.getColIndex() >= 9) continue;
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), info.getColIndex() + 1, (CellStyle)centerCellStyle, info.getName());
                }
                String roleSheetName = ResManager.loadKDString((String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f", (String)"PermSheetHelper_91", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                int index = 1;
                for (int i = 6 + index; i < 306 + index; ++i) {
                    Cell cell = this.addCellRegion((Sheet)sheet, 2, i + 3);
                    cell.setCellType(CellType.STRING);
                    cell.setCellStyle((CellStyle)centerCellStyle);
                    String str = "IF(COUNTBLANK(" + roleSheetName + "!B" + (i - index) + "),\"\",TRANSPOSE(" + roleSheetName + "!B" + (i - index) + "))";
                    cell.setCellFormula(str);
                    Cell cell2 = this.addCellRegion((Sheet)sheet, 3, i + 3);
                    cell2.setCellStyle((CellStyle)centerCellStyle);
                    cell2.setCellType(CellType.STRING);
                    String str2 = "IF(COUNTBLANK(" + roleSheetName + "!C" + (i - index) + "),\"\",TRANSPOSE(" + roleSheetName + "!C" + (i - index) + "))";
                    cell2.setCellFormula(str2);
                }
                CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(4 + index, 99999 + index, 9 + index, 308 + index);
                this.fillGouCombo((Sheet)sheet, cellRangeAddressList);
                sheet.createFreezePane(10, 4);
            }
        }
    }

    private void fillGouCombo(Sheet sheet, CellRangeAddressList cellRangeAddressList) {
        String[] items = new String[]{"\u221a"};
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint dataScopeValueConstraint = helper.createExplicitListConstraint(items);
        DataValidation dataScopeDataValidation = helper.createValidation(dataScopeValueConstraint, cellRangeAddressList);
        sheet.addValidationData(dataScopeDataValidation);
    }

    private void initRoleListHeader(SheetHandler.ParsedRow row, XSSFSheet sheet, String sheetKey) {
        block5: {
            CellStyle cellStyle;
            CellStyle mustCellStyle;
            List excelCellInfos;
            block7: {
                block6: {
                    if (!"importRoleList".equals(sheetKey) || row.getRowNum() >= 4) break block5;
                    excelCellInfos = (List)this.headerTb.get((Object)sheetKey, (Object)row.getRowNum());
                    List hasErrorCheck = (List)this.headerTb.get((Object)sheetKey, (Object)2);
                    if (CollectionUtils.isEmpty((Collection)hasErrorCheck)) {
                        return;
                    }
                    this.hasErrorCol = ((ExcelCellInfo)hasErrorCheck.get(0)).isHasErrorLine();
                    mustCellStyle = this.styles1.getTitleMustInputStyle();
                    mustCellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cellStyle = this.styles1.getTitleStyle("header");
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cellStyle.setWrapText(true);
                    mustCellStyle.setWrapText(true);
                    if (row.getRowNum() != 0) break block6;
                    this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles1.getTitleStyle(), ((ExcelCellInfo)excelCellInfos.get(0)).getName());
                    break block5;
                }
                if (row.getRowNum() != 1) break block7;
                for (ExcelCellInfo info : excelCellInfos) {
                    this.addCellRegion((Sheet)sheet, info.getRowIndex(), this.hasErrorCol ? info.getColIndex() : info.getColIndex() + 1).setCellValue(info.getName());
                }
                break block5;
            }
            if (row.getRowNum() != 2) break block5;
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, row.getRowNum(), row.getRowNum() + 2, 0, 0, mustCellStyle, this.errCellValue);
            sheet.setColumnWidth(1, this.errCellValue.getBytes().length * 120);
            for (ExcelCellInfo info : excelCellInfos) {
                if (info.getName().contains("*")) {
                    this.addMergedRegionWithWhiteBorder((Sheet)sheet, info.getRowIndex(), info.getRowIndex() + 2, info.getColIndex() + 1, info.getColIndex() + 1, mustCellStyle, info.getName());
                } else {
                    this.addMergedRegionWithWhiteBorder((Sheet)sheet, info.getRowIndex(), info.getRowIndex() + 2, info.getColIndex() + 1, info.getColIndex() + 1, cellStyle, info.getName());
                }
                sheet.setColumnWidth(info.getColIndex() + 3, info.getName().getBytes().length * 120);
            }
        }
    }

    private Cell addCellRegion(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell;
        Row row = sheet.getRow(rowIndex);
        if (null == row) {
            row = sheet.createRow(rowIndex);
        }
        if (null == (cell = row.getCell(colIndex))) {
            cell = row.createCell(colIndex);
        }
        CellStyle cellstyle = cell.getCellStyle();
        this.originalFont = this.book.createFont();
        this.originalFont.setFontHeightInPoints((short)12);
        cellstyle.setFont(this.originalFont);
        cellstyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellstyle.setAlignment(HorizontalAlignment.LEFT);
        return cell;
    }

    private Cell addCellRegionWithWhiteBorder(Sheet sheet, int rowIndex, int colIndex) {
        Cell cell = this.addCellRegion(sheet, rowIndex, colIndex);
        cell.getCellStyle().setTopBorderColor(IndexedColors.WHITE.getIndex());
        cell.getCellStyle().setRightBorderColor(IndexedColors.WHITE.getIndex());
        cell.getCellStyle().setBottomBorderColor(IndexedColors.WHITE.getIndex());
        cell.getCellStyle().setLeftBorderColor(IndexedColors.WHITE.getIndex());
        return cell;
    }

    private Cell addCellRegionWithWhiteBorder(Sheet sheet, int rowIndex, int colIndex, CellStyle cellStyle, String cellValue) {
        Cell cell = this.addCellRegionWithWhiteBorder(sheet, rowIndex, colIndex);
        Optional.ofNullable(cellStyle).ifPresent(arg_0 -> ((Cell)cell).setCellStyle(arg_0));
        Optional.ofNullable(cellValue).ifPresent(cv -> {
            if (cv.length() > 1000) {
                cv = cv.substring(0, 1000);
            }
            cell.setCellValue(cv);
        });
        return cell;
    }

    private void putRoleListSheet(XSSFSheet sheet, Map.Entry<Integer, String> entry) {
        CellStyle commonCellStyle = this.styles1.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        int currRowNum = this.currentRow.getRowNum();
        int cellIndex = this.countIndex(entry.getKey()) - 1;
        XSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        sxssfCell.setCellStyle(commonCellStyle);
        sxssfCell.setCellValue(entry.getValue());
    }

    private void putSXSSFSheet(XSSFSheet sheet, Map.Entry<Integer, String> entry) {
        CellStyle commonCellStyle = this.styles1.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        int currRowNum = this.currentRow.getRowNum();
        int cellIndex = this.countIndex(entry.getKey());
        XSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        sxssfCell.setCellStyle(commonCellStyle);
        sxssfCell.setCellValue(entry.getValue());
    }

    private void putDimSheet(XSSFSheet sheet, Integer key, String value, Integer currRowNum, boolean isRed, JSONObject styleObj) {
        CellStyle commonCellStyle = this.styles1.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        int cellIndex = this.countIndex(key);
        XSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        if (isRed) {
            sxssfCell.setCellStyle(this.getCellStyle(styleObj));
        } else {
            sxssfCell.setCellStyle(commonCellStyle);
        }
        sxssfCell.setCellValue(value);
    }

    private void putRoleFuncSheet(XSSFSheet sheet, Map.Entry<Integer, String> entry, SheetHandler.ParsedRow row) {
        if (row.getRowNum() > 3 && entry.getKey() == 8) {
            List<String> list;
            String entityNum = (String)row.getData().get(4);
            String dim = (String)row.getData().get(8);
            if (this.isMustDim(dim, list = this.dimMap.get(entityNum))) {
                this.setMustDimColor(sheet, entry, dim, list, 1, 0);
            } else {
                this.writeFuncErrExcel(sheet, entry);
            }
        } else {
            this.writeFuncErrExcel(sheet, entry);
        }
    }

    private void writeFuncErrExcel(XSSFSheet sheet, Map.Entry<Integer, String> entry) {
        CellStyle commonCellStyle = this.styles1.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        int currRowNum = this.currentRow.getRowNum() + 1;
        int cellIndex = this.countIndex(entry.getKey());
        XSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        sxssfCell.setCellStyle(commonCellStyle);
        sxssfCell.setCellValue(entry.getValue());
    }

    private boolean isMustDim(String dim, List<String> list) {
        if (HRStringUtils.isEmpty((String)dim)) {
            return false;
        }
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        if (dim.contains(",")) {
            String[] split;
            for (String dm : split = dim.split(",")) {
                if (!list.contains(dm)) continue;
                return true;
            }
        } else {
            return list.contains(dim);
        }
        return false;
    }

    private void putErrorRoleFuncSheet(XSSFSheet sheet, Map.Entry<Integer, String> entry, SheetHandler.ParsedRow row) {
        if (row.getRowNum() > 3 && entry.getKey() == 9) {
            List<String> list;
            String entityNum = (String)row.getData().get(5);
            String dim = (String)row.getData().get(9);
            if (this.isMustDim(dim, list = this.dimMap.get(entityNum))) {
                this.setMustDimColor(sheet, entry, dim, list, 0, 1);
            } else {
                this.setFieldExcel(sheet, entry);
            }
        } else {
            this.setFieldExcel(sheet, entry);
        }
    }

    private void setFieldExcel(XSSFSheet sheet, Map.Entry<Integer, String> entry) {
        CellStyle commonCellStyle = this.styles1.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        int currRowNum = this.currentRow.getRowNum();
        int cellIndex = this.countIndex(entry.getKey() - 1);
        XSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        sxssfCell.setCellStyle(commonCellStyle);
        sxssfCell.setCellValue(entry.getValue());
    }

    private void setMustDimColor(XSSFSheet sheet, Map.Entry<Integer, String> entry, String dim, List<String> list, int idx, int step) {
        Font originalFont = this.book.createFont();
        originalFont.setFontHeightInPoints((short)12);
        originalFont.setColor(IndexedColors.RED.getIndex());
        XSSFRichTextString richTextString = new XSSFRichTextString(dim);
        if (dim.contains(",")) {
            String[] split;
            for (String dm : split = dim.split(",")) {
                if (!list.contains(dm)) continue;
                richTextString.applyFont(dim.indexOf(dm), dim.indexOf(dm) + dm.length(), originalFont);
            }
        } else {
            richTextString.applyFont(0, dim.length(), originalFont);
        }
        int currRowNum = this.currentRow.getRowNum() + idx;
        int cellIndex = this.countIndex(entry.getKey() - step);
        XSSFCell sxssfCell = this.getRow(sheet, currRowNum).createCell(cellIndex);
        sxssfCell.setCellValue((RichTextString)richTextString);
    }

    private int countIndex(int index) {
        return ++index;
    }

    public XSSFRow getRow(XSSFSheet sheet, int intdexRow) {
        XSSFRow row = sheet.getRow(intdexRow);
        if (row == null) {
            row = sheet.createRow(intdexRow);
        }
        return row;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        boolean isContains = this.permRoleInitImportService.containsValue(this.getSheetName().trim());
        if (this.currentRow != null && isContains) {
            this.sheetSet.add(this.getSheetName());
            this.writeDimMsg();
            this.writeDimDataRangeMsg();
        }
        this.setInterrupt(false);
        if (this.sheetSet.size() != 5) {
            return;
        }
        this.setInterrupt(true);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.book.write((OutputStream)os);
            byte[] data = os.toByteArray();
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String fileName = null;
            fileName = String.format(ResManager.loadKDString((String)"\u5168\u91cf\u62a5\u544a_%1$s", (String)"PermImportFailedSheetHandler_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), this.impFileName).replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
            String url = tempFile.saveAsUrl(fileName, data, 7200);
            RequestContext rc = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)this.ctx.getAppId(), (String)(this.ctx.getBillFormId() + UUID.randomUUID().toString()), (String)fileName);
            FileService service = FileServiceFactory.getAttachmentFileService();
            url = service.upload(new FileItem(fileName, path, tempFile.getInputStream(url)));
            this.urlMap.put("allErrUrl", UrlService.getAttachmentFullUrl((String)url));
        }
        catch (Exception exp) {
            throw new KDBizException((Throwable)exp, new ErrorCode("", exp instanceof KDBizException ? exp.getMessage() : ResManager.loadKDString((String)"\u9519\u8bef\u6570\u636e\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"PermImportFailedSheetHandler_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            try {
                if (this.book != null) {
                    this.book.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            this.ctx = null;
            this.sheets.clear();
            this.book = null;
        }
    }

    private void writeDimDataRangeMsg() {
        String sheetKey = PermRoleTemplateFieldMap.getRoleTemplateSheetName((String)this.currentRow.getSheetName());
        if ("importRoleDataRange".equals(sheetKey)) {
            Map lackMsgMap;
            DataRangeInitValidateBO dimErrMsgBO;
            XSSFSheet sheet = this.sheets.get(sheetKey);
            ArrayList rowDataList = this.rowDtMap.get(sheetKey);
            if (CollectionUtils.isEmpty(rowDataList)) {
                rowDataList = Lists.newArrayListWithExpectedSize((int)16);
                this.rowDtMap.put(sheetKey, rowDataList);
            }
            if (Objects.nonNull(dimErrMsgBO = this.validateBo.getDataRangeInitValidateBO()) && (lackMsgMap = dimErrMsgBO.getLackMsgMap()) != null) {
                for (Map.Entry entry : lackMsgMap.entrySet()) {
                    String errorVal = (String)entry.getValue();
                    DimAndDataRangeBaseModel key = (DimAndDataRangeBaseModel)entry.getKey();
                    ArrayList ls = Lists.newArrayListWithExpectedSize((int)4);
                    if (Objects.isNull(key.getRowNum())) {
                        int rowNum = this.currentRow.getRowNum() + 1;
                        if (rowDataList.stream().noneMatch(it -> it.getRowNum() == rowNum)) {
                            this.initDimRowDt(errorVal, key, ls);
                            RowData rowData = new RowData();
                            rowData.setRowNum(this.currentRow.getRowNum() + 1);
                            rowData.setColList((List)ls);
                            rowDataList.add(rowData);
                            continue;
                        }
                        key.setRowNum(Integer.valueOf(rowNum));
                        this.checkRpLine(rowDataList, errorVal, key, ls);
                        continue;
                    }
                    this.checkRpLine(rowDataList, errorVal, key, ls);
                }
            }
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            for (RowData rd : rowDataList) {
                for (ExcelCellInfo in : rd.getColList()) {
                    this.putDimSheet(sheet, in.getColIndex(), in.getValue(), rd.getRowNum(), in.isRed(), styleObj);
                }
            }
        }
    }

    private void checkRpLine(List<RowData> rowDataList, String errorVal, DimAndDataRangeBaseModel key, List<ExcelCellInfo> ls) {
        Optional<RowData> any = rowDataList.stream().filter(it -> it.getRowNum() == key.getRowNum().intValue()).findAny();
        if (!any.isPresent()) {
            this.initDimRowDt(errorVal, key, ls);
            RowData rowData = new RowData();
            rowData.setRowNum(key.getRowNum().intValue());
            rowData.setColList(ls);
            rowDataList.add(rowData);
        } else {
            RowData rowData = any.get();
            List<RowData> collect = rowDataList.stream().filter(it -> it.getRowNum() >= rowData.getRowNum()).collect(Collectors.toList());
            rowDataList.removeIf(it -> it.getRowNum() >= rowData.getRowNum());
            collect.forEach(it -> it.setRowNum(it.getRowNum() + 1));
            rowDataList.addAll(collect);
            this.initDimRowDt(errorVal, key, ls);
            RowData newData = new RowData();
            newData.setRowNum(key.getRowNum().intValue());
            newData.setColList(ls);
            rowDataList.add(newData);
        }
    }

    private void writeDimMsg() {
        String sheetKey = PermRoleTemplateFieldMap.getRoleTemplateSheetName((String)this.currentRow.getSheetName());
        if ("importRoleDim".equals(sheetKey)) {
            Map lackMsgMap;
            XSSFSheet sheet = this.sheets.get(sheetKey);
            DimInitValidateBO dimErrMsgBO = this.validateBo.getDimErrMsgBO();
            ArrayList rowDataList = this.rowDtMap.get(sheetKey);
            if (CollectionUtils.isEmpty(rowDataList)) {
                rowDataList = Lists.newArrayListWithExpectedSize((int)16);
                this.rowDtMap.put(sheetKey, rowDataList);
            }
            if (Objects.nonNull(dimErrMsgBO) && (lackMsgMap = dimErrMsgBO.getLackMsgMap()) != null) {
                for (Map.Entry entry : lackMsgMap.entrySet()) {
                    String errorVal = (String)entry.getValue();
                    DimAndDataRangeBaseModel key = (DimAndDataRangeBaseModel)entry.getKey();
                    ArrayList ls = Lists.newArrayListWithExpectedSize((int)4);
                    if (Objects.isNull(key.getRowNum())) {
                        int rowNum = this.currentRow.getRowNum() + 1;
                        if (rowDataList.stream().noneMatch(it -> it.getRowNum() == rowNum)) {
                            this.initDimRowDt(errorVal, key, ls);
                            RowData rowData = new RowData();
                            rowData.setRowNum(this.currentRow.getRowNum() + 1);
                            rowData.setColList((List)ls);
                            rowDataList.add(rowData);
                            continue;
                        }
                        key.setRowNum(Integer.valueOf(rowNum));
                        this.checkRpLine(rowDataList, errorVal, key, ls);
                        continue;
                    }
                    this.checkRpLine(rowDataList, errorVal, key, ls);
                }
            }
            JSONObject styleObj = new JSONObject();
            styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
            for (RowData rd : rowDataList) {
                for (ExcelCellInfo in : rd.getColList()) {
                    this.putDimSheet(sheet, in.getColIndex(), in.getValue(), rd.getRowNum(), in.isRed(), styleObj);
                }
            }
        }
    }

    private void initDimRowDt(String errorVal, DimAndDataRangeBaseModel key, List<ExcelCellInfo> ls) {
        ExcelCellInfo error = new ExcelCellInfo();
        error.setRowIndex(this.currentRow.getRowNum());
        error.setColIndex(-1);
        error.setValue(errorVal);
        error.setRed(true);
        ls.add(error);
        ExcelCellInfo roleNum = new ExcelCellInfo();
        roleNum.setRowIndex(this.currentRow.getRowNum());
        roleNum.setColIndex(0);
        roleNum.setValue(key.getRoleNumber());
        roleNum.setRed(true);
        ls.add(roleNum);
        ExcelCellInfo roleName = new ExcelCellInfo();
        roleName.setRowIndex(this.currentRow.getRowNum());
        roleName.setColIndex(1);
        roleName.setValue(key.getRoleName());
        roleName.setRed(true);
        ls.add(roleName);
        ExcelCellInfo buCaFuncName = new ExcelCellInfo();
        buCaFuncName.setRowIndex(this.currentRow.getRowNum());
        buCaFuncName.setColIndex(2);
        buCaFuncName.setValue(key.getBuCaFuncName());
        buCaFuncName.setRed(true);
        ls.add(buCaFuncName);
    }

    private void setRoleRange() {
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
    }

    public void handleSheetComments(Map<String, CommentsTable> comments) {
    }
}

