/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.service.perm.init.PermInitImportService;
import kd.hr.hrcs.bussiness.service.perm.init.PermTemplateFieldMap;
import kd.hr.hrcs.common.model.perminit.ExcelCellInfo;

@ExcludeFromJacocoGeneratedReport
public class PermImportSheetHandler
extends SheetHandler {
    private static final Log LOG = LogFactory.getLog(PermImportSheetHandler.class);
    private ImportContext importContext;
    private String url;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private Map<Integer, String> nameRow;
    private SheetHandler.ParsedRow currentRow;
    private int userRoleCount = 0;
    private int userDataRuleCount = 0;
    private int userBdRuleCount = 0;
    private int userFieldCount = 0;
    private Map<String, Integer> countMap;
    private Map<String, Long> dimMap;
    private List<Map<String, Object>> dealDims;
    private Set<String> sheetSet = Sets.newHashSetWithExpectedSize((int)4);
    private PermInitImportService permInitImportService = new PermInitImportService();
    private Table<String, Integer, List<ExcelCellInfo>> headerUserTb;
    private String errCellValue = ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PermImportSheetHandler_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    private ImportLogger importLogger;

    public PermImportSheetHandler(ImportContext importContext, String url, Map<String, Integer> countMap, Map<String, Long> dimMap, Table<String, Integer, List<ExcelCellInfo>> headerUserTb) {
        this.importContext = importContext;
        this.url = url;
        this.dataQueue = importContext.getDataQueue(url);
        this.importLogger = importContext.getLogger(url);
        this.countMap = countMap;
        this.dimMap = dimMap;
        this.permInitImportService.getOtDim(dimMap);
        this.headerUserTb = headerUserTb;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        this.currentRow = row;
        String sheetName = row.getSheetName();
        String sheetKey = PermTemplateFieldMap.getTemplateSheetName((String)sheetName);
        if (!this.permInitImportService.containsValue(this.permInitImportService.dealSheetName(sheetName))) {
            return;
        }
        if (row.getData().size() == 0) {
            return;
        }
        if (PermTemplateFieldMap.getTemplateName((String)"importUserR").contains(sheetName)) {
            this.initFSheetData(row, sheetKey);
        } else {
            this.initSheetData(row, sheetKey);
        }
        if (this.headerUserTb.size() == 0) {
            LinkedHashMap<Integer, String> sortMap = new LinkedHashMap<Integer, String>(16);
            row.getData().keySet().stream().sorted().forEach(it -> {
                String cfr_ignored_0 = (String)sortMap.put((Integer)it, (String)row.getData().get(it));
            });
            sortMap.forEach((key, value) -> {
                if (key == 0 && value.equals(this.errCellValue)) {
                    ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
                    this.headerUserTb.put((Object)sheetKey, (Object)row.getRowNum(), (Object)list);
                }
            });
        }
    }

    private void count(String sheetKey) {
        if ("importUserR".equals(sheetKey)) {
            ++this.userRoleCount;
        } else if ("importUserDr".equals(sheetKey)) {
            ++this.userDataRuleCount;
        } else if ("importUserBD".equals(sheetKey)) {
            ++this.userBdRuleCount;
        } else if ("importUserFp".equals(sheetKey)) {
            ++this.userFieldCount;
        }
    }

    private void initFSheetData(SheetHandler.ParsedRow row, String sheetKey) {
        int currRowNum = row.getRowNum();
        if (row.getRowNum() == 1) {
            this.nameRow = row.getData();
            this.dealDims = this.initDims(row.getData());
            this.importLogger.setRowIndex(currRowNum);
            this.importLogger.setLastRowIndex(this.getRowCount());
        }
        if (row.getRowNum() > 4) {
            this.count(sheetKey);
            this.addData(currRowNum);
        }
    }

    private List<Map<String, Object>> initDims(Map<Integer, String> data) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        data.forEach((key, value) -> {
            if (value.contains("#")) {
                String[] arr = value.split("#");
                String col = arr[0];
                if (this.dimMap.containsKey(col)) {
                    HashMap<String, Object> dim = new HashMap<String, Object>(2);
                    dim.put("code", col);
                    dim.put("id", this.dimMap.get(col));
                    dim.put("ot", "Y");
                    dim.put("type", this.dimMap.get(arr[1]));
                    dim.put("oldCode", value);
                    list.add(dim);
                }
            } else if (this.dimMap.containsKey(value)) {
                HashMap<String, Object> dim = new HashMap<String, Object>(2);
                dim.put("code", value);
                dim.put("id", this.dimMap.get(value));
                dim.put("ot", "N");
                list.add(dim);
            }
        });
        return list;
    }

    private void initSheetData(SheetHandler.ParsedRow row, String sheetKey) {
        int currRowNum = row.getRowNum();
        if (row.getRowNum() == 1) {
            this.nameRow = row.getData();
            this.importLogger.setRowIndex(0);
            this.importLogger.setLastRowIndex(this.getRowCount());
        }
        if (row.getRowNum() > 2) {
            this.count(sheetKey);
            this.addData(currRowNum);
        }
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 30L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"PermImportSheetHandler_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        catch (InterruptedException exp) {
            LOG.error("resolve thread error\u3002", (Throwable)exp);
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"PermImportSheetHandler_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    private JSONObject fieldMapping(Map<Integer, String> data) {
        JSONObject rowObj = new JSONObject();
        data.forEach((key, value) -> rowObj.put(this.nameRow.get(key), value));
        return rowObj;
    }

    private void addData(int currRowNum) {
        String sheetKey = PermTemplateFieldMap.getTemplateSheetName((String)this.getSheetName());
        JSONObject rowObj = new JSONObject();
        if (CollectionUtils.isNotEmpty(this.dealDims)) {
            rowObj.put("hasDim", (Object)"Y");
            rowObj.put("dim", this.dealDims);
        } else {
            rowObj.put("hasDim", (Object)"N");
        }
        rowObj.put("title", this.nameRow);
        rowObj.putAll((Map)this.fieldMapping(this.currentRow.getData()));
        rowObj.put("rowNum", (Object)currRowNum);
        rowObj.put("sheetKey", (Object)sheetKey);
        this.addBillData(new ImportBillData(rowObj, currRowNum, currRowNum, null));
    }

    public void endDocument() {
        boolean isContains = this.permInitImportService.containsValue(this.permInitImportService.dealSheetName(this.getSheetName()));
        if (this.currentRow != null && isContains) {
            this.sheetSet.add(this.getSheetName());
        }
        this.setInterrupt(false);
        if (this.sheetSet.size() == 4) {
            this.setInterrupt(true);
            this.countMap.put("importUserR", this.userRoleCount);
            this.countMap.put("importUserDr", this.userDataRuleCount);
            this.countMap.put("importUserBD", this.userBdRuleCount);
            this.countMap.put("importUserFp", this.userFieldCount);
            this.importContext.setResolveComplete(this.url);
            this.importContext.feedbackProgress(5, null, null);
        }
    }
}

