/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.MemberRoleSheet;
import kd.hr.hrcs.formplugin.web.perm.init.excel.PermHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleExcel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PermRoleSheetHelper {
    private static final Log LOGGER = LogFactory.getLog(PermRoleSheetHelper.class);

    public static RoleExcel getRole(Consumer<Triple<String, Long, Long>> feedbackProgress, String[] roleIds) {
        HRBaseServiceHelper roleServiceHelper = new HRBaseServiceHelper("hrcs_role");
        Map<String, DynamicObject> hmpRoleMap = Arrays.stream(roleServiceHelper.query("id,property,rolegrp,isintersection,usescope,createadmingrp", new QFilter[]{new QFilter("id", "in", (Object)roleIds)})).collect(Collectors.toMap(it -> it.getString("id"), it -> it, (oldValue, newValue) -> oldValue));
        DynamicObject[] sysRoles = PermRoleSheetHelper.getSysRole(roleIds);
        Map<String, List<Triple<String, String, String>>> roleScopeMap = PermRoleSheetHelper.getRoleScope(roleIds);
        List<RoleExcel.RoleSheet> roleSet = Arrays.stream(sysRoles).filter(sysRole -> hmpRoleMap.containsKey(sysRole.getString("id"))).map(sysRole -> {
            DynamicObject hmpRole = (DynamicObject)hmpRoleMap.get(sysRole.getString("id"));
            if (null == hmpRole) {
                return null;
            }
            String roleId = hmpRole.getString("id");
            List<Triple> roleScope = roleScopeMap.getOrDefault(roleId, Collections.emptyList());
            ArrayList viewScopeItems = new ArrayList(10);
            ArrayList editScopeItems = new ArrayList(10);
            roleScope.forEach(item -> {
                String scopeItem = String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011", (String)"PermRoleSheetHelper_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), item.getLeft(), item.getMiddle());
                if (HRStringUtils.equals((String)"1", (String)((String)item.getRight()))) {
                    editScopeItems.add(scopeItem);
                } else {
                    viewScopeItems.add(scopeItem);
                }
            });
            RoleExcel.RoleSheet roleSheet = new RoleExcel.RoleSheet();
            roleSheet.setRoleId(sysRole.getString("id"));
            roleSheet.setRoleNumber(sysRole.getString("number"));
            roleSheet.setRoleName(sysRole.getLocaleString("name"));
            roleSheet.setRoleRemark(sysRole.getLocaleString("remark"));
            roleSheet.setRoleGroupNumber(hmpRole.getString("rolegrp.number"));
            roleSheet.setRoleGroupName(hmpRole.getString("rolegrp.name"));
            roleSheet.setRoleProperty(hmpRole.getString("property"));
            roleSheet.setRoleCBisIntersection(hmpRole.getString("isintersection"));
            roleSheet.setUseScope(hmpRole.getString("usescope"));
            roleSheet.setCreateAdminGrpNumber(hmpRole.getString("createadmingrp.number"));
            roleSheet.setCreateAdminGrpName(hmpRole.getString("createadmingrp.name"));
            roleSheet.setOpenRangeWithView(StringUtils.join(viewScopeItems, (String)";\n"));
            roleSheet.setOpenRangeWithEdit(StringUtils.join(editScopeItems, (String)";\n"));
            return roleSheet;
        }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LOGGER.info("Complete role sheet.");
        Set<RoleExcel.FunctionItemSheet> functionItemSet = PermRoleSheetHelper.getRolePerm(roleIds);
        LOGGER.info("Complete role perm sheet.");
        RoleExcel.DimSheet dim = PermRoleSheetHelper.getRoleDim(roleIds);
        LOGGER.info("Complete role dim sheet.");
        Set<RoleExcel.DataRangeSheet> dataRangeSet = PermRoleSheetHelper.getRoleDataRange(feedbackProgress, roleIds);
        LOGGER.info("Complete role data range sheet.");
        Set<RoleExcel.FieldPermSheet> fieldPermSet = PermRoleSheetHelper.getRoleFieldPerm(feedbackProgress, roleIds);
        LOGGER.info("Complete role field perm sheet.");
        RoleExcel roleExcel = new RoleExcel();
        roleExcel.setRoleSet(roleSet);
        roleExcel.setFunctionItemSet(functionItemSet);
        roleExcel.setDim(dim);
        roleExcel.setDataRangeSet(dataRangeSet);
        roleExcel.setFieldPermSet(fieldPermSet);
        return roleExcel;
    }

    private static DynamicObject[] getSysRole(String[] roleIds) {
        HRBaseServiceHelper sysRoleServiceHelper = new HRBaseServiceHelper("perm_role");
        return sysRoleServiceHelper.query("id,number,name,remark,modifytime", new QFilter[]{new QFilter("id", "in", (Object)roleIds)}, "modifytime desc");
    }

    private static Map<String, List<Triple<String, String, String>>> getRoleScope(String[] roleIds) {
        HRBaseServiceHelper roleAssignScopeServiceHelper = new HRBaseServiceHelper("hrcs_roleassignscope");
        HRBaseServiceHelper roleOpenScopeServiceHelper = new HRBaseServiceHelper("hrcs_roleopenscope");
        DynamicObject[] assignItems = roleAssignScopeServiceHelper.query("roleid,admingroup,ismodifiable", new QFilter[]{new QFilter("roleid.id", "in", (Object)roleIds)});
        DynamicObject[] openItems = roleOpenScopeServiceHelper.query("roleid,admingroup", new QFilter[]{new QFilter("roleid.id", "in", (Object)roleIds)});
        HashMap<String, List<Triple<String, String, String>>> map = new HashMap<String, List<Triple<String, String, String>>>(16);
        Arrays.stream(assignItems).forEach(item -> map.computeIfAbsent(item.getString("roleid.id"), key -> new ArrayList(10)).add(Triple.of((Object)item.getString("admingroup.number"), (Object)item.getString("admingroup.name"), (Object)(item.getBoolean("ismodifiable") ? "1" : "0"))));
        Arrays.stream(openItems).forEach(item -> map.computeIfAbsent(item.getString("roleid.id"), key -> new ArrayList(10)).add(Triple.of((Object)item.getString("admingroup.number"), (Object)item.getString("admingroup.name"), (Object)"1")));
        return map;
    }

    private static Set<RoleExcel.FunctionItemSheet> getRolePerm(String[] roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_roleperm");
        DynamicObject[] rolePerms = serviceHelper.query("roleid.id,roleid.number,roleid.name,roleperm.entity,roleperm.permitem,roleperm.bizapp", new QFilter[]{new QFilter("roleid.id", "in", (Object)roleIds)});
        HashMap roleBuCaMap = new HashMap(16);
        Map<String, List> entityMap = Arrays.stream(rolePerms).flatMap(rolePerm -> rolePerm.getDynamicObjectCollection("roleperm").stream()).collect(Collectors.toMap(it -> it.getString("bizapp.id"), it -> Lists.newArrayList((Object[])new String[]{it.getString("entity.number")}), (oldValue, newValue) -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)oldValue, (Iterable)newValue))));
        HRBuCaServiceHelper.getBuCaFuncFromSpec(entityMap).entrySet().forEach(entry -> ((Map)entry.getValue()).entrySet().forEach(item -> roleBuCaMap.put((String)entry.getKey() + "#" + (String)item.getKey(), ((DynamicObject)item.getValue()).getString("name"))));
        Set entities = entityMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        HRBaseServiceHelper dimServiceHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        Map<String, List> dimMap = Arrays.stream(dimServiceHelper.query("entitytype.id,entryentity.dimension,entryentity.ismust", new QFilter[]{new QFilter("entitytype.id", "in", entities)})).collect(Collectors.toMap(it -> it.getString("entitytype.id"), it -> it.getDynamicObjectCollection("entryentity").stream().map(entry -> Pair.of((Object)entry.getBoolean("ismust"), (Object)entry.getString("dimension.name"))).collect(Collectors.toList()), (oldValue, newValue) -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)oldValue, (Iterable)newValue))));
        Set<String> appIds = entityMap.keySet();
        HRBaseServiceHelper appServiceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        Map<String, Pair> appMap = Arrays.stream(appServiceHelper.query("id,bizcloud", new QFilter[]{new QFilter("id", "in", appIds)})).collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("bizcloud.number"), (Object)it.getString("bizcloud.name")), (oldValue, newValue) -> oldValue));
        HRBaseServiceHelper permRelateServiceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        Set permRelateSet = Arrays.stream(permRelateServiceHelper.query("entryentity.entitytypeid,entryentity.app,entryentity.permitemid", new QFilter[0])).flatMap(it -> it.getDynamicObjectCollection("entryentity").stream()).flatMap(it -> Arrays.stream(it.getString("permitemid").split(",")).map(permItem -> it.getString("app.number") + "#" + it.getString("entitytypeid.number") + "#" + permItem)).collect(Collectors.toSet());
        HRBaseServiceHelper permRelateConfigServiceHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        Set permRelateConfigSet = Arrays.stream(permRelateConfigServiceHelper.query("app.number,entitytype.number,permitem.number", new QFilter[]{new QFilter("isassign", "=", (Object)"1")})).map(it -> it.getString("app.number") + "#" + it.getString("entitytype.number") + "#" + it.getString("permitem.number")).collect(Collectors.toSet());
        HashMap<String, RoleExcel.FunctionItemSheet> result = new HashMap<String, RoleExcel.FunctionItemSheet>();
        for (DynamicObject rolePerm2 : rolePerms) {
            for (DynamicObject entry2 : rolePerm2.getDynamicObjectCollection("roleperm")) {
                Pair appItem = appMap.getOrDefault(entry2.getString("bizapp.id"), Pair.of((Object)"", (Object)""));
                List dims = dimMap.getOrDefault(entry2.getString("entity.number"), Collections.emptyList()).stream().distinct().collect(Collectors.toList());
                String permRelateKey = entry2.getString("bizapp.number") + "#" + entry2.getString("entity.number") + "#" + entry2.getString("permitem.number");
                if (permRelateSet.contains(permRelateKey) && !permRelateConfigSet.contains(permRelateKey) || HRStringUtils.isEmpty((String)entry2.getString("permitem.name"))) continue;
                RoleExcel.FunctionItemSheet functionItem = new RoleExcel.FunctionItemSheet();
                functionItem.setId(entry2.getString("permitem.id"));
                functionItem.setName(Optional.ofNullable(entry2.getString("permitem.name")).orElse(""));
                functionItem.setAppNumber(Optional.ofNullable(entry2.getString("bizapp.number")).orElse(""));
                functionItem.setAppName(Optional.ofNullable(entry2.getString("bizapp.name")).orElse(""));
                functionItem.setCloudNumber((String)Optional.ofNullable(appItem.getKey()).orElse(""));
                functionItem.setCloudName((String)Optional.ofNullable(appItem.getValue()).orElse(""));
                functionItem.setEntityNumber(Optional.ofNullable(entry2.getString("entity.number")).orElse(""));
                functionItem.setEntityName(Optional.ofNullable(entry2.getString("entity.name")).orElse(""));
                functionItem.setBuCaFuncName(roleBuCaMap.getOrDefault(entry2.getString("bizapp.id") + "#" + entry2.getString("entity.number"), ""));
                functionItem.setRoleSet(Sets.newHashSet((Object[])new Pair[]{Pair.of((Object)rolePerm2.getString("roleid.number"), (Object)rolePerm2.getString("roleid.name"))}));
                ArrayList<String> must = new ArrayList<String>();
                ArrayList<Object> common = new ArrayList<Object>();
                for (Pair dim : dims) {
                    if (((Boolean)dim.getKey()).booleanValue()) {
                        must.add((String)dim.getValue());
                        continue;
                    }
                    common.add(dim.getValue());
                }
                ArrayList allDimNames = Lists.newArrayList((Iterable)Iterables.concat(must, common));
                functionItem.setDimName(String.join((CharSequence)";", allDimNames));
                functionItem.setRedDimName(must);
                String key = functionItem.getCloudNumber() + "#" + functionItem.getAppNumber() + "#" + functionItem.getEntityNumber() + "#" + functionItem.getId();
                RoleExcel.FunctionItemSheet tempFunctionItem = (RoleExcel.FunctionItemSheet)result.get(key);
                if (null != tempFunctionItem) {
                    tempFunctionItem.getRoleSet().addAll(functionItem.getRoleSet());
                    continue;
                }
                result.put(key, functionItem);
            }
        }
        return new HashSet<RoleExcel.FunctionItemSheet>(result.values());
    }

    private static RoleExcel.DimSheet getRoleDim(String[] roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimension");
        HRBaseServiceHelper funcServiceHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObject[] roleDimensions = serviceHelper.query("role,dimension,bucafunc", new QFilter[]{new QFilter("role.id", "in", (Object)roleIds)});
        Set funcIds = Arrays.stream(roleDimensions).map(it -> it.getLong("bucafunc.id")).collect(Collectors.toSet());
        Map<String, String> funcMap = Arrays.stream(funcServiceHelper.query("id,name", new QFilter[]{new QFilter("id", "in", funcIds)})).collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("name"), (oldValue, newValue) -> oldValue));
        List<Pair<Pair<String, String>, Triple<String, String, String>>> list = Arrays.stream(roleDimensions).map(roleDimension -> Pair.of((Object)Pair.of((Object)roleDimension.getString("dimension.number"), (Object)roleDimension.getString("dimension.name")), (Object)Triple.of((Object)roleDimension.getString("role.number"), (Object)roleDimension.getString("role.name"), (Object)funcMap.getOrDefault(roleDimension.getString("bucafunc.id"), "-")))).sorted(Comparator.comparing(it -> (String)((Triple)it.getValue()).getLeft() + (String)((Triple)it.getValue()).getRight())).collect(Collectors.toList());
        RoleExcel.DimSheet dim = new RoleExcel.DimSheet();
        dim.setList(list);
        return dim;
    }

    private static Set<RoleExcel.FieldPermSheet> getRoleFieldPerm(Consumer<Triple<String, Long, Long>> feedbackProgress, String[] roleIds) {
        feedbackProgress.accept((Triple<String, Long, Long>)Triple.of((Object)ResManager.loadKDString((String)"\u89e3\u6790\u4e2d", (String)"PermSheetHelper_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)90L));
        HRBaseServiceHelper roleFieldHelper = new HRBaseServiceHelper("hrcs_rolefield");
        DynamicObject[] items = roleFieldHelper.query("id,app,entitytype,role,fieldpermentry.fieldname,fieldpermentry.isbanread,fieldpermentry.isbanwrite", new QFilter[]{new QFilter("role.id", "in", (Object)roleIds)});
        HRBaseServiceHelper sysRoleServiceHelper = new HRBaseServiceHelper("perm_role");
        Map<String, Pair> sysRoleMap = Arrays.stream(sysRoleServiceHelper.query("id,number,name", new QFilter[]{new QFilter("id", "in", (Object)roleIds)})).collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("number"), (Object)it.getString("name")), (oldValue, newValue) -> oldValue));
        Set appIds = Arrays.stream(items).map(it -> it.getString("app")).collect(Collectors.toSet());
        HRBaseServiceHelper appServiceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        Map<String, Pair> appMap = Arrays.stream(appServiceHelper.query("number,name", new QFilter[]{new QFilter("id", "in", appIds)})).collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("number"), (Object)it.getString("name")), (oldValue, newValue) -> oldValue));
        Map<String, Map> fieldPermMap = Arrays.stream(items).collect(Collectors.toMap(it -> it.getString("role.number") + "#" + it.getString("app") + "#" + it.getString("entitytype.number"), it -> RoleServiceHelper.getEntityFieldMap((String)it.getString("entitytype.number")), (oldValue, newValue) -> {
            HashMap map = new HashMap(oldValue);
            map.putAll(newValue);
            return map;
        }));
        return Arrays.stream(items).flatMap(item -> {
            Pair appItem = appMap.getOrDefault(item.getString("app"), Pair.of((Object)"", (Object)""));
            Map filedPermItem = fieldPermMap.getOrDefault(item.getString("role.number") + "#" + item.getString("app") + "#" + item.getString("entitytype.number"), new HashMap());
            return item.getDynamicObjectCollection("fieldpermentry").stream().map(it -> {
                Pair sysRole = sysRoleMap.getOrDefault(item.getString("role.id"), Pair.of((Object)"", (Object)""));
                RoleExcel.FieldPermSheet permSheet = new RoleExcel.FieldPermSheet();
                permSheet.setRoleNumber((String)sysRole.getKey());
                permSheet.setRoleName((String)sysRole.getValue());
                permSheet.setAppNumber((String)appItem.getKey());
                permSheet.setAppName((String)appItem.getValue());
                permSheet.setEntityNumber(item.getString("entitytype.number"));
                permSheet.setEntityName(item.getString("entitytype.name"));
                permSheet.setFieldNumber(it.getString("fieldname"));
                permSheet.setFieldName(filedPermItem.getOrDefault(it.getString("fieldname"), ""));
                permSheet.setNoView(it.getBoolean("isbanread"));
                permSheet.setNoEdit(it.getBoolean("isbanwrite"));
                return permSheet;
            });
        }).collect(Collectors.toSet());
    }

    private static Set<RoleExcel.DataRangeSheet> getRoleDataRange(Consumer<Triple<String, Long, Long>> feedbackProgress, String[] roleIds) {
        ArrayList<MemberRoleSheet> memberRoleSheetList = new ArrayList<MemberRoleSheet>(10);
        HRBaseServiceHelper hrHelper = new HRBaseServiceHelper("hrcs_role");
        DataSet hrRole = hrHelper.queryDataSet("kd.hr.hrcs.formplugin.web.perm.init.excel.PermSheetHelper.getTemplateExcelWriter.hrcs_role", "id,property", new QFilter[]{new QFilter("id", "in", (Object)roleIds)});
        HRBaseServiceHelper sysHelper = new HRBaseServiceHelper("perm_role");
        DataSet sysRole = sysHelper.queryDataSet("kd.hr.hrcs.formplugin.web.perm.init.excel.PermSheetHelper.getTemplateExcelWriter.perm_role", "id,name,number,enable");
        DataSet result = hrRole.leftJoin(sysRole).on("id", "id").select(new String[]{"id", "property", "number", "name", "enable"}).finish().where("enable = '1'").orderBy(new String[]{"number"});
        while (result.hasNext()) {
            Row row = result.next();
            MemberRoleSheet memberRoleSheet = new MemberRoleSheet();
            memberRoleSheet.setRoleId(row.getString("id"));
            memberRoleSheet.setRoleNumber(row.getString("number"));
            memberRoleSheet.setRoleName(row.getString("name"));
            memberRoleSheet.setRoleProperty(row.getString("property"));
            memberRoleSheetList.add(memberRoleSheet);
        }
        feedbackProgress.accept((Triple<String, Long, Long>)Triple.of((Object)ResManager.loadKDString((String)"\u89e3\u6790\u4e2d", (String)"PermSheetHelper_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), (Object)100L, (Object)20L));
        return PermHelper.getRole(feedbackProgress, memberRoleSheetList, true, false).stream().map(it -> {
            RoleExcel.DataRangeSheet dataRange = new RoleExcel.DataRangeSheet();
            dataRange.setRoleId(it.getRoleNumber());
            dataRange.setRoleNumber(it.getRoleNumber());
            dataRange.setRoleName(it.getRoleName());
            dataRange.setFuns(it.getFuns());
            return dataRange;
        }).collect(Collectors.toSet());
    }
}

