/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.formplugin.web.perm.init.excel.AbstractWriter;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleTemplateExcelWriter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class RoleDemoExcelWriter
extends AbstractWriter {
    private static final Log LOGGER = LogFactory.getLog(RoleDemoExcelWriter.class);
    private static final int COL_WIDTH_NUM = 192;
    public static final String DROP_DOWN_SHEET_PREX = "DDM_";
    private static final String[] SOURCES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int SCENE1 = 10000;
    private static final int SCENE2 = 20000;
    private static final int SCENE3 = 30000;
    private static final int SCENE4 = 40000;
    private static final int SCENE5 = 50000;
    private ExportSheetStyle styles;
    private final Font originalFont;

    public RoleDemoExcelWriter() {
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
        this.styles = new ExportSheetStyle(this.wb, null);
        this.originalFont = this.wb.createFont();
        this.originalFont.setFontHeightInPoints((short)12);
        XSSFCellStyle tipsCellStyle = (XSSFCellStyle)this.styles.getTitleStyle();
        XSSFFont tipsFont = tipsCellStyle.getFont();
        tipsFont.setBold(true);
        tipsFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header");
        headerCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderRight(BorderStyle.THIN);
        headerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerCellFont = headerCellStyle.getFont();
        headerCellFont.setBold(true);
        headerCellFont.setFontHeightInPoints((short)12);
        XSSFCellStyle headerMustInputCellStyle = (XSSFCellStyle)this.styles.getTitleMustInputStyle();
        headerMustInputCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerMustInputCellStyle.setBorderTop(BorderStyle.THIN);
        headerMustInputCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderRight(BorderStyle.THIN);
        headerMustInputCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderBottom(BorderStyle.THIN);
        headerMustInputCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerMustInputCellStyle.setBorderLeft(BorderStyle.THIN);
        headerMustInputCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        XSSFFont headerMustInputFont = headerMustInputCellStyle.getFont();
        headerMustInputFont.setBold(true);
        headerMustInputFont.setFontHeightInPoints((short)12);
        headerMustInputFont.setColor(IndexedColors.RED.getIndex());
        XSSFCellStyle headerCenterCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header-center");
        headerCenterCellStyle.setFillForegroundColor(new XSSFColor(new Color(197, 217, 241), null));
        headerCenterCellStyle.setBorderTop(BorderStyle.THIN);
        headerCenterCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderRight(BorderStyle.THIN);
        headerCenterCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderBottom(BorderStyle.THIN);
        headerCenterCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setBorderLeft(BorderStyle.THIN);
        headerCenterCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        headerCenterCellStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont headerCenterCellFont = headerCenterCellStyle.getFont();
        headerCenterCellFont.setBold(true);
        headerCenterCellFont.setFontHeightInPoints((short)12);
        XSSFCellStyle commonColumnCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("body-common-column");
        commonColumnCellStyle.setFillForegroundColor(new XSSFColor(new Color(253, 233, 217), null));
        commonColumnCellStyle.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonColumnCellStyle.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonColumnCellStyle.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonColumnCellStyle.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonColumnCellStyle.setBorderTop(BorderStyle.THIN);
        commonColumnCellStyle.setBorderRight(BorderStyle.THIN);
        commonColumnCellStyle.setBorderBottom(BorderStyle.THIN);
        commonColumnCellStyle.setBorderLeft(BorderStyle.THIN);
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        commonCellStyle1.setFont(this.originalFont);
        commonCellStyle1.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle1.setBorderTop(BorderStyle.THIN);
        commonCellStyle1.setBorderRight(BorderStyle.THIN);
        commonCellStyle1.setBorderBottom(BorderStyle.THIN);
        commonCellStyle1.setBorderLeft(BorderStyle.THIN);
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        commonCellStyle3.setTopBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle3.setRightBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle3.setBottomBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle3.setLeftBorderColor(IndexedColors.GREY_25_PERCENT.getIndex());
        commonCellStyle3.setBorderTop(BorderStyle.THIN);
        commonCellStyle3.setBorderRight(BorderStyle.THIN);
        commonCellStyle3.setBorderBottom(BorderStyle.THIN);
        commonCellStyle3.setBorderLeft(BorderStyle.THIN);
        Font font = this.wb.createFont();
        font.setColor(IndexedColors.RED.getIndex());
        commonCellStyle3.setFont(font);
    }

    @Override
    public Font getOriginalFont() {
        return this.originalFont;
    }

    private void setWhiteTopBorder(SXSSFSheet sheet, int rowIndex, int colIndex) {
        SXSSFCell cell = RoleDemoExcelWriter.getRow((SXSSFSheet)sheet, (int)rowIndex).getCell(colIndex);
        CellStyle cellStyle = this.wb.createCellStyle();
        cellStyle.cloneStyleFrom(cell.getCellStyle());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        cell.setCellStyle(cellStyle);
    }

    public void addRoleListSheet(String sheetName) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        String dropdownSheetName = DROP_DOWN_SHEET_PREX + sheetName;
        SXSSFSheet dropdownSheet = this.wb.createSheet(dropdownSheetName);
        sheet.setZoom(75);
        Map<String, Integer> colIndexMap = this.addRoleListHeader(sheet);
        this.setDropDown(sheet, dropdownSheet, colIndexMap);
        this.addRoleListBody(sheet, colIndexMap);
        int dropdownItemsSheetIndex = this.wb.getSheetIndex(dropdownSheetName);
        if (dropdownItemsSheetIndex >= 0) {
            this.wb.setSheetHidden(dropdownItemsSheetIndex, true);
        }
    }

    private void setDropDown(SXSSFSheet sheet, SXSSFSheet dropdownSheet, Map<String, Integer> colIndexMap) {
        ArrayList rolePropValuesList = Lists.newArrayListWithExpectedSize((int)2);
        rolePropValuesList.add(ResManager.loadKDString((String)"\u5141\u8bb8\u81ea\u5b9a\u4e49", (String)"RoleDemoExcelWriter_34", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        rolePropValuesList.add(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49", (String)"RoleDemoExcelWriter_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.createDropDownSheet(sheet, dropdownSheet, rolePropValuesList, colIndexMap.get("roleProperty"));
        ArrayList cbisValuesList = Lists.newArrayListWithExpectedSize((int)4);
        cbisValuesList.add(ResManager.loadKDString((String)"\u53d7\u89d2\u8272\u8303\u56f4\u5f71\u54cd", (String)"RoleDemoExcelWriter_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        cbisValuesList.add(ResManager.loadKDString((String)"\u4e0d\u53d7\u89d2\u8272\u8303\u56f4\u5f71\u54cd", (String)"RoleDemoExcelWriter_37", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        cbisValuesList.add(ResManager.loadKDString((String)"\u4ec5\u53d7\u89d2\u8272\u6570\u636e\u8303\u56f4\u5f71\u54cd", (String)"RoleDemoExcelWriter_38", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        cbisValuesList.add(ResManager.loadKDString((String)"\u4ec5\u53d7\u89d2\u8272\u5b57\u6bb5\u6743\u9650\u5f71\u54cd", (String)"RoleDemoExcelWriter_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.createDropDownSheet(sheet, dropdownSheet, cbisValuesList, colIndexMap.get("roleCBisIntersection"));
        ArrayList useScopeValuesList = Lists.newArrayListWithExpectedSize((int)2);
        useScopeValuesList.add(ResManager.loadKDString((String)"\u516c\u5f00", (String)"RoleDemoExcelWriter_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        useScopeValuesList.add(ResManager.loadKDString((String)"\u79c1\u6709", (String)"RoleDemoExcelWriter_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        useScopeValuesList.add(ResManager.loadKDString((String)"\u5206\u914d", (String)"RoleDemoExcelWriter_42", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.createDropDownSheet(sheet, dropdownSheet, useScopeValuesList, colIndexMap.get("useScope"));
    }

    private void createDropDownSheet(SXSSFSheet sheet, SXSSFSheet dropdownSheet, List<String> inputValuesList, int offSet) {
        if (CollectionUtils.isEmpty(inputValuesList)) {
            return;
        }
        for (int k = 0; k < inputValuesList.size(); ++k) {
            RoleDemoExcelWriter.getRow((SXSSFSheet)dropdownSheet, (int)k).createCell(offSet).setCellValue(inputValuesList.get(k));
        }
        String formatString = dropdownSheet.getSheetName() + "!$%s$%d:$%s$%d";
        String currColLabel = RoleDemoExcelWriter.getColumnLabel(offSet + 1);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(1, 10000, offSet, offSet);
        String strFormula = String.format(formatString, currColLabel, 1, currColLabel, inputValuesList.size());
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    private Map<String, Integer> addRoleListHeader(SXSSFSheet sheet) {
        int i;
        HashMap<String, Integer> colIndexMap = new HashMap<String, Integer>(16);
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u4e0d\u5141\u8bb8\u8c03\u6574\u89d2\u8272\u63a7\u6743\u7ef4\u5ea6\u7684\u987a\u5e8f\uff1b4\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        int roleNumberIndex = i = 2;
        this.addCellRegion((Sheet)sheet, 1, roleNumberIndex).setCellValue("roleNumber");
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        Lang lang = RequestContext.get().getLang();
        enabledLangList.sort((x1, x2) -> {
            if (lang.name().equals(x2.getNumber())) {
                return 1;
            }
            if (lang.name().equals(x1.getNumber())) {
                return -1;
            }
            return 0;
        });
        for (EnabledLang enabledLang : enabledLangList) {
            int roleNameIndex = ++i;
            this.addCellRegion((Sheet)sheet, 1, roleNameIndex).setCellValue("roleName_" + enabledLang.getNumber());
            colIndexMap.put("roleName_" + enabledLang.getNumber(), roleNameIndex);
        }
        ++i;
        int roleGroupNumberIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, roleGroupNumberIndex).setCellValue("roleGroupNumber");
        int roleGroupNameIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, roleGroupNameIndex).setCellValue("roleGroupName");
        int rolePropertyIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, rolePropertyIndex).setCellValue("roleProperty");
        int roleCBisIntersectionIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, roleCBisIntersectionIndex).setCellValue("roleCBisIntersection");
        int useScopeIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, useScopeIndex).setCellValue("useScope");
        int createAdminGrpNumberIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, createAdminGrpNumberIndex).setCellValue("createAdminGrpNumber");
        int createAdminGrpNameIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, createAdminGrpNameIndex).setCellValue("createAdminGrpName");
        int openRangeWithViewIndex = i++;
        this.addCellRegion((Sheet)sheet, 1, openRangeWithViewIndex).setCellValue("openRangeWithView");
        int openRangeWithEditIndex = i;
        this.addCellRegion((Sheet)sheet, 1, openRangeWithEditIndex).setCellValue("openRangeWithEdit");
        colIndexMap.put("roleNumber", roleNumberIndex);
        colIndexMap.put("roleGroupNumber", roleGroupNumberIndex);
        colIndexMap.put("roleGroupName", roleGroupNameIndex);
        colIndexMap.put("roleProperty", rolePropertyIndex);
        colIndexMap.put("roleCBisIntersection", roleCBisIntersectionIndex);
        colIndexMap.put("useScope", useScopeIndex);
        colIndexMap.put("createAdminGrpNumber", createAdminGrpNumberIndex);
        colIndexMap.put("createAdminGrpName", createAdminGrpNameIndex);
        colIndexMap.put("openRangeWithView", openRangeWithViewIndex);
        colIndexMap.put("openRangeWithEdit", openRangeWithEditIndex);
        for (EnabledLang enabledLang : enabledLangList) {
            int roleRemarkIndex = ++i;
            this.addCellRegion((Sheet)sheet, 1, roleRemarkIndex).setCellValue("roleRemark_" + enabledLang.getNumber());
            colIndexMap.put("roleRemark_" + enabledLang.getNumber(), roleRemarkIndex);
        }
        sheet.getRow(1).setHidden(Boolean.valueOf(true));
        LOGGER.info("Begin  addRoleHeader3.");
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        mustCellStyle.setWrapText(true);
        cellStyle.setWrapText(true);
        centerCellStyle.setWrapText(true);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 0, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 1, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        String content = ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"RoleTemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"RoleTemplateExcelWriter_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, 2, 2, mustCellStyle, content, tip);
        tip = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"RoleTemplateExcelWriter_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        int j = 3;
        for (EnabledLang enabledLang : enabledLangList) {
            CellStyle style;
            if (lang.name().equals(enabledLang.getNumber())) {
                content = String.format(ResManager.loadKDString((String)"%1$s\u89d2\u8272\u540d\u79f0\uff08%2$s\uff09", (String)"RoleTemplateExcelWriter_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), "*", enabledLang.getName());
                style = mustCellStyle;
            } else {
                content = String.format(ResManager.loadKDString((String)"%1$s\u89d2\u8272\u540d\u79f0\uff08%2$s\uff09", (String)"RoleTemplateExcelWriter_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), "", enabledLang.getName());
                style = cellStyle;
            }
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, j, j, style, content, tip);
            ++j;
        }
        content = ResManager.loadKDString((String)"\u89d2\u8272\u7ec4\u7f16\u7801", (String)"RoleTemplateExcelWriter_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, j, j, cellStyle, content);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u7ec4\u540d\u79f0", (String)"RoleTemplateExcelWriter_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content);
        content = ResManager.loadKDString((String)"*\u89d2\u8272\u6210\u5458\u8303\u56f4\u5c5e\u6027", (String)"RoleTemplateExcelWriter_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u662f\u5426\u5141\u8bb8\u89d2\u8272\u4e0b\u7528\u6237\u81ea\u5b9a\u4e49\u8303\u56f4\u3002\n\u5f55\u5165\u503c\uff1a\u5141\u8bb8\u81ea\u5b9a\u4e49\u8303\u56f4\u3001\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u3002", (String)"RoleTemplateExcelWriter_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, mustCellStyle, content, tip);
        content = ResManager.loadKDString((String)"*\u81ea\u5b9a\u4e49\u8303\u56f4\u662f\u5426\u53d7\u9650\u4e8e\u89d2\u8272\u8303\u56f4", (String)"RoleTemplateExcelWriter_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u5982\u679c\u5141\u8bb8\u6210\u5458\u81ea\u5b9a\u4e49\u6570\u636e\u8303\u56f4\uff0c\u9700\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u7684\u8303\u56f4\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u89d2\u8272\u9650\u5b9a\u7684\u8303\u56f4\n\u5f55\u5165\u503c\uff1a\n\u53d7\u89d2\u8272\u8303\u56f4\u5f71\u54cd\n\u4e0d\u53d7\u89d2\u8272\u8303\u56f4\u5f71\u54cd\n\u4ec5\u53d7\u89d2\u8272\u6570\u636e\u8303\u56f4\u5f71\u54cd\n\u4ec5\u53d7\u89d2\u8272\u5b57\u6bb5\u6743\u9650\u5f71\u54cd", (String)"RoleTemplateExcelWriter_16", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, mustCellStyle, content, tip);
        content = ResManager.loadKDString((String)"*\u516c\u5f00\u72b6\u6001", (String)"RoleTemplateExcelWriter_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u72b6\u6001\u503c\uff1a\u516c\u5f00\u3001\u79c1\u6709\u3001\u5206\u914d\n\u5206\u914d\u548c\u79c1\u6709\u72b6\u6001\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u3002", (String)"RoleTemplateExcelWriter_17", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, mustCellStyle, content, tip);
        content = ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u7f16\u7801", (String)"RoleTemplateExcelWriter_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u79c1\u6709\u3001\u5206\u914d\u72b6\u6001\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u6240\u5c5e\u7ba1\u7406\u5458", (String)"RoleTemplateExcelWriter_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content, tip);
        content = ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u540d\u79f0", (String)"RoleTemplateExcelWriter_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u67e5\u770b\uff09", (String)"RoleTemplateExcelWriter_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u516c\u5f00\u3001\u79c1\u6709\u72b6\u6001\u65e0\u9700\u8bbe\u7f6e\uff1b\n\u5206\u914d\u72b6\u6001\u4e0b\uff0c\u53ef\u6dfb\u52a0\u7ba1\u7406\u5458\u7ec4\u3002", (String)"RoleTemplateExcelWriter_60", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content, tip);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u7f16\u8f91\uff09", (String)"RoleTemplateExcelWriter_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u516c\u5f00\u3001\u5206\u914d\u72b6\u6001\uff0c\u53ef\u6dfb\u52a0\u7ba1\u7406\u5458\u5206\u7ec4\u3002", (String)"RoleTemplateExcelWriter_61", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, ++j, j, cellStyle, content, tip);
        ++j;
        for (EnabledLang enabledLang : enabledLangList) {
            content = ResManager.loadKDString((String)"\u89d2\u8272\u63cf\u8ff0\uff08%s\uff09", (String)"RoleTemplateExcelWriter_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{enabledLang.getName()});
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 4, j, j, cellStyle, content);
            ++j;
        }
        LOGGER.info("End  addRoleHeader.");
        return colIndexMap;
    }

    private void addRoleListBody(SXSSFSheet sheet, Map<String, Integer> colIndexMap) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)this.styles.getTitleStyle("body-common-column");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleinitdemo_role");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,rolenumber,rolename,rolegroupnumber,rolegroupname,roleproperty,rolecbisintersection,admingroupnumber,admingroupname,usescope,publicscopeview,publicscopeedit,roleremark", new QFilter[0], "sceneid,index");
        this.scene(sheet, items, colIndexMap);
    }

    private void addMemberRoleSheetBody(SXSSFSheet sheet) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)this.styles.getTitleStyle("body-common-column");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitdemo_userdim");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,usernumber,usernumbertip,username,usernametip,fileorgnumber,fileorgnumbertip,fileorgname,fileorgnametip,rolenumber,rolenumbertip,rolename,rolenametip,validstart,validstarttip,validend,validendtip,customenable,customenabletip,bucafunc,bucafunctip,orgrange,orgrangetip,dim_adminorg,dim_adminorgtip,dim_projectteam,dim_projectteamtip,dim_salarygroup,dim_salarygrouptip,dim_countryarea,dim_countryareatip", new QFilter[0], "sceneid,index");
        this.addMergedRegionWithGrayBorder((Sheet)sheet, 10, 10, 0, 16).setCellStyle((CellStyle)cellStyle);
        sheet.getRow(10).setHeight((short)200);
        this.scene2(sheet, items);
        this.addMergedRegionWithGrayBorder((Sheet)sheet, 12, 12, 0, 16).setCellStyle((CellStyle)cellStyle);
        sheet.getRow(12).setHeight((short)200);
        this.scene3(sheet, items);
        this.addMergedRegionWithGrayBorder((Sheet)sheet, 14, 14, 0, 16).setCellStyle((CellStyle)cellStyle);
        sheet.getRow(14).setHeight((short)200);
        this.scene4(sheet, items);
        this.addMergedRegionWithGrayBorder((Sheet)sheet, 17, 17, 0, 16).setCellStyle((CellStyle)cellStyle);
        sheet.getRow(17).setHeight((short)200);
        this.scene5(sheet, items);
    }

    private void scene(SXSSFSheet sheet, DynamicObject[] items, Map<String, Integer> colIndexMap) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        XSSFCellStyle commonCellStyle2 = (XSSFCellStyle)this.styles.getTextStyle("body-common2");
        int rowIndex = 5;
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hrcs_roleinitdemo_role");
        for (DynamicObject item : items) {
            sheet.createRow(rowIndex).setRowStyle(commonCellStyle1);
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle1, item.getString("scenedesc"));
            for (EnabledLang enabledLang : enabledLangList) {
                String number = enabledLang.getNumber();
                this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleName_" + number), commonCellStyle1, ((OrmLocaleValue)item.get("rolename")).get((Object)number));
                this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleRemark_" + number), commonCellStyle1, ((OrmLocaleValue)item.get("roleremark")).get((Object)number));
            }
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleNumber"), commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleGroupNumber"), commonCellStyle1, item.getString("rolegroupnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleGroupName"), commonCellStyle1, item.getString("rolegroupname"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleProperty"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("roleproperty")).getItemByName(item.getString("roleproperty")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("roleCBisIntersection"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("rolecbisintersection")).getItemByName(item.getString("rolecbisintersection")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("useScope"), commonCellStyle1, ((ComboProp)mainType.getAllFields().get("usescope")).getItemByName(item.getString("usescope")));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("createAdminGrpNumber"), commonCellStyle1, item.getString("admingroupnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("createAdminGrpName"), commonCellStyle1, item.getString("admingroupname"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("openRangeWithView"), commonCellStyle1, item.getString("publicscopeview"));
            this.addCellRegion((Sheet)sheet, rowIndex, (int)colIndexMap.get("openRangeWithEdit"), commonCellStyle1, item.getString("publicscopeedit"));
            ++rowIndex;
        }
    }

    private void scene2(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-common2");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        DynamicObject item = Arrays.stream(items).filter(it -> 20000 == it.getInt("sceneid")).findAny().get();
        sheet.createRow(11).setRowStyle(commonCellStyle1);
        this.addCellRegion((Sheet)sheet, 11, 0, commonCellStyle1, item.getString("scenename"));
        this.addCellRegion((Sheet)sheet, 11, 1, commonCellStyle2, item.getString("scenedesc"));
        this.addCellRegion((Sheet)sheet, 11, 2, commonCellStyle1, item.getString("usernumber"));
        this.addCellRegion((Sheet)sheet, 11, 3, commonCellStyle1, item.getString("username"));
        this.addCellRegion((Sheet)sheet, 11, 4, commonCellStyle1, item.getString("fileorgnumber"));
        this.addCellRegion((Sheet)sheet, 11, 5, commonCellStyle1, item.getString("fileorgname"));
        this.addCellRegion((Sheet)sheet, 11, 6, commonCellStyle1, item.getString("rolenumber"));
        this.addCellRegion((Sheet)sheet, 11, 7, commonCellStyle1, item.getString("rolename"));
        this.addCellRegion((Sheet)sheet, 11, 8, commonCellStyle1, this.formatDate(item.getDate("validstart")));
        this.addCellRegion((Sheet)sheet, 11, 9, commonCellStyle1, this.formatDate(item.getDate("validend")));
        this.addCellRegion((Sheet)sheet, 11, 10, commonCellStyle3, item.getString("customenable"));
        this.addCellRegion((Sheet)sheet, 11, 11, commonCellStyle1, item.getString("bucafunc"));
        XSSFCellStyle noLimitCellStyle = (XSSFCellStyle)this.wb.createCellStyle();
        noLimitCellStyle.cloneStyleFrom(commonCellStyle1);
        noLimitCellStyle.setAlignment(HorizontalAlignment.CENTER);
        Font font = this.wb.createFont();
        font.setColor(IndexedColors.GREY_25_PERCENT.getIndex());
        noLimitCellStyle.setFont(font);
        this.addMergedRegion((Sheet)sheet, 11, 11, 12, 16, (CellStyle)noLimitCellStyle, ResManager.loadKDString((String)"\u6b64\u533a\u57df\u65e0\u9700\u8bbe\u7f6e\u3002", (String)"PermSheetHelper_54", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6b64\u533a\u57df\u65e0\u9700\u8bbe\u7f6e\u3002", (String)"PermSheetHelper_54", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void scene3(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-common2");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        DynamicObject item = Arrays.stream(items).filter(it -> 30000 == it.getInt("sceneid")).findAny().get();
        sheet.createRow(13).setRowStyle(commonCellStyle1);
        this.addCellRegion((Sheet)sheet, 13, 0, commonCellStyle1, item.getString("scenename"));
        this.addCellRegion((Sheet)sheet, 13, 1, commonCellStyle2, item.getString("scenedesc"));
        this.addCellRegion((Sheet)sheet, 13, 2, commonCellStyle1, item.getString("usernumber"));
        this.addCellRegion((Sheet)sheet, 13, 3, commonCellStyle1, item.getString("username"));
        this.addCellRegion((Sheet)sheet, 13, 4, commonCellStyle1, item.getString("fileorgnumber"));
        this.addCellRegion((Sheet)sheet, 13, 5, commonCellStyle1, item.getString("fileorgname"));
        this.addCellRegion((Sheet)sheet, 13, 6, commonCellStyle1, item.getString("rolenumber"));
        this.addCellRegion((Sheet)sheet, 13, 7, commonCellStyle1, item.getString("rolename"));
        this.addCellRegion((Sheet)sheet, 13, 8, commonCellStyle1, this.formatDate(item.getDate("validstart")));
        this.addCellRegion((Sheet)sheet, 13, 9, commonCellStyle1, this.formatDate(item.getDate("validend")));
        this.addCellRegion((Sheet)sheet, 13, 10, commonCellStyle3, item.getString("customenable"));
        this.addCellRegion((Sheet)sheet, 13, 11, commonCellStyle1, item.getString("bucafunc"));
        this.addCellRegion((Sheet)sheet, 13, 12, commonCellStyle1, item.getString("orgrange").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("orgrangetip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
        this.addCellRegion((Sheet)sheet, 13, 13, commonCellStyle1, item.getString("dim_adminorg").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
        this.addCellRegion((Sheet)sheet, 13, 15, commonCellStyle1, item.getString("dim_salarygroup").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("dim_salarygrouptip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
        this.setPinkBackground(sheet, 13, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 13, 15, commonCellStyle1);
    }

    private void scene4(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-common2");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        boolean isFirst = true;
        int rowIndex = 15;
        List newItems = Arrays.stream(items).filter(it -> 40000 == it.getInt("sceneid")).collect(Collectors.toList());
        for (DynamicObject item : newItems) {
            sheet.createRow(rowIndex).setRowStyle(commonCellStyle1);
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, isFirst ? commonCellStyle2 : commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, this.formatDate(item.getDate("validstart")));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, this.formatDate(item.getDate("validend")));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("customenable"), item.getString("customenabletip"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle3, item.getString("bucafunc").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 12, commonCellStyle1, item.getString("orgrange").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("orgrangetip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 13, commonCellStyle1, item.getString("dim_adminorg").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 14, commonCellStyle1, item.getString("dim_projectteam").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            ++rowIndex;
            isFirst = false;
        }
        this.addMergedRegion((Sheet)sheet, 15, 16, 0, 0, commonCellStyle1, null);
        RoleDemoExcelWriter.getRow((SXSSFSheet)sheet, (int)16).getCell(1).getCellStyle().setBorderTop(BorderStyle.NONE);
        this.setWhiteTopBorder(sheet, 16, 1);
        this.setPinkBackground(sheet, 15, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 15, 14, commonCellStyle1);
    }

    private void scene5(SXSSFSheet sheet, DynamicObject[] items) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle2 = this.styles.getTextStyle("body-common2");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        boolean isFirst = true;
        int rowIndex = 18;
        List newItems = Arrays.stream(items).filter(it -> 50000 == it.getInt("sceneid")).collect(Collectors.toList());
        for (DynamicObject item : newItems) {
            sheet.createRow(rowIndex).setRowStyle(commonCellStyle1);
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, isFirst ? commonCellStyle2 : commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, this.formatDate(item.getDate("validstart")));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, this.formatDate(item.getDate("validend")));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("customenable"), item.getString("customenabletip"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle1, item.getString("bucafunc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 12, commonCellStyle1, item.getString("orgrange").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"), item.getString("orgrangetip").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 13, commonCellStyle3, item.getString("dim_adminorg").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            this.addCellRegion((Sheet)sheet, rowIndex, 15, commonCellStyle3, item.getString("dim_salarygroup").replaceAll(";", ";\n").replaceAll("\uff1b", "\uff1b\n"));
            ++rowIndex;
            isFirst = false;
        }
        this.addMergedRegion((Sheet)sheet, 18, 19, 0, 0, commonCellStyle1, null);
        this.setWhiteTopBorder(sheet, 19, 1);
        this.setPinkBackground(sheet, 18, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 18, 15, commonCellStyle1);
        this.setPinkBackground(sheet, 19, 13, commonCellStyle1);
        this.setPinkBackground(sheet, 19, 15, commonCellStyle1);
    }

    public void addCustomRoleDataRuleSheet(String sheetName) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        sheet.setZoom(75);
        this.addCustomRoleDataRuleHeader(sheet);
        this.addCustomRoleDataRuleBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(4, 3560);
        sheet.setColumnWidth(5, 3560);
        sheet.setColumnWidth(6, 2846);
        sheet.setColumnWidth(7, 3616);
        sheet.setColumnWidth(10, 3560);
        sheet.setColumnWidth(11, 3560);
        sheet.setColumnWidth(12, 2486);
        sheet.setColumnWidth(13, 3560);
        sheet.setColumnWidth(14, 3560);
    }

    private void addCustomRoleDataRuleHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        sheet.createRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, mustCellStyle, ResManager.loadKDString((String)"*\u6743\u9650\u9879", (String)"PermSheetHelper_30", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"1\u3001\u5141\u8bb8\u5f55\u5165\u591a\u4e2a\u503c\n2\u3001\u503c\u4e3a\u7a7a\u65f6\uff0c\u9ed8\u8ba4\u89d2\u8272\u4e0b\u4e1a\u52a1\u5bf9\u8c61\u7684\u6240\u6709\u6743\u9650\u9879\u8303\u56f4\u90fd\u6309\u540c\u4e2a\u6570\u636e\u89c4\u5219\u65b9\u6848", (String)"PermSheetHelper_99", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 13, mustCellStyle, ResManager.loadKDString((String)"*\u6570\u636e\u89c4\u5219\u65b9\u6848\u7f16\u7801", (String)"PermSheetHelper_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 14, cellStyle, ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u540d\u79f0", (String)"PermSheetHelper_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRoleDataRuleBody(SXSSFSheet sheet) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitdemo_userdr");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,usernumber,usernumbertip,username,usernametip,fileorgnumber,fileorgnumbertip,fileorgname,fileorgnametip,rolenumber,rolenumbertip,rolename,rolenametip,appnumber,appnumbertip,appname,appnametip,entitynumber,entitynumbertip,entityname,entitynametip,permitem,permitemtip,datarulenumber,datarulenumbertip,datarulename,datarulenametip", new QFilter[0], "sceneid,index");
        int rowIndex = 3;
        for (DynamicObject item : items) {
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, item.getString("appnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, item.getString("appname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("entitynumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle1, item.getString("entityname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 12, commonCellStyle3, item.getString("permitem"));
            this.addCellRegion((Sheet)sheet, rowIndex, 13, commonCellStyle3, item.getString("datarulenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 14, commonCellStyle3, item.getString("datarulename"));
            ++rowIndex;
        }
        this.addMergedRegion((Sheet)sheet, 5, 6, 0, 0, null, null);
        this.addMergedRegion((Sheet)sheet, 5, 6, 1, 1, null, null);
        sheet.getRow(rowIndex - 1).setHeight((short)1000);
    }

    public void addCustomRoleBaseDataDataScopePropertySheet(String sheetName) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        sheet.setZoom(75);
        this.addCustomRoleBaseDataDataScopePropertyHeader(sheet);
        this.addCustomRoleBaseDataDataScopePropertyBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(4, 3560);
        sheet.setColumnWidth(5, 3560);
        sheet.setColumnWidth(6, 2846);
        sheet.setColumnWidth(7, 3616);
        sheet.setColumnWidth(10, 3560);
        sheet.setColumnWidth(11, 3560);
        sheet.setColumnWidth(12, 3560);
        sheet.setColumnWidth(13, 3560);
        sheet.setColumnWidth(14, 4633);
        sheet.setColumnWidth(15, 4633);
    }

    private void addCustomRoleBaseDataDataScopePropertyHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        sheet.createRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, mustCellStyle, ResManager.loadKDString((String)"*\u57fa\u7840\u8d44\u6599\u5c5e\u6027", (String)"PermSheetHelper_100", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 13, cellStyle, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u540d\u79f0", (String)"PermSheetHelper_34", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 14, mustCellStyle, ResManager.loadKDString((String)"*\u6570\u636e\u89c4\u5219\u65b9\u6848\u7f16\u7801", (String)"PermSheetHelper_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 15, cellStyle, ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u540d\u79f0", (String)"PermSheetHelper_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRoleBaseDataDataScopePropertyBody(SXSSFSheet sheet) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitdemo_userbd");
        DynamicObject item = serviceHelper.queryOne("sceneid,scenename,scenedesc,index,usernumber,usernumbertip,username,usernametip,fileorgnumber,fileorgnumbertip,fileorgname,fileorgnametip,rolenumber,rolenumbertip,rolename,rolenametip,appnumber,appnumbertip,appname,appnametip,entitynumber,entitynumbertip,entityname,entitynametip,propkey,propkeytip,propname,propnametip,datarulenumber,datarulenumbertip,datarulename,datarulenametip", new QFilter[0], "sceneid,index");
        if (null != item) {
            this.addCellRegion((Sheet)sheet, 3, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, 3, 1, commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, 3, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, 3, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, 3, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, 3, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, 3, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, 3, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, 3, 8, commonCellStyle1, item.getString("appnumber"));
            this.addCellRegion((Sheet)sheet, 3, 9, commonCellStyle1, item.getString("appname"));
            this.addCellRegion((Sheet)sheet, 3, 10, commonCellStyle1, item.getString("entitynumber"));
            this.addCellRegion((Sheet)sheet, 3, 11, commonCellStyle1, item.getString("entityname"));
            this.addCellRegion((Sheet)sheet, 3, 12, commonCellStyle3, item.getString("propkey"));
            this.addCellRegion((Sheet)sheet, 3, 13, commonCellStyle3, item.getString("propname"));
            this.addCellRegion((Sheet)sheet, 3, 14, commonCellStyle3, item.getString("datarulenumber"));
            this.addCellRegion((Sheet)sheet, 3, 15, commonCellStyle3, item.getString("datarulename"));
        }
    }

    public void addCustomRolePropertyPermSheet(String sheetName) {
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        sheet.setZoom(75);
        this.addCustomRolePropertyPermHeader(sheet);
        this.addCustomRolePropertyPermBody(sheet);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(4, 3560);
        sheet.setColumnWidth(5, 3560);
        sheet.setColumnWidth(6, 2846);
        sheet.setColumnWidth(7, 3616);
        sheet.setColumnWidth(10, 3560);
        sheet.setColumnWidth(11, 3560);
    }

    private void addCustomRolePropertyPermHeader(SXSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u8bf4\u660e1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PermSheetHelper_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        sheet.createRow(1).setHidden(Boolean.valueOf(true));
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        this.addCellRegion((Sheet)sheet, 2, 0, cellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 1, cellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 2, mustCellStyle, ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"PermSheetHelper_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 3, cellStyle, ResManager.loadKDString((String)"\u59d3\u540d", (String)"PermSheetHelper_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 4, mustCellStyle, ResManager.loadKDString((String)"*HR\u7ba1\u7406\u7ec4\u7ec7\u7f16\u7801", (String)"PermSheetHelper_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 5, cellStyle, ResManager.loadKDString((String)"HR\u7ba1\u7406\u7ec4\u7ec7\u540d\u79f0", (String)"PermSheetHelper_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 6, mustCellStyle, ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"PermSheetHelper_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 7, cellStyle, ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermSheetHelper_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 8, mustCellStyle, ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"PermSheetHelper_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 9, cellStyle, ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"PermSheetHelper_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 10, mustCellStyle, ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"PermSheetHelper_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 11, cellStyle, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"PermSheetHelper_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 12, mustCellStyle, ResManager.loadKDString((String)"*\u5b57\u6bb5\u5c5e\u6027", (String)"PermSheetHelper_101", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 13, cellStyle, ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0", (String)"PermSheetHelper_38", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 14, mustCellStyle, ResManager.loadKDString((String)"*\u67e5\u770b", (String)"PermSheetHelper_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\u3002", (String)"PermSheetHelper_55", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addCellRegion((Sheet)sheet, 2, 15, mustCellStyle, ResManager.loadKDString((String)"*\u7f16\u8f91", (String)"PermSheetHelper_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f55\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\n\u5f55\u5165\u8981\u6c42\uff1a\u4e0d\u5141\u8bb8\u67e5\u770b\u65f6\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"PermSheetHelper_56", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }

    private void addCustomRolePropertyPermBody(SXSSFSheet sheet) {
        CellStyle commonCellStyle1 = this.styles.getTextStyle("body-common1");
        CellStyle commonCellStyle3 = this.styles.getTextStyle("body-common3");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_perminitdemo_userfld");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,usernumber,usernumbertip,username,usernametip,fileorgnumber,fileorgnumbertip,fileorgname,fileorgnametip,rolenumber,rolenumbertip,rolename,rolenametip,appnumber,appnumbertip,appname,appnametip,entitynumber,entitynumbertip,entityname,entitynametip,propkey,propkeytip,propname,propnametip,canread,canreadtip,canwrite,canwritetip", new QFilter[0], "sceneid,index");
        int rowIndex = 3;
        for (DynamicObject item : items) {
            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle1, item.getString("scenename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle1, item.getString("scenedesc"));
            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle1, item.getString("usernumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle1, item.getString("username"));
            this.addCellRegion((Sheet)sheet, rowIndex, 4, commonCellStyle1, item.getString("fileorgnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 5, commonCellStyle1, item.getString("fileorgname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 6, commonCellStyle1, item.getString("rolenumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 7, commonCellStyle1, item.getString("rolename"));
            this.addCellRegion((Sheet)sheet, rowIndex, 8, commonCellStyle1, item.getString("appnumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 9, commonCellStyle1, item.getString("appname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 10, commonCellStyle1, item.getString("entitynumber"));
            this.addCellRegion((Sheet)sheet, rowIndex, 11, commonCellStyle1, item.getString("entityname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 12, commonCellStyle1, item.getString("propkey"));
            this.addCellRegion((Sheet)sheet, rowIndex, 13, commonCellStyle1, item.getString("propname"));
            this.addCellRegion((Sheet)sheet, rowIndex, 14, commonCellStyle3, item.getString("canread"));
            this.addCellRegion((Sheet)sheet, rowIndex, 15, commonCellStyle3, item.getString("canwrite"));
            ++rowIndex;
        }
    }

    public static String getColumnLabel(int columnNo) {
        if (columnNo < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(SOURCES[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(SOURCES[remainder]);
        }
        return sb.reverse().toString();
    }

    public void addFunctionItemSheet(String sheetName) {
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        this.addFunctionItemHeader(sheet);
        this.addFunctionItemBody(sheet);
    }

    private void addFunctionItemHeader(XSSFSheet sheet) {
        RoleTemplateExcelWriter roleTemplateExcelWriter = new RoleTemplateExcelWriter();
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u7070\u8272\u5217\u4e3a\u7cfb\u7edf\u81ea\u52a8\u52a0\u8f7d\u6570\u636e\u4e0d\u5141\u8bb8\u8c03\u6574\uff1b4\u3001\u8bf7\u6309\u89d2\u8272\u52fe\u9009\u529f\u80fd\u6743\u9650\u9879\uff1b5\u3001\u5f53\u8c03\u6574\u4e86\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u540e\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u9875\u7b7e\u7684\u89d2\u8272\u4e0e\u5bf9\u5e94\u7684\u529f\u80fd\u6743\u9650\u9879\u662f\u5426\u6b63\u786e\u3002", (String)"RoleTemplateExcelWriter_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 3, 0, 0, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f", (String)"PermSheetHelper_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 3, 1, 1, centerCellStyle, ResManager.loadKDString((String)"\u573a\u666f\u8bf4\u660e", (String)"PermSheetHelper_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        int startRow = 1;
        int startCol = 2;
        roleTemplateExcelWriter.addFunctionItemHeaderCol(sheet, startRow, startCol);
        String roleSheetName = ResManager.loadKDString((String)"\u89d2\u8272\u6e05\u5355", (String)"PermSheetHelper_89", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        for (int i = 8; i < 308; ++i) {
            Cell cell = this.addCellRegion((Sheet)sheet, 2, i + 3);
            cell.setCellStyle(centerCellStyle);
            cell.setCellType(CellType.STRING);
            String str = "IF(COUNTBLANK(" + roleSheetName + "!C" + (i - 2) + "),\"\",TRANSPOSE(" + roleSheetName + "!C" + (i - 2) + "))";
            cell.setCellFormula(str);
            Cell cell2 = this.addCellRegion((Sheet)sheet, 3, i + 3);
            cell2.setCellStyle(centerCellStyle);
            cell2.setCellType(CellType.STRING);
            String str2 = "IF(COUNTBLANK(" + roleSheetName + "!D" + (i - 2) + "),\"\",TRANSPOSE(" + roleSheetName + "!D" + (i - 2) + "))";
            cell2.setCellFormula(str2);
        }
    }

    private void addFunctionItemBody(XSSFSheet sheet) {
        CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleinitdemo_fc");
        DynamicObject[] items = serviceHelper.query("sceneid,scenename,scenedesc,index,entryentity.cloudnum,entryentity.cloudname,entryentity.appnum,entryentity.appname,entryentity.entitynum,entryentity.entityname,entryentity.bucafuncname,entryentity.dimname,entryentity.name,entryentity.payroll_01,entryentity.payroll_02,entryentity.payroll_03,entryentity.ch_020", new QFilter[0], "sceneid,index");
        int rowIndex = 4;
        for (DynamicObject item : items) {
            DynamicObjectCollection entryentity = item.getDynamicObjectCollection("entryentity");
            int size = entryentity.size() + rowIndex - 1;
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 4, size, 0, 0, commonCellStyle, item.getString("scenename"));
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 4, size, 1, 1, commonCellStyle, item.getString("scenedesc"));
            for (DynamicObject dynamicObject : entryentity) {
                int colIndex = 2;
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("cloudnum"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("cloudname"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("appnum"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("appname"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("entitynum"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("entityname"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("name"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("bucafuncname"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("dimname"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("payroll_01"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("payroll_02"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("payroll_03"));
                this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, dynamicObject.getString("ch_020"));
                ++rowIndex;
            }
        }
    }
}

