/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.excel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.init.PermRoleFuncService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DynamicControlHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.common.model.perminit.DimValueBean;
import kd.hr.hrcs.formplugin.web.perm.init.excel.MemberRoleSheet;
import kd.hr.hrcs.formplugin.web.perm.init.excel.RoleExcel;
import kd.hr.hrcs.formplugin.web.perm.init.excel.TemplateExcelWriter;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class RoleTemplateExcelWriter
extends TemplateExcelWriter {
    private static final Log LOGGER = LogFactory.getLog(RoleTemplateExcelWriter.class);
    private static final int COL_WIDTH_NUM = 192;
    private static final int COL_SHORT_WIDTH_NUM = 120;
    private boolean isShowErrMsg = false;
    final PermRoleFuncService permRoleFuncService = new PermRoleFuncService();

    public RoleTemplateExcelWriter() {
    }

    public RoleTemplateExcelWriter(boolean isShowErrMsg) {
        this.isShowErrMsg = isShowErrMsg;
    }

    public SXSSFWorkbook getWorkbook() {
        return this.wb;
    }

    public void addRoleSheet(String sheetName, RoleExcel roleExcel) {
        LOGGER.info("Begin add role sheet.");
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        sheet.setZoom(80);
        this.addRoleHeader(sheet);
        this.addRoleBody(sheet, roleExcel);
        LOGGER.info("End add role sheet.");
    }

    public void addFunctionItemSheet(String sheetName, RoleExcel roleExcel) {
        LOGGER.info("Begin add role function item sheet.");
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        sheet.setZoom(80);
        this.addFunctionItemHeader(sheet);
        this.addFunctionItemBody(sheet, roleExcel);
        LOGGER.info("End add role function item sheet.");
    }

    public void addDimSheet(String sheetName, RoleExcel roleExcel) {
        LOGGER.info("Begin add role dim sheet.");
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        sheet.setZoom(80);
        this.addDimHeader(sheet, roleExcel);
        this.addDimBody(sheet, roleExcel);
        LOGGER.info("End add role dim sheet.");
    }

    public int addDataRangeSheet(String sheetName, RoleExcel roleExcel) {
        LOGGER.info("Begin add role data range sheet.");
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        sheet.setZoom(80);
        int lastColumnIndex = this.addDataRangeHeader(sheet, roleExcel);
        if (!this.isShowErrMsg) {
            this.addDataRangeBody(sheet, roleExcel, lastColumnIndex);
        }
        LOGGER.info("End add role data range sheet.");
        return lastColumnIndex;
    }

    public void addFieldPermSheet(String sheetName, RoleExcel roleExcel) {
        LOGGER.info("Begin add role field perm sheet.");
        XSSFSheet sheet = this.wb.getXSSFWorkbook().createSheet(sheetName);
        sheet.setZoom(80);
        this.addFieldPermHeader(sheet);
        this.addFieldPermBody(sheet, roleExcel);
        LOGGER.info("End add role field perm sheet.");
    }

    private void addFieldPermHeader(XSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"RoleTemplateExcelWriter_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addFieldPermHeaderCol(sheet, 1, 0);
    }

    private void addFieldPermBody(XSSFSheet sheet, RoleExcel roleExcel) {
        if (null != roleExcel) {
            CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
            commonCellStyle.setWrapText(false);
            Map<String, List<RoleExcel.FieldPermSheet>> roleFieldPermMap = roleExcel.getFieldPermSet().stream().collect(Collectors.groupingBy(RoleExcel.FieldPermSheet::getRoleNumber));
            int rowIndex = 3;
            int draft = this.isShowErrMsg ? 1 : 0;
            for (RoleExcel.RoleSheet role : roleExcel.getRoleSet()) {
                List<RoleExcel.FieldPermSheet> fieldPerms = roleFieldPermMap.get(role.getRoleNumber());
                if (null == fieldPerms) continue;
                for (RoleExcel.FieldPermSheet fieldPerm : fieldPerms) {
                    if (this.isShowErrMsg) {
                        this.addCellRegion((Sheet)sheet, rowIndex, 0, this.getErrorCellStyle(), fieldPerm.getErrorMsg());
                    }
                    this.addCellRegion((Sheet)sheet, rowIndex, 0 + draft, commonCellStyle, fieldPerm.getRoleNumber());
                    this.addCellRegion((Sheet)sheet, rowIndex, 1 + draft, commonCellStyle, fieldPerm.getRoleName());
                    this.addCellRegion((Sheet)sheet, rowIndex, 2 + draft, commonCellStyle, fieldPerm.getAppNumber());
                    this.addCellRegion((Sheet)sheet, rowIndex, 3 + draft, commonCellStyle, fieldPerm.getAppName());
                    this.addCellRegion((Sheet)sheet, rowIndex, 4 + draft, commonCellStyle, fieldPerm.getEntityNumber());
                    this.addCellRegion((Sheet)sheet, rowIndex, 5 + draft, commonCellStyle, fieldPerm.getEntityName());
                    this.addCellRegion((Sheet)sheet, rowIndex, 6 + draft, commonCellStyle, fieldPerm.getFieldNumber());
                    this.addCellRegion((Sheet)sheet, rowIndex, 7 + draft, commonCellStyle, fieldPerm.getFieldName());
                    this.addCellRegion((Sheet)sheet, rowIndex, 8 + draft, commonCellStyle, this.getFieldBanStr(fieldPerm.isNoView()));
                    this.addCellRegion((Sheet)sheet, rowIndex, 9 + draft, commonCellStyle, this.getFieldBanStr(fieldPerm.isNoEdit()));
                    ++rowIndex;
                }
            }
        }
    }

    private CellStyle getErrorCellStyle() {
        CellStyle commonCellStyle = this.styles.getTextStyle("body-errormsg");
        Font redFont = this.styles.getRedFont();
        commonCellStyle.setFont(redFont);
        return commonCellStyle;
    }

    public Map<String, Integer> addDataRangeHeaderCol(XSSFSheet sheet, int startRow, int startCol) {
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        mustCellStyle.setWrapText(true);
        cellStyle.setWrapText(true);
        HashMap colIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        this.addCellRegion((Sheet)sheet, startRow, startCol).setCellValue("roleNumber");
        colIndexMap.put("roleNumber", startCol);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 1).setCellValue("roleName");
        colIndexMap.put("roleName", startCol + 1);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 2).setCellValue("buCaFuncName");
        colIndexMap.put("buCaFuncName", startCol + 2);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 3).setCellValue("orgRange");
        colIndexMap.put("orgRange", startCol + 3);
        RoleTemplateExcelWriter.getRow(sheet, startRow).getCTRow().setHidden(true);
        String content = ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"RoleTemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"1\u3001\u5fc5\u987b\u662f\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u9875\u7b7e\u7684\u89d2\u8272\n2\u3001\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u4e2d\u8bbe\u7f6e\u4e86\u201c\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u201d\u7684\u89d2\u8272\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6570\u636e\u8303\u56f4\uff1b\u201c\u5141\u8bb8\u81ea\u5b9a\u4e49\u201d\u7684\u89d2\u8272\u6309\u9700\u8bbe\u7f6e\u6570\u636e\u8303\u56f4", (String)"RoleTemplateExcelWriter_37", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, startCol, startCol, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"RoleTemplateExcelWriter_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, startCol + 1, startCol + 1, cellStyle, content);
        sheet.setColumnWidth(startCol + 1, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"*\u804c\u80fd\u7c7b\u578b", (String)"RoleTemplateExcelWriter_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u4fdd\u6301\u4e0e\u201c\u89d2\u8272\u7ef4\u5ea6\u201d\u9875\u7b7e\u6807\u8bb0\u7684\u804c\u80fd\u4e00\u81f4\u3002", (String)"RoleTemplateExcelWriter_59", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, startCol + 2, startCol + 2, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + 2, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"*\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4", (String)"RoleTemplateExcelWriter_43", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u4e2d\uff0c\u5982\u679c\u89d2\u8272\u88ab\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\uff0c\u5219\u5fc5\u987b\u4e3a\u5176\u8bbe\u7f6e\u4e1a\u52a1\u7ec4\u7ec7\u8303\u56f4\uff1b\u5982\u679c\u89d2\u8272\u88ab\u8bbe\u7f6e\u4e3a\u201c\u5141\u8bb8\u81ea\u5b9a\u4e49\u8303\u56f4\u201d\uff0c\u5219\u53ef\u4ee5\u6839\u636e\u9700\u8981\u8bbe\u7f6e\u6570\u636e\u8303\u56f4\u3002\n\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u4e1a\u52a1\u7ec4\u7ec7\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002", (String)"RoleTemplateExcelWriter_55", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, startCol + 3, startCol + 3, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + 3, content.getBytes().length * 192);
        sheet.createFreezePane(4, 5);
        return colIndexMap;
    }

    public Map<String, Integer> addFieldPermHeaderCol(XSSFSheet sheet, int startRow, int startCol) {
        String content;
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        HashMap colIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        int draft = 0;
        if (this.isShowErrMsg) {
            draft = 1;
            this.addCellRegion((Sheet)sheet, startRow, startCol).setCellValue("errorMsg");
            colIndexMap.put("errorMsg", startCol);
        }
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft).setCellValue("roleNumber");
        colIndexMap.put("roleNumber", startCol + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 1).setCellValue("roleName");
        colIndexMap.put("roleName", startCol + draft + 1);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 2).setCellValue("appNum");
        colIndexMap.put("appNum", startCol + draft + 2);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 3).setCellValue("appName");
        colIndexMap.put("appName", startCol + draft + 3);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 4).setCellValue("entityNum");
        colIndexMap.put("entityNum", startCol + draft + 4);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 5).setCellValue("entityName");
        colIndexMap.put("entityName", startCol + draft + 5);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 6).setCellValue("fieldNumber");
        colIndexMap.put("fieldNumber", startCol + draft + 6);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 7).setCellValue("fieldName");
        colIndexMap.put("fieldName", startCol + draft + 7);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 8).setCellValue("view");
        colIndexMap.put("view", startCol + draft + 8);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 9).setCellValue("edit");
        colIndexMap.put("edit", startCol + draft + 9);
        RoleTemplateExcelWriter.getRow(sheet, startRow).getCTRow().setHidden(true);
        if (this.isShowErrMsg) {
            content = ResManager.loadKDString((String)"\u9519\u8bef\u8bf4\u660e", (String)"RoleTemplateExcelWriter_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addCellRegion((Sheet)sheet, startRow + 1, startCol, mustCellStyle, content, "");
            sheet.setColumnWidth(0, content.getBytes().length * 400);
        }
        content = ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"RoleTemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u9875\u7b7e\u7684\u89d2\u8272", (String)"RoleTemplateExcelWriter_56", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + draft, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"RoleTemplateExcelWriter_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 1, cellStyle, content);
        sheet.setColumnWidth(startCol + draft + 1, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"*\u5e94\u7528\u7f16\u7801", (String)"RoleTemplateExcelWriter_44", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u53ef\u53c2\u8003\u300a\u89d2\u8272\u529f\u80fd\u6743\u9650\u300b\u9875\u7b7e", (String)"RoleTemplateExcelWriter_45", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 2, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + draft + 2, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"RoleTemplateExcelWriter_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 3, cellStyle, content);
        sheet.setColumnWidth(startCol + draft + 3, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"*\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"RoleTemplateExcelWriter_46", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u53ef\u53c2\u8003\u300a\u89d2\u8272\u529f\u80fd\u6743\u9650\u300b\u9875\u7b7e", (String)"RoleTemplateExcelWriter_45", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 4, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + draft + 4, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"RoleTemplateExcelWriter_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 5, cellStyle, content);
        sheet.setColumnWidth(startCol + draft + 5, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"*\u5b57\u6bb5\u5c5e\u6027", (String)"RoleTemplateExcelWriter_47", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 6, mustCellStyle, content);
        sheet.setColumnWidth(startCol + draft + 6, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0", (String)"RoleTemplateExcelWriter_48", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 7, cellStyle, content);
        sheet.setColumnWidth(startCol + draft + 7, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"*\u67e5\u770b", (String)"RoleTemplateExcelWriter_49", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u8f93\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\u3002", (String)"RoleTemplateExcelWriter_51", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 8, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + draft + 8, content.getBytes().length * 256);
        content = ResManager.loadKDString((String)"*\u7f16\u8f91", (String)"RoleTemplateExcelWriter_50", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u5f55\u5165\u503c\uff1a\u5141\u8bb8/\u4e0d\u5141\u8bb8\n\u5f55\u5165\u8981\u6c42\uff1a\u4e0d\u5141\u8bb8\u67e5\u770b\u65f6\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"RoleTemplateExcelWriter_52", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 1, startCol + draft + 9, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + draft + 9, content.getBytes().length * 256);
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(startRow + 2, startRow + 9999, startCol + draft + 8, startCol + 9);
        String allow = ResManager.loadKDString((String)"\u5141\u8bb8", (String)"RoleTemplateExcelWriter_53", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String notAllow = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8", (String)"RoleTemplateExcelWriter_54", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String[] items = new String[]{allow, notAllow};
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint dataScopeValueConstraint = helper.createExplicitListConstraint(items);
        DataValidation dataScopeDataValidation = helper.createValidation(dataScopeValueConstraint, cellRangeAddressList);
        sheet.addValidationData(dataScopeDataValidation);
        return colIndexMap;
    }

    public int addDataRangeHeader(XSSFSheet sheet, RoleExcel roleExcel) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"RoleTemplateExcelWriter_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addDataRangeHeaderCol(sheet, 1, 0);
        Set dimNumberSet = null;
        if (null != roleExcel) {
            dimNumberSet = roleExcel.getDim().getList().stream().map(Pair::getKey).map(Pair::getKey).collect(Collectors.toSet());
        }
        List dimList = this.permRoleFuncService.getDimList(dimNumberSet);
        List typeIdList = dimList.stream().map(dyn -> dyn.getLong("teamtype.id")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
        DynamicObject[] struct = serviceHelper.query("id,name,number,otclassify.teamtype,issyspreset", new QFilter[]{new QFilter("otclassify.teamtype.id", "in", typeIdList), new QFilter("enable", "!=", (Object)"10")}, "createtime");
        Map<Long, List<DynamicObject>> structGroup = Arrays.stream(struct).collect(Collectors.groupingBy(dyn -> dyn.getLong("otclassify.teamtype.id")));
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        centerCellStyle.setWrapText(true);
        int col = 4;
        for (DynamicObject dyn2 : dimList) {
            long typeId = dyn2.getLong("teamtype.id");
            String dimName = dyn2.getString("name");
            List structList = DynamicControlHelper.sortStructProjects((List)structGroup.getOrDefault(typeId, new ArrayList()));
            String dimNum = dyn2.getString("number");
            if (!CollectionUtils.isEmpty((Collection)structList)) {
                String kdString = ResManager.loadKDString((String)"\u884c\u653f\u7c7b\u7ec4\u7ec7\u56e2\u961f", (String)"PermSheetHelper_41", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                String tip = ResManager.loadKDString((String)"\u5f55\u5165\u6ce8\u610f\u4e8b\u9879\uff1a\n1\u3001\u53ef\u5f55\u5165\u591a\u4e2a\u503c\uff0c\u6309\u5206\u53f7\u5206\u9694\u663e\u793a\uff1b\n2\u3001\u540d\u79f0\u975e\u5fc5\u5f55\u9879\uff1b\n3\u3001\u652f\u6301\u8bbe\u7f6e\u5305\u542b\u4e0b\u7ea7\uff0c\u7279\u6b8a\u6807\u8bb0\u7b26\u53f7\u4e3a<\u5305\u542b\u4e0b\u7ea7>\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\norg2\u3010**\u516c\u53f8\u3011<\u5305\u542b\u4e0b\u7ea7>;\norg2<\u5305\u542b\u4e0b\u7ea7>\uff1b\n4\u3001\u652f\u6301\u8bbe\u7f6e\u52a8\u6001\u6570\u636e\u8303\u56f4\u3002\u793a\u4f8b\u5982\u4e0b\uff1a\nDYNA_COND_10020\u3010\u4efb\u804c\u90e8\u95e8\u53ca\u4e0b\u7ea7\u90e8\u95e8\u3011\u3002", (String)"PermSheetHelper_50", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                if (structList.size() > 1) {
                    if (kdString.equals(dimName)) {
                        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 3, col, col + structList.size() - 1, centerCellStyle, dimName, tip);
                    } else {
                        this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 3, col, col + structList.size() - 1, centerCellStyle, dimName);
                    }
                } else if (kdString.equals(dimName)) {
                    this.addCellRegion((Sheet)sheet, 3, col, centerCellStyle, dimName, tip);
                } else {
                    this.addCellRegion((Sheet)sheet, 3, col, centerCellStyle, dimName);
                }
                for (DynamicObject structDyn : structList) {
                    this.addCellRegion((Sheet)sheet, 1, col, centerCellStyle, dimNum + "#" + structDyn.getString("number"));
                    this.addCellRegion((Sheet)sheet, 4, col, centerCellStyle, structDyn.getString("name"));
                    ++col;
                }
                continue;
            }
            this.addCellRegion((Sheet)sheet, 1, col, centerCellStyle, dimNum);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 3, 4, col, col, centerCellStyle, dimName);
            ++col;
        }
        XSSFRow row = sheet.getRow(4);
        row.setHeight((short)768);
        if (!this.isShowErrMsg) {
            String content = ResManager.loadKDString((String)"\u89d2\u8272\u7ef4\u5ea6", (String)"RoleTemplateExcelWriter_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            String tip = ResManager.loadKDString((String)"\u6839\u636e\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\uff0c\u83b7\u53d6\u89d2\u8272\u5404\u804c\u80fd\u4e0b\u7684\u7ef4\u5ea6\u3002", (String)"RoleTemplateExcelWriter_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            if (dimList.size() > 1) {
                this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, 4, col - 1, centerCellStyle, content, tip);
            } else if (dimList.size() > 0) {
                this.addCellRegionWithWhiteBorder((Sheet)sheet, 2, 4, centerCellStyle, content, tip);
            }
        }
        return col;
    }

    private void addDataRangeBody(XSSFSheet sheet, RoleExcel roleExcel, int lastColumnIndex) {
        if (null != roleExcel) {
            CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
            commonCellStyle.setWrapText(false);
            Map<String, RoleExcel.DataRangeSheet> roleDataRangeMap = roleExcel.getDataRangeSet().stream().collect(Collectors.toMap(RoleExcel.DataRangeSheet::getRoleNumber, it -> it, (oldValue, newValue) -> oldValue));
            int rowIndex = 5;
            for (RoleExcel.RoleSheet role : roleExcel.getRoleSet()) {
                RoleExcel.DataRangeSheet dataRange = roleDataRangeMap.getOrDefault(role.getRoleNumber(), new RoleExcel.DataRangeSheet());
                for (MemberRoleSheet.FunctionType fun : dataRange.getFuns()) {
                    Collection<List<MemberRoleSheet.Dim>> listGroupDims = fun.getDims().stream().filter(dim -> Objects.nonNull(dim) && Objects.nonNull(dim.getNumber())).collect(Collectors.groupingBy(MemberRoleSheet.Dim::getGroupId)).values();
                    if (kd.bos.util.CollectionUtils.isNotEmpty(listGroupDims)) {
                        for (List<MemberRoleSheet.Dim> groupDims : listGroupDims) {
                            this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle, dataRange.getRoleNumber());
                            this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle, dataRange.getRoleName());
                            this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle, fun.getName());
                            this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle, fun.getBuOrgs().stream().map(it -> String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011%3$s\uff1b", (String)"TemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), it.getLeft(), it.getMiddle(), (Boolean)it.getRight() != false ? PermInitServiceHelper.getContainsSubText() : "")).reduce((acc, item) -> acc + "\n" + item).orElse(""));
                            int dimNextColumnIndex = 4;
                            HashMap<String, MemberRoleSheet.Dim> allDimSet = new HashMap<String, MemberRoleSheet.Dim>();
                            List sortedDimList = groupDims.stream().sorted(this.getDimComparator()).collect(Collectors.toList());
                            for (MemberRoleSheet.Dim dim2 : sortedDimList) {
                                if (null != dim2.getStructProject() && !dim2.getStructProject().isEmpty()) {
                                    dim2.getStructProject().forEach(cf -> {
                                        ArrayList<DimValueBean> classifyDimValues = new ArrayList<DimValueBean>(dim2.getDimValues());
                                        classifyDimValues.addAll((Collection)cf.getRight());
                                        MemberRoleSheet.Dim classifyDim = new MemberRoleSheet.Dim(dim2.getGroupId(), dim2.getId(), dim2.getName(), dim2.getNumber(), dim2.getEnable(), dim2.getDataSource(), new HashSet<Triple<String, String, List<DimValueBean>>>(dim2.getStructProject()), dim2.isAll(), classifyDimValues);
                                        allDimSet.put(dim2.getNumber() + "#" + (String)cf.getLeft(), classifyDim);
                                    });
                                    continue;
                                }
                                allDimSet.put(dim2.getNumber(), dim2);
                            }
                            while (dimNextColumnIndex < lastColumnIndex) {
                                MemberRoleSheet.Dim dim3 = (MemberRoleSheet.Dim)allDimSet.get(sheet.getRow(1).getCell(dimNextColumnIndex).getStringCellValue());
                                if (Objects.nonNull(dim3)) {
                                    String cellValue = "ALL";
                                    if (!dim3.isAll()) {
                                        cellValue = dim3.getDimValues().stream().filter(Objects::nonNull).map(it -> String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011%3$s\uff1b", (String)"TemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), it.getDimValCode(), it.getDimValName(), it.isContainsSub() ? PermInitServiceHelper.getContainsSubText() : "")).reduce((acc, item) -> acc + "\n" + item).orElse("");
                                    }
                                    this.addCellRegion((Sheet)sheet, rowIndex, dimNextColumnIndex, commonCellStyle, cellValue);
                                }
                                ++dimNextColumnIndex;
                            }
                            ++rowIndex;
                        }
                        continue;
                    }
                    this.addCellRegion((Sheet)sheet, rowIndex, 0, commonCellStyle, dataRange.getRoleNumber());
                    this.addCellRegion((Sheet)sheet, rowIndex, 1, commonCellStyle, dataRange.getRoleName());
                    this.addCellRegion((Sheet)sheet, rowIndex, 2, commonCellStyle, fun.getName());
                    this.addCellRegion((Sheet)sheet, rowIndex, 3, commonCellStyle, fun.getBuOrgs().stream().map(it -> String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011%3$s\uff1b", (String)"TemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), it.getLeft(), it.getMiddle(), (Boolean)it.getRight() != false ? PermInitServiceHelper.getContainsSubText() : "")).reduce((acc, item) -> acc + "\n" + item).orElse(""));
                    ++rowIndex;
                }
            }
        }
    }

    public void addDimHeader(XSSFSheet sheet, RoleExcel roleExcel) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1.\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2.\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3.\u4e0d\u5141\u8bb8\u8c03\u6574\u7ef4\u5ea6\u5217\uff1b4.\u52fe\u9009\u5f53\u524d\u89d2\u8272\u9700\u8981\u63a7\u6743\u7684\u7ef4\u5ea6\uff1b5.\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\u3002", (String)"RoleTemplateExcelWriter_34", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        centerCellStyle.setWrapText(true);
        this.addDimHeaderCol(sheet, 1, 0);
        int draft = this.isShowErrMsg ? 1 : 0;
        Set dimNumberSet = null;
        if (null != roleExcel) {
            dimNumberSet = roleExcel.getDim().getList().stream().map(Pair::getKey).map(Pair::getKey).collect(Collectors.toSet());
        }
        List dimList = this.permRoleFuncService.getDimList(dimNumberSet);
        String content = ResManager.loadKDString((String)"\u89d2\u8272\u7ef4\u5ea6", (String)"RoleTemplateExcelWriter_39", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"\u6839\u636e\u201c\u89d2\u8272\u529f\u80fd\u6743\u9650\u201d\u9875\u7b7e\uff0c\u83b7\u53d6\u89d2\u8272\u5404\u804c\u80fd\u4e0b\u7684\u7ef4\u5ea6\u3002", (String)"RoleTemplateExcelWriter_40", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        if (dimList.size() > 1) {
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, 2, 2, 3 + draft, 2 + dimList.size() + draft, centerCellStyle, content, tip);
        } else if (dimList.size() > 0) {
            this.addCellRegionWithWhiteBorder((Sheet)sheet, 2, 3 + draft, centerCellStyle, content, tip);
        }
        int col = 3 + draft;
        XSSFRow row = sheet.getRow(3);
        row.setHeight((short)768);
        for (DynamicObject dim : dimList) {
            this.addCellRegion((Sheet)sheet, 1, col, centerCellStyle, dim.getString("number"));
            this.addCellRegion((Sheet)sheet, 3, col, centerCellStyle, dim.getString("name"));
            ++col;
        }
        if (dimList.size() > 0) {
            CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(4, 99999, 3 + draft, col - 1);
            this.fillGouCombo((Sheet)sheet, cellRangeAddressList);
        }
    }

    private void addDimBody(XSSFSheet sheet, RoleExcel roleExcel) {
        if (null != roleExcel) {
            CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
            commonCellStyle.setWrapText(false);
            List<Pair<Pair<String, String>, Triple<String, String, String>>> list = roleExcel.getDim().getList();
            int columnIndexStart = this.isShowErrMsg ? 4 : 3;
            AtomicInteger columnIndex = new AtomicInteger(columnIndexStart);
            list.stream().filter(Objects::nonNull).map(Pair::getKey).distinct().filter(Objects::nonNull).forEach(dim -> {
                this.addCellRegion((Sheet)sheet, 1, columnIndex.get()).setCellValue((String)dim.getKey());
                this.addCellRegion((Sheet)sheet, 3, columnIndex.getAndIncrement()).setCellValue((String)dim.getValue());
            });
            AtomicInteger rowIndex = new AtomicInteger(4);
            Map<Triple, List<Pair>> map = list.stream().collect(Collectors.groupingBy(Pair::getValue));
            List<Map.Entry<Object, List<Object>>> items = new ArrayList<Map.Entry<Triple, List<Pair>>>(map.entrySet());
            if (!HRStringUtils.equals((String)"1", (String)roleExcel.getSource())) {
                List sortedRoleNumbers = roleExcel.getRoleSet().stream().map(RoleExcel.RoleSheet::getRoleNumber).collect(Collectors.toList());
                Comparator<Map.Entry> comparator = Comparator.comparing(item -> {
                    int index = sortedRoleNumbers.indexOf(((Triple)item.getKey()).getLeft());
                    return -1 == index ? Integer.MAX_VALUE : index;
                });
                items = map.entrySet().stream().sorted(comparator).collect(Collectors.toList());
            } else {
                items = map.entrySet().stream().sorted(Comparator.comparing(it -> (String)((Triple)it.getKey()).getLeft() + (String)((Triple)it.getKey()).getRight())).collect(Collectors.toList());
            }
            int draft = this.isShowErrMsg ? 1 : 0;
            Map<String, String> roleDimErrMsgMap = roleExcel.getDim().getRoleDimErrMsgMap();
            for (Map.Entry<Object, List<Object>> entry : items) {
                String rowKey = (String)((Triple)entry.getKey()).getLeft() + "#" + (String)((Triple)entry.getKey()).getRight();
                if (this.isShowErrMsg && roleDimErrMsgMap.get(rowKey) != null) {
                    this.addCellRegion((Sheet)sheet, rowIndex.get(), 0, this.getErrorCellStyle(), roleDimErrMsgMap.get(rowKey));
                }
                this.addCellRegion((Sheet)sheet, rowIndex.get(), 0 + draft, commonCellStyle, (String)((Triple)entry.getKey()).getLeft());
                this.addCellRegion((Sheet)sheet, rowIndex.get(), 1 + draft, commonCellStyle, (String)((Triple)entry.getKey()).getMiddle());
                this.addCellRegion((Sheet)sheet, rowIndex.get(), 2 + draft, commonCellStyle, (String)((Triple)entry.getKey()).getRight());
                Set dimSet = entry.getValue().stream().map(it -> (String)((Pair)it.getKey()).getKey()).collect(Collectors.toSet());
                for (int index = 3 + draft; index <= columnIndex.get() + draft; ++index) {
                    XSSFCell tempCell = sheet.getRow(1).getCell(index);
                    if (null != tempCell && dimSet.contains(tempCell.getStringCellValue())) {
                        this.addCellRegion((Sheet)sheet, rowIndex.get(), index, commonCellStyle, "\u221a");
                        continue;
                    }
                    this.addCellRegion((Sheet)sheet, rowIndex.get(), index, commonCellStyle, "");
                }
                rowIndex.incrementAndGet();
            }
            if (this.isShowErrMsg) {
                List<Triple<String, String, String>> appendErrMsgs = roleExcel.getDim().getAppendErrMsgs();
                for (Triple<String, String, String> item3 : appendErrMsgs) {
                    this.addCellRegion((Sheet)sheet, rowIndex.get(), 0, this.getErrorCellStyle(), (String)item3.getRight());
                    this.addCellRegion((Sheet)sheet, rowIndex.get(), draft, commonCellStyle, (String)item3.getLeft());
                    this.addCellRegion((Sheet)sheet, rowIndex.get(), 2 + draft, commonCellStyle, (String)item3.getMiddle());
                    rowIndex.incrementAndGet();
                }
            }
        }
    }

    public Map<String, Integer> addDimHeaderCol(XSSFSheet sheet, int startRow, int startCol) {
        String content;
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        mustCellStyle.setWrapText(true);
        cellStyle.setWrapText(true);
        int draft = this.isShowErrMsg ? 1 : 0;
        HashMap colIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft).setCellValue("roleNumber");
        colIndexMap.put("roleNumber", startCol);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 1).setCellValue("roleName");
        colIndexMap.put("roleName", startCol + draft + 1);
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft + 2).setCellValue("buCaFuncName");
        colIndexMap.put("buCaFuncName", startCol + draft + 2);
        RoleTemplateExcelWriter.getRow(sheet, startRow).getCTRow().setHidden(true);
        if (this.isShowErrMsg) {
            content = ResManager.loadKDString((String)"\u9519\u8bef\u8bf4\u660e", (String)"RoleTemplateExcelWriter_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 2, startCol, startCol, mustCellStyle, content, "");
            sheet.setColumnWidth(0, content.getBytes().length * 400);
        }
        content = ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"RoleTemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u9875\u7b7e\u7684\u89d2\u8272", (String)"RoleTemplateExcelWriter_56", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 2, startCol + draft, startCol + draft, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + draft, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"RoleTemplateExcelWriter_35", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 2, startCol + draft + 1, startCol + draft + 1, cellStyle, content);
        sheet.setColumnWidth(startCol + draft + 1, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"*\u804c\u80fd\u7c7b\u578b", (String)"RoleTemplateExcelWriter_36", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u53ef\u6839\u636e\u300a\u89d2\u8272\u529f\u80fd\u6743\u9650\u300b\u9875\u7b7e\u83b7\u53d6\u89d2\u8272\u7684\u804c\u80fd\u7c7b\u578b", (String)"RoleTemplateExcelWriter_38", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 2, startCol + draft + 2, startCol + draft + 2, mustCellStyle, content, tip);
        sheet.setColumnWidth(startCol + draft + 2, content.getBytes().length * 192);
        sheet.createFreezePane(3 + draft, 4);
        return colIndexMap;
    }

    public void addFunctionItemHeader(XSSFSheet sheet) {
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u7070\u8272\u5217\u4e3a\u7cfb\u7edf\u81ea\u52a8\u52a0\u8f7d\u6570\u636e\u4e0d\u5141\u8bb8\u8c03\u6574\uff1b4\u3001\u8bf7\u6309\u89d2\u8272\u52fe\u9009\u529f\u80fd\u6743\u9650\u9879\uff1b5\u3001\u5f53\u8c03\u6574\u4e86\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u540e\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u9875\u7b7e\u7684\u89d2\u8272\u4e0e\u5bf9\u5e94\u7684\u529f\u80fd\u6743\u9650\u9879\u662f\u5426\u6b63\u786e\u3002", (String)"RoleTemplateExcelWriter_21", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addFunctionItemHeaderCol(sheet, 1, 0);
        CellStyle centerCellStyle = this.styles.getTitleStyle("header-center");
        String roleSheetName = ResManager.loadKDString((String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f", (String)"PermSheetHelper_91", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        int index = this.isShowErrMsg ? 1 : 0;
        for (int i = 6 + index; i < 306 + index; ++i) {
            Cell cell = this.addCellRegion((Sheet)sheet, 2, i + 3);
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(centerCellStyle);
            String str = "IF(COUNTBLANK(" + roleSheetName + (this.isShowErrMsg ? "!B" : "!A") + (i - index) + "),\"\",TRANSPOSE(" + roleSheetName + (this.isShowErrMsg ? "!B" : "!A") + (i - index) + "))";
            cell.setCellFormula(str);
            Cell cell2 = this.addCellRegion((Sheet)sheet, 3, i + 3);
            cell2.setCellStyle(centerCellStyle);
            cell2.setCellType(CellType.STRING);
            String str2 = "IF(COUNTBLANK(" + roleSheetName + (this.isShowErrMsg ? "!C" : "!B") + (i - index) + "),\"\",TRANSPOSE(" + roleSheetName + (this.isShowErrMsg ? "!C" : "!B") + (i - index) + "))";
            cell2.setCellFormula(str2);
        }
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(4 + index, 99999 + index, 9 + index, 308 + index);
        this.fillGouCombo((Sheet)sheet, cellRangeAddressList);
    }

    public Map<String, Integer> addFunctionItemHeaderCol(XSSFSheet sheet, int startRow, int startCol) {
        HashMap colIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        int draft = this.isShowErrMsg ? 1 : 0;
        this.addCellRegion((Sheet)sheet, startRow, startCol + draft).setCellValue("cloudNum");
        colIndexMap.put("cloudNum", startCol + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 1 + draft).setCellValue("cloudName");
        colIndexMap.put("cloudName", startCol + 1 + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 2 + draft).setCellValue("appNum");
        colIndexMap.put("appNum", startCol + 2 + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 3 + draft).setCellValue("appName");
        colIndexMap.put("appName", startCol + 3 + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 4 + draft).setCellValue("entityNum");
        colIndexMap.put("entityNum", startCol + 4 + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 5 + draft).setCellValue("entityName");
        colIndexMap.put("entityName", startCol + 5 + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 6 + draft).setCellValue("name");
        colIndexMap.put("name", startCol + 6 + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 7 + draft).setCellValue("buCaFuncName");
        colIndexMap.put("buCaFuncName", startCol + 7 + draft);
        this.addCellRegion((Sheet)sheet, startRow, startCol + 8 + draft).setCellValue("dimName");
        colIndexMap.put("dimName", startCol + 8 + draft);
        RoleTemplateExcelWriter.getRow(sheet, startRow).getCTRow().setHidden(true);
        XSSFCellStyle centerCellStyle = (XSSFCellStyle)this.styles.getTitleStyle("header-center2");
        centerCellStyle.setBorderBottom(BorderStyle.THIN);
        centerCellStyle.setBottomBorderColor(IndexedColors.WHITE.getIndex());
        centerCellStyle.setBorderTop(BorderStyle.THIN);
        centerCellStyle.setTopBorderColor(IndexedColors.WHITE.getIndex());
        centerCellStyle.setBorderRight(BorderStyle.THIN);
        centerCellStyle.setRightBorderColor(IndexedColors.WHITE.getIndex());
        centerCellStyle.setBorderLeft(BorderStyle.THIN);
        centerCellStyle.setLeftBorderColor(IndexedColors.WHITE.getIndex());
        centerCellStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont headerCellFont = centerCellStyle.getFont();
        headerCellFont.setBold(true);
        headerCellFont.setFontHeightInPoints((short)12);
        String content = ResManager.loadKDString((String)"\u529f\u80fd\u83dc\u5355", (String)"RoleTemplateExcelWriter_22", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String tip = ResManager.loadKDString((String)"\u8bf7\u52ff\u4fee\u6539\u7070\u8272\u5217\uff0c\u8be5\u5217\u4e3a\u7cfb\u7edf\u6570\u636e\u3002", (String)"PermImportRoleFailedSheetHandler_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        int index = 0;
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 1, startCol + draft, startCol + 8 + draft, (CellStyle)centerCellStyle, content, tip);
        if (this.isShowErrMsg) {
            content = ResManager.loadKDString((String)"\u9519\u8bef\u8bf4\u660e", (String)"RoleTemplateExcelWriter_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 2 - draft, startRow + 2, startCol, startCol + index++, (CellStyle)centerCellStyle, content, content);
            sheet.setColumnWidth(0, content.getBytes().length * 400);
        }
        content = ResManager.loadKDString((String)"\u4e91\u7f16\u7801", (String)"RoleTemplateExcelWriter_23", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u4e91\u540d\u79f0", (String)"RoleTemplateExcelWriter_24", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801", (String)"RoleTemplateExcelWriter_25", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u5e94\u7528\u540d\u79f0", (String)"RoleTemplateExcelWriter_26", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"RoleTemplateExcelWriter_27", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u540d\u79f0", (String)"RoleTemplateExcelWriter_28", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u6743\u9650\u9879", (String)"RoleTemplateExcelWriter_31", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b", (String)"RoleTemplateExcelWriter_29", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u6240\u5c5e\u7684\u804c\u80fd\u7c7b\u578b\uff0c\u914d\u7f6e\u201c\u89d2\u8272\u6570\u636e\u8303\u56f4\u201d\u65f6\u53ef\u53c2\u8003\u3002", (String)"RoleTemplateExcelWriter_32", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content, tip);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"RoleTemplateExcelWriter_30", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61\u7684\u6570\u636e\u63a7\u6743\u7ef4\u5ea6\uff0c\u5fc5\u9009\u7ef4\u5ea6\u6807\u4e3a\u7ea2\u8272\u3002\u82e5\u52fe\u9009\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61\u7684\u89d2\u8272\uff0c\u5219\u9700\u5728\u201c\u89d2\u8272\u7ef4\u5ea6\u201d\u9875\u7b7e\u52fe\u9009\u76f8\u5e94\u7ef4\u5ea6\u3002", (String)"RoleTemplateExcelWriter_33", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addCellRegion((Sheet)sheet, startRow + 2, startCol + index, (CellStyle)centerCellStyle, content, tip);
        sheet.setColumnWidth(startCol + index++, content.getBytes().length * 192);
        int idx = this.isShowErrMsg ? 1 : 0;
        sheet.createFreezePane(9 + idx, 4);
        return colIndexMap;
    }

    public void doAddFunctionItemBody(XSSFSheet sheet, RoleExcel roleExcel) {
        CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        Map hrAppMap = this.permRoleFuncService.getHRAppMap();
        Map entityGroup = this.permRoleFuncService.getEntityGroup(hrAppMap.keySet());
        if (null != roleExcel) {
            Set roleIds = roleExcel.getRoleSet().stream().map(RoleExcel.RoleSheet::getRoleId).collect(Collectors.toSet());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_roleperm");
            DynamicObject[] rolePerms = serviceHelper.query("roleid.id,roleid.number,roleid.name,roleperm.entity,roleperm.permitem,roleperm.bizapp", new QFilter[]{new QFilter("roleid.id", "in", roleIds)});
            Map<String, Pair> rolePermMap = Arrays.stream(rolePerms).flatMap(it -> it.getDynamicObjectCollection("roleperm").stream()).collect(Collectors.toMap(it -> it.getString("permitem.id") + "#" + it.getString("entity.id") + "#" + it.getString("bizapp.id"), it -> Pair.of((Object)it.getString("entity.id"), (Object)it.getDynamicObject("bizapp")), (oldValue, newValue) -> oldValue));
            entityGroup.putAll(rolePermMap.values().stream().filter(it -> it.getValue() != null).distinct().collect(Collectors.groupingBy(it -> ((DynamicObject)it.getValue()).getString("id"), Collectors.mapping(Pair::getKey, Collectors.toList()))));
        }
        HashSet entityNumSet = Sets.newHashSetWithExpectedSize((int)16);
        entityGroup.forEach((key, value) -> entityNumSet.addAll(value));
        Map hrFuncItemGroup = this.permRoleFuncService.getHRFuncItemGroup((Set)entityNumSet);
        this.permRoleFuncService.removeFuncItemByForbid(hrFuncItemGroup);
        Map removeFuncItemByForbid = this.permRoleFuncService.getRemoveFuncItemByForbid();
        Map removeRelItemMap = this.permRoleFuncService.getRemoveRelItemMap(entityGroup);
        Map funcMap = HRBuCaServiceHelper.getBuCaFuncFromSpec((Map)entityGroup);
        Map dimMap = this.permRoleFuncService.getDimMap((Set)entityNumSet);
        HRBaseServiceHelper entityServiceHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject[] entityResults = entityServiceHelper.query("id,number,name,dentityid", new QFilter[]{new QFilter("id", "in", (Object)entityNumSet)});
        Map<String, DynamicObject> entityMap = Arrays.stream(entityResults).collect(Collectors.toMap(er -> er.getString("id"), er -> er));
        Set entities = entityGroup.values().stream().flatMap(Collection::stream).map(it -> "'" + it + "'").collect(Collectors.toSet());
        HashSet<String> notAllowedEntities = new HashSet<String>();
        String sql = "SELECT FNUMBER from T_META_ENTITY WHERE FKEY = 'CtrlType' AND FTYPE = '24' AND FDATA like '%\"controlFunction\":false%' AND FNUMBER in (" + String.join((CharSequence)",", entities) + ")";
        DataSet ds = HRDBUtil.queryDataSet((String)"queryMetasByApp", (DBRoute)DBRoute.meta, (String)sql, null);
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                notAllowedEntities.add(row.getString("FNUMBER"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        int rowIndex = this.isShowErrMsg ? 5 : 4;
        for (Map.Entry entry : entityGroup.entrySet()) {
            String appName;
            String appNum;
            String appId = (String)entry.getKey();
            List entityNumList = (List)entry.getValue();
            Map entityFuncMap = (Map)funcMap.get(appId);
            DynamicObject app = (DynamicObject)hrAppMap.get(appId);
            if (null == app) {
                LOGGER.info("Got empty app with appId: {} and entityNumList: {}.", (Object)appId, (Object)entityNumList);
                continue;
            }
            String masterId = app.getString("masterid");
            if (HRStringUtils.isEmpty((String)masterId)) {
                appNum = app.getString("number");
                appName = app.getString("name");
            } else {
                DynamicObject originApp = (DynamicObject)hrAppMap.get(masterId);
                appNum = originApp.getString("number");
                appName = originApp.getString("name");
            }
            for (String entityNum : entityNumList) {
                List removeItemList;
                block31: {
                    try {
                        if (notAllowedEntities.contains(entityNum)) {
                        }
                        break block31;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Get data entity type error.", (Throwable)exception);
                    }
                    continue;
                }
                List itemList = (List)hrFuncItemGroup.get(entityNum);
                if (itemList == null) continue;
                Map entityItemMap = (Map)removeFuncItemByForbid.get(appId);
                if (entityItemMap != null && (removeItemList = (List)entityItemMap.get(entityNum)) != null) {
                    itemList.removeIf(item -> removeItemList.contains(item.getString("permitem.id")));
                }
                DynamicObject dim = (DynamicObject)dimMap.get(entityNum);
                DynamicObject func = (DynamicObject)entityFuncMap.get(entityNum);
                DynamicObject entity = entityMap.get(entityNum);
                if (null == entity) {
                    LOGGER.info("Got empty entity from entityMap with entityNum: {}.", (Object)entityNum);
                    continue;
                }
                String dEntityId = entity.getString("dentityid");
                List removeItemList2 = (List)removeRelItemMap.get(appId + "#" + entityNum);
                for (DynamicObject item2 : itemList) {
                    String itemNum = item2.getString("permitem.number");
                    String entityTypeId = item2.getString("entitytypeid");
                    String itemName = item2.getString("permitem.name") == null ? "" : item2.getString("permitem.name").trim();
                    if (HRStringUtils.isEmpty((String)itemName) || !HRStringUtils.equals((String)dEntityId, (String)entityTypeId) || removeItemList2 != null && removeItemList2.contains(itemNum)) continue;
                    int colIndex = this.isShowErrMsg ? 1 : 0;
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, app.getString("bizcloud.number"));
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, app.getString("bizcloud.name"));
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, appNum);
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, appName);
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, entity.getString("number"));
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, entity.getString("name"));
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, itemName);
                    this.addCellRegion((Sheet)sheet, rowIndex, colIndex++, commonCellStyle, func.getString("name"));
                    if (dim != null) {
                        StringBuilder stringBuilder = new StringBuilder();
                        DynamicObjectCollection dimEntry = dim.getDynamicObjectCollection("entryentity");
                        ArrayList redIndexList = Lists.newArrayListWithExpectedSize((int)dimEntry.size());
                        int redStartIndex = 0;
                        HashSet nameSet = Sets.newHashSetWithExpectedSize((int)dimEntry.size());
                        for (DynamicObject row : dimEntry) {
                            boolean isMust = row.getBoolean("ismust");
                            String name = row.getString("dimension.name");
                            if (HRStringUtils.isEmpty((String)name) || !nameSet.add(name)) continue;
                            stringBuilder.append(name).append(",");
                            if (isMust) {
                                redIndexList.add(Pair.of((Object)redStartIndex, (Object)(redStartIndex + name.length())));
                            }
                            redStartIndex = redStartIndex + name.length() + 1;
                        }
                        if (stringBuilder.length() > 0) {
                            Cell cell = this.addCellRegion((Sheet)sheet, rowIndex, colIndex, commonCellStyle, "");
                            Font originalFont = this.wb.createFont();
                            originalFont.setFontHeightInPoints((short)12);
                            originalFont.setColor(IndexedColors.RED.getIndex());
                            XSSFRichTextString richTextString = new XSSFRichTextString(stringBuilder.substring(0, stringBuilder.length() - 1));
                            for (Pair pair : redIndexList) {
                                richTextString.applyFont(((Integer)pair.getKey()).intValue(), ((Integer)pair.getValue()).intValue(), originalFont);
                            }
                            cell.setCellValue((RichTextString)richTextString);
                        }
                    }
                    ++rowIndex;
                }
            }
        }
    }

    private void addFunctionItemBody(XSSFSheet sheet, RoleExcel roleExcel) {
        this.doAddFunctionItemBody(sheet, roleExcel);
        if (null == roleExcel) {
            return;
        }
        CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
        commonCellStyle.setWrapText(false);
        XSSFCellStyle errorCellStyle = this.wb.getXSSFWorkbook().createCellStyle();
        errorCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        errorCellStyle.setDataFormat(this.wb.getXSSFWorkbook().createDataFormat().getFormat("@"));
        errorCellStyle.setAlignment(HorizontalAlignment.GENERAL);
        Font font = this.wb.createFont();
        font.setBold(true);
        font.setColor(IndexedColors.RED.getIndex());
        errorCellStyle.setFont(font);
        Map<String, Set> roleNumberMap = roleExcel.getFunctionItemSet().stream().collect(Collectors.toMap(it -> it.getCloudNumber() + "#" + it.getAppNumber() + "#" + it.getEntityNumber() + "#" + it.getName(), it -> it.getRoleSet().stream().map(Pair::getKey).collect(Collectors.toSet()), (oldValue, newValue) -> oldValue));
        HashMap allRoleErrMsgMap = new HashMap();
        roleExcel.getFunctionItemSet().forEach(it -> allRoleErrMsgMap.putAll(it.getRoleErrMsg()));
        Map<String, String> permErrMap = roleExcel.getFunctionItemSet().stream().filter(it -> HRStringUtils.isNotEmpty((String)it.getPermErrMsg())).collect(Collectors.toMap(it -> it.getCloudNumber() + "#" + it.getAppNumber() + "#" + it.getEntityNumber() + "#" + it.getName(), it -> it.getPermErrMsg(), (newVal, oldVal) -> newVal));
        XSSFFormulaEvaluator formulaEvaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        HashMap<Integer, String> roleNumberCache = new HashMap<Integer, String>();
        int lastRow = sheet.getLastRowNum();
        int lastColumn = roleExcel.getRoleSet().size();
        ArrayList hasRoleErrorColumnList = Lists.newArrayListWithExpectedSize((int)lastColumn);
        for (int rowIndex = this.isShowErrMsg ? 5 : 4; rowIndex <= lastRow; ++rowIndex) {
            XSSFRow row = sheet.getRow(rowIndex);
            int index = this.isShowErrMsg ? 1 : 0;
            String key = row.getCell(index).getStringCellValue() + "#" + row.getCell(2 + index).getStringCellValue() + "#" + row.getCell(4 + index).getStringCellValue() + "#" + row.getCell(6 + index).getStringCellValue();
            if (this.isShowErrMsg && permErrMap.containsKey(key)) {
                this.addCellRegion((Sheet)sheet, rowIndex, 0, (CellStyle)errorCellStyle, permErrMap.get(key));
            }
            Set roleNumberSet = roleNumberMap.getOrDefault(key, new HashSet());
            for (int columnIndex = 9 + index; columnIndex <= 8 + index + lastColumn; ++columnIndex) {
                String roleNumber = roleNumberCache.computeIfAbsent(columnIndex, arg_0 -> RoleTemplateExcelWriter.lambda$addFunctionItemBody$35(sheet, (FormulaEvaluator)formulaEvaluator, arg_0));
                if (roleNumberSet.contains(roleNumber)) {
                    this.addCellRegion((Sheet)sheet, rowIndex, columnIndex, commonCellStyle, "\u221a");
                }
                if (this.isShowErrMsg && allRoleErrMsgMap.containsKey(roleNumber) && !hasRoleErrorColumnList.contains(columnIndex)) {
                    Font redFont = this.wb.createFont();
                    redFont.setBold(true);
                    redFont.setColor(IndexedColors.RED.getIndex());
                    errorCellStyle.setFont(redFont);
                    this.addCellRegion((Sheet)sheet, 4, columnIndex, (CellStyle)errorCellStyle, (String)allRoleErrMsgMap.get(roleNumber));
                }
                hasRoleErrorColumnList.add(columnIndex);
            }
        }
    }

    public void addRoleHeader(XSSFSheet sheet) {
        LOGGER.info("Begin  addRoleHeader.");
        this.addCellRegionWithWhiteBorder((Sheet)sheet, 0, 0, this.styles.getTitleStyle(), ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a1\u3001\u9875\u7b7e\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539\uff1b2\u3001\u6807*\u7684\u8bb0\u5f55\u4e3a\u5fc5\u586b\u9879\uff1b3\u3001\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\u53ef\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42\uff1b4\u3001\u4e00\u6b21\u6700\u591a\u5bfc\u5165300\u4e2a\u89d2\u8272\uff1b5\u3001\u5f53\u8c03\u6574\u4e86\u300a\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u300b\u540e\uff0c\u8bf7\u68c0\u67e5\u300a\u89d2\u8272\u529f\u80fd\u6743\u9650\u300b\u9875\u7b7e\u4e2d\u89d2\u8272\u5217\u52fe\u9009\u7684\u6743\u9650\u9879\u662f\u5426\u6b63\u786e\u3002", (String)"RoleTemplateExcelWriter_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        this.addRoleHeaderCol(sheet, 1, 0);
    }

    private void addRoleBody(XSSFSheet sheet, RoleExcel roleExcel) {
        if (null != roleExcel) {
            InteServiceImpl intService = new InteServiceImpl();
            List enabledLangList = intService.getEnabledLang();
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hrcs_roleinitdemo_role");
            CellStyle commonCellStyle = this.styles.getTextStyle("body-common1");
            commonCellStyle.setWrapText(false);
            int rowIndex = 5;
            for (RoleExcel.RoleSheet role : roleExcel.getRoleSet()) {
                int startIndex = -1;
                if (this.isShowErrMsg) {
                    this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, this.getErrorCellStyle(), role.getErrorMsg());
                }
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, role.getRoleNumber());
                for (EnabledLang enabledLang : enabledLangList) {
                    this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, (String)role.getRoleName().get((Object)enabledLang.number));
                }
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, role.getRoleGroupNumber());
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, role.getRoleGroupName());
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, ((ComboProp)mainType.getAllFields().get("roleproperty")).getItemByName(role.getRoleProperty()));
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, HRStringUtils.equals((String)"0", (String)role.getRoleProperty()) ? "" : ((ComboProp)mainType.getAllFields().get("rolecbisintersection")).getItemByName(role.getRoleCBisIntersection()));
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, ((ComboProp)mainType.getAllFields().get("usescope")).getItemByName(role.getUseScope()));
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, role.getCreateAdminGrpNumber());
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, role.getCreateAdminGrpName());
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, role.getOpenRangeWithView());
                this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, role.getOpenRangeWithEdit());
                for (EnabledLang enabledLang : enabledLangList) {
                    this.addCellRegion((Sheet)sheet, rowIndex, ++startIndex, commonCellStyle, (String)role.getRoleRemark().get((Object)enabledLang.number));
                }
                ++rowIndex;
            }
        }
    }

    public Map<String, Integer> addRoleHeaderCol(XSSFSheet sheet, int startRow, int startCol) {
        String tip;
        String content;
        int j;
        String key;
        LOGGER.info("Begin  addRoleHeader 2.");
        if (this.isShowErrMsg) {
            ++startCol;
        }
        this.addCellRegion((Sheet)sheet, startRow, startCol).setCellValue("roleNumber");
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        int i = startCol + 1;
        Lang lang = RequestContext.get().getLang();
        enabledLangList.sort((x1, x2) -> {
            if (lang.name().equals(x2.getNumber())) {
                return 1;
            }
            if (lang.name().equals(x1.getNumber())) {
                return -1;
            }
            return 0;
        });
        HashMap colIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        for (EnabledLang enabledLang : enabledLangList) {
            key = "roleName_" + enabledLang.getNumber();
            this.addCellRegion((Sheet)sheet, startRow, i).setCellValue(key);
            colIndexMap.put(key, i);
            ++i;
        }
        this.addCellRegion((Sheet)sheet, startRow, i).setCellValue("roleGroupNumber");
        colIndexMap.put("roleGroupNumber", i);
        this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue("roleGroupName");
        colIndexMap.put("roleGroupName", i);
        this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue("roleProperty");
        colIndexMap.put("roleProperty", i);
        this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue("roleCBisIntersection");
        colIndexMap.put("roleCBisIntersection", i);
        this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue("useScope");
        colIndexMap.put("useScope", i);
        this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue("createAdminGrpNumber");
        colIndexMap.put("createAdminGrpNumber", i);
        this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue("createAdminGrpName");
        colIndexMap.put("createAdminGrpName", i);
        this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue("openRangeWithView");
        colIndexMap.put("openRangeWithView", i);
        this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue("openRangeWithEdit");
        colIndexMap.put("openRangeWithEdit", i);
        for (EnabledLang enabledLang : enabledLangList) {
            key = "roleRemark_" + enabledLang.getNumber();
            this.addCellRegion((Sheet)sheet, startRow, ++i).setCellValue(key);
            colIndexMap.put(key, i);
        }
        RoleTemplateExcelWriter.getRow(sheet, startRow).getCTRow().setHidden(true);
        LOGGER.info("Begin  addRoleHeader3.");
        CellStyle mustCellStyle = this.styles.getTitleMustInputStyle();
        mustCellStyle.setAlignment(HorizontalAlignment.CENTER);
        CellStyle cellStyle = this.styles.getTitleStyle("header");
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setWrapText(true);
        mustCellStyle.setWrapText(true);
        int n = j = this.isShowErrMsg ? 0 : startCol;
        if (this.isShowErrMsg) {
            content = ResManager.loadKDString((String)"\u9519\u8bef\u8bf4\u660e", (String)"RoleTemplateExcelWriter_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            tip = ResManager.loadKDString((String)"\u9519\u8bef\u8bf4\u660e", (String)"RoleTemplateExcelWriter_57", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, j, j, cellStyle, content, tip);
            sheet.setColumnWidth(0, content.getBytes().length * 192);
            ++j;
        }
        content = ResManager.loadKDString((String)"*\u89d2\u8272\u7f16\u7801", (String)"RoleTemplateExcelWriter_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"RoleTemplateExcelWriter_13", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, j, j, mustCellStyle, content, tip);
        sheet.setColumnWidth(j, content.getBytes().length * 192);
        tip = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"RoleTemplateExcelWriter_14", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        ++j;
        for (EnabledLang enabledLang : enabledLangList) {
            CellStyle style;
            if (lang.name().equals(enabledLang.getNumber())) {
                content = String.format(ResManager.loadKDString((String)"%1$s\u89d2\u8272\u540d\u79f0\uff08%2$s\uff09", (String)"RoleTemplateExcelWriter_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), "*", enabledLang.getName());
                style = mustCellStyle;
            } else {
                content = String.format(ResManager.loadKDString((String)"%1$s\u89d2\u8272\u540d\u79f0\uff08%2$s\uff09", (String)"RoleTemplateExcelWriter_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), "", enabledLang.getName());
                style = cellStyle;
            }
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, j, j, style, content, tip);
            sheet.setColumnWidth(j, content.getBytes().length * 120);
            ++j;
        }
        content = ResManager.loadKDString((String)"\u89d2\u8272\u7ec4\u7f16\u7801", (String)"RoleTemplateExcelWriter_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, j, j, cellStyle, content);
        sheet.setColumnWidth(j, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u7ec4\u540d\u79f0", (String)"RoleTemplateExcelWriter_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, ++j, j, cellStyle, content);
        sheet.setColumnWidth(j, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"*\u89d2\u8272\u6210\u5458\u8303\u56f4\u5c5e\u6027", (String)"RoleTemplateExcelWriter_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u662f\u5426\u5141\u8bb8\u89d2\u8272\u4e0b\u7528\u6237\u81ea\u5b9a\u4e49\u8303\u56f4\u3002\n\u5f55\u5165\u503c\uff1a\u5141\u8bb8\u81ea\u5b9a\u4e49\u8303\u56f4\u3001\u4e0d\u5141\u8bb8\u81ea\u5b9a\u4e49\u3002", (String)"RoleTemplateExcelWriter_15", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, ++j, j, mustCellStyle, content, tip);
        sheet.setColumnWidth(j, content.getBytes().length * 192);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"hrcs_role");
        ComboProp property = (ComboProp)mainEntityType.getProperty("property");
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(startRow + 4, startRow + 9999, j, j);
        this.fillCombo(sheet, property, cellRangeAddressList);
        content = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8303\u56f4\u662f\u5426\u53d7\u9650\u4e8e\u89d2\u8272\u8303\u56f4", (String)"RoleTemplateExcelWriter_62", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u5f53\u89d2\u8272\u6210\u5458\u8303\u56f4\u5c5e\u6027\u503c\u4e3a\u201c\u5141\u8bb8\u81ea\u5b9a\u4e49\u201d\u65f6\uff0c\u5fc5\u9700\u8bbe\u503c\uff1b\n\u5f55\u5165\u503c\uff1a\n\u81ea\u5b9a\u4e49\u8303\u56f4\u4e0d\u53d7\u89d2\u8272\u9650\u5236\uff1b\n\u81ea\u5b9a\u4e49\u8303\u56f4\u53d7\u89d2\u8272\u9650\u5236\uff1b\n\u4ec5\u81ea\u5b9a\u4e49\u6570\u636e\u8303\u56f4\u53d7\u89d2\u8272\u9650\u5236\uff1b\n\u4ec5\u81ea\u5b9a\u4e49\u5b57\u6bb5\u6743\u9650\u53d7\u89d2\u8272\u9650\u5236\u3002", (String)"RoleTemplateExcelWriter_63", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, ++j, j, cellStyle, content, tip);
        sheet.setColumnWidth(j, content.getBytes().length * 192);
        ComboProp isIntersection = (ComboProp)mainEntityType.getProperty("isintersection");
        CellRangeAddressList cellRangeAddressList2 = new CellRangeAddressList(startRow + 4, startRow + 9999, j, j);
        this.fillCombo(sheet, isIntersection, cellRangeAddressList2);
        content = ResManager.loadKDString((String)"*\u516c\u5f00\u72b6\u6001", (String)"RoleTemplateExcelWriter_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u72b6\u6001\u503c\u4e3a\uff1a\u516c\u5f00\u3001\u79c1\u6709\u3001\u5206\u914d\uff1b\n\u201c\u516c\u5f00\u72b6\u6001\u201d\u503c\u4e3a\u79c1\u6709\u3001\u5206\u914d\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u3002", (String)"RoleTemplateExcelWriter_64", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, ++j, j, mustCellStyle, content, tip);
        sheet.setColumnWidth(j, content.getBytes().length * 192);
        ComboProp userScope = (ComboProp)mainEntityType.getProperty("usescope");
        CellRangeAddressList cellRangeAddressList3 = new CellRangeAddressList(startRow + 4, startRow + 9999, j, j);
        this.fillCombo(sheet, userScope, cellRangeAddressList3);
        content = ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u7f16\u7801", (String)"RoleTemplateExcelWriter_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u201c\u516c\u5f00\u72b6\u6001\u201d\u503c\u4e3a\u201c\u79c1\u6709\u201d\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u3002", (String)"RoleTemplateExcelWriter_65", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, ++j, j, cellStyle, content, tip);
        sheet.setColumnWidth(j, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u540d\u79f0", (String)"RoleTemplateExcelWriter_9", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, ++j, j, cellStyle, content);
        sheet.setColumnWidth(j, content.getBytes().length * 192);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u67e5\u770b\uff09", (String)"RoleTemplateExcelWriter_10", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u201c\u516c\u5f00\u72b6\u6001\u201d\u503c\u4e3a\u201c\u5206\u914d\u201d\u65f6\uff0c\u53ef\u8bbe\u7f6e\u5176\u4ed6\u7ba1\u7406\u5458\u7ec4\u67e5\u770b\u5f53\u524d\u89d2\u8272\u3002", (String)"RoleTemplateExcelWriter_19", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, ++j, j, cellStyle, content, tip);
        sheet.setColumnWidth(j, content.getBytes().length * 120);
        content = ResManager.loadKDString((String)"\u89d2\u8272\u516c\u5f00\u8303\u56f4\uff08\u7f16\u8f91\uff09", (String)"RoleTemplateExcelWriter_11", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        tip = ResManager.loadKDString((String)"\u201c\u516c\u5f00\u72b6\u6001\u201d\u503c\u4e3a\u201c\u516c\u5f00\u201d\u6216\u201c\u5206\u914d\u201d\u65f6\uff0c\u53ef\u8bbe\u7f6e\u7ba1\u7406\u5458\u5206\u7ec4\u7f16\u8f91\u89d2\u8272\u3002", (String)"RoleTemplateExcelWriter_20", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, ++j, j, cellStyle, content, tip);
        sheet.setColumnWidth(j, content.getBytes().length * 120);
        ++j;
        for (EnabledLang enabledLang : enabledLangList) {
            content = ResManager.loadKDString((String)"\u89d2\u8272\u63cf\u8ff0\uff08%s\uff09", (String)"RoleTemplateExcelWriter_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{enabledLang.getName()});
            this.addMergedRegionWithWhiteBorder((Sheet)sheet, startRow + 1, startRow + 3, j, j, cellStyle, content);
            sheet.setColumnWidth(j, content.getBytes().length * 120);
            ++j;
        }
        LOGGER.info("End  addRoleHeader.");
        return colIndexMap;
    }

    private static XSSFRow getRow(XSSFSheet sheet, int r) {
        if (r >= 0x100000) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5bfc\u51fa\u7684\u603b\u6570\u636e\u884c\u6570\u8d85\u51faExcel\u6587\u4ef6\u6700\u5927\u884c\u6570%s\u884c\uff0c\u8bf7\u5408\u7406\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5206\u6279\u5bfc\u51fa\u3002", (String)"ExportDataTask_3", (String)"bos-export", (Object[])new Object[0]), 0x100000));
        }
        XSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    private void fillCombo(XSSFSheet sheet, ComboProp prop, CellRangeAddressList cellRangeAddressList) {
        String[] items = (String[])prop.getComboItems().stream().map(item -> item.getName().getLocaleValue()).toArray(String[]::new);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint dataScopeValueConstraint = helper.createExplicitListConstraint(items);
        DataValidation dataScopeDataValidation = helper.createValidation(dataScopeValueConstraint, cellRangeAddressList);
        sheet.addValidationData(dataScopeDataValidation);
    }

    private void fillGouCombo(Sheet sheet, CellRangeAddressList cellRangeAddressList) {
        String[] items = new String[]{ResManager.loadKDString((String)"\u221a", (String)"RoleTemplateExcelWriter_58", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])};
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint dataScopeValueConstraint = helper.createExplicitListConstraint(items);
        DataValidation dataScopeDataValidation = helper.createValidation(dataScopeValueConstraint, cellRangeAddressList);
        sheet.addValidationData(dataScopeDataValidation);
    }

    private Comparator<MemberRoleSheet.Dim> getDimComparator() {
        Comparator<MemberRoleSheet.Dim> comparator = (it1, it2) -> {
            if (kd.bos.util.CollectionUtils.isNotEmpty(it1.getStructProject()) && kd.bos.util.CollectionUtils.isNotEmpty(it2.getStructProject())) {
                return 0;
            }
            if (kd.bos.util.CollectionUtils.isNotEmpty(it1.getStructProject())) {
                return -1;
            }
            if (kd.bos.util.CollectionUtils.isNotEmpty(it2.getStructProject())) {
                return 1;
            }
            return 0;
        };
        comparator = comparator.thenComparing(MemberRoleSheet.Dim::getEnable, Comparator.reverseOrder()).thenComparing(it -> it.getDataSource().toLowerCase());
        return comparator;
    }

    private static /* synthetic */ String lambda$addFunctionItemBody$35(XSSFSheet sheet, FormulaEvaluator formulaEvaluator, Integer ci) {
        XSSFCell cell = RoleTemplateExcelWriter.getRow(sheet, 2).getCell(ci.intValue());
        String originalFormula = cell.getCellFormula();
        String tempFormula = originalFormula.replaceAll("\\(", "").replaceAll("\\)", "");
        cell.setCellFormula(tempFormula.substring(tempFormula.indexOf("TRANSPOSE") + 9));
        String cellRoleNumber = formulaEvaluator.evaluate((Cell)cell).getStringValue();
        cell.setCellFormula(originalFormula);
        return cellRoleNumber;
    }
}

