/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.init.task;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.ExecutorService;
import org.apache.commons.lang3.tuple.Triple;

public abstract class AbstractPermTask
extends AbstractTask {
    protected static final String DATE_PATTERN = "yyyyMMdd";
    private final Log LOGGER = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.doExecute(requestContext, map, this.getFeedbackProgress());
    }

    protected abstract void doExecute(RequestContext var1, Map<String, Object> var2, Consumer<Triple<String, Long, Long>> var3) throws KDException;

    protected Consumer<Triple<String, Long, Long>> getFeedbackProgress() {
        return progressInfo -> {
            String stageName = (String)progressInfo.getLeft();
            long total = (Long)progressInfo.getMiddle();
            long complete = (Long)progressInfo.getRight();
            HashMap custData = Maps.newHashMapWithExpectedSize((int)2);
            long progress = 0L;
            if (total != 0L) {
                progress = complete * 100L / total;
            }
            if (progress >= 100L) {
                progress = 99L;
            } else if (progress < 0L) {
                progress = 0L;
            }
            custData.put("desc", stageName);
            custData.put("total", String.valueOf(total));
            custData.put("complete", String.valueOf(complete));
            ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, (int)progress, stageName, (Map)custData);
            this.LOGGER.info("Update task[{}] process[{}] with data:[{}].", new Object[]{this.taskId, progress, custData});
        };
    }
}

