/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.log;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.MultiLangEnumBridge;
import kd.hr.hbp.common.util.HRQFilterHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.service.perm.log.PermLogHelper;
import kd.hr.hrcs.formplugin.common.HrcsFormpluginRes;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class PermLogRoleDetailPlugin
extends HRDynamicFormBasePlugin
implements TabSelectListener,
SetFilterListener,
RowClickEventListener,
CellClickListener,
ListRowClickListener {
    private static final String tabRoleDataScope = "tabroledatascope";
    private static boolean HIDDEN_NONTAB_FLAG = false;

    public void entryRowClick(RowClickEvent evt) {
        String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
        if (HRStringUtils.equals((String)status, (String)OperationStatus.VIEW.toString())) {
            return;
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void initialize() {
        String logType = this.getLogType();
        Set<TabInfoEnum> tabInfoEnums = TabInfoEnum.getTabInfoEnums(logType);
        for (TabInfoEnum tabInfoEnum : tabInfoEnums) {
            BillList billListControl = (BillList)this.getControl(tabInfoEnum.getControlKey());
            billListControl.addSetFilterListener((SetFilterListener)this);
        }
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BillList billListControl = (BillList)this.getView().getControl(TabInfoEnum.ROLE_BASEINFO.getControlKey());
        billListControl.addRowClickListener((RowClickEventListener)this);
        billListControl.addListRowClickListener((ListRowClickListener)this);
        billListControl.addListRowDoubleClickListener((ListRowClickListener)this);
    }

    private String getLogType() {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        return (String)formShowParameter.getCustomParam("logType");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object pkId = formShowParameter.getCustomParam("pkId");
        HRBaseServiceHelper dynaPermApplyBillService = new HRBaseServiceHelper("hrcs_permlog");
        DynamicObject dyn = dynaPermApplyBillService.loadSingle(pkId);
        IDataModel model = view.getModel();
        this.putBaseInfo(dyn, model);
        HashMap level2Tabs = new HashMap(4);
        level2Tabs.put(tabRoleDataScope, new HashSet(4));
        String logType = this.getLogType();
        Set<TabInfoEnum> tabInfoEnums = TabInfoEnum.getTabInfoEnums(logType);
        for (TabInfoEnum tabInfoEnum : tabInfoEnums) {
            BillList billListControl = (BillList)this.getControl(tabInfoEnum.getControlKey());
            billListControl.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)new BillListDataProvider(tabInfoEnum.getTabKey(), view, pkId, level2Tabs)));
        }
        Set hiddenTabs = Arrays.stream(TabInfoEnum.values()).filter(item -> !tabInfoEnums.contains(item)).collect(Collectors.toSet());
        for (TabInfoEnum hiddenTab : hiddenTabs) {
            view.setVisible(Boolean.FALSE, new String[]{hiddenTab.getTabKey()});
        }
        hiddenTabs.retainAll(TabInfoEnum.roleDataScopeTabInfoEnum);
        if (hiddenTabs.size() == 4) {
            view.setVisible(Boolean.FALSE, new String[]{tabRoleDataScope});
        }
        if (!hiddenTabs.contains((Object)TabInfoEnum.ROLE_INFLU_USER) && Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("isInfluusernumber"))) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab("tabroleinfluuser");
        }
    }

    public void setFilter(SetFilterEvent evt) {
        Object pkId = this.getView().getFormShowParameter().getCustomParam("pkId");
        evt.getQFilters().add(HRQFilterHelper.buildEql((String)"id", (Object)pkId));
        String entryEntityId = ((BillList)evt.getSource()).getEntryEntity();
        if (TabInfoEnum.ROLE_BASEINFO.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"baseinfoentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_FUNC_PERM.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"rolefuncentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_DIMENSION.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"roledimentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_BUSI_ORG_SCP.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"rangeorgentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_BUSI_DATA_SCP.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"rangebizentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_DATA_RULE.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"rangedrentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_BD_SCOPE.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"rangebddrentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_FIELD_PERM.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"rangefieldentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_OPEN_SCOPE.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"roleopenentry.id is not null", (Object[])new Object[0]));
        } else if (TabInfoEnum.ROLE_INFLU_USER.getEntryKey().equals(entryEntityId)) {
            evt.getQFilters().add(QFilter.of((String)"influuserentry.id is not null", (Object[])new Object[0]));
        }
    }

    private void putBaseInfo(DynamicObject dyn, IDataModel model) {
        model.setValue("number", dyn.get("number"));
        model.setValue("logtype", dyn.get("logtype"));
        String roleNumber = dyn.getString("rolenumber");
        String roleName = dyn.getString("rolename");
        if (StringUtils.isNotEmpty((CharSequence)roleNumber) || StringUtils.isNotEmpty((CharSequence)roleName)) {
            model.setValue("roleinfo", (Object)(StringUtils.isNotEmpty((CharSequence)roleNumber) ? roleNumber : "").concat("  ").concat(StringUtils.isNotEmpty((CharSequence)roleName) ? roleName : ""));
        }
        model.setValue("operationtime", dyn.get("operationtime"));
        model.setValue("operator", dyn.get("operator"));
    }

    public void tabSelected(TabSelectEvent evt) {
    }

    public static class BillListDataProvider
    extends ListDataProvider {
        private final String tabKey;
        private final IFormView view;
        private final Object pkId;
        private final Map<String, Set<String>> level2Tabs;

        public BillListDataProvider(String tabKey, IFormView view, Object pkId, Map<String, Set<String>> level2Tabs) {
            this.tabKey = tabKey;
            this.view = view;
            this.pkId = pkId;
            this.level2Tabs = level2Tabs;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection entryDatas = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)entryDatas)) {
                if (!HIDDEN_NONTAB_FLAG) {
                    return entryDatas;
                }
                if (TabInfoEnum.roleDataScopeTabs.contains(this.tabKey)) {
                    this.level2Tabs.get(PermLogRoleDetailPlugin.tabRoleDataScope).add(this.tabKey);
                    if (this.level2Tabs.get(PermLogRoleDetailPlugin.tabRoleDataScope).size() == 4) {
                        this.view.setVisible(Boolean.FALSE, new String[]{PermLogRoleDetailPlugin.tabRoleDataScope});
                    }
                }
                this.view.setVisible(Boolean.FALSE, new String[]{this.tabKey});
                return entryDatas;
            }
            ArrayList cellStyleList = Lists.newArrayListWithExpectedSize((int)entryDatas.size());
            if (TabInfoEnum.ROLE_BASEINFO.getTabKey().equals(this.tabKey)) {
                DynamicObject firstDyn = (DynamicObject)entryDatas.get(0);
                DynamicObjectCollection sortEntryDatas = new DynamicObjectCollection(firstDyn.getDynamicObjectType(), firstDyn.getParent());
                Map<String, DynamicObject> fieldMap = entryDatas.stream().collect(Collectors.toMap(item -> item.getString("baseinfoentry.baseinfo_changefield"), item -> item));
                for (int i = 0; i < BaseInfoField.baseInfoFields.size(); ++i) {
                    String baseInfoField = (String)BaseInfoField.baseInfoFields.get(i);
                    DynamicObject dynamicObject = fieldMap.get(baseInfoField);
                    if (!ObjectUtils.isNotEmpty((Object)dynamicObject)) continue;
                    dynamicObject.set("fseq", (Object)i);
                    sortEntryDatas.add((Object)dynamicObject);
                }
                for (int row = 0; row < sortEntryDatas.size(); ++row) {
                    DynamicObject entryData = (DynamicObject)entryDatas.get(row);
                    String beforeData = (String)entryData.get("baseinfoentry.baseinfo_beforedata");
                    String afterData = (String)entryData.get("baseinfoentry.baseinfo_afterdata");
                    if (StringUtils.isBlank((CharSequence)beforeData)) {
                        entryData.set("baseinfoentry.baseinfo_beforedata", (Object)PermLogHelper.CONTENT_NULL);
                        PermLogHelper.addCellStyle((List)cellStyleList, (String)"baseinfo_beforedata", (int)row);
                    }
                    if (!StringUtils.isBlank((CharSequence)afterData)) continue;
                    entryData.set("baseinfoentry.baseinfo_afterdata", (Object)PermLogHelper.CONTENT_NULL);
                    PermLogHelper.addCellStyle((List)cellStyleList, (String)"baseinfo_afterdata", (int)row);
                }
                BillList billListControl = (BillList)this.view.getControl(TabInfoEnum.ROLE_BASEINFO.getControlKey());
                billListControl.setCellStyle((List)cellStyleList);
            } else if (TabInfoEnum.ROLE_DIMENSION.getTabKey().equals(this.tabKey)) {
                for (int row = 0; row < entryDatas.size(); ++row) {
                    DynamicObject entryData = (DynamicObject)entryDatas.get(row);
                    String beforeData = (String)entryData.get("roledimentry.roledim_beforedata");
                    String afterData = (String)entryData.get("roledimentry.roledim_afterdata");
                    if (StringUtils.isBlank((CharSequence)beforeData)) {
                        entryData.set("roledimentry.roledim_beforedata", (Object)PermLogHelper.CONTENT_NULL);
                        PermLogHelper.addCellStyle((List)cellStyleList, (String)"roledim_beforedata", (int)row);
                    }
                    if (!StringUtils.isBlank((CharSequence)afterData)) continue;
                    entryData.set("roledimentry.roledim_afterdata", (Object)PermLogHelper.CONTENT_NULL);
                    PermLogHelper.addCellStyle((List)cellStyleList, (String)"roledim_afterdata", (int)row);
                }
                BillList billListControl = (BillList)this.view.getControl(TabInfoEnum.ROLE_DIMENSION.getControlKey());
                billListControl.setCellStyle((List)cellStyleList);
            } else if (TabInfoEnum.ROLE_BUSI_ORG_SCP.getTabKey().equals(this.tabKey)) {
                for (int row = 0; row < entryDatas.size(); ++row) {
                    DynamicObject entryData = (DynamicObject)entryDatas.get(row);
                    String beforeData = (String)entryData.get("rangeorgentry.rangeorg_beforeorgs");
                    String afterData = (String)entryData.get("rangeorgentry.rangeorg_afterorgs");
                    if (StringUtils.isBlank((CharSequence)beforeData)) {
                        entryData.set("rangeorgentry.rangeorg_beforeorgs", (Object)PermLogHelper.CONTENT_NULL);
                        PermLogHelper.addCellStyle((List)cellStyleList, (String)"rangeorg_beforeorgs", (int)row);
                    }
                    if (!StringUtils.isBlank((CharSequence)afterData)) continue;
                    entryData.set("rangeorgentry.rangeorg_afterorgs", (Object)PermLogHelper.CONTENT_NULL);
                    PermLogHelper.addCellStyle((List)cellStyleList, (String)"rangeorg_afterorgs", (int)row);
                }
                BillList billListControl = (BillList)this.view.getControl(TabInfoEnum.ROLE_BUSI_ORG_SCP.getControlKey());
                billListControl.setCellStyle((List)cellStyleList);
            } else if (TabInfoEnum.ROLE_BUSI_DATA_SCP.getTabKey().equals(this.tabKey)) {
                for (int row = 0; row < entryDatas.size(); ++row) {
                    DynamicObject entryData = (DynamicObject)entryDatas.get(row);
                    String beforeData = (String)entryData.get("rangebizentry.rangebiz_beforebizdata");
                    String afterData = (String)entryData.get("rangebizentry.rangebiz_afterbizdata");
                    if (StringUtils.isBlank((CharSequence)beforeData)) {
                        entryData.set("rangebizentry.rangebiz_beforebizdata", (Object)PermLogHelper.CONTENT_NULL);
                        PermLogHelper.addCellStyle((List)cellStyleList, (String)"rangebiz_beforebizdata", (int)row);
                    }
                    if (!StringUtils.isBlank((CharSequence)afterData)) continue;
                    entryData.set("rangebizentry.rangebiz_afterbizdata", (Object)PermLogHelper.CONTENT_NULL);
                    PermLogHelper.addCellStyle((List)cellStyleList, (String)"rangebiz_afterbizdata", (int)row);
                }
                BillList billListControl = (BillList)this.view.getControl(TabInfoEnum.ROLE_BUSI_DATA_SCP.getControlKey());
                billListControl.setCellStyle((List)cellStyleList);
            } else if (TabInfoEnum.ROLE_DATA_RULE.getTabKey().equals(this.tabKey)) {
                for (int row = 0; row < entryDatas.size(); ++row) {
                    DynamicObject entryData = (DynamicObject)entryDatas.get(row);
                    String beforeData = (String)entryData.get("rangedrentry.roledr_beforedrdesc");
                    String afterData = (String)entryData.get("rangedrentry.roledr_afterdrdesc");
                    if (StringUtils.isBlank((CharSequence)beforeData)) {
                        entryData.set("rangedrentry.roledr_beforedrdesc", (Object)PermLogHelper.CONTENT_NULL);
                        PermLogHelper.addCellStyle((List)cellStyleList, (String)"roledr_beforedrdesc", (int)row);
                    }
                    if (!StringUtils.isBlank((CharSequence)afterData)) continue;
                    entryData.set("rangedrentry.roledr_afterdrdesc", (Object)PermLogHelper.CONTENT_NULL);
                    PermLogHelper.addCellStyle((List)cellStyleList, (String)"roledr_afterdrdesc", (int)row);
                }
                BillList billListControl = (BillList)this.view.getControl(TabInfoEnum.ROLE_DATA_RULE.getControlKey());
                billListControl.setCellStyle((List)cellStyleList);
            } else if (TabInfoEnum.ROLE_BD_SCOPE.getTabKey().equals(this.tabKey)) {
                for (int row = 0; row < entryDatas.size(); ++row) {
                    DynamicObject entryData = (DynamicObject)entryDatas.get(row);
                    String beforeData = (String)entryData.get("rangebddrentry.rolebddr_beforedrdesc");
                    String afterData = (String)entryData.get("rangebddrentry.rolebddr_afterdrdesc");
                    if (StringUtils.isBlank((CharSequence)beforeData)) {
                        entryData.set("rangebddrentry.rolebddr_beforedrdesc", (Object)PermLogHelper.CONTENT_NULL);
                        PermLogHelper.addCellStyle((List)cellStyleList, (String)"rolebddr_beforedrdesc", (int)row);
                    }
                    if (!StringUtils.isBlank((CharSequence)afterData)) continue;
                    entryData.set("rangebddrentry.rolebddr_afterdrdesc", (Object)PermLogHelper.CONTENT_NULL);
                    PermLogHelper.addCellStyle((List)cellStyleList, (String)"rolebddr_afterdrdesc", (int)row);
                }
                BillList billListControl = (BillList)this.view.getControl(TabInfoEnum.ROLE_BD_SCOPE.getControlKey());
                billListControl.setCellStyle((List)cellStyleList);
            } else if (TabInfoEnum.ROLE_FIELD_PERM.getTabKey().equals(this.tabKey)) {
                for (int row = 0; row < entryDatas.size(); ++row) {
                    DynamicObject entryData = (DynamicObject)entryDatas.get(row);
                    String beforeData = (String)entryData.get("rangefieldentry.rolefield_beforedata");
                    String afterData = (String)entryData.get("rangefieldentry.rolefield_afterdata");
                    if (StringUtils.isBlank((CharSequence)beforeData)) {
                        entryData.set("rangefieldentry.rolefield_beforedata", (Object)PermLogHelper.CONTENT_NULL);
                        PermLogHelper.addCellStyle((List)cellStyleList, (String)"rolefield_beforedata", (int)row);
                    }
                    if (!StringUtils.isBlank((CharSequence)afterData)) continue;
                    entryData.set("rangefieldentry.rolefield_afterdata", (Object)PermLogHelper.CONTENT_NULL);
                    PermLogHelper.addCellStyle((List)cellStyleList, (String)"rolefield_afterdata", (int)row);
                }
                BillList billListControl = (BillList)this.view.getControl(TabInfoEnum.ROLE_FIELD_PERM.getControlKey());
                billListControl.setCellStyle((List)cellStyleList);
            } else if (TabInfoEnum.ROLE_OPEN_SCOPE.getTabKey().equals(this.tabKey)) {
                for (int row = 0; row < entryDatas.size(); ++row) {
                    DynamicObject entryData = (DynamicObject)entryDatas.get(row);
                    String beforeData = (String)entryData.get("roleopenentry.roleopen_beforedata");
                    String afterData = (String)entryData.get("roleopenentry.roleopen_afterdata");
                    if (StringUtils.isBlank((CharSequence)beforeData)) {
                        entryData.set("roleopenentry.roleopen_beforedata", (Object)PermLogHelper.CONTENT_NULL);
                        PermLogHelper.addCellStyle((List)cellStyleList, (String)"roleopen_beforedata", (int)row);
                    }
                    if (!StringUtils.isBlank((CharSequence)afterData)) continue;
                    entryData.set("roleopenentry.roleopen_afterdata", (Object)PermLogHelper.CONTENT_NULL);
                    PermLogHelper.addCellStyle((List)cellStyleList, (String)"roleopen_afterdata", (int)row);
                }
                BillList billListControl = (BillList)this.view.getControl(TabInfoEnum.ROLE_OPEN_SCOPE.getControlKey());
                billListControl.setCellStyle((List)cellStyleList);
            }
            return entryDatas;
        }
    }

    static enum TabInfoEnum {
        ROLE_BASEINFO("billlistaprolebaseinfo", "tabrolebaseinfo", "baseinfoentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_FUNC_PERM("billlistaprolefuncperm", "tabrolefunctionperm", "rolefuncentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_DIMENSION("billlistaproledimension", "tabroledimension", "roledimentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_BUSI_ORG_SCP("billlistaprolebusiorgscp", "tabrolebusiorgscope", "rangeorgentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_BUSI_DATA_SCP("billlistaprolebusidatascp", "tabrolebusidatascope", "rangebizentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_DATA_RULE("billlistaproledatarule", "tabroledatarule", "rangedrentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_BD_SCOPE("billlistaprolebdscope", "tabrolebdscope", "rangebddrentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_FIELD_PERM("billlistaprolefieldperm", "tabrolefieldperm", "rangefieldentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_OPEN_SCOPE("billlistaproleopenscope", "tabroleopenscope", "roleopenentry", (Set<String>)ImmutableSet.of((Object)"1010", (Object)"1015", (Object)"1020", (Object)"1025", (Object)"1030")),
        ROLE_INFLU_USER("billlistaproleinfluuser", "tabroleinfluuser", "influuserentry", (Set<String>)ImmutableSet.of((Object)"1025", (Object)"1035", (Object)"1040"));

        public static final Set<String> roleDataScopeTabs;
        private static final Map<String, Set<TabInfoEnum>> logTypeMappingTab;
        public static final Set<TabInfoEnum> roleDataScopeTabInfoEnum;
        private final String controlKey;
        private final String tabKey;
        private final String entryKey;
        private final Set<String> supportLogTypes;

        public static Set<TabInfoEnum> getTabInfoEnums(String logType) {
            return logTypeMappingTab.get(logType);
        }

        public String getControlKey() {
            return this.controlKey;
        }

        public String getTabKey() {
            return this.tabKey;
        }

        public String getEntryKey() {
            return this.entryKey;
        }

        public Set<String> getSupportLogTypes() {
            return this.supportLogTypes;
        }

        private TabInfoEnum(String controlKey, String tabKey, String entryKey, Set<String> supportLogTypes) {
            this.controlKey = controlKey;
            this.tabKey = tabKey;
            this.entryKey = entryKey;
            this.supportLogTypes = supportLogTypes;
        }

        static {
            roleDataScopeTabs = ImmutableSet.of((Object)ROLE_BUSI_ORG_SCP.getTabKey(), (Object)ROLE_BUSI_DATA_SCP.getTabKey(), (Object)ROLE_DATA_RULE.getTabKey(), (Object)ROLE_BD_SCOPE.getTabKey());
            logTypeMappingTab = new HashMap<String, Set<TabInfoEnum>>(10);
            logTypeMappingTab.put("1010", new HashSet());
            logTypeMappingTab.put("1015", new HashSet());
            logTypeMappingTab.put("1020", new HashSet());
            logTypeMappingTab.put("1025", new HashSet());
            logTypeMappingTab.put("1030", new HashSet());
            logTypeMappingTab.put("1035", new HashSet());
            logTypeMappingTab.put("1040", new HashSet());
            for (TabInfoEnum value : TabInfoEnum.values()) {
                for (String supportLogType : value.getSupportLogTypes()) {
                    logTypeMappingTab.get(supportLogType).add(value);
                }
            }
            roleDataScopeTabInfoEnum = ImmutableSet.of((Object)((Object)ROLE_BUSI_ORG_SCP), (Object)((Object)ROLE_BUSI_DATA_SCP), (Object)((Object)ROLE_DATA_RULE), (Object)((Object)ROLE_BD_SCOPE));
        }
    }

    static enum BaseInfoField {
        roleNumber(0, new MultiLangEnumBridge("\u89d2\u8272\u7f16\u7801", HrcsFormpluginRes.PermLogRoleDetailPlugin_0.resId(), "hrmp-hrcs-formplugin")),
        roleName(1, new MultiLangEnumBridge("\u89d2\u8272\u540d\u79f0", HrcsFormpluginRes.PermLogRoleDetailPlugin_1.resId(), "hrmp-hrcs-formplugin")),
        roleGroup(2, new MultiLangEnumBridge("\u89d2\u8272\u7ec4", HrcsFormpluginRes.PermLogRoleDetailPlugin_2.resId(), "hrmp-hrcs-formplugin")),
        roleType(3, new MultiLangEnumBridge("\u89d2\u8272\u7c7b\u578b", HrcsFormpluginRes.PermLogRoleDetailPlugin_3.resId(), "hrmp-hrcs-formplugin")),
        roleMngGroup(4, new MultiLangEnumBridge("\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4", HrcsFormpluginRes.PermLogRoleDetailPlugin_4.resId(), "hrmp-hrcs-formplugin")),
        roleScopeProp(5, new MultiLangEnumBridge("\u89d2\u8272\u6210\u5458\u8303\u56f4\u5c5e\u6027", HrcsFormpluginRes.PermLogRoleDetailPlugin_5.resId(), "hrmp-hrcs-formplugin")),
        roleScopeLimit(6, new MultiLangEnumBridge("\u53d7\u89d2\u8272\u8303\u56f4\u9650\u5236", HrcsFormpluginRes.PermLogRoleDetailPlugin_6.resId(), "hrmp-hrcs-formplugin")),
        roleOpenStatus(7, new MultiLangEnumBridge("\u516c\u5f00\u72b6\u6001", HrcsFormpluginRes.PermLogRoleDetailPlugin_7.resId(), "hrmp-hrcs-formplugin")),
        roleDesc(8, new MultiLangEnumBridge("\u63cf\u8ff0", HrcsFormpluginRes.PermLogRoleDetailPlugin_8.resId(), "hrmp-hrcs-formplugin"));

        private final int index;
        private final MultiLangEnumBridge desc;
        private final String descName;
        private static final List<String> baseInfoFields;

        private BaseInfoField(int index, MultiLangEnumBridge desc) {
            this.index = index;
            this.desc = desc;
            this.descName = desc.getDescription();
        }

        public String getDescName() {
            return this.descName;
        }

        static {
            baseInfoFields = Arrays.stream(BaseInfoField.values()).map(BaseInfoField::getDescName).collect(Collectors.toList());
        }
    }
}

