/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.permfile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

@ExcludeFromJacocoGeneratedReport
public class SyncPermfilePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(SyncPermfilePlugin.class);
    private static final Long LABRELSTATUSPRD_ING = 1010L;
    private static final Long LABRELSTATUSPRD_END = 1020L;
    private static final String FIELD_LABORRELSTATUS = "laborrelstatus";
    public static final String KEY_BTN_OK = "btnok";
    public static final String KEY_BTN_CANCEL = "btncancel";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL});
        BasedataEdit mulEdit = (BasedataEdit)this.getControl(FIELD_LABORRELSTATUS);
        mulEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            IDataModel model = this.getModel();
            Object laborrelstatus = model.getValue(FIELD_LABORRELSTATUS);
            if (laborrelstatus == null || laborrelstatus instanceof DynamicObjectCollection && ((DynamicObjectCollection)laborrelstatus).size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u3002", (String)"SyncPermfilePlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(this.getModel().getValue(FIELD_LABORRELSTATUS));
            this.getView().close();
        } else if (KEY_BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)FIELD_LABORRELSTATUS)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            showParameter.getListFilterParameter().getQFilters().add(enableFilter);
            showParameter.getListFilterParameter().getQFilters().add(statusFilter);
            showParameter.getListFilterParameter().getQFilters().add(this.getLabrelStatusPrdFilter());
        }
    }

    private QFilter getLabrelStatusPrdFilter() {
        QFilter qFilter = null;
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"hrcs_filesynstagecfg", (String)"stage", (QFilter[])new QFilter[0]);
        ArrayList stages = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            stages.add(dynamicObject.getDynamicObject("stage").getPkValue());
        }
        qFilter = new QFilter("labrelstatusprd", "in", (Object)stages);
        return qFilter;
    }

    private List<Long> getLaborrelIdList() {
        DynamicObjectCollection targetUserCollection = (DynamicObjectCollection)this.getModel().getValue(FIELD_LABORRELSTATUS);
        ArrayList laborrelIdList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject targetUser : targetUserCollection) {
            DynamicObject laborrel = targetUser.getDynamicObject("fbasedataid");
            Long laborrelId = laborrel.getLong("id");
            laborrelIdList.add(laborrelId);
        }
        return laborrelIdList;
    }
}

