/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.permfile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;

public class UserPermfileEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String PERMFILEGRP = "permfilegrp";
    private static final String POSITION = "position";
    private static final String IS_NEED_REFRESH = "isNeedRefresh";
    private static final String ORG = "org";
    private static final String FIELD_USER = "user";
    private static final String USERTYPE_ROBOT = "6";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl(ORG);
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit userControl = (BasedataEdit)this.getControl(FIELD_USER);
        userControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "org": {
                long level = HRPermServiceHelper.getUserGroupMinLevel();
                if (-1L != level && level <= 2L) break;
                List userPermFileIds = HRPermServiceHelper.getUserPermFile();
                evt.getCustomQFilters().add(new QFilter("id", "in", (Object)userPermFileIds));
                break;
            }
            case "user": {
                evt.getCustomQFilters().add(new QFilter("usertype", "!=", (Object)USERTYPE_ROBOT).and("isforbidden", "=", (Object)"0"));
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        IFormView pView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (pView instanceof IListView) {
            IPageCache pageCache = (IPageCache)pView.getService(IPageCache.class);
            if ("1".equals(pageCache.get("listdatachanged"))) {
                returnData.put(IS_NEED_REFRESH, "true");
            } else {
                returnData.put(IS_NEED_REFRESH, "false");
            }
        }
        this.getView().returnDataToParent(returnData);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DynamicObject permfile = this.getModel().getDataEntity();
        if (Objects.nonNull(permfile) && 0L != permfile.getLong("id")) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_permfilegrpmember");
            QFilter qfilter = new QFilter("permfile", "=", (Object)permfile.getLong("id"));
            DynamicObject permfileMember = helper.queryOne("id,permfile,permfilegrp", new QFilter[]{qfilter});
            if (Objects.nonNull(permfileMember) && Objects.nonNull(permfileMember.get(PERMFILEGRP))) {
                this.getModel().setValue(PERMFILEGRP, permfileMember.get("permfilegrp.id"));
                this.getModel().setValue("permfilegrpmember", (Object)permfileMember.getLong("id"));
                this.getModel().setDataChanged(false);
            }
            DynamicObject user = (DynamicObject)this.getModel().getValue(FIELD_USER);
            this.getModel().setValue("username", user.get("name"));
            this.setDepartmentInfo(permfile.getLong("user.id"));
        } else {
            Object groupId = this.getView().getFormShowParameter().getCustomParam("groupId");
            this.getModel().setValue(PERMFILEGRP, groupId);
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)FIELD_USER, (String)fieldKey)) {
            DynamicObject user = this.getModel().getDataEntity().getDynamicObject(FIELD_USER);
            Optional.ofNullable(user).ifPresent(userDy -> {
                this.getModel().setValue("username", (Object)user.getString("name"));
                this.setDepartmentInfo(user.getLong("id"));
            });
        }
    }

    private void setDepartmentInfo(Long userId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_user");
        String fields = "id, entryentity,entryentity.dpt,entryentity.position,entryentity.ispartjob";
        QFilter[] filters = new QFilter[]{new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE), new QFilter("id", "=", (Object)userId)};
        DynamicObject[] departmemts = helper.query(fields, filters);
        if (Objects.isNull(departmemts) || departmemts.length == 0) {
            return;
        }
        DynamicObjectCollection col = (DynamicObjectCollection)departmemts[0].get("entryentity");
        for (DynamicObject departmemt : col) {
            if (departmemt.getBoolean("ispartjob")) continue;
            this.getModel().setValue("department", departmemt.get("dpt.id"));
            OrmLocaleValue coll = (OrmLocaleValue)departmemt.get(POSITION);
            if (coll.size() <= 0) break;
            this.getModel().setValue(POSITION, departmemt.get(POSITION));
            break;
        }
    }
}

