/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.permfile.imp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hrcs.formplugin.web.perm.permfile.imp.HrBatchImportSheetHandler;

public class PermFileBatchImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(PermFileBatchImportPlugin.class);

    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        for (String url : this.ctx.getAllUrls()) {
            this.handleResolve(service, reader, url);
        }
    }

    private void handleResolve(FileService service, ExcelReader reader, String url) {
        try {
            InputStream in = service.getInputStream(url);
            Throwable cause = null;
            try {
                MainEntityType mainEntityType = this.buildMainEntityType(null);
                if (mainEntityType instanceof QueryEntityType) {
                    mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
                }
                reader.read(in, (SheetHandler)new HrBatchImportSheetHandler(this.ctx, mainEntityType, url));
            }
            catch (Throwable throwable) {
                cause = throwable;
                throw throwable;
            }
            finally {
                this.handleSource(cause, in);
            }
        }
        catch (Throwable var18) {
            if (SystemParamServiceHelper.isShowStackTrace()) {
                this.ctx.getLogger(url).log(Integer.valueOf(0), var18);
            } else {
                Throwable cause = var18.getCause();
                String importErrMsg = cause instanceof KDBizException ? var18.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"PermFileBatchImportPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
            }
            this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
            this.ctx.setResolveComplete(url);
        }
    }

    private void handleSource(Throwable cause, InputStream in) throws IOException {
        if (in != null) {
            if (cause != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {
                    cause.addSuppressed(throwable);
                }
            } else {
                in.close();
            }
        }
    }

    public String getBillFormId() {
        return "hrcs_userpermfile";
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected void beforeSave(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (!CollectionUtils.isEmpty(rowdatas)) {
            for (ImportBillData row : rowdatas) {
                row.getData().put("importflag", (Object)"isPersonalizeData");
            }
        }
        super.beforeSave(rowdatas, logger);
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        List overrideFieldsConfig = super.getOverrideFieldsConfig();
        ArrayList overrideValue = Lists.newArrayListWithExpectedSize((int)2);
        for (ComboItem item : overrideFieldsConfig) {
            String value = item.getValue();
            if (!"org".equals(value) && !"user".equals(value)) continue;
            overrideValue.add(item);
        }
        return overrideValue;
    }

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                formView.setVisible(Boolean.FALSE, new String[]{"radiofield2", "radiofield1"});
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage());
            }
        }
        catch (NoSuchFieldException e) {
            log.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }
}

