/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.RoleManageService;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;
import kd.hr.hrcs.common.constants.perm.PermTreeLevel;
import org.apache.commons.collections.MapUtils;

public class AllFuncPermTreeUtil
implements TreeNodeQueryListener {
    private static final String BIZ_UNIT_REL_FORM_DS = "bizUnitRelFormDS";
    private static final String BIZ_OBJ_APP_DS = "bizObjAppDS";
    private static final String ENTITY_DESIGN_DS = "entityDesignDS";
    private static final String ENTAPP_ENTNUM = "entapp_entnum";
    private static final String ENT_NUM = "ent_num";
    private static final String ENTAPP_APPID = "entapp_appid";
    private static final String ENT_ID = "ent_id";
    private static final String FUNC_PERM_DS = "funcPermDS";
    private static final String FUNCPERM_ENTID = "funcperm_entid";
    private static final String BURF_FORMID = "burf_formid";
    private static final String BURF_APPID = "burf_appid";
    private static final String ENT_DS = "entDS";
    private static final String ENTD_ID = "entd_id";
    private static final String ENTD_NUM = "entd_num";
    private static final String CLOUD_APP_DS = "cloudAppDS";
    private static final String APP_ID = "app_id";
    private static final String CLOUD_ID = "cloud_id";
    private static final String APP_NUM = "app_num";
    private static final String CLOUD_NAME = "cloud_name";
    private static final String PERMITEML_ID = "permiteml_id";
    private static final String PERMITEM_NUM = "permitem_num";
    private static final String FUNCPERM_ID = "funcperm_id";
    private static final String PERMITEML_NAME = "permiteml_name";
    public static final String FOR_BID_APPS = "forBidApps";
    public static final String FOR_BID_APP_ENTITY = "forBidAppEntity";
    public static final String FOR_ENTITY_PERM = "entityPerm";
    public static final String FOR_APP_ENTITY_PERM = "appEntityPerm";
    private static final Log LOGGER = LogFactory.getLog(AllFuncPermTreeUtil.class);
    public static final String ID_ROOTNODE = "root#FIRST";
    public static final String NODESUFFIX_FIRST = "#" + PermTreeLevel.FIRST;
    public static final String NODESUFFIX_CLOUD = "#cloud";
    public static final String NODESUFFIX_APP = "#app";
    public static final String NODESUFFIX_ENTITY = "#entity";
    public static final String NODESUFFIX_PERMITEM = "#permItem";
    private static final String FLAG_HASLOADEDFROMCACHE = "flag_hasLoadedFromCache";
    private static final String CACHE_SHOW_FORMNUMS = "cache_show_formnums";
    private static final String CACHE_NOTSHOW_FORMNUMS = "cache_notshow_formnums";
    private static final String INDUSTRY = "bos_devp_industry";
    private TreeView treeView = null;
    private String appNum = null;
    private String dimension = null;
    private PermPageCacheUtil permPageCacheUtil = null;
    private List<String> cloudIds = new ArrayList<String>(16);
    private Map<String, Set<String>> allPermConfig = new HashMap<String, Set<String>>(16);
    private Set<String> noCtrlPermEntitys;
    Map<String, String> permIdNumberMap = Maps.newHashMapWithExpectedSize((int)16);

    private boolean isEntityCtrlPerm(String entityNum) {
        return !this.noCtrlPermEntitys.contains(entityNum);
    }

    public static String getFuncPermName() {
        return ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"AllFuncPermTreeUtil_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    public AllFuncPermTreeUtil(TreeView pTreeView, String pAppNum, String pDimension) {
        this.treeView = pTreeView;
        this.appNum = pAppNum;
        this.dimension = pDimension == null ? "DIM_ORG" : pDimension;
        if (pTreeView != null) {
            IPageCache pageCache = (IPageCache)pTreeView.getView().getService(IPageCache.class);
            this.permPageCacheUtil = new PermPageCacheUtil(pageCache);
        }
        if (CollectionUtils.isEmpty(this.cloudIds)) {
            this.cloudIds = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
        }
        if (CollectionUtils.isEmpty(this.allPermConfig)) {
            this.allPermConfig = PermRelateServiceHelper.queryAllPermRelateConfig();
        }
        if (this.permPageCacheUtil != null) {
            this.noCtrlPermEntitys = RoleManageService.getNoCtrlPermEntitysFromCache();
        }
        if (MapUtils.isEmpty(this.permIdNumberMap)) {
            this.permIdNumberMap = PermRelateServiceHelper.buildPermIdNumber();
        }
    }

    public void initListener() {
        this.treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public TreeNode createRootNode() {
        TreeNode rootNode = new TreeNode("", ID_ROOTNODE, AllFuncPermTreeUtil.getFuncPermName(), true);
        return rootNode;
    }

    public static String getUserTypesByAppNum(String pAppNum) {
        if ("BASE".equals(pAppNum)) {
            return "1,5";
        }
        if ("SCP".equals(pAppNum)) {
            return "3";
        }
        return null;
    }

    public TreeNode initTree(boolean ifShow) {
        TreeNode rootNode = this.createRootNode();
        rootNode.setIsOpened(true);
        this.addCloudNode(rootNode, null, ifShow);
        return rootNode;
    }

    private void appendAppFilter(StringBuilder sb) {
        String filterAppNum = this.permPageCacheUtil.get("FormShowParam_appNum");
        if (StringUtils.isNotEmpty((String)filterAppNum)) {
            this.filterApp(sb, filterAppNum);
        }
    }

    private void filterApp(StringBuilder sb, String filterAppNum) {
        if (filterAppNum.contains(",")) {
            String[] filterAppNumArr = filterAppNum.split(",");
            sb.append(" and app.fnumber in(");
            for (int i = 0; i < filterAppNumArr.length; ++i) {
                if (StringUtils.isEmpty((String)filterAppNumArr[i])) continue;
                sb.append(" '").append(filterAppNumArr[i].trim()).append("' ");
                if (i == filterAppNumArr.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
        } else if (!"BASE".equals(filterAppNum) && !"SCP".equals(filterAppNum)) {
            sb.append(" and app.fnumber = '").append(filterAppNum).append("' ");
        }
    }

    private void appendUserType(StringBuilder sb) {
        String userTypes = AllFuncPermTreeUtil.getUserTypesByAppNum(this.appNum);
        if (userTypes != null) {
            sb.append(" and (");
            String[] arrUserType = userTypes.split(",");
            for (int i = 0; i < arrUserType.length; ++i) {
                String userType = arrUserType[i];
                if (i != 0) {
                    sb.append(" or ");
                }
                sb.append(" app.fusertype = '").append(userType).append("' ").append(" or app.fusertype like '").append(userType).append(",%' ").append(" or app.fusertype like '%,").append(userType).append("' ").append(" or app.fusertype like '%,").append(userType).append(",%' ");
            }
            sb.append(')');
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        if (event.getNodeId() == null) {
            return;
        }
        String nodeId = event.getNodeId().toString();
        String parentId = nodeId.substring(0, nodeId.indexOf(35));
        if (nodeId.contains(NODESUFFIX_CLOUD)) {
            this.addAppNode(parentId, null);
        } else if (nodeId.contains(NODESUFFIX_APP)) {
            this.addEntityNode(parentId);
        } else if (nodeId.contains(NODESUFFIX_ENTITY)) {
            this.addPermItemNode(parentId);
        }
    }

    public static String getEntityNumFromNodeId(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            return null;
        }
        if (nodeId.indexOf(124) == -1 || nodeId.indexOf(64) == -1) {
            return null;
        }
        return nodeId.substring(nodeId.indexOf(124) + 1, nodeId.indexOf(64));
    }

    public static String getEntityIdFromNodeId(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            return null;
        }
        if (nodeId.indexOf(124) == -1 || nodeId.indexOf(64) == -1) {
            return null;
        }
        return nodeId.substring(0, nodeId.indexOf(124));
    }

    public static String getAppIdFromNodeId(String nodeId) {
        if (StringUtils.isEmpty((String)nodeId)) {
            return null;
        }
        if (nodeId.indexOf(64) == -1 || nodeId.indexOf(35) == -1) {
            return null;
        }
        String result = nodeId.substring(nodeId.indexOf(64) + 1, nodeId.indexOf(35));
        return result;
    }

    public void searchAllFuncPermTreeByText(String searchText, String appId) {
        this.searchAllFuncPermTreeByText(searchText, appId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchAllFuncPermTreeByText(String searchText, String appId, List<String> cloudId) {
        String algoKeyPrefix = this.getClass().getName() + ".searchAllFuncPermTreeByText.";
        DataSet bizObjAppDS = null;
        DataSet bizUnitRelFormDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet funcPermDS = null;
        DataSet appEntDS = null;
        DataSet appEntPermItemDS = null;
        DataSet entDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        try {
            Map appEntity;
            String appEntityStr;
            bizUnitRelFormDS = this.getBizUniRelFormDs(algoKeyPrefix);
            bizObjAppDS = this.getBizObjAppDs(algoKeyPrefix);
            entityDesignDS = this.getEntityDesignDs(algoKeyPrefix);
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(ENTAPP_ENTNUM, ENT_NUM).select(new String[]{ENTAPP_APPID, ENT_ID}).finish();
            List<String> forBidApps = this.getForBidApps();
            String whereCondition = AllFuncPermTreeUtil.getHRCondition(forBidApps);
            String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
            if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
                whereCondition = whereCondition + " and burf_appid not in (" + appBlacklist + ")";
            }
            LOGGER.info("Got HRCondition: {}.", (Object)whereCondition);
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS).where(whereCondition);
            funcPermDS = this.queryFuncPermDS(algoKeyPrefix);
            appEntPermItemDS = appEntDS.join(funcPermDS).on(BURF_FORMID, FUNCPERM_ENTID).select(new String[]{BURF_APPID}, new String[]{FUNCPERM_ENTID}).finish();
            entDS = this.queryEntDS(searchText, RequestContext.get().getLang().name(), algoKeyPrefix);
            String forBids = this.permPageCacheUtil.get("forBids");
            HashSet forBidEntitys = new HashSet(16);
            if (forBids != null) {
                Set entities = (Set)SerializationUtils.fromJsonString((String)forBids, Set.class);
                forBidEntitys.addAll(entities);
            }
            if ((appEntityStr = this.permPageCacheUtil.get(FOR_BID_APP_ENTITY)) != null && (appEntity = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get(FOR_BID_APP_ENTITY), Map.class)).get(appId) != null) {
                forBidEntitys.addAll((Collection)appEntity.get(appId));
            }
            if (forBidEntitys.size() > 0) {
                HashMap filterMap = new HashMap(1);
                filterMap.put("valids", forBidEntitys);
                entDS = entDS.filter("entd_num not in valids", filterMap);
            }
            appEntPermItemDS2 = appEntPermItemDS.join(entDS).on(FUNCPERM_ENTID, ENTD_ID).select(new String[]{BURF_APPID}, new String[]{ENTD_NUM, ENTD_ID}).finish();
            StringBuilder sbCloudAppSql = this.buildCloudAppSql();
            this.appendUserType(sbCloudAppSql);
            if (!CollectionUtils.isEmpty(cloudId)) {
                String whereSql = cloudId.stream().map(hrcloudId -> '\'' + hrcloudId + '\'').collect(Collectors.joining(", "));
                sbCloudAppSql.append(" AND cloudl.fid in ( ").append(whereSql).append(" )");
            }
            if (StringUtils.isNotEmpty((String)appId)) {
                sbCloudAppSql.append(" AND app.fId = '").append(appId).append("' ");
            }
            this.appendAppFilter(sbCloudAppSql);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString(), (Object[])new Object[]{RequestContext.get().getLang().name()});
            entityDesignDS = this.getEntityInfoDs(algoKeyPrefix);
            Map<String, String> entityMap = this.getEntityMap(entityDesignDS);
            this.setDataToRootNode4Search(appEntPermItemDS2, cloudAppDS, entityMap);
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS});
    }

    private Map<String, String> getEntityMap(DataSet entityDesignDS) {
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)16);
        while (entityDesignDS.hasNext()) {
            Row row = entityDesignDS.next();
            entityMap.put(row.getString(ENT_NUM), row.getString("name"));
        }
        return entityMap;
    }

    private void setDataToRootNode4Search(DataSet appEntPermItemDS2, DataSet cloudAppDS, Map<String, String> entityMap) {
        this.treeView.deleteAllNodes();
        TreeNode rootNode = this.createRootNode();
        this.treeView.addNode(rootNode);
        HashSet<Object> cloudIds = new HashSet<Object>(16);
        HashSet<Object> appIds = new HashSet<Object>(16);
        HashSet entitySet = Sets.newHashSet();
        try (DataSet finalDS = appEntPermItemDS2.join(cloudAppDS).on(BURF_APPID, APP_ID).select(new String[]{ENTD_NUM, ENTD_ID}, new String[]{CLOUD_ID, CLOUD_NAME, "app_masterid", APP_ID, APP_NUM}).finish();){
            Map appEntity = new HashMap(16);
            if (this.permPageCacheUtil.get(FOR_BID_APP_ENTITY) != null) {
                appEntity = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get(FOR_BID_APP_ENTITY), Map.class);
            }
            while (finalDS.hasNext()) {
                Set<String> forbidPerms;
                String tempAppId;
                Row row = finalDS.next();
                String appMasterId = row.getString("app_masterid");
                String entityNum = row.getString(ENTD_NUM);
                String appId = HRStringUtils.isNotEmpty((String)appMasterId) ? appMasterId : row.getString(APP_ID);
                String string = tempAppId = StringUtils.isNotEmpty((String)appMasterId) ? appMasterId : appId;
                if (!this.isEntityCtrlPerm(entityNum) || MapUtils.isNotEmpty(appEntity) && appEntity.get(tempAppId) != null && ((List)appEntity.get(tempAppId)).contains(entityNum)) continue;
                HashSet set = new HashSet(16);
                if (this.allPermConfig.get(appId) != null) {
                    set = Sets.newHashSet((Iterable)this.allPermConfig.get(appId));
                }
                if (!PermRelateServiceHelper.hasAssignablePerm((String)entityNum, (String)appId, (Set)set, forbidPerms = this.collectEntityForbidPerms(entityNum, appId))) continue;
                String cloudId = row.getString(CLOUD_ID) + NODESUFFIX_CLOUD;
                String appLongId = tempAppId + NODESUFFIX_APP;
                String appName = AppMetadataCache.getAppInfo((String)row.getString(APP_NUM)).getName().getLocaleValue();
                String entityName = entityMap.get(entityNum);
                String entityLongID = row.getString(ENTD_ID) + "|" + entityNum + "@" + tempAppId + NODESUFFIX_ENTITY;
                if (!entitySet.add(entityLongID)) continue;
                this.handleCloudNode(rootNode, cloudIds, appIds, row, cloudId, appLongId, appName, entityName, entityLongID);
            }
        }
    }

    private Set<String> collectEntityForbidPerms(String entityNum, String appId) {
        Map entityPerm = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get(FOR_ENTITY_PERM), Map.class);
        Map appEntityPerm = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get(FOR_APP_ENTITY_PERM), Map.class);
        HashSet forbidPerms = Sets.newHashSetWithExpectedSize((int)16);
        if (MapUtils.isNotEmpty((Map)entityPerm) && entityPerm.containsKey(entityNum)) {
            forbidPerms.addAll((Collection)entityPerm.get(entityNum));
        }
        if (MapUtils.isNotEmpty((Map)appEntityPerm) && appEntityPerm.containsKey(appId) && ((Map)appEntityPerm.get(appId)).containsKey(entityNum)) {
            forbidPerms.addAll((Collection)((Map)appEntityPerm.get(appId)).get(entityNum));
        }
        return forbidPerms.stream().map(it -> this.permIdNumberMap.get(it)).collect(Collectors.toSet());
    }

    private void handleCloudNode(TreeNode rootNode, Set<Object> cloudIds, Set<Object> appIds, Row row, String cloudid, String appLongId, String appName, String entityName, String entityLongID) {
        if (cloudIds.contains(cloudid)) {
            if (appIds.contains(appLongId)) {
                this.expandTreeNode(rootNode, appLongId, entityName, entityLongID);
            } else {
                this.addAppEntityNode(rootNode, appIds, cloudid, appLongId, appName, entityName, entityLongID);
            }
        } else {
            this.addCloudAppEntityNode(rootNode, rootNode.getId(), cloudIds, appIds, cloudid, row.getString(CLOUD_NAME), appLongId, appName, entityName, entityLongID);
        }
    }

    private DataSet queryFuncPermDS(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + FUNC_PERM_DS), (DBRoute)DBRoute.permission, (String)" select distinct funcperm.FDENTITYTYPEID funcperm_entid from t_perm_functionperm funcperm  INNER  JOIN t_perm_permitem permitem ON permitem.FID = funcperm.FPERMITEMID ");
    }

    private DataSet queryEntDS(String searchText, String langStr, String algoKeyPrefix) {
        searchText = '%' + searchText + '%';
        return DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)"select entd.FID entd_id, entd.fnumber entd_num from t_meta_entitydesign entd  INNER JOIN t_meta_mainentityinfo_l entdl  ON (entdl.FID = entd.fnumber AND entdl.FLOCALEID = ?  and entdl.fname like ?)   where entd.FISTEMPLATE = '0'  and fmodeltype <> 'ReportQueryListModel' ", (Object[])new Object[]{langStr, searchText});
    }

    private StringBuilder buildCloudAppSql() {
        return new StringBuilder().append("select cloudl.fid cloud_id, cloudl.fname cloud_name, cloud.fseq cloud_seq, ").append(" app.FID app_id, app.fnumber app_num, app.fmasterid AS app_masterid ").append("  from t_meta_bizapp app ").append(" INNER  JOIN t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.FID AND cloudl.FLOCALEID = ?)").append(" WHERE  NOT EXISTS (SELECT 1 FROM t_meta_appruntime appr ").append(" WHERE (app.fid = appr.fid OR app.fmasterid = appr.fid) AND appr.falluserapp = '1')").append(" AND  app.fdeploystatus = '2' ");
    }

    private void expandTreeNode(TreeNode rootNode, String appLongId, String entityName, String entityLongID) {
        TreeNode appNode = rootNode.getTreeNode(appLongId, 2);
        TreeNode entityNode = new TreeNode(appLongId, entityLongID, entityName, true);
        appNode.addChild(entityNode);
        this.treeView.expand(appLongId);
    }

    private void addAppEntityNode(TreeNode rootNode, Set<Object> appIds, String cloudid, String appLongId, String appName, String entityName, String entityLongID) {
        TreeNode cloudNode = rootNode.getTreeNode(cloudid, 1);
        TreeNode appNode = new TreeNode(cloudid, appLongId, appName, true);
        appIds.add(appLongId);
        cloudNode.addChild(appNode);
        this.treeView.expand(cloudid);
        TreeNode entityNode = new TreeNode(appLongId, entityLongID, entityName, true);
        appNode.addChild(entityNode);
        this.treeView.expand(appLongId);
    }

    private void addCloudAppEntityNode(TreeNode rootNode, String rootNodeId, Set<Object> cloudIds, Set<Object> appIds, String cloudid, String cloudName, String appLongId, String appName, String entityName, String entityLongID) {
        TreeNode cloudNode = new TreeNode(rootNodeId, cloudid, cloudName, true);
        cloudIds.add(cloudid);
        rootNode.addChild(cloudNode);
        this.treeView.expand(rootNodeId);
        TreeNode appNode = new TreeNode(cloudid, appLongId, appName, true);
        appIds.add(appLongId);
        cloudNode.addChild(appNode);
        this.treeView.expand(cloudid);
        TreeNode entityNode = new TreeNode(appLongId, entityLongID, entityName, true);
        appNode.addChild(entityNode);
        this.treeView.expand(appLongId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloudNode(TreeNode rootNode, String nodeId, boolean ifShow) {
        this.buildAllRelatedPerm();
        this.buildForBid();
        String langStr = RequestContext.get().getLang().name();
        String algoKeyPrefix = this.getClass().getName() + ".addCloudNode.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        DataSet appEntPermItemDS = null;
        DataSet funcPermDS = null;
        DataSet entDS = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        DataSet appEntPermItemDS2 = null;
        try {
            bizUnitRelFormDS = this.getBizUniRelFormDs(algoKeyPrefix);
            bizObjAppDS = this.getBizObjAppDs(algoKeyPrefix);
            entityDesignDS = this.getEntityDesignDs(algoKeyPrefix);
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(ENTAPP_ENTNUM, ENT_NUM).select(new String[]{ENTAPP_APPID, ENT_ID}).finish();
            List<String> forBidApps = this.getForBidApps();
            String whereCondition = AllFuncPermTreeUtil.getHRCondition(forBidApps);
            String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
            if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
                whereCondition = whereCondition + " and burf_appid not in (" + appBlacklist + ")";
            }
            LOGGER.info("Got HRCondition: {}.", (Object)whereCondition);
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS).where(whereCondition);
            funcPermDS = DB.queryDataSet((String)(algoKeyPrefix + FUNC_PERM_DS), (DBRoute)DBRoute.permission, (String)"select  distinct funcperm.FDENTITYTYPEID funcperm_entid from t_perm_functionperm funcperm ");
            appEntPermItemDS = appEntDS.join(funcPermDS).on(BURF_FORMID, FUNCPERM_ENTID).select(new String[]{BURF_APPID}, new String[]{FUNCPERM_ENTID}).finish();
            entDS = DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)"select entd.FID  entd_id, entd.fnumber entd_num  from  t_meta_entitydesign entd  where entd.FISTEMPLATE = '0'");
            appEntPermItemDS2 = appEntPermItemDS.join(entDS).on(FUNCPERM_ENTID, ENTD_ID).select(new String[]{BURF_APPID}, new String[]{ENTD_NUM}).finish();
            appEntPermItemDS2 = this.removeForBidAppEntity(appEntPermItemDS2);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)this.buildCloudAppSql4AddCloudNode(nodeId).toString(), (Object[])new Object[]{langStr});
            finalDS = this.setDataToRootNode(rootNode, ifShow, appEntPermItemDS2, cloudAppDS);
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
    }

    private DataSet removeForBidAppEntity(DataSet appEntPermItemDS2) {
        String appEntityStr = this.permPageCacheUtil.get(FOR_BID_APP_ENTITY);
        if (appEntityStr != null) {
            Map appEntity = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get(FOR_BID_APP_ENTITY), Map.class);
            for (Map.Entry entry : appEntity.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                HashMap<String, Object> filterMap = new HashMap<String, Object>(1);
                filterMap.put("appId", key);
                filterMap.put("valids", value);
                appEntPermItemDS2 = appEntPermItemDS2.filter("burf_appid != appId or (burf_appid = appId and entd_num not in valids)", filterMap);
            }
        }
        return appEntPermItemDS2;
    }

    private void buildForBid() {
        ArrayList entities = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList apps = Lists.newArrayListWithExpectedSize((int)16);
        HashMap appEntity = new HashMap(16);
        HashMap entityPerm = Maps.newHashMapWithExpectedSize((int)16);
        HashMap appEntityPerm = Maps.newHashMapWithExpectedSize((int)16);
        EntityCtrlServiceHelper.queryEntityForBidInfo((List)entities, (List)apps, appEntity, (Map)entityPerm, (Map)appEntityPerm);
        if (!CollectionUtils.isEmpty((Collection)entities)) {
            this.permPageCacheUtil.put("forBids", SerializationUtils.toJsonString((Object)entities));
        }
        if (!CollectionUtils.isEmpty((Collection)apps)) {
            this.permPageCacheUtil.put(FOR_BID_APPS, SerializationUtils.toJsonString((Object)apps));
        }
        if (MapUtils.isNotEmpty(appEntity)) {
            this.permPageCacheUtil.put(FOR_BID_APP_ENTITY, SerializationUtils.toJsonString(appEntity));
        }
        this.permPageCacheUtil.put(FOR_ENTITY_PERM, SerializationUtils.toJsonString((Object)entityPerm));
        this.permPageCacheUtil.put(FOR_APP_ENTITY_PERM, SerializationUtils.toJsonString((Object)appEntityPerm));
    }

    private DataSet setDataToRootNode(TreeNode rootNode, boolean ifShow, DataSet appEntPermItemDS2, DataSet cloudAppDS) {
        DataSet finalDS = appEntPermItemDS2.join(cloudAppDS).on(BURF_APPID, APP_ID).select(new String[]{ENTD_NUM}, new String[]{CLOUD_ID, CLOUD_NAME, "cloud_seq"}).finish().orderBy(new String[]{"cloud_seq asc"});
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        HashSet<String> cloudIdSet = new HashSet<String>(16);
        while (finalDS.hasNext()) {
            String id;
            Row row = finalDS.next();
            String entityNum = row.getString(ENTD_NUM);
            if (!this.isEntityCtrlPerm(entityNum) || cloudIdSet.contains(id = row.getString(CLOUD_ID) + NODESUFFIX_CLOUD)) continue;
            cloudIdSet.add(id);
            String name = row.getString(CLOUD_NAME);
            TreeNode cloudNode = new TreeNode(ID_ROOTNODE, id, name, true);
            list.add(cloudNode);
        }
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)list.size());
        this.cloudIds.forEach(cloudId -> list.stream().filter(node -> HRStringUtils.equals((String)cloudId, (String)node.getId().substring(0, node.getId().indexOf(35)))).findFirst().ifPresent(nodes::add));
        for (TreeNode cloudNode : nodes) {
            rootNode.addChild(cloudNode);
        }
        if (ifShow) {
            this.treeView.addNode(rootNode);
        }
        return finalDS;
    }

    private StringBuilder buildCloudAppSql4AddCloudNode(String nodeId) {
        String cloudNumBlackList;
        StringBuilder sb = new StringBuilder().append("select cloudl.fid cloud_id, cloudl.fname cloud_name, cloud.fseq cloud_seq, ").append(" app.FID app_id ").append(" from  t_meta_bizapp app ").append(" INNER JOIN  t_meta_bizcloud cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.FID AND cloudl.FLOCALEID = ?)").append(" WHERE NOT EXISTS  (SELECT 1 FROM t_meta_appruntime appr ").append(" WHERE (app.fid = appr.fid OR app.fmasterid = appr.fid) AND appr.falluserapp = '1')").append(" AND app.fdeploystatus  = '2' ");
        Set cloudIds = HRCloudServiceHelper.getAllHRCloudId();
        if (!CollectionUtils.isEmpty((Collection)cloudIds)) {
            sb.append(" and cloudl.fid in ( '").append(String.join((CharSequence)"','", cloudIds)).append("')");
        }
        if (StringUtils.isNotEmpty((String)nodeId)) {
            sb.append(" and cloudl.fid = '").append(nodeId).append("' ");
        }
        if (StringUtils.isNotEmpty((String)(cloudNumBlackList = RunModeServiceHelper.getCloudIdsFromBlackList()))) {
            sb.append(" and cloudl.fid not in (").append(cloudNumBlackList).append(')');
        }
        this.appendAppFilter(sb);
        this.appendUserType(sb);
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppNode(String parentNodeId, String nodeId) {
        Map extAppAndOrgnlAppRel = PermFormCommonUtil.getExtAppAndOrgnlAppRel();
        String algoKeyPrefix = this.getClass().getName() + ".addAppNode.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        DataSet entDS = null;
        DataSet funcPermDS = null;
        DataSet appEntPermItemDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        Object finalDS = null;
        try {
            bizUnitRelFormDS = this.getBizUniRelFormDs(algoKeyPrefix);
            bizObjAppDS = this.getBizObjAppDs(algoKeyPrefix);
            entityDesignDS = this.getEntityDesignDs(algoKeyPrefix);
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(ENTAPP_ENTNUM, ENT_NUM).select(new String[]{ENTAPP_APPID, ENT_ID}).finish();
            List<String> forBidApps = this.getForBidApps();
            String whereCondition = AllFuncPermTreeUtil.getHRCondition(forBidApps);
            String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
            if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
                whereCondition = whereCondition + " and burf_appid not in (" + appBlacklist + ")";
            }
            LOGGER.info("Got HRCondition: {}.", (Object)whereCondition);
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS).where(whereCondition);
            funcPermDS = DB.queryDataSet((String)(algoKeyPrefix + FUNC_PERM_DS), (DBRoute)DBRoute.permission, (String)"select distinct  funcperm.FDENTITYTYPEID funcperm_entid from t_perm_functionperm funcperm  INNER JOIN t_perm_permitem  permitem ON permitem.FID = funcperm.FPERMITEMID ");
            appEntPermItemDS = appEntDS.join(funcPermDS).on(BURF_FORMID, FUNCPERM_ENTID).select(new String[]{BURF_APPID}, new String[]{FUNCPERM_ENTID}).finish();
            entDS = DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)"select entd.FID entd_id,  entd.fnumber entd_num  from t_meta_entitydesign  entd  where  entd.FISTEMPLATE = '0' AND entd.FTYPE = '0' ");
            appEntPermItemDS2 = appEntPermItemDS.join(entDS).on(FUNCPERM_ENTID, ENTD_ID).select(new String[]{BURF_APPID}, new String[]{ENTD_NUM}).finish();
            appEntPermItemDS2 = this.removeForBidAppEntity(appEntPermItemDS2);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)this.buildCloudAppSql4AddAppNode(nodeId).toString(), (Object[])new Object[]{parentNodeId});
            this.setDataToCloudNode(parentNodeId, extAppAndOrgnlAppRel, appEntPermItemDS2, cloudAppDS);
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
    }

    private void setDataToCloudNode(String parentNodeId, Map<String, String> extAppAndOrgnlAppRel, DataSet appEntPermItemDS2, DataSet cloudAppDS) {
        Map<Long, String> industryMap = this.getIndustryInfo();
        ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(16);
        HashSet<String> appIdSet = new HashSet<String>(16);
        try (DataSet finalDS = appEntPermItemDS2.join(cloudAppDS).on(BURF_APPID, APP_ID).select(new String[]{ENTD_NUM}, new String[]{APP_ID, APP_NUM, "app_industry"}).finish();){
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String entityNum = row.getString(ENTD_NUM);
                if (!this.isEntityCtrlPerm(entityNum)) continue;
                String appId = row.getString(APP_ID);
                appId = extAppAndOrgnlAppRel.get(appId);
                String id = appId + NODESUFFIX_APP;
                String num = row.getString(APP_NUM);
                if (appIdSet.contains(id)) continue;
                appIdSet.add(id);
                String name = num;
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)num);
                if (appInfo != null && appInfo.getName() != null && appInfo.getName().getLocaleValue() != null) {
                    name = appInfo.getName().getLocaleValue();
                }
                Long appIndustryId = row.getLong("app_industry");
                name = this.getAppNameByIndustryName(industryMap, name, appIndustryId);
                TreeNode appNode = new TreeNode(parentNodeId + NODESUFFIX_CLOUD, id, name, true);
                listNode.add(appNode);
            }
        }
        if (listNode.size() > 0) {
            listNode.sort(Comparator.comparing(TreeNode::getId));
            this.treeView.addNodes(listNode);
        }
    }

    private String getAppNameByIndustryName(Map<Long, String> industryMap, String name, Long appIndustryId) {
        String industryName;
        if (appIndustryId != null && appIndustryId != 0L && StringUtils.isNotEmpty((String)(industryName = industryMap.get(appIndustryId)))) {
            name = name + "(" + industryName + ")";
        }
        return name;
    }

    private Map<Long, String> getIndustryInfo() {
        HashMap<Long, String> industryMap = new HashMap<Long, String>(16);
        Map industries = BusinessDataServiceHelper.loadFromCache((String)INDUSTRY, (String)"id, name", (QFilter[])new QFilter[0]);
        for (Map.Entry entry : industries.entrySet()) {
            DynamicObject industry = (DynamicObject)entry.getValue();
            Long industryId = industry.getLong("id");
            String industryName = industry.getString("name");
            industryMap.put(industryId, industryName);
        }
        return industryMap;
    }

    private StringBuilder buildCloudAppSql4AddAppNode(String nodeId) {
        String appIdBlackList;
        StringBuilder sb = new StringBuilder().append(" select app.fid app_id, app.fnumber app_num, app.findustry app_industry ").append(" from t_meta_bizapp  app ").append(" INNER JOIN t_meta_bizcloud  cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" WHERE NOT EXISTS (SELECT  1 FROM t_meta_appruntime appr ").append(" WHERE (app.fid = appr.fid OR app.fmasterid = appr.fid) ").append(" AND appr.falluserapp = '1') ").append(" AND app.fdeploystatus =  '2' ").append(" AND cloud.FID = ? ");
        if (StringUtils.isNotEmpty((String)nodeId)) {
            sb.append(" and app.fid = '").append(nodeId).append("' ");
        }
        if (StringUtils.isNotEmpty((String)(appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist()))) {
            sb.append(" and app.fid not in (").append(appIdBlackList).append(')');
        }
        this.appendAppFilter(sb);
        this.appendUserType(sb);
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityNode(String appId) {
        List forQueryAppIds = PermFormCommonUtil.getAllExtAppId((String)appId);
        forQueryAppIds.add(appId);
        String algoKeyPrefix = this.getClass().getName() + ".addEntityNode.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        DataSet funcPermDS = null;
        DataSet appEntPermItemDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet entDS = null;
        Object finalDS = null;
        DataSet cloudAppDS = null;
        try {
            Map appEntity;
            String appEntityStr;
            bizUnitRelFormDS = this.getBizUniRelFormDs(algoKeyPrefix);
            bizObjAppDS = this.getBizObjAppDs(algoKeyPrefix);
            entityDesignDS = this.getEntityDesignDs(algoKeyPrefix);
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(ENTAPP_ENTNUM, ENT_NUM).select(new String[]{ENTAPP_APPID, ENT_ID}).finish();
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS);
            funcPermDS = this.getFuncPermDs(algoKeyPrefix);
            appEntPermItemDS = appEntDS.join(funcPermDS).on(BURF_FORMID, FUNCPERM_ENTID).select(new String[]{BURF_APPID}, new String[]{FUNCPERM_ENTID}).finish();
            StringBuilder sbEntSql = this.buildEntitySql();
            this.buildWhitelistSql(sbEntSql);
            this.buildNotShowSql(sbEntSql);
            String appNumber = AppMetadataCache.getAppNumberById((String)appId);
            String formBlacklist = RunModeServiceHelper.getEntityNumFromBlacklist((String)appNumber);
            if (StringUtils.isNotEmpty((String)formBlacklist)) {
                sbEntSql.append(" AND entd.fnumber not in (").append(formBlacklist).append(')');
            }
            entDS = DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)sbEntSql.toString());
            String forBids = this.permPageCacheUtil.get("forBids");
            ArrayList forBidEntitys = Lists.newArrayListWithExpectedSize((int)16);
            if (forBids != null) {
                List entities = (List)SerializationUtils.fromJsonString((String)forBids, List.class);
                forBidEntitys.addAll(entities);
            }
            if ((appEntityStr = this.permPageCacheUtil.get(FOR_BID_APP_ENTITY)) != null && (appEntity = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get(FOR_BID_APP_ENTITY), Map.class)).get(appId) != null) {
                forBidEntitys.addAll((Collection)appEntity.get(appId));
            }
            if (forBidEntitys.size() > 0) {
                HashMap<String, ArrayList> filterMap = new HashMap<String, ArrayList>(1);
                filterMap.put("valids", forBidEntitys);
                entDS = entDS.filter("entd_num not in valids", filterMap);
            }
            appEntPermItemDS2 = appEntPermItemDS.join(entDS).on(FUNCPERM_ENTID, ENTD_ID).select(new String[]{BURF_APPID}, new String[]{ENTD_NUM, ENTD_ID}).finish();
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)this.buildCloudAppSql4AddEntityNode(forQueryAppIds).toString());
            entityDesignDS = this.getEntityInfoDs(algoKeyPrefix);
            Map<String, String> entityMap = this.getEntityMap(entityDesignDS);
            this.setDataToAppNode(appId, appEntPermItemDS2, cloudAppDS, entityMap);
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
    }

    private void setDataToAppNode(String appId, DataSet appEntPermItemDS2, DataSet cloudAppDS, Map<String, String> entityMap) {
        ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(16);
        try (DataSet finalDS = appEntPermItemDS2.join(cloudAppDS).on(BURF_APPID, APP_ID).select(new String[]{ENTD_NUM, ENTD_ID}, new String[0]).finish();){
            HashSet<String> entityNumSet = new HashSet<String>(16);
            while (finalDS.hasNext()) {
                Set<String> forbidPerms;
                Row row = finalDS.next();
                String entityNum = row.getString(ENTD_NUM);
                if (entityNumSet.contains(entityNum)) continue;
                entityNumSet.add(entityNum);
                if (!this.isEntityCtrlPerm(entityNum)) continue;
                HashSet set = new HashSet(16);
                if (this.allPermConfig.get(appId) != null) {
                    set = Sets.newHashSet((Iterable)this.allPermConfig.get(appId));
                }
                if (!PermRelateServiceHelper.hasAssignablePerm((String)entityNum, (String)appId, (Set)set, forbidPerms = this.collectEntityForbidPerms(entityNum, appId))) continue;
                String id = row.getString(ENTD_ID) + "|" + entityNum + "@" + appId + NODESUFFIX_ENTITY;
                String name = entityMap.get(entityNum);
                TreeNode entityNode = new TreeNode(appId + NODESUFFIX_APP, id, name, true);
                listNode.add(entityNode);
            }
        }
        if (listNode.size() > 0) {
            Map permTreeSeq = EntityCtrlServiceHelper.getPermTreeSeq((String)appId);
            if (permTreeSeq != null) {
                listNode.sort((o1, o2) -> {
                    String id1 = o1.getId();
                    String id2 = o2.getId();
                    Integer index1 = (Integer)permTreeSeq.get(id1.substring(id1.indexOf(124) + 1, id1.indexOf(64)));
                    Integer index2 = (Integer)permTreeSeq.get(id2.substring(id2.indexOf(124) + 1, id2.indexOf(64)));
                    if (null == index1) {
                        index1 = Integer.MAX_VALUE;
                    }
                    if (null == index2) {
                        index2 = Integer.MAX_VALUE;
                    }
                    if (Integer.MAX_VALUE == index1 && Integer.MAX_VALUE == index2) {
                        Collator cltr = Collator.getInstance(RequestContext.get().getLang().getLocale());
                        return cltr.compare(o1.getText(), o2.getText());
                    }
                    return index1.compareTo(index2);
                });
            } else {
                final Collator cltr = Collator.getInstance(RequestContext.get().getLang().getLocale());
                listNode.sort(new Comparator<TreeNode>(){

                    @Override
                    public int compare(TreeNode o1, TreeNode o2) {
                        return cltr.compare(o1.getText(), o2.getText());
                    }
                });
            }
            this.treeView.addNodes(listNode);
        }
    }

    private StringBuilder buildCloudAppSql4AddEntityNode(List<String> forQueryAppIds) {
        StringBuilder sbCloudAppSql = new StringBuilder().append("select  app.fid app_id, app.fnumber app_num, app.findustry app_industry ").append(" from t_meta_bizapp app   ").append(" INNER JOIN t_meta_bizcloud cloud ON cloud.FID = app.FBIZCLOUDID   ");
        sbCloudAppSql.append(" AND app.FID in (");
        for (int i = 0; i < forQueryAppIds.size(); ++i) {
            String forQueryAppId = forQueryAppIds.get(i);
            sbCloudAppSql.append(" '").append(forQueryAppId).append("' ");
            if (i == forQueryAppIds.size() - 1) continue;
            sbCloudAppSql.append(',');
        }
        sbCloudAppSql.append(')');
        return sbCloudAppSql;
    }

    private void buildNotShowSql(StringBuilder sbEntSql) {
        String strNotShowFormNums = this.permPageCacheUtil.get(CACHE_NOTSHOW_FORMNUMS);
        if (StringUtils.isNotEmpty((String)strNotShowFormNums)) {
            List formnums = (List)SerializationUtils.fromJsonString((String)strNotShowFormNums, List.class);
            String strFornum = "";
            StringBuilder strFornumBuilder = new StringBuilder();
            for (String formnum : formnums) {
                strFornumBuilder.append(" '").append(formnum).append("',");
            }
            if (strFornumBuilder.length() > 0) {
                strFornum = strFornumBuilder.toString().substring(0, strFornumBuilder.length() - 1);
            }
            sbEntSql.append(" AND entd.fnumber not in (").append(strFornum).append(')');
        }
    }

    private void buildWhitelistSql(StringBuilder sbEntSql) {
        String strShowFormNums = this.permPageCacheUtil.get(CACHE_SHOW_FORMNUMS);
        if (StringUtils.isNotEmpty((String)strShowFormNums)) {
            List formNums = (List)SerializationUtils.fromJsonString((String)strShowFormNums, List.class);
            String strFornum = "";
            StringBuilder strFornumBuilder = new StringBuilder();
            for (String formNum : formNums) {
                strFornumBuilder.append(" '").append(formNum).append("',");
            }
            strFornum = strFornumBuilder.toString().substring(0, strFornumBuilder.toString().length() - 1);
            sbEntSql.append(" AND entd.fnumber in (").append(strFornum).append(')');
        }
    }

    private DataSet getFuncPermDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + FUNC_PERM_DS), (DBRoute)DBRoute.permission, (String)"select distinct funcperm.FDENTITYTYPEID  funcperm_entid from t_perm_functionperm funcperm  INNER JOIN t_perm_permitem permitem  ON permitem.FID = funcperm.FPERMITEMID ");
    }

    private DataSet getEntityDesignDs(String algoKeyPrefix) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entitymeta");
        return helper.queryDataSet(algoKeyPrefix + ENTITY_DESIGN_DS, "id ent_id, number ent_num, name");
    }

    private DataSet getEntityInfoDs(String algoKeyPrefix) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entityinfo");
        return helper.queryDataSet(algoKeyPrefix + ENTITY_DESIGN_DS, "dentityid ent_id, id ent_num, name");
    }

    private DataSet getBizObjAppDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid  entapp_entnum FROM t_perm_bizobjapp");
    }

    private DataSet getBizUniRelFormDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + BIZ_UNIT_REL_FORM_DS), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid,  fformid burf_formid FROM t_meta_bizunitrelform");
    }

    private List<String> getForBidApps() {
        String forBidAppStr = this.permPageCacheUtil.get(FOR_BID_APPS);
        List forBidApps = Lists.newArrayListWithExpectedSize((int)16);
        if (HRStringUtils.isNotEmpty((String)forBidAppStr)) {
            forBidApps = (List)SerializationUtils.fromJsonString((String)forBidAppStr, List.class);
        }
        return forBidApps;
    }

    public static String getHRCondition(List<String> forBidApps) {
        List<Object> appIds;
        List forbidExtApps = PermFormCommonUtil.getAllExtAppId((List)Lists.newArrayList(forBidApps));
        HRBaseServiceHelper userAdminGroupServiceHelper = new HRBaseServiceHelper("perm_useradmingroup");
        HRBaseServiceHelper adminGroupServiceHelper = new HRBaseServiceHelper("perm_admingroupapp");
        DynamicObject[] userGroupItems = userAdminGroupServiceHelper.queryOriginalArray("usergroup.id,usergroup.level", new QFilter[]{new QFilter("user.id", "=", (Object)RequestContext.get().getCurrUserId()).and("usergroup.isdomain", "=", (Object)"1").and("usergroup.domain.number", "=", (Object)"hr")});
        Set topAdminGroupIds = Arrays.stream(userGroupItems).filter(it -> it.getInt("usergroup.level") == 2).map(it -> it.getLong("usergroup.id")).collect(Collectors.toSet());
        DynamicObject[] topAGRange = adminGroupServiceHelper.queryOriginalArray("app,usergroup.id", new QFilter[]{new QFilter("usergroup.id", "in", topAdminGroupIds).and("app", "not in", (Object)forbidExtApps)});
        int count = (int)Arrays.stream(topAGRange).map(it -> it.getLong("usergroup.id")).distinct().count();
        if (count < topAdminGroupIds.size()) {
            appIds = Lists.newArrayList((Iterable)EntityCtrlServiceHelper.getHRApps((boolean)true));
        } else {
            List userGroupIds = Arrays.stream(userGroupItems).map(it -> it.getLong("usergroup.id")).collect(Collectors.toList());
            DynamicObject[] apps = adminGroupServiceHelper.queryOriginalArray("app", new QFilter[]{new QFilter("usergroup.id", "in", userGroupIds).and("app", "not in", (Object)forbidExtApps)});
            appIds = Arrays.stream(apps).map(it -> it.getString("app")).collect(Collectors.toList());
        }
        appIds.removeAll(forbidExtApps);
        List finalFilterAppIds = PermFormCommonUtil.getAllExtAppId((List)appIds);
        String appIdStr = finalFilterAppIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
        if (HRStringUtils.isEmpty((String)appIdStr)) {
            return "1=2";
        }
        return " burf_appid in ( " + appIdStr + " )";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermItemNode(String parentNodeId) {
        String langStr = RequestContext.get().getLang().name();
        String entityId = parentNodeId.substring(0, parentNodeId.indexOf(124));
        String entityNum = parentNodeId.substring(parentNodeId.indexOf(124) + 1, parentNodeId.indexOf(64));
        String appId = parentNodeId.substring(parentNodeId.indexOf(64) + 1);
        String algoKeyPrefix = this.getClass().getName() + ".addEntityNode.";
        List<String> relatedPerm = this.getRelatedPerm(appId, entityNum);
        DataSet finalDS = null;
        try {
            finalDS = DB.queryDataSet((String)(algoKeyPrefix + FUNC_PERM_DS), (DBRoute)DBRoute.permission, (String)"SELECT distinct funcperm.fentitytypeid funcperm_entnum, funcperm.FDENTITYTYPEID funcperm_entid, funcperm.FID funcperm_id,  permiteml.fid permiteml_id, permiteml.fname permiteml_name, permitem.fnumber permitem_num  FROM t_perm_functionperm funcperm  INNER JOIN t_perm_permitem permitem ON permitem.FID = funcperm.FPERMITEMID  INNER JOIN t_perm_permitem_l permiteml ON (permiteml.FID = permitem.FID AND permiteml.FLOCALEID = ?) WHERE funcperm.FDENTITYTYPEID = ? ", (Object[])new Object[]{langStr, entityId});
            ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(20);
            Map entityPerm = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get(FOR_ENTITY_PERM), Map.class);
            Map appEntityPerm = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get(FOR_APP_ENTITY_PERM), Map.class);
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String permItemId = row.getString(PERMITEML_ID);
                String id = row.getString(FUNCPERM_ID) + '|' + permItemId + '@' + appId + NODESUFFIX_PERMITEM;
                String name = row.getString(PERMITEML_NAME);
                String permItemNum = row.getString(PERMITEM_NUM);
                if (!CollectionUtils.isEmpty(relatedPerm) && relatedPerm.contains(permItemNum) || entityPerm.containsKey(entityNum) && ((List)entityPerm.get(entityNum)).contains(permItemId) || appEntityPerm.containsKey(appId) && ((Map)appEntityPerm.get(appId)).containsKey(entityNum) && ((List)((Map)appEntityPerm.get(appId)).get(entityNum)).contains(permItemId)) continue;
                TreeNode permItemNode = new TreeNode(parentNodeId + NODESUFFIX_ENTITY, id, name, false);
                listNode.add(permItemNode);
            }
            if (!listNode.isEmpty()) {
                AllFuncPermTreeUtil.sortPermItemSeq(entityNum, listNode);
                this.treeView.addNodes(listNode);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{finalDS});
    }

    public static void sortPermItemSeq(String entityId, List<TreeNode> listNode) {
        HRBaseServiceHelper funcPermHelper = new HRBaseServiceHelper("perm_functionperm");
        final Map<String, Integer> permItemSeq = funcPermHelper.queryOriginalCollection("entitytype,permitem,seq", new QFilter[]{new QFilter("entitytype", "=", (Object)entityId)}).stream().collect(Collectors.toMap(it -> it.getString("permitem"), it -> it.getInt("seq"), (newVal, oldVal) -> newVal));
        listNode.sort(new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                String o1Id = o1.getId();
                String o2Id = o2.getId();
                String o1PermId = o1Id.substring(o1Id.indexOf(124) + 1, o1Id.indexOf(64));
                String o2PermId = o2Id.substring(o2Id.indexOf(124) + 1, o2Id.indexOf(64));
                Integer o1PermSeq = permItemSeq.getOrDefault(o1PermId, Integer.MAX_VALUE);
                Integer o2PermSeq = permItemSeq.getOrDefault(o2PermId, Integer.MAX_VALUE);
                return o1PermSeq.compareTo(o2PermSeq);
            }
        });
    }

    private DataSet getBizunitrelformDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + BIZ_UNIT_REL_FORM_DS), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid, fformid  burf_formid FROM t_meta_bizunitrelform");
    }

    private void setDataToEntityNode(String parentNodeId, String appId, DataSet appEntPermItemDS2, DataSet cloudAppDS) {
        try (DataSet finalDS = appEntPermItemDS2.join(cloudAppDS).on(BURF_APPID, APP_ID).select(new String[]{FUNCPERM_ID, PERMITEML_ID, PERMITEML_NAME, PERMITEM_NUM}, new String[]{APP_ID}).finish();){
            HashMap<String, String> permItemMap = new HashMap<String, String>(16);
            ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(16);
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String id = row.getString(FUNCPERM_ID) + "|" + row.getString(PERMITEML_ID) + "@" + appId + NODESUFFIX_PERMITEM;
                String name = row.getString(PERMITEML_NAME);
                String permItemNum = row.getString(PERMITEM_NUM);
                permItemMap.put(id, permItemNum);
                TreeNode permItemNode = new TreeNode(parentNodeId + NODESUFFIX_ENTITY, id, name, false);
                listNode.add(permItemNode);
            }
            if (listNode.size() > 0) {
                this.sortTree(permItemMap, listNode);
            }
        }
    }

    public static String buildEntityForBidFilterStr(String forBidsStr, String colName) {
        if (HRStringUtils.isEmpty((String)forBidsStr)) {
            return null;
        }
        List forBids = (List)SerializationUtils.fromJsonString((String)forBidsStr, List.class);
        if (forBids == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(colName).append(" not in (");
        for (String entityId : forBids) {
            sb.append('\'').append(entityId).append("',");
        }
        return sb.substring(0, sb.length() - 1) + ")";
    }

    public List<String> getRelatedPerm(String appId, String entityId) {
        String allRelatedPerms = this.permPageCacheUtil.get("AllRelatedPerms");
        Map entityPermMap = (Map)SerializationUtils.fromJsonString((String)allRelatedPerms, Map.class);
        if (entityPermMap.get(appId) != null && ((Map)entityPermMap.get(appId)).get(entityId) != null) {
            return (List)((Map)entityPermMap.get(appId)).get(entityId);
        }
        return null;
    }

    public void buildAllRelatedPerm() {
        Map entityPermMap = PermRelateServiceHelper.buildAllRelatedPerm();
        if (!CollectionUtils.isEmpty((Map)entityPermMap)) {
            this.permPageCacheUtil.put("AllRelatedPerms", SerializationUtils.toJsonString((Object)entityPermMap));
        }
    }

    private String buildFuncPermSql() {
        return "select distinct funcperm.FDENTITYTYPEID funcperm_entid, funcperm.FID funcperm_id,  permiteml.fid permiteml_id, permiteml.fname permiteml_name, permitem.fnumber permitem_num FROM t_perm_functionperm funcperm  INNER JOIN t_perm_permitem permitem ON permitem.FID = funcperm.FPERMITEMID  INNER JOIN t_perm_permitem_l permiteml ON (permiteml.FID = permitem.FID AND permiteml.FLOCALEID = ?) ";
    }

    private StringBuilder buildEntitySql() {
        return new StringBuilder().append(" select entd.FID entd_id, entd.fnumber entd_num ").append(" from t_meta_entitydesign entd ").append(" where entd.FISTEMPLATE =  '0' ").append(" AND entd.FTYPE = '0' ");
    }

    private void sortTree(final Map<String, String> permItemMap, List<TreeNode> listNode) {
        listNode.sort(new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                String id1 = o1.getId();
                String id2 = o2.getId();
                String permItemNum1 = (String)permItemMap.get(id1);
                String permItemNum2 = (String)permItemMap.get(id2);
                return permItemNum1.compareTo(permItemNum2);
            }
        });
        this.treeView.addNodes(listNode);
    }
}

