/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.md.FieldPermModel;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.util.FieldPermInfoJsonUtil;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.formplugin.web.perm.role.AllFuncPermTreeUtil;

public class AssignedFunctionTreePlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(AssignedFunctionTreePlugin.class);
    private static final String FIELD_SEPERATOR = "\\|\\|";
    private static final String NEW_ENTRY_FIELD = "selectfields";
    private static final String DELETE_FIELD_PERM_ENTRY = "delfieldpermentry";
    private static final String BATCHSET_ENTRY_FIELD = "btn_batchset";
    private static final String CALLBACK_BATCHSET_CHOOSE_FIELD = "callback_batchset_choose_field";
    private static final String CALLBACK_CHOOSE_FIELD = "perm_choosefieldpage";
    private static final String FIELD_ENTRY = "list_fieldperm";
    private static final String FIELD_ENTRY_ID = "fieldperm_entryid";
    private static final String FIELD_NUM = "fieldperm_fieldnum";
    private static final String FIELD_NAME = "fieldperm_fieldname";
    private static final String NOT_ALLOW_QUERY = "fieldperm_not_allow_query";
    private static final String NOT_ALLOW_EDIT = "fieldperm_not_allow_edit";
    private static final String ORIGIN_FIELD_CACHE = "originFieldCache";
    protected static final String FIELDPERM_ENTITY = "fieldperm_entity";
    private TreeView fieldPermTree = null;
    public static final String FIELD_PERM_CACHE = "fieldPermCache";
    protected static final String ENTITY_INFO_SPLIT = "@";
    protected static final String TREE_FIELDPERM = "tree_fieldperm";
    private String KEY_FIELD_TREE_FOCUSED = "KEY_FIELD_TREE_FOCUSED";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        IPageCache pageCache = this.getView().getPageCache();
        this.fieldPermTree = (TreeView)this.getControl(TREE_FIELDPERM);
        this.fieldPermTree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
                AssignedFunctionTreePlugin.this.refreshFiledList();
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey = event.getProperty().getName();
        int rowIndex = event.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "fieldperm_not_allow_query": {
                this.setEditBtn(rowIndex);
                this.updateFieldCache(false);
                break;
            }
            case "fieldperm_not_allow_edit": {
                this.updateFieldCache(false);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        String opKey = ((FormOperate)evt.getSource()).getOperateKey();
        if (NEW_ENTRY_FIELD.equals(opKey)) {
            String[] entityInfo = this.getFocusEntityInfo(TREE_FIELDPERM, true);
            this.checkBeforeShowF7(evt, entityInfo);
        }
    }

    private void checkBeforeShowF7(BeforeDoOperationEventArgs evt, String[] entityInfo) {
        if (entityInfo == null || entityInfo.length == 0 || entityInfo[1] == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u4fa7\u9009\u62e9\u5177\u4f53\u7684\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"AssignedFunctionTreePlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "selectfields": {
                this.showFieldF7();
                break;
            }
            case "delfieldpermentry": {
                this.updateFieldCache(true);
                break;
            }
            case "btn_batchset": {
                this.setBatchSet();
                break;
            }
        }
    }

    private void setBatchSet() {
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity(FIELD_ENTRY);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)fieldEntry)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u4e1a\u52a1\u5bf9\u8c61\u7684\u5b57\u6bb5\u3002", (String)"AssignedFunctionTreePlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entry = (EntryGrid)this.getView().getControl(FIELD_ENTRY);
        if (entry.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u7684\u5b57\u6bb5\u3002", (String)"AssignedFunctionTreePlugin_8", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("hrcs_fieldbatchset");
        parameter.setShowTitle(true);
        parameter.setHasRight(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_BATCHSET_CHOOSE_FIELD));
        parameter.setCustomParam("ServiceAppId", (Object)"hrcs");
        this.getView().showForm(parameter);
    }

    protected String[] getFocusEntityInfo(String treeNum, boolean clearEntryRow) {
        TreeView tv = (TreeView)this.getControl(treeNum);
        String nodeId = tv.getTreeState().getFocusNodeId();
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return null;
        }
        if (nodeId.contains("#entity")) {
            String entityId = AllFuncPermTreeUtil.getEntityIdFromNodeId(nodeId);
            String entityNum = AllFuncPermTreeUtil.getEntityNumFromNodeId(nodeId);
            String appId = AllFuncPermTreeUtil.getAppIdFromNodeId(nodeId);
            if (Objects.isNull(entityNum) || Objects.isNull(appId)) {
                return null;
            }
            return new String[]{appId, entityNum, entityId};
        }
        if (clearEntryRow) {
            this.clearAllEntryRow();
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CALLBACK_CHOOSE_FIELD.equals(actionId)) {
            this.refreshFieldListByF7(evt);
        } else if (CALLBACK_BATCHSET_CHOOSE_FIELD.equals(actionId)) {
            Map ret = (Map)evt.getReturnData();
            if (ret == null) {
                return;
            }
            String isBanWrite = (String)ret.get("comboedit");
            String isBanRead = (String)ret.get("comboview");
            String[] entityInfo = this.getFocusEntityInfo(TREE_FIELDPERM, false);
            if (Objects.isNull(entityInfo) && Objects.isNull(entityInfo = this.getCacheFieldTreeFocusNode())) {
                return;
            }
            String entityNum = entityInfo[1];
            String appId = entityInfo[0];
            UserRoleFieldPermInfo userRoleFieldPermInfo = this.getFieldPermInfoFromCache(appId, entityNum);
            List fieldPermModelList = userRoleFieldPermInfo.getFieldPermModelList();
            EntryGrid entry = (EntryGrid)this.getView().getControl(FIELD_ENTRY);
            fieldPermModelList.clear();
            DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity(FIELD_ENTRY);
            int[] selectRows = entry.getSelectRows();
            for (DynamicObject row : fieldEntry) {
                FieldPermModel fieldPermModel = new FieldPermModel();
                fieldPermModel.setEntityNum((Object)entityNum);
                fieldPermModel.setFiledNum(row.getString(FIELD_NUM));
                fieldPermModel.setFiledName(row.getString(FIELD_NAME));
                fieldPermModel.setIsBanWrite(row.getString(NOT_ALLOW_EDIT));
                fieldPermModel.setIsBanRead(row.getString(NOT_ALLOW_QUERY));
                fieldPermModelList.add(fieldPermModel);
            }
            for (Object idx : (Object)selectRows) {
                FieldPermModel fieldModel = (FieldPermModel)fieldPermModelList.get((int)idx);
                fieldModel.setIsBanRead(isBanRead);
                fieldModel.setIsBanWrite(isBanWrite);
            }
            this.fillFieldPermListByInfo(userRoleFieldPermInfo);
            if (HRStringUtils.isNotEmpty((String)entityNum)) {
                this.setFieldPermInfoToCache(appId, entityNum, userRoleFieldPermInfo);
            }
        }
    }

    protected void clearAllEntryRow() {
        this.getModel().deleteEntryData(FIELD_ENTRY);
        this.getModel().updateCache();
    }

    private void showFieldF7() {
        String[] entityInfo = this.getFocusEntityInfo(TREE_FIELDPERM, true);
        if (entityInfo == null) {
            return;
        }
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)CALLBACK_CHOOSE_FIELD, (boolean)true, (int)0, (boolean)true);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_CHOOSE_FIELD));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("paramEntityName", (Object)entityInfo[1]);
        fsp.setCustomParam("ServiceAppId", (Object)"hrcs");
        fsp.setShowTitle(true);
        fsp.setHasRight(true);
        DynamicObjectCollection fieldPermColl = this.getModel().getEntryEntity(FIELD_ENTRY);
        if (!CollectionUtils.isEmpty((Collection)fieldPermColl)) {
            List usedFields = fieldPermColl.stream().map(it -> it.getString(FIELD_NUM)).collect(Collectors.toList());
            fsp.getListFilterParameter().setFilter(new QFilter("fieldid", "not in", usedFields));
        }
        this.getView().showForm((FormShowParameter)fsp);
    }

    private void refreshFieldListByF7(ClosedCallBackEvent evt) {
        FieldPermModel fieldPermModel;
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        IDataModel model = this.getModel();
        if (returnData == null) {
            return;
        }
        ArrayList fieldPermModelList = Lists.newArrayListWithCapacity((int)16);
        DynamicObjectCollection selectedCol = model.getEntryEntity(FIELD_ENTRY);
        for (DynamicObject selectDy : selectedCol) {
            fieldPermModel = new FieldPermModel();
            fieldPermModel.setFiledName(selectDy.getString(FIELD_NAME));
            fieldPermModel.setEntityNum((Object)selectDy.getString("fieldperm_entity.number"));
            fieldPermModel.setFiledNum(selectDy.getString(FIELD_NUM));
            fieldPermModel.setIsBanRead(selectDy.getString(NOT_ALLOW_QUERY));
            fieldPermModel.setIsBanWrite(selectDy.getString(NOT_ALLOW_EDIT));
            fieldPermModelList.add(fieldPermModel);
        }
        Set selectedNumSet = selectedCol.stream().map(dy -> dy.getString(FIELD_NUM)).collect(Collectors.toSet());
        String[] entityInfo = this.getFocusEntityInfo(TREE_FIELDPERM, true);
        for (ListSelectedRow row : returnData) {
            String longStrId = row.getPrimaryKeyValue().toString();
            String[] longStrSplit = longStrId.split(FIELD_SEPERATOR);
            String fieldNum = longStrSplit[0];
            String fieldName = longStrSplit[1];
            fieldPermModel = new FieldPermModel();
            if (selectedNumSet.contains(fieldNum)) continue;
            fieldPermModel.setEntityNum((Object)entityInfo[1]);
            fieldPermModel.setFiledName(fieldName);
            fieldPermModel.setFiledNum(fieldNum);
            fieldPermModel.setIsBanRead("1");
            fieldPermModel.setIsBanWrite("1");
            fieldPermModelList.add(fieldPermModel);
        }
        UserRoleFieldPermInfo userRoleFieldPermInfo = new UserRoleFieldPermInfo();
        userRoleFieldPermInfo.setEmptyFlag(false);
        userRoleFieldPermInfo.setFieldPermModelList((List)fieldPermModelList);
        this.fillFieldPermListByInfo(userRoleFieldPermInfo);
        if (entityInfo != null) {
            this.setFieldPermInfoToCache(entityInfo[0], entityInfo[1], userRoleFieldPermInfo);
        }
    }

    private void cacheFieldTreeFocusNode(String[] focusEntityInfo) {
        String cacheValue = focusEntityInfo[0] + ENTITY_INFO_SPLIT + focusEntityInfo[1];
        this.getView().getPageCache().put(this.KEY_FIELD_TREE_FOCUSED, cacheValue);
    }

    private String[] getCacheFieldTreeFocusNode() {
        String cacheValue = this.getView().getPageCache().get(this.KEY_FIELD_TREE_FOCUSED);
        return cacheValue.split(ENTITY_INFO_SPLIT);
    }

    private void refreshFiledList() {
        String[] entityInfo = this.getFocusEntityInfo(TREE_FIELDPERM, true);
        if (entityInfo == null) {
            return;
        }
        this.cacheFieldTreeFocusNode(entityInfo);
        String appId = entityInfo[0];
        String entityNum = entityInfo[1];
        UserRoleFieldPermInfo userRoleFieldPermInfo = this.getFieldPermInfoFromCache(appId, entityNum);
        if (userRoleFieldPermInfo.isEmptyFlag()) {
            userRoleFieldPermInfo = this.getFieldPermInfoFromData(appId, entityNum);
            this.setFieldPermInfoToOriginCache(appId, entityNum, userRoleFieldPermInfo);
            this.setFieldPermInfoToCache(appId, entityNum, userRoleFieldPermInfo);
        }
        this.fillFieldPermListByInfo(userRoleFieldPermInfo);
    }

    private void setFieldPermInfoToOriginCache(String appId, String entityNum, UserRoleFieldPermInfo userRoleFieldPermInfo) {
        String fieldPermInfoMapKey = appId + ENTITY_INFO_SPLIT + entityNum;
        String currentCacheJson = this.getPageCache().get(ORIGIN_FIELD_CACHE);
        Map userRoleFieldPermInfoMap = FieldPermInfoJsonUtil.fromJsonStr((String)currentCacheJson);
        userRoleFieldPermInfoMap.put(fieldPermInfoMapKey, userRoleFieldPermInfo);
        this.getPageCache().put(ORIGIN_FIELD_CACHE, SerializationUtils.toJsonString((Object)userRoleFieldPermInfoMap));
    }

    protected UserRoleFieldPermInfo getFieldPermInfoFromCache(String appId, String entityNum) {
        UserRoleFieldPermInfo fieldPermInfo;
        String jsonStr = this.getPageCache().get(FIELD_PERM_CACHE);
        if (StringUtils.isEmpty((String)jsonStr)) {
            fieldPermInfo = new UserRoleFieldPermInfo();
            fieldPermInfo.setEmptyFlag(true);
        } else {
            Map fieldPermInfoMap = FieldPermInfoJsonUtil.fromJsonStr((String)jsonStr);
            String fieldPermInfoMapKey = appId + ENTITY_INFO_SPLIT + entityNum;
            fieldPermInfo = fieldPermInfoMap.getOrDefault(fieldPermInfoMapKey, new UserRoleFieldPermInfo(true));
        }
        return fieldPermInfo;
    }

    protected UserRoleFieldPermInfo getFieldPermInfoFromData(String appId, String entityNum) {
        UserRoleFieldPermInfo userRoleFieldPermInfo = new UserRoleFieldPermInfo();
        userRoleFieldPermInfo.setEmptyFlag(false);
        List fieldPermModelList = userRoleFieldPermInfo.getFieldPermModelList();
        Object userRoleRelateId = this.getUserRoleRelateId();
        String[] entityInfo = this.getFocusEntityInfo(TREE_FIELDPERM, true);
        if (entityInfo == null) {
            return userRoleFieldPermInfo;
        }
        HRBaseServiceHelper userFieldHelper = new HRBaseServiceHelper("hrcs_userfield");
        QFilter qFilter = new QFilter("userrolerealt", "=", (Object)PermRoleUtil.str2LongWithDefValue((String)((String)userRoleRelateId), (Long)0L)).and(new QFilter("entitytype", "=", (Object)entityNum)).and(new QFilter("app", "=", (Object)appId));
        String queryFields = "id, entryentity, entryentity.id, entryentity.fieldname, entryentity.isbanread, entryentity.isbanwrite";
        DynamicObject userFieldDy = userFieldHelper.queryOne(queryFields, new QFilter[]{qFilter});
        if (userFieldDy == null) {
            return userRoleFieldPermInfo;
        }
        Map fieldMap = RoleServiceHelper.getEntityFieldMap((String)entityNum);
        userRoleFieldPermInfo.setId(Long.valueOf(userFieldDy.getLong("id")));
        DynamicObjectCollection userFieldEntry = userFieldDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject userFieldRow : userFieldEntry) {
            FieldPermModel fieldPermModel = new FieldPermModel();
            fieldPermModel.setRoleFieldId(userRoleRelateId);
            fieldPermModel.setEntryId(userFieldRow.get("id"));
            String fieldName = userFieldRow.getString("fieldname");
            fieldPermModel.setFiledNum(fieldName);
            fieldPermModel.setFiledName((String)fieldMap.get(fieldName));
            fieldPermModel.setIsBanRead(userFieldRow.getString("isbanread"));
            fieldPermModel.setIsBanWrite(userFieldRow.getString("isbanwrite"));
            fieldPermModelList.add(fieldPermModel);
        }
        return userRoleFieldPermInfo;
    }

    protected Object getUserRoleRelateId() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        return params.get("userRoleRelateId");
    }

    private void setFieldPermInfoToCache(String appId, String entityNum, UserRoleFieldPermInfo userRoleFieldPermInfo) {
        String fieldPermInfoMapKey = appId + ENTITY_INFO_SPLIT + entityNum;
        String jsonStr = this.getPageCache().get(FIELD_PERM_CACHE);
        Map userRoleFieldPermInfoMap = FieldPermInfoJsonUtil.fromJsonStr((String)jsonStr);
        userRoleFieldPermInfoMap.put(fieldPermInfoMapKey, userRoleFieldPermInfo);
        this.getPageCache().put(FIELD_PERM_CACHE, SerializationUtils.toJsonString((Object)userRoleFieldPermInfoMap));
    }

    protected void fillFieldPermListByInfo(UserRoleFieldPermInfo userRoleFieldPermInfo) {
        this.clearAllEntryRow();
        if (userRoleFieldPermInfo.isEmptyFlag()) {
            return;
        }
        List fieldPermModelList = userRoleFieldPermInfo.getFieldPermModelList();
        IDataModel model = this.getModel();
        model.getEntryEntity(FIELD_ENTRY);
        if (fieldPermModelList.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(FIELD_ENTRY, fieldPermModelList.size());
            for (int index = 0; index < fieldPermModelList.size(); ++index) {
                FieldPermModel fieldPermModel = (FieldPermModel)fieldPermModelList.get(index);
                model.setValue(FIELDPERM_ENTITY, fieldPermModel.getEntityNum(), index);
                model.setValue(FIELD_ENTRY_ID, fieldPermModel.getEntryId(), index);
                model.setValue(FIELD_NAME, (Object)fieldPermModel.getFiledName(), index);
                model.setValue(FIELD_NUM, (Object)fieldPermModel.getFiledNum(), index);
                String isBanRead = fieldPermModel.getIsBanRead();
                String isBanWrite = fieldPermModel.getIsBanWrite();
                model.setValue(NOT_ALLOW_QUERY, (Object)isBanRead, index);
                model.setValue(NOT_ALLOW_EDIT, (Object)isBanWrite, index);
                if (!Objects.equals(isBanRead, "1")) continue;
                this.getView().setEnable(Boolean.FALSE, index, new String[]{NOT_ALLOW_EDIT});
            }
            model.endInit();
        }
        this.getView().updateView(FIELD_ENTRY);
    }

    private void updateFieldCache(boolean clearEntryRow) {
        String[] entityInfo = this.getFocusEntityInfo(TREE_FIELDPERM, clearEntryRow);
        if (Objects.isNull(entityInfo) && Objects.isNull(entityInfo = this.getCacheFieldTreeFocusNode())) {
            return;
        }
        String appId = entityInfo[0];
        String entityNum = entityInfo[1];
        UserRoleFieldPermInfo userRoleFieldPermInfo = this.getFieldPermInfoFromCache(appId, entityNum);
        List fieldPermModelList = userRoleFieldPermInfo.getFieldPermModelList();
        fieldPermModelList.clear();
        DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity(FIELD_ENTRY);
        for (DynamicObject row : fieldEntry) {
            FieldPermModel fieldPermModel = new FieldPermModel();
            fieldPermModel.setEntityNum((Object)entityNum);
            fieldPermModel.setFiledNum(row.getString(FIELD_NUM));
            fieldPermModel.setFiledName(row.getString(FIELD_NAME));
            fieldPermModel.setIsBanRead(row.getString(NOT_ALLOW_QUERY));
            fieldPermModel.setIsBanWrite(row.getString(NOT_ALLOW_EDIT));
            fieldPermModelList.add(fieldPermModel);
        }
        this.setFieldPermInfoToCache(appId, entityNum, userRoleFieldPermInfo);
    }

    private void setEditBtn(int rowIndex) {
        String value = (String)this.getModel().getValue(NOT_ALLOW_QUERY);
        if (HRStringUtils.equals((String)value, (String)"0")) {
            this.getModel().setValue(NOT_ALLOW_EDIT, (Object)"1");
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{NOT_ALLOW_EDIT});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{NOT_ALLOW_EDIT});
            this.getModel().setValue(NOT_ALLOW_EDIT, (Object)"1");
        }
    }
}

