/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermCommonTreeHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DimensionHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.PermDimTreeEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@ExcludeFromJacocoGeneratedReport
public class PermCommonTreePlugin
extends HRDynamicFormBasePlugin
implements IDataModelChangeListener,
TreeNodeQueryListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static final String KEY_NOT_HAS_RIGHT_IDS = "notHasRightIds";

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        Object entityNumber = evt.getFormShowParameter().getCustomParam("entityNumber");
        if (Objects.isNull(entityNumber) || HRStringUtils.isEmpty((String)entityNumber.toString())) {
            evt.setCancel(true);
            evt.setCancelMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"PermCommonTreePlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Button btnOk = (Button)this.getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        TreeView treeview = (TreeView)this.getControl("treeview");
        treeview.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        treeview.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Label label = (Label)this.getControl("clearall");
        label.addClickListener((ClickListener)this);
        Label previewAllLabel = (Label)this.getControl("previewall");
        previewAllLabel.addClickListener((ClickListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        Search entrySearch = (Search)this.getView().getControl("searchap1");
        entrySearch.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        TreeNode treeNode = PermCommonTreeHelper.getInstance().buildTree(this.getView(), null);
        this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)treeNode));
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Optional<Pair<Map<String, Map<String, Object>>, Map<String, TreeNode>>> optionalData = this.getDataForForm();
        if (optionalData.isPresent()) {
            LinkedHashMap withChild2Node = Maps.newLinkedHashMapWithExpectedSize((int)16);
            this.fillValue((Map)optionalData.get().getKey(), (Map)optionalData.get().getValue(), withChild2Node);
            this.fillEntry(withChild2Node);
        }
    }

    private Optional<Pair<Map<String, Map<String, Object>>, Map<String, TreeNode>>> getDataForForm() {
        JSONObject jsonValue;
        RoleDataPermModel permModel;
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!this.hasMemoryEnry()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            entryEntity.forEach(entry -> {
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", entry.getString("id"));
                item.put("name", entry.getString("name"));
                item.put("includeSub", entry.getBoolean("includesub"));
                valueMap.put(entry.getString("id"), item);
            });
        }
        if (Objects.isNull(permModel = (RoleDataPermModel)JSONObject.toJavaObject((JSON)(jsonValue = (JSONObject)this.getView().getFormShowParameter().getCustomParam("checkValue")), RoleDataPermModel.class))) {
            return Optional.empty();
        }
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        String rootNodeStr = this.getPageCache().get("rootNode");
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        LinkedHashMap treeNodes = Maps.newLinkedHashMapWithExpectedSize((int)16);
        this.flatTree(rootNode, treeNodes);
        if (CollectionUtils.isEmpty((Map)treeNodes)) {
            return Optional.empty();
        }
        Object isOrgDimParam = this.getView().getFormShowParameter().getCustomParam("isOrgDim");
        boolean isOrgDim = false;
        if (isOrgDimParam != null) {
            isOrgDim = (Boolean)isOrgDimParam;
        }
        if (valueMap.isEmpty()) {
            if ("bos_org".equals(entityNumber) && !isOrgDim) {
                valueMap.putAll(permModel.getOrgMap());
            } else {
                String controlId;
                String[] split;
                Map dimGroupMap = permModel.getDimGroupMap();
                DimGrpModel dimGrpModel = (DimGrpModel)dimGroupMap.get((split = (controlId = (String)this.getView().getFormShowParameter().getCustomParam("controlId")).split("#"))[2]);
                if (Objects.isNull(dimGrpModel)) {
                    return Optional.empty();
                }
                String dimNumber = (String)this.getView().getFormShowParameter().getCustomParam("dimensionNumber");
                TreeMap dimMap = dimGrpModel.getDimMap();
                DimModel dimModel = (DimModel)dimMap.get(dimNumber);
                if (!Objects.isNull(dimModel)) {
                    Map<String, Map> values = dimModel.getDimValues().entrySet().stream().filter(it -> !HRStringUtils.equals((String)"2", (String)((String)((Map)it.getValue()).get("valueType")))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue));
                    valueMap.putAll(values);
                }
            }
        }
        if (CollectionUtils.isEmpty((Map)valueMap)) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)valueMap, (Object)treeNodes));
    }

    private void fillValue(Map<String, Map<String, Object>> valueMap, Map<String, TreeNode> treeNodes, LinkedHashMap<TreeNode, Triple<Boolean, Boolean, Boolean>> withChild2Node) {
        HashMap<String, TreeNode> currentTreeNodes = new HashMap<String, TreeNode>(treeNodes);
        HashMap<String, Map<String, Object>> currentValueMap = new HashMap<String, Map<String, Object>>(valueMap);
        Set<String> originalTreeNodeIds = treeNodes.keySet();
        Set selectedNodeIdSet = currentValueMap.keySet();
        Set treeNodeIdSet = currentTreeNodes.keySet();
        selectedNodeIdSet.removeAll(treeNodeIdSet);
        Map<String, TreeNode> prepareNodes = selectedNodeIdSet.stream().map(nodeId -> {
            Map valueItem = (Map)valueMap.get(nodeId);
            TreeNode tempItem = new TreeNode("0", nodeId, valueItem.get("name").toString());
            tempItem.setLongNumber(valueItem.getOrDefault("number", "").toString());
            return tempItem;
        }).collect(Collectors.toMap(TreeNode::getId, node -> node, (oldValue, newValue) -> oldValue));
        currentTreeNodes.putAll(prepareNodes);
        for (Map.Entry<String, Map<String, Object>> entry : valueMap.entrySet()) {
            String orgId = entry.getKey();
            TreeNode currentNode = (TreeNode)currentTreeNodes.get(orgId);
            Map<String, Object> value = entry.getValue();
            if (HRStringUtils.isEmpty((String)orgId) || null == currentNode) continue;
            Object includeSub = value.get("includeSub");
            boolean flag = includeSub instanceof String ? Boolean.parseBoolean((String)value.get("includeSub")) : (Boolean)includeSub;
            withChild2Node.put(currentNode, (Triple<Boolean, Boolean, Boolean>)Triple.of((Object)flag, (Object)(!CollectionUtils.isEmpty((Collection)currentNode.getChildren()) ? 1 : 0), (Object)(!currentNode.isDisabled() && originalTreeNodeIds.contains(orgId) ? 1 : 0)));
        }
        TreeView treeView = (TreeView)this.getControl("treeview");
        treeView.checkNodesWithoutChild(new ArrayList<TreeNode>(withChild2Node.keySet()));
    }

    private void flatTree(TreeNode rootNode, LinkedHashMap<String, TreeNode> result) {
        result.put(rootNode.getId(), rootNode);
        List children = rootNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (TreeNode child : children) {
                this.flatTree(child, result);
            }
        }
    }

    private void fillEntry(LinkedHashMap<TreeNode, Triple<Boolean, Boolean, Boolean>> withChild2Node) {
        this.getModel().beginInit();
        ArrayList<String> notHasRightIds = new ArrayList<String>();
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        int index = 0;
        for (Map.Entry<TreeNode, Triple<Boolean, Boolean, Boolean>> entry : withChild2Node.entrySet()) {
            TreeNode node = entry.getKey();
            if (Objects.isNull(node)) continue;
            Boolean containSub = (Boolean)entry.getValue().getLeft();
            Boolean hasChildren = (Boolean)entry.getValue().getMiddle();
            Boolean hasRight = (Boolean)entry.getValue().getRight();
            if (!hasRight.booleanValue()) {
                rowIndexList.add(index);
                notHasRightIds.add(node.getId());
            }
            this.getModel().insertEntryRow("entryentity", index);
            this.getModel().setValue("id", (Object)node.getId(), index);
            this.getModel().setValue("name", (Object)node.getText(), index);
            this.getModel().setValue("number", (Object)node.getLongNumber(), index);
            this.getModel().setValue("includesub", (Object)containSub, index);
            this.getModel().setValue("haschildren", (Object)hasChildren, index);
            ++index;
        }
        this.getModel().endInit();
        if (!rowIndexList.isEmpty()) {
            rowIndexList.forEach(rowIndex -> this.getView().setEnable(Boolean.FALSE, rowIndex.intValue(), new String[]{"includesub", "haschildren"}));
            this.getPageCache().put(KEY_NOT_HAS_RIGHT_IDS, SerializationUtils.toJsonString(notHasRightIds));
        }
        this.getView().updateView("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (HRStringUtils.equals((String)"donothing", (String)operationKey)) {
            this.getPageCache().put("deleteEntry", "1");
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = eg.getSelectRows();
            String id = (String)this.getModel().getValue("id", index);
            TreeView treeView = (TreeView)this.getControl("treeview");
            treeView.uncheckNode(id);
            this.getModel().deleteEntryRow("entryentity", index);
            this.selectUndeletedRow(index, selectRows, eg);
            this.getPageCache().remove("deleteEntry");
            if (this.hasMemoryEnry()) {
                List memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
                memoryEntry.removeIf(model -> HRStringUtils.equals((String)id, (String)model.getId()));
                this.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)memoryEntry));
            }
        }
    }

    private void selectUndeletedRow(int index, int[] selectRows, EntryGrid eg) {
        int[] rows = new int[selectRows.length];
        for (int idx = 0; idx < selectRows.length; ++idx) {
            rows[idx] = index == selectRows[idx] ? -1 : (selectRows[idx] > index ? selectRows[idx] - 1 : selectRows[idx]);
        }
        int[] ints = Arrays.stream(rows).filter(it -> it != -1).toArray();
        eg.selectRows(ints, -1);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control field = (Control)evt.getSource();
        switch (key = field.getKey()) {
            case "btnok": {
                if (this.hasMemoryEnry()) {
                    List memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
                    this.getModel().beginInit();
                    this.getModel().deleteEntryData("entryentity");
                    this.insertEntryByModel(memoryEntry);
                    this.getModel().endInit();
                }
                PermCommonTreeHelper.handleOk((IFormView)this.getView());
                break;
            }
            case "clearall": {
                PermCommonTreeHelper.handleClearAll((IFormView)this.getView());
                break;
            }
            case "previewall": {
                DynamicObjectCollection items = this.getModel().getEntryEntity("entryentity");
                Map<String, Boolean> entryOtSubMap = items.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> it.getBoolean("includesub"), (oldValue, newValue) -> oldValue));
                TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("rootNode"), TreeNode.class);
                List nodes = items.stream().map(it -> {
                    String currentItemOtSub;
                    String string = currentItemOtSub = it.getBoolean("includesub") ? "1" : "0";
                    if (HRStringUtils.equals((String)currentItemOtSub, (String)"0")) {
                        String tempNodeId = it.getString("id");
                        TreeNode tempTreeNode = treeNode.getTreeNode(tempNodeId);
                        while (null != tempTreeNode && HRStringUtils.isNotEmpty((String)tempNodeId)) {
                            if (entryOtSubMap.getOrDefault(tempNodeId, false).booleanValue()) {
                                currentItemOtSub = "1";
                                break;
                            }
                            tempNodeId = tempTreeNode.getParentid();
                            tempTreeNode = treeNode.getTreeNode(tempNodeId);
                        }
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("nodeId", it.getString("id"));
                    map.put("nodeName", it.getString("name"));
                    map.put("nodeIcon", "");
                    map.put("nodeType", "1010");
                    map.put("hasChildren", it.getBoolean("haschildren") ? "1" : "0");
                    map.put("otSub", currentItemOtSub);
                    map.put("crossOtSub", "0");
                    return map;
                }).collect(Collectors.toList());
                String identify = (String)this.getView().getFormShowParameter().getCustomParam("identify");
                Pair<String, String> captionAndTips = this.getCaptionAndTips(identify);
                String caption = (String)captionAndTips.getLeft();
                String tips = (String)captionAndTips.getRight();
                HashMap<String, Object> otherParam = new HashMap<String, Object>();
                otherParam.put("entityNumber", this.getView().getFormShowParameter().getCustomParam("entityNumber"));
                otherParam.put("currentHRbuCaFunc", this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc"));
                otherParam.put("tips", tips);
                otherParam.put("skipPermissionControl", this.getView().getFormShowParameter().getCustomParam("skipPermissionControl"));
                this.showPreviewForm(SerializationUtils.toJsonString(nodes), "1", "1010", caption, identify, otherParam);
                break;
            }
        }
    }

    private void showPreviewForm(String nodes, String isAll, String ot, String caption, String identify, Map<String, Object> otherParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrcs_ottreepreview");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("nodes", (Object)nodes);
        parameter.setCustomParam("isAll", (Object)isAll);
        parameter.setCustomParam("from", (Object)ot);
        parameter.setCustomParam("identify", (Object)identify);
        parameter.getCustomParams().putAll(otherParams);
        parameter.setCaption(caption);
        this.getView().showForm(parameter);
    }

    private Pair<String, String> getCaptionAndTips(String identify) {
        String caption = "";
        String tips = "";
        switch (identify) {
            case "bizOrg": {
                IFormView mainPageView = this.getView().getView((String)this.getView().getFormShowParameter().getCustomParam("mainPageId"));
                String HRbuFunc = DimensionHelper.getHrbuFunc((IPageCache)mainPageView.getPageCache());
                PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(mainPageView, false);
                Map assignedHrBuCaMap = permPageCacheUtil.getAssignedHrBuCaMap();
                caption = (String)((Map)assignedHrBuCaMap.get(HRbuFunc)).get("name");
                tips = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"HRDataPermCtrlContainerPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                break;
            }
            case "funcDim": {
                String dimId = (String)this.getView().getFormShowParameter().getCustomParam("dimId");
                DynamicObject dimension = new HRBaseServiceHelper("hrcs_dimension").queryOne("number,name,entitytype,hrbu", (Object)Long.parseLong(dimId));
                String dimensionName = dimension.getLocaleString("name").getLocaleValue();
                String previewLabelName = ResManager.loadKDString((String)"\u9884\u89c8", (String)"CustomCtrlPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                caption = dimensionName + previewLabelName;
                tips = dimensionName;
                break;
            }
            case "common": {
                String dimId = (String)this.getView().getFormShowParameter().getCustomParam("dimId");
                DynamicObject dimension = new HRBaseServiceHelper("hrcs_dimension").queryOne("number,name,entitytype", (Object)Long.parseLong(dimId));
                String dimensionName = dimension.getLocaleString("name").getLocaleValue();
                String previewLabelName = ResManager.loadKDString((String)"\u9884\u89c8", (String)"CustomCtrlPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                caption = dimensionName + previewLabelName;
                tips = dimensionName;
                break;
            }
        }
        return Pair.of((Object)caption, (Object)tips);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        HRPageCache pageCache = new HRPageCache(this.getView());
        Map parentMap = (Map)pageCache.get("parentMap", Map.class);
        Map childrenMap = (Map)parentMap.get(nodeId);
        if (null != childrenMap && !childrenMap.isEmpty()) {
            ArrayList treeNodeList = Lists.newArrayListWithExpectedSize((int)childrenMap.size());
            for (Map.Entry entry : childrenMap.entrySet()) {
                PermCommonTreeHelper.queryChildren((Map)parentMap, (List)treeNodeList, entry);
            }
            TreeView treeView = (TreeView)this.getControl("treeview");
            treeView.addNodes((List)treeNodeList);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        List notHasRightIds = new ArrayList();
        String notHasRightIdsStr = this.getPageCache().get(KEY_NOT_HAS_RIGHT_IDS);
        if (HRStringUtils.isNotEmpty((String)notHasRightIdsStr)) {
            notHasRightIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_NOT_HAS_RIGHT_IDS), List.class);
        }
        PermCommonTreeHelper.getInstance().handleTreeNodeCheck(this.getView(), treeNodeCheckEvent, notHasRightIds);
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        String key = source.getKey();
        String searchText = evt.getText();
        if (HRStringUtils.equals((String)key, (String)"searchap")) {
            TreeView tv = (TreeView)this.getView().getControl("treeview");
            tv.deleteAllNodes();
            PermCommonTreeHelper.getInstance().buildTree(this.getView(), searchText);
            Optional<Pair<Map<String, Map<String, Object>>, Map<String, TreeNode>>> optionalData = this.getDataForForm();
            if (optionalData.isPresent()) {
                LinkedHashMap withChild2Node = Maps.newLinkedHashMapWithExpectedSize((int)16);
                this.fillValue((Map)optionalData.get().getKey(), (Map)optionalData.get().getValue(), withChild2Node);
            }
        } else {
            List memoryEntry;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (!this.hasMemoryEnry()) {
                this.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)entryEntity));
            }
            if (CollectionUtils.isEmpty((Collection)(memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView()))) && !CollectionUtils.isEmpty((Collection)entryEntity)) {
                this.getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)entryEntity));
                memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
            }
            if (CollectionUtils.isEmpty((Collection)memoryEntry)) {
                return;
            }
            this.getModel().beginInit();
            this.getModel().deleteEntryData("entryentity");
            ArrayList newValue = Lists.newArrayListWithExpectedSize((int)16);
            for (PermDimTreeEntryModel model : memoryEntry) {
                String name = model.getName();
                String number = model.getNumber();
                if (HRStringUtils.isEmpty((String)searchText) || !name.contains(searchText) && !number.contains(searchText)) continue;
                newValue.add(model);
            }
            if (HRStringUtils.isEmpty((String)searchText)) {
                newValue.addAll(memoryEntry);
            }
            this.insertEntryByModel(newValue);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("includesub".equals(name) && this.hasMemoryEnry()) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            String id = (String)this.getModel().getValue("id", index);
            List memoryEntry = PermCommonTreeHelper.getInstance().getMemoryEntry(this.getView());
            memoryEntry.forEach(entry -> {
                if (HRStringUtils.equals((String)id, (String)entry.getId())) {
                    entry.setIncludesub(((Boolean)this.getModel().getValue("includesub", index)).booleanValue());
                }
            });
            this.getView().getPageCache().put("originalEntryValue", SerializationUtils.toJsonString((Object)memoryEntry));
        }
    }

    private void insertEntryByModel(List<PermDimTreeEntryModel> memoryEntry) {
        for (int index = 0; index < memoryEntry.size(); ++index) {
            PermDimTreeEntryModel model = memoryEntry.get(index);
            this.getModel().insertEntryRow("entryentity", index);
            this.getModel().setValue("id", (Object)model.getId(), index);
            this.getModel().setValue("name", (Object)model.getName(), index);
            this.getModel().setValue("number", (Object)model.getNumber(), index);
            this.getModel().setValue("includesub", (Object)model.isIncludesub(), index);
            this.getModel().setValue("haschildren", (Object)model.isHaschildren(), index);
        }
    }

    private boolean hasMemoryEnry() {
        return !HRStringUtils.isEmpty((String)this.getView().getPageCache().get("originalEntryValue"));
    }
}

