/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;

public class RoleAssignMemberEntryGrid
extends EntryGrid {
    private static final Log LOGGER = LogFactory.getLog(RoleAssignMemberEntryGrid.class);
    private static final String MEMBERENTRY = "memberentry";
    private static final String MEMBERENTRY_STATE = "memberentryState";
    private static final Map<String, String> PROP_NAME = new HashMap<String, String>();

    public boolean isNeedPaged() {
        return true;
    }

    protected void bindPageData(BindingContext bctx) {
        try {
            String entryStateStr = this.getView().getPageCache().get(MEMBERENTRY_STATE);
            if (HRStringUtils.isNotEmpty((String)entryStateStr)) {
                Map state = (Map)SerializationUtils.fromJsonString((String)entryStateStr, Map.class);
                IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
                proxy.postBack(MEMBERENTRY, (Object)state);
                this.getView().getPageCache().remove(MEMBERENTRY_STATE);
            }
        }
        catch (Exception exception) {
            LOGGER.info("Got error.", (Object)exception);
        }
        super.bindPageData(bctx);
    }

    protected DynamicObject[] getEntryDataEntities(int startIndex, int endIndex) {
        List qFilters = new ArrayList();
        String orderBy = null;
        EntryQueryParam queryParam = this.getPageCacheQueryParam();
        if (null != queryParam) {
            this.translateQueryParam(queryParam);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"hrcs_userrolerelat"), queryParam.buildFilterCondition());
            filterBuilder.buildFilter();
            qFilters = filterBuilder.getQFilters();
            orderBy = queryParam.getSortItems().stream().filter(it -> 0 != it.getSortStyle()).map(it -> it.getSortColumnName() + " " + (it.getSortStyle() == 1 ? "ASC" : "DESC")).reduce("", (it1, it2) -> it1 + " " + it2);
        }
        int pageIndex = this.getEntryState().getCurrentPageIndex() - 1;
        int pageSize = this.getEntryState().getPageRows();
        LOGGER.info("start get user info by role with params qfilters: {} pageIndex: {} pageSize: {}.", new Object[]{qFilters, pageIndex, pageSize});
        Object[] relations = RoleMemberAssignServiceHelper.getUserInfoByRole((String)this.getRoleId(), qFilters, (String)orderBy, (int)pageIndex, (int)pageSize);
        LOGGER.info("end get user info by role with results size: {}.", (Object)relations.length);
        ArrayList<DynamicObject> items = new ArrayList<DynamicObject>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_rolememassign");
        HRBaseServiceHelper userServiceHelper = new HRBaseServiceHelper("bos_user");
        if (!ObjectUtils.isEmpty((Object[])relations)) {
            AtomicInteger index = new AtomicInteger(1);
            for (Object dynamicObject : relations) {
                DynamicObject item = serviceHelper.generateEmptyEntryDynamicObject(MEMBERENTRY);
                Object relation = dynamicObject;
                DynamicObject tempUserDynamicObject = Optional.ofNullable(relation.getDynamicObject("user")).orElseGet(() -> ((HRBaseServiceHelper)userServiceHelper).generateEmptyDynamicObject());
                DynamicObject tempPermDynamicObject = relation.getDynamicObject("permfile");
                item.set("picturefield", (Object)tempUserDynamicObject.getString("picturefield"));
                item.set("membername", (Object)tempUserDynamicObject.getLocaleString("name"));
                item.set("membernumber", (Object)tempUserDynamicObject.getString("number"));
                item.set("isforbidden", (Object)tempUserDynamicObject.getString("isforbidden"));
                item.set("userrolerelateid", (Object)relation.getLong("id"));
                item.set("permfileid", (Object)tempPermDynamicObject.getLong("id"));
                item.set("hrbu", (Object)tempPermDynamicObject.getLocaleString("org.name"));
                item.set("dataproperty", (Object)relation.getString("customenable"));
                item.set("scheme", relation.get("scheme"));
                item.set("createtime", (Object)PermRoleUtil.date2LocalTime((Date)relation.getDate("createtime")));
                item.set("creatorname", (Object)relation.getString("creator.name"));
                item.set("validstart", (Object)relation.getDate("validstart"));
                item.set("validend", (Object)relation.getDate("validend"));
                item.set("seq", (Object)index.getAndIncrement());
                String sourceType = relation.getString("sourcetype");
                item.set("sourcetype", (Object)sourceType);
                if (HRStringUtils.equals((String)sourceType, (String)"3")) {
                    item.set("sourcebdtype", (Object)"hrcs_perminitrecord");
                    item.set("sourcebd", relation.get("initrecord"));
                } else if (HRStringUtils.equals((String)sourceType, (String)"4")) {
                    item.set("sourcebdtype", (Object)"hrcs_dynascheme");
                    item.set("sourcebd", relation.get("scheme"));
                }
                items.add(item);
            }
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(MEMBERENTRY);
        dynamicObjects.clear();
        for (int index = 0; index < endIndex; ++index) {
            if (index < startIndex) {
                dynamicObjects.addNew();
                continue;
            }
            dynamicObjects.add(items.get(index - startIndex));
        }
        this.getModel().setValue(MEMBERENTRY, (Object)dynamicObjects);
        this.getModel().updateEntryCache(dynamicObjects);
        return items.toArray(new DynamicObject[0]);
    }

    protected int getRowCount() {
        LOGGER.info("start to get row count.");
        List qFilters = new ArrayList();
        EntryQueryParam queryParam = this.getPageCacheQueryParam();
        if (null != queryParam) {
            this.translateQueryParam(queryParam);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"hrcs_userrolerelat"), queryParam.buildFilterCondition());
            filterBuilder.buildFilter();
            qFilters = filterBuilder.getQFilters();
        }
        LOGGER.info("end to translate query param.");
        int count = RoleMemberAssignServiceHelper.getUserCountByRole((String)this.getRoleId(), qFilters);
        LOGGER.info("end to get row count: {}.", (Object)count);
        return count;
    }

    protected boolean onFetchPageData(int pageIndex, int pageRows) {
        return true;
    }

    private EntryQueryParam getPageCacheQueryParam() {
        IPageCache pageCache = this.getView().getPageCache();
        String str = pageCache.get(this.getPageCacheQueryParamKey());
        return str == null ? null : (EntryQueryParam)SerializationUtils.fromJsonString((String)str, EntryQueryParam.class);
    }

    private String getPageCacheQueryParamKey() {
        return "entryQueryParam." + this.getEntryKey();
    }

    private void translateQueryParam(EntryQueryParam queryParam) {
        LOGGER.info("Got original query param: {}.", (Object)queryParam);
        try {
            for (EntryFilterItemInfo item : queryParam.getFilterItems()) {
                Object itemValue;
                String realPropName = PROP_NAME.get(item.getPropName());
                if (HRStringUtils.isNotEmpty((String)realPropName)) {
                    item.setPropName(realPropName);
                }
                if ((itemValue = item.getValue()) instanceof String) {
                    if (HRStringUtils.equals((String)"false", (String)((String)itemValue))) {
                        item.setValue((Object)"0");
                        continue;
                    }
                    if (!HRStringUtils.equals((String)"true", (String)((String)itemValue))) continue;
                    item.setValue((Object)"1");
                    continue;
                }
                if (!(itemValue instanceof List)) continue;
                item.setValue(((List)itemValue).stream().map(it -> {
                    if (it instanceof String) {
                        if (HRStringUtils.equals((String)"false", (String)((String)it))) {
                            return "0";
                        }
                        if (HRStringUtils.equals((String)"true", (String)((String)it))) {
                            return "1";
                        }
                        return it;
                    }
                    return it;
                }).collect(Collectors.toList()));
            }
            for (EntryFilterItemInfo item : queryParam.getSortItems()) {
                item.setSortColumnName(PROP_NAME.getOrDefault(item.getSortColumnName(), item.getSortColumnName()));
            }
        }
        catch (Exception exception) {
            LOGGER.info("translateQueryParam error.", (Object)exception);
        }
        LOGGER.info("Got latest query param: {}.", (Object)queryParam);
    }

    private String getRoleId() {
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam("roleId");
        return HRStringUtils.isEmpty((String)roleId) ? "1=UYGP=CQ7+O" : roleId;
    }

    static {
        PROP_NAME.put("membername", "user.name");
        PROP_NAME.put("membernumber", "user.number");
        PROP_NAME.put("hrbu", "permfile.org.name");
        PROP_NAME.put("isforbidden", "user.isforbidden");
        PROP_NAME.put("creatorname", "creator.name");
    }
}

