/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.md.FieldPermModel;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.formplugin.web.perm.role.AssignedFunctionTreePlugin;

public class RoleDataRuleFieldPermEdit
extends AssignedFunctionTreePlugin {
    private static final Log LOG = LogFactory.getLog(RoleDataRuleFieldPermEdit.class);
    private static final String BD_ENTITY = "bdentity";
    private static final String BD_DATA_RULE = "bddatarule";
    private static final String CALLBACK_ID_BD_PROPKEY = "CallBackId_bdPropKey";
    private static final String BD_PROPKEY = "bdpropkey";
    private static final String BD_PROPNAME = "bdpropname";
    private static final String IS_BAN_READ = "isbanread";
    private static final String IS_BAN_WRITE = "isbanwrite";
    private static final String FIELD_PERM_ENTRY = "fieldpermentry";
    private static final String ROLE_FIELD_ENTITY = "hrcs_rolefield";
    private static final String APP = "app";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("roleName")) {
            Tab tabap = (Tab)this.getView().getControl("tabap");
            tabap.activeTab("tabpageap4");
        }
        RoleServiceHelper.loadRoleFieldPerm((IFormView)this.getView(), (String)this.getRoleId());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (Objects.equals(CALLBACK_ID_BD_PROPKEY, actionId)) {
            this.refreshDataRulePropKeyByF7(evt);
        }
    }

    private void refreshDataRulePropKeyByF7(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        IDataModel model = this.getModel();
        if (returnData == null) {
            return;
        }
        for (ListSelectedRow row : returnData) {
            String longStrId = row.getPrimaryKeyValue().toString();
            int splitIndex = longStrId.indexOf("||");
            String bdPropKey = longStrId.substring(0, splitIndex);
            String bdPropName = longStrId.substring(splitIndex + 2);
            int splitIndex2 = bdPropName.indexOf("||");
            String propEntNum = bdPropName.substring(splitIndex2 + 2);
            bdPropName = bdPropName.substring(0, splitIndex2);
            boolean isSelected = false;
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity_bddatarule1");
            for (DynamicObject dyObject : entryEntity) {
                if (!bdPropKey.equals(dyObject.getString(BD_PROPKEY))) continue;
                isSelected = true;
                break;
            }
            if (isSelected) continue;
            model.beginInit();
            int curIndex = this.getModel().createNewEntryRow("entryentity_bddatarule1");
            model.setValue(BD_PROPKEY, (Object)bdPropKey, curIndex);
            model.setValue(BD_PROPNAME, (Object)bdPropName, curIndex);
            model.setValue(BD_ENTITY, (Object)propEntNum, curIndex);
            model.setValue(BD_DATA_RULE, null, curIndex);
            model.endInit();
        }
        this.getView().updateView("entryentity_bddatarule1");
    }

    private String getRoleId() {
        return (String)this.getView().getFormShowParameter().getCustomParam("roleId");
    }

    @Override
    protected UserRoleFieldPermInfo getFieldPermInfoFromData(String appId, String entityNum) {
        String roleId = this.getRoleId();
        UserRoleFieldPermInfo userRoleFieldPermInfo = new UserRoleFieldPermInfo();
        HRBaseServiceHelper roleFieldHelper = new HRBaseServiceHelper(ROLE_FIELD_ENTITY);
        QFilter qFilter = new QFilter("role", "=", (Object)roleId).and(new QFilter("entitytype", "=", (Object)entityNum)).and(new QFilter(APP, "=", (Object)appId));
        DynamicObject roleFieldDy = roleFieldHelper.queryOne("id, fieldpermentry, fieldpermentry.fieldname, fieldpermentry.isbanread, fieldpermentry.isbanwrite", new QFilter[]{qFilter});
        if (Objects.isNull(roleFieldDy)) {
            return userRoleFieldPermInfo;
        }
        Map fieldMap = RoleServiceHelper.getEntityFieldMap((String)entityNum);
        userRoleFieldPermInfo.setId(Long.valueOf(roleFieldDy.getLong("id")));
        List fieldPermModelList = userRoleFieldPermInfo.getFieldPermModelList();
        DynamicObjectCollection roleFieldEntry = roleFieldDy.getDynamicObjectCollection(FIELD_PERM_ENTRY);
        for (DynamicObject userFieldRow : roleFieldEntry) {
            FieldPermModel fieldPermModel = new FieldPermModel();
            fieldPermModel.setEntryId(userFieldRow.get("id"));
            fieldPermModel.setRoleFieldId((Object)roleId);
            String fieldName = userFieldRow.getString("fieldname");
            fieldPermModel.setFiledNum(fieldName);
            fieldPermModel.setEntityNum((Object)entityNum);
            fieldPermModel.setFiledName((String)fieldMap.get(fieldName));
            fieldPermModel.setIsBanRead(userFieldRow.getString(IS_BAN_READ));
            fieldPermModel.setIsBanWrite(userFieldRow.getString(IS_BAN_WRITE));
            fieldPermModelList.add(fieldPermModel);
        }
        return userRoleFieldPermInfo;
    }
}

