/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class RoleGrpPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final String LONGNUMBER = "longnumber";
    private static final String DESCRIPTION = "description";
    private static final String FIELD_PARENT = "parent";
    private static final String FIELD_LONGNUMBER = "longnumber";
    private static final String ENTITY_BOS_ROLEGROUP = "perm_rolegroup";
    private static final String ENTITY_HR_ROLEGROUP = "hrcs_rolegrp";

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.getModel().setValue(FIELD_PARENT, (Object)this.getParentFocusNode());
    }

    private String getParentFocusNode() {
        TreeView tv;
        IFormView parentFormView = this.getView().getParentView();
        String focusNodeId = "";
        if (parentFormView != null && (tv = (TreeView)parentFormView.getControl("treeview")) != null) {
            focusNodeId = tv.getTreeState().getFocusNodeId();
        }
        return focusNodeId;
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit parentEdit = (BasedataEdit)this.getView().getControl(FIELD_PARENT);
        parentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_HR_ROLEGROUP);
        DynamicObject[] roleGroup = helper.query(null);
        ArrayList<String> ids = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : roleGroup) {
            ids.add(dynamicObject.getString("id"));
        }
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setMultiSelect(false);
        formShowParameter.setLookUp(true);
        QFilter qFilter = new QFilter("id", "in", ids);
        formShowParameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void afterBindData(EventObject e) {
        String roleGrpId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        if (HRStringUtils.isNotEmpty((String)roleGrpId)) {
            HRBaseServiceHelper bosRoleGrphelper = new HRBaseServiceHelper(ENTITY_BOS_ROLEGROUP);
            DynamicObject bosRoleGroup = bosRoleGrphelper.queryOne((Object)roleGrpId);
            this.getModel().setValue("number", (Object)bosRoleGroup.getString("number"));
            this.getModel().setValue("name", (Object)bosRoleGroup.getString("name"));
            this.getModel().setValue("isleaf", (Object)bosRoleGroup.getString("isleaf"));
            this.getModel().setValue("enable", (Object)bosRoleGroup.getString("enable"));
            this.getModel().setValue("status", (Object)bosRoleGroup.getString("status"));
            this.getModel().setValue(DESCRIPTION, (Object)bosRoleGroup.getString(DESCRIPTION));
            this.getModel().setValue(FIELD_PARENT, bosRoleGroup.get("parent.id"));
            BasedataEdit parentEdit = (BasedataEdit)this.getControl(FIELD_PARENT);
            parentEdit.setQFilter(new QFilter("longnumber", "not like", (Object)(bosRoleGroup.getString("longnumber") + "%")));
        } else {
            this.getModel().setValue("isleaf", (Object)"1");
            this.getModel().setValue("status", (Object)"C");
            this.getModel().setValue("enable", (Object)"1");
            this.getModel().setValue("creator", (Object)RequestContext.get().getUserId());
            this.setNumber();
        }
        this.checkNumberEditable();
        this.getModel().setDataChanged(false);
    }

    private void checkNumberEditable() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_BOS_ROLEGROUP);
        DynamicObject roleGroup = serviceHelper.generateEmptyDynamicObject();
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ENTITY_BOS_ROLEGROUP, (DynamicObject)roleGroup, null);
        this.getView().setEnable(Boolean.valueOf(Objects.isNull(codeRule)), new String[]{"number"});
    }

    private void setBillNoProperty(String billNoName, String number, boolean isMustInput) {
        boolean isChanged = this.getView().getModel().getDataChanged();
        if (HRStringUtils.isNotEmpty((String)number)) {
            this.getModel().setValue(billNoName, (Object)number);
        }
        if (this.getControl(billNoName) instanceof TextEdit) {
            ((TextEdit)this.getControl(billNoName)).setMustInput(isMustInput);
        }
        if (!isChanged) {
            this.getView().getModel().setDataChanged(false);
        }
    }

    private void setNumber() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_BOS_ROLEGROUP);
        DynamicObject roleGroup = serviceHelper.generateEmptyDynamicObject();
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)ENTITY_BOS_ROLEGROUP, (DynamicObject)roleGroup, null);
        String number = CodeRuleServiceHelper.readNumber((CodeRuleInfo)codeRule, (DynamicObject)roleGroup);
        for (int i = 0; i < 20 && this.checkNumberExist(number); ++i) {
            number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)roleGroup);
        }
        this.setBillNoProperty("number", number, true);
    }

    private boolean checkNumberExist(String number) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_BOS_ROLEGROUP);
        DynamicObject[] gropus = helper.query(new QFilter[]{new QFilter("number", "=", (Object)number)});
        return !Objects.isNull(gropus) && gropus.length != 0;
    }
}

