/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.service.perm.RoleManageService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRListFieldPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.SaveRoleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.bussiness.util.PermRoleDuplicateCodeUtil;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;
import kd.hr.hrcs.common.constants.perm.PermTreeUtil;
import kd.hr.hrcs.formplugin.web.perm.role.AllFuncPermTreeUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UserFuncPermTreeUtil
implements TreeNodeQueryListener {
    private static final String ENTD_NUM = "entd_num";
    private static final String APP_ID = "app_id";
    private static final String PERMITEML_ID = "permiteml_id";
    private static final String CLOUDL_ID = "cloudl_id";
    private static final String ROLEPD_ENTNUM = "rolepd_entnum";
    private static final String ROLEPD_PERMITEMID = "rolepd_permitemid";
    private static final String ROLEPD_APPID = "rolepd_appid";
    private static final String PERM_ITEM_DS = "permItemDS";
    private static final String ENTITY_DS = "entityDS";
    private static final String PARENT_ID = "parentId";
    private static final String ALL_INDEPENDENT_PERM = "allIndependentPerm";
    private Map<String, String> allEntNumAndNameMap;
    private static final String CLOUDL_NAME = "cloudl_name";
    private static final String APP_INDUSTRY = "app_industry";
    private static final String APP_NUM = "app_num";
    private static final String CLOUD_APP_DS = "cloudAppDS";
    private static final String ENTD_ID = "entd_id";
    private static final String PERMITEML_NAME = "permiteml_name";
    private static final String FUNCPERM_ID = "funcperm_id";
    private static final String PERMITEM_NUM = "permitem_num";
    private static final String BURF_APPID = "burf_appid";
    private static final String FUNCPERM_ENTID = "funcperm_entid";
    private static final String PARENTID = "parentid";
    private static final String EXPAND = "_expand_";
    private static final String ADD_NODES = "_addNodes_";
    private static final Log LOGGER = LogFactory.getLog(UserFuncPermTreeUtil.class);
    private TreeView[] userTreeViews;
    private TreeView funcPermTreeView;
    private TreeView viewFuncPermTreeView = null;
    private TreeView fieldPermTreeView;
    private TreeView dataPermTreeView = null;
    private Map<String, Map<String, String>> nodeMap;
    private Map<String, Map<String, String>> parentMap;
    private TreeView allFuncPermTreeView;
    private List<String> clouds = new ArrayList<String>(16);
    public static final String PGCACHE_NODEMAP = "nodeMap";
    public static final String DELIMITER = "$";
    public static final String PGCACHE_PARENTMAP = "parentMap";
    public static final String PGCACHE_NODEMAP_PREFIX = "nodeMap$";
    public static final String PGCACHE_PARENTMAP_PREFIX = "parentMap$";
    public static final String PGCACHE_PERMITEMIDNUMMAP = "pgCache_PermItemIdNumMap";
    private String nodeMapPgKey = "";
    private String dimension = "";
    private PermPageCacheUtil permPageCacheUtil;
    private String parentMapPgKey = "";
    private String orgId = "";
    private String appNum;
    private static final String FLAG_HASLOADEDFROMCACHE = "flag_hasLoadedFromCache";
    private static Log logger = LogFactory.getLog(UserFuncPermTreeUtil.class);
    private Set<String> noCtrlPermEntitys;
    private int invokeAddFuncPermNodeNumber = 0;
    private static Pattern chinesePattern = Pattern.compile("[\u4e00-\u9fa5]");

    public void doSearchFieldPermTree(IFormView formView, String searchText) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        boolean showSetup = (Boolean)formView.getModel().getValue("fieldshowsetup");
        boolean showRelated = (Boolean)formView.getModel().getValue("fieldshowrelated");
        if (StringUtils.isEmpty((String)searchText)) {
            this.searchNullForField(showSetup, showRelated);
            permPageCacheUtil.remove("isUserFuncPermTreeSearchMode");
        } else {
            permPageCacheUtil.put("isUserFuncPermTreeSearchMode", "true");
            this.searchFiledPermTreeByText(searchText, showSetup, showRelated);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private String getNodeNotExistMsg() {
        return ResManager.loadKDString((String)"parentMap\u4e2d\u6ca1\u6709\u5305\u542bID\u4e3a%s\u7684\u8282\u70b9\u6570\u636e", (String)"UserFuncPermTreeUtil_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    private boolean isEntityCtrlPerm(String entityNum) {
        return !this.noCtrlPermEntitys.contains(entityNum);
    }

    public static String getAssignedName() {
        return ResManager.loadKDString((String)"\u5df2\u5206\u914d", (String)"UserFuncPermTreeUtil_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
    }

    public UserFuncPermTreeUtil(TreeView allFuncPermTreeView, TreeView[] userTreeViews, List<Long> pOrgIds, String pAppNum, String pDimension, Long curorgId) {
        this.allFuncPermTreeView = allFuncPermTreeView;
        this.userTreeViews = userTreeViews;
        if (null != curorgId && StringUtils.isNotEmpty((String)curorgId.toString())) {
            this.orgId = curorgId.toString();
        }
        this.funcPermTreeView = userTreeViews[0];
        this.fieldPermTreeView = userTreeViews[1];
        IPageCache pageCache = (IPageCache)allFuncPermTreeView.getView().getService(IPageCache.class);
        this.permPageCacheUtil = new PermPageCacheUtil(pageCache);
        LOGGER.info("Init UserFuncPermTreeUtil with porgids:[{}]", pOrgIds, (Object)userTreeViews[0].getKey());
        if (pOrgIds == null || pOrgIds.size() == 0) {
            this.nodeMapPgKey = PGCACHE_NODEMAP_PREFIX + userTreeViews[0].getKey();
            this.parentMapPgKey = PGCACHE_PARENTMAP_PREFIX + userTreeViews[0].getKey();
        } else {
            Collections.sort(pOrgIds);
            StringBuilder sbOrgId = new StringBuilder();
            for (int index = 0; index < pOrgIds.size(); ++index) {
                sbOrgId.append(pOrgIds.get(index));
                if (index == pOrgIds.size() - 1) continue;
                sbOrgId.append('_');
            }
            String adminOrgId = sbOrgId.toString();
            this.nodeMapPgKey = PGCACHE_NODEMAP_PREFIX + adminOrgId;
            this.parentMapPgKey = PGCACHE_PARENTMAP_PREFIX + adminOrgId;
        }
        this.nodeMap = UserFuncPermTreeUtil.getTreeCacheMap(this.permPageCacheUtil, this.nodeMapPgKey, null);
        this.parentMap = UserFuncPermTreeUtil.getTreeCacheMap(this.permPageCacheUtil, this.parentMapPgKey, null);
        this.appNum = pAppNum;
        this.dimension = pDimension == null ? "DIM_ORG" : pDimension;
        String allRelatedPermsStr = this.permPageCacheUtil.get("allRelatedPerms");
        if (allRelatedPermsStr == null) {
            Map<String, List<Map<String, String>>> allRelatedPerms = this.queryAllRelatedPerms();
            this.permPageCacheUtil.put("allRelatedPerms", SerializationUtils.toJsonString(allRelatedPerms));
        }
        if (CollectionUtils.isEmpty(this.clouds)) {
            this.clouds = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
        }
        this.noCtrlPermEntitys = RoleManageService.getNoCtrlPermEntitysFromCache();
    }

    public Map<String, Map<String, String>> getNodeMap() {
        return this.nodeMap;
    }

    @ExcludeFromJacocoGeneratedReport
    public void setNodeMap(Map<String, Map<String, String>> nodeMap) {
        this.nodeMap = nodeMap;
    }

    public Map<String, Map<String, String>> getParentMap() {
        return this.parentMap;
    }

    @ExcludeFromJacocoGeneratedReport
    public void reSet() {
        this.parentMap = new HashMap<String, Map<String, String>>();
        this.nodeMap = new HashMap<String, Map<String, String>>();
    }

    public static Map<String, Map<String, String>> getTreeCacheMap(PermPageCacheUtil pPermPageCacheUtil, String cacheKey, Long orgId) {
        String mapPgKey = "";
        mapPgKey = orgId == null || orgId == -1L ? cacheKey : (!cacheKey.contains(DELIMITER) ? cacheKey + DELIMITER + orgId : cacheKey);
        Map<String, Map<String, String>> map = pPermPageCacheUtil.get(mapPgKey) == null ? new HashMap<String, Map<String, String>>() : (Map)SerializationUtils.fromJsonString((String)pPermPageCacheUtil.get(mapPgKey), Map.class);
        return map;
    }

    public static TreeNode createRootNode() {
        return new TreeNode("", "root#FIRST", UserFuncPermTreeUtil.getAssignedName(), false);
    }

    public void initListener() {
        for (TreeView userTreeView : this.userTreeViews) {
            if (Objects.isNull(userTreeView)) continue;
            userTreeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        }
    }

    private void addNodeToFuncTree(TreeView tvForSingleShow, List<TreeNode> addNodeList, Set<String> hasDoneTreeViewEvents) {
        if (tvForSingleShow != null && tvForSingleShow != this.funcPermTreeView && tvForSingleShow != this.viewFuncPermTreeView) {
            return;
        }
        HashSet<String> needExpandNodeIds = new HashSet<String>(16);
        ArrayList<TreeNode> newAddNodeList = new ArrayList<TreeNode>(16);
        for (TreeNode addNode : addNodeList) {
            TreeNode newAddNode = PermTreeUtil.copyNewTreeNode((TreeNode)addNode);
            newAddNodeList.add(newAddNode);
            needExpandNodeIds.add(newAddNode.getParentid());
        }
        this.doAddNodeToFuncTree(hasDoneTreeViewEvents, newAddNodeList);
        ArrayList needExpandNodeIdList = new ArrayList(needExpandNodeIds);
        needExpandNodeIdList.sort((s1, s2) -> {
            int l1 = PermTreeUtil.getTreeNodeLevel((String)s1);
            int l2 = PermTreeUtil.getTreeNodeLevel((String)s2);
            return l1 - l2;
        });
        String expandEventStr = this.funcPermTreeView.getKey() + EXPAND + needExpandNodeIdList;
        if (hasDoneTreeViewEvents.add(expandEventStr)) {
            for (String nodeId : needExpandNodeIdList) {
                if (nodeId.endsWith("#entity")) continue;
                this.funcPermTreeView.expand(nodeId);
                if (this.viewFuncPermTreeView == null) continue;
                this.viewFuncPermTreeView.expand(nodeId);
            }
        }
    }

    private void doAddNodeToFuncTree(Set<String> hasDoneTreeViewEvents, List<TreeNode> newAddNodeList) {
        if (!CollectionUtils.isEmpty(newAddNodeList)) {
            String addNodesEventStr;
            ArrayList<String> nodeIds = new ArrayList<String>(16);
            for (TreeNode treeNode : newAddNodeList) {
                nodeIds.add(treeNode.getId());
            }
            String delNodesEventStr = this.funcPermTreeView.getKey() + "_deleteNodes_" + nodeIds;
            if (hasDoneTreeViewEvents.add(delNodesEventStr)) {
                this.funcPermTreeView.deleteNodes(nodeIds);
                if (this.viewFuncPermTreeView != null) {
                    this.viewFuncPermTreeView.deleteNodes(nodeIds);
                }
            }
            if (hasDoneTreeViewEvents.add(addNodesEventStr = this.funcPermTreeView.getKey() + ADD_NODES + newAddNodeList)) {
                this.funcPermTreeView.addNodes(newAddNodeList);
                if (this.viewFuncPermTreeView != null) {
                    this.viewFuncPermTreeView.addNodes(newAddNodeList);
                }
            }
        }
    }

    private void addNodeToFieldTree(TreeView tvForSingleShow, List<TreeNode> addNodeList, boolean ifListLikeTree, Set<String> hasDoneTreeViewEvents) {
        int newAddNodeListCount;
        String addNodesEvtInfo;
        if (tvForSingleShow != null && tvForSingleShow != this.fieldPermTreeView) {
            return;
        }
        List<Object> newAddNodeList = new ArrayList<TreeNode>(16);
        HashSet<String> needExpandNodeIds = new HashSet<String>(16);
        this.getNewNodeList(addNodeList, needExpandNodeIds, newAddNodeList);
        if (addNodeList.size() > 0 && addNodeList.get(0).getId().endsWith("#entity")) {
            String nodeId = ((TreeNode)newAddNodeList.get(0)).getId();
            this.sortEntityNodes(nodeId.substring(nodeId.indexOf(64) + 1, nodeId.indexOf(35)), newAddNodeList);
        }
        String viewStatus = this.permPageCacheUtil.get("viewStatus");
        if (null == this.permPageCacheUtil.getPageCache().get("wizardTabIndex") && (HRStringUtils.equals((String)"1", (String)viewStatus) || null == viewStatus)) {
            String roleId = (String)this.funcPermTreeView.getView().getFormShowParameter().getCustomParam("roleId");
            Map fieldPermInfoMap = HRListFieldPermServiceHelper.getRoleFieldPermInfoFromDatabase(null, null, (String)roleId);
            Set appIds = fieldPermInfoMap.keySet().stream().map(it -> it.split("@")[0]).collect(Collectors.toSet());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(needExpandNodeIds)) {
                return;
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
            Set cloudIds = serviceHelper.queryOriginalCollection("bizcloud.id", new QFilter[]{new QFilter("id", "in", appIds)}).stream().map(it -> it.getString("bizcloud.id")).collect(Collectors.toSet());
            if (((String)needExpandNodeIds.iterator().next()).equals("root#FIRST")) {
                newAddNodeList = newAddNodeList.stream().filter(it -> cloudIds.contains(it.getId().split("#")[0])).collect(Collectors.toList());
            } else if (((String)needExpandNodeIds.iterator().next()).endsWith("#cloud")) {
                newAddNodeList = newAddNodeList.stream().filter(it -> appIds.contains(it.getId().split("#")[0])).collect(Collectors.toList());
            } else {
                Set entityIds = fieldPermInfoMap.keySet().stream().map(it -> it.split("@")[1] + "@" + it.split("@")[0]).collect(Collectors.toSet());
                newAddNodeList = newAddNodeList.stream().filter(it -> entityIds.contains(it.getId().substring(it.getId().indexOf("|") + 1, it.getId().indexOf("#")))).collect(Collectors.toList());
            }
        }
        if (hasDoneTreeViewEvents.add(addNodesEvtInfo = this.fieldPermTreeView.getKey() + ADD_NODES + newAddNodeList) && (newAddNodeListCount = newAddNodeList.size()) > 0) {
            this.doAddNodeToFieldTree(ifListLikeTree, newAddNodeList, newAddNodeListCount);
        }
        ArrayList<String> needExpandNodeIdList = new ArrayList<String>(needExpandNodeIds);
        needExpandNodeIdList.sort((nodeA, nodeB) -> {
            int level1 = PermTreeUtil.getTreeNodeLevel((String)nodeA);
            int level2 = PermTreeUtil.getTreeNodeLevel((String)nodeB);
            return level1 - level2;
        });
        String expandEvtStr = this.fieldPermTreeView.getKey() + EXPAND + needExpandNodeIdList;
        if (hasDoneTreeViewEvents.add(expandEvtStr)) {
            for (String nodeId : needExpandNodeIdList) {
                this.fieldPermTreeView.expand(nodeId);
            }
        }
    }

    private void getNewNodeList(List<TreeNode> needAddNodeList, Set<String> needExpandNodeIds, List<TreeNode> newAddNodeList) {
        for (TreeNode node : needAddNodeList) {
            String addNodeId = node.getId();
            TreeNode newAddNode = PermTreeUtil.copyNewTreeNode((TreeNode)node);
            if (addNodeId.contains("#permItem")) continue;
            if (addNodeId.contains("#entity")) {
                newAddNode.setChildren(null);
            }
            newAddNodeList.add(newAddNode);
            needExpandNodeIds.add(newAddNode.getParentid());
        }
    }

    private void doAddNodeToFieldTree(boolean ifListLikeTree, List<TreeNode> newAddNodeList, int newAddNodeListCount) {
        if (ifListLikeTree) {
            for (int i = 0; i < newAddNodeListCount; ++i) {
                TreeNode newAddNode = newAddNodeList.get(i);
                if (i == newAddNodeListCount - 1) {
                    String nodeId = newAddNode.getId();
                    this.fieldPermTreeView.deleteNode(nodeId);
                    this.fieldPermTreeView.addNode(newAddNode);
                    continue;
                }
                this.fieldPermTreeView.addNode(newAddNode);
            }
        } else {
            newAddNodeList.forEach(node -> this.fieldPermTreeView.deleteNode(node.getId()));
            this.fieldPermTreeView.addNodes(newAddNodeList);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void addNodeToDataTree(TreeView tvForSingleShow, List<TreeNode> addNodeList, boolean ifListLikeTree, Set<String> hasDoneTreeViewEvents) {
        if (tvForSingleShow != null && tvForSingleShow != this.dataPermTreeView) {
            return;
        }
        RoleServiceHelper.addNodeToDataTree((TreeView)this.dataPermTreeView, addNodeList, (boolean)ifListLikeTree, hasDoneTreeViewEvents);
    }

    private void userTreeAddNode(List<TreeNode> addNodeList, TreeView tvForSingleShow, boolean ifListLikeTree, Set<String> hasDoneTreeViewEvents) {
        List<TreeNode> entityNodes = addNodeList.stream().filter(node -> node.getId().endsWith("#entity")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(entityNodes)) {
            addNodeList.removeIf(entityNodes::contains);
            String nodeId = ((TreeNode)entityNodes.get(0)).getId();
            this.sortEntityNodes(nodeId.substring(nodeId.indexOf(64) + 1, nodeId.indexOf(35)), entityNodes);
            addNodeList.addAll(entityNodes);
        }
        this.addNodeToFuncTree(tvForSingleShow, addNodeList, hasDoneTreeViewEvents);
        if (this.fieldPermTreeView != null) {
            this.addNodeToFieldTree(tvForSingleShow, addNodeList, ifListLikeTree, hasDoneTreeViewEvents);
        }
        if (this.dataPermTreeView != null) {
            this.addNodeToDataTree(tvForSingleShow, addNodeList, ifListLikeTree, hasDoneTreeViewEvents);
        }
    }

    public void removeFuncPermNode(PermPageCacheUtil permPageCacheUtil, List<Map<String, Object>> selectedNodes) {
        if (selectedNodes == null) {
            return;
        }
        SaveRoleServiceHelper.removeRoleDataRuleCach((PermPageCacheUtil)permPageCacheUtil, selectedNodes);
        ArrayList<String> ids = new ArrayList<String>(16);
        this.buildRemoveMap(permPageCacheUtil, selectedNodes, ids);
        if (ids.size() > 0) {
            this.doRemove(ids);
        }
        this.updateCache();
    }

    private void buildRemoveMap(PermPageCacheUtil permPageCacheUtil, List<Map<String, Object>> selectedNodes, List<String> ids) {
        Map<String, List<Pair<String, String>>> selectNodesMap = selectedNodes.stream().map(it -> Pair.of((Object)it.get("id").toString(), (Object)it.get(PARENTID).toString())).collect(Collectors.groupingBy(it -> (String)it.getValue()));
        String isUserFuncPermTreeSearchMode = permPageCacheUtil.get("isUserFuncPermTreeSearchMode");
        for (Map<String, Object> selectNode : selectedNodes) {
            Map<String, String> childMap;
            String id = selectNode.get("id").toString();
            ids.add(id);
            String parentId = selectNode.get(PARENTID).toString();
            if (this.nodeMap.containsKey(id)) {
                if (HRStringUtils.isNotEmpty((String)isUserFuncPermTreeSearchMode)) {
                    if (this.getChildCount(id) == this.getChildCount(selectNodesMap, id)) {
                        this.recursionDel(id, this.nodeMap, this.parentMap);
                        childMap = this.nodeMap.get(parentId);
                        if (Objects.nonNull(childMap)) {
                            childMap.remove(id);
                        }
                    }
                } else {
                    this.recursionDel(id, this.nodeMap, this.parentMap);
                    childMap = this.nodeMap.get(parentId);
                    if (Objects.nonNull(childMap)) {
                        childMap.remove(id);
                    }
                }
            }
            if (!Objects.nonNull(childMap = this.nodeMap.get(parentId)) || selectNodesMap.containsKey(id)) continue;
            childMap.remove(id);
        }
    }

    private void doRemove(List<String> ids) {
        for (TreeView userTreeView : this.userTreeViews) {
            if (Objects.isNull(userTreeView)) continue;
            if (!ids.contains("root#FIRST")) {
                userTreeView.deleteNodes(ids);
            } else {
                if (HRStringUtils.equals((String)userTreeView.getKey(), (String)"tree_fieldperm")) {
                    this.doSearchFieldPermTree(userTreeView.getView(), "");
                    continue;
                }
                TreeNode userTree = UserFuncPermTreeUtil.createRootNode();
                userTreeView.deleteAllNodes();
                userTreeView.addNode(userTree);
            }
            userTreeView.uncheckNode("root#FIRST");
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private int getChildCount(String id) {
        if (id.endsWith("#entity")) {
            return 1;
        }
        Map<String, String> map = this.nodeMap.get(id);
        if (null == map) {
            return 0;
        }
        int current = 1;
        for (String childId : map.keySet()) {
            current += this.getChildCount(childId);
        }
        return current;
    }

    @ExcludeFromJacocoGeneratedReport
    private int getChildCount(Map<String, List<Pair<String, String>>> selectNodesMap, String id) {
        if (id.endsWith("#permItem")) {
            return 0;
        }
        int current = 1;
        List<Pair<String, String>> list = selectNodesMap.get(id);
        if (null == list) {
            return current;
        }
        for (Pair<String, String> item : list) {
            current += this.getChildCount(selectNodesMap, (String)item.getKey());
        }
        return current;
    }

    private void recursionDel(String id, Map<String, Map<String, String>> pNodeMap, Map<String, Map<String, String>> pParentMap) {
        Map dataMap;
        HashMap pNodeMapCopy = new HashMap(16);
        if (!CollectionUtils.isEmpty(pNodeMap)) {
            pNodeMap.forEach((key, value) -> {
                HashMap nodeMap = Maps.newHashMap();
                nodeMap.putAll(value);
                pNodeMapCopy.put(key, nodeMap);
            });
        }
        if ((dataMap = (Map)pNodeMapCopy.get(id)) == null) {
            return;
        }
        this.removeAppContainsEntity(id, pNodeMap);
        for (String key2 : dataMap.keySet()) {
            this.recursionDel(key2, pNodeMap, pParentMap);
            pNodeMap.remove(key2);
            pParentMap.remove(key2);
        }
        pNodeMap.remove(id);
        pParentMap.remove(id);
    }

    private void removeAppContainsEntity(String id, Map<String, Map<String, String>> pNodeMap) {
        String[] idSplit;
        if (id.contains("|") && id.contains("@") && id.contains("#") && (idSplit = id.split("#")).length >= 1 && "entity".equals(idSplit[idSplit.length - 1])) {
            String appNum = id.substring(id.indexOf("@") + 1, id.indexOf("#"));
            Map<String, String> appMap = pNodeMap.get(appNum + "#" + "app");
            appMap.remove(id);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void appendUserType(StringBuilder stringBuilder) {
        String userTypes = AllFuncPermTreeUtil.getUserTypesByAppNum(this.appNum);
        if (StringUtils.isNotEmpty((String)userTypes)) {
            stringBuilder.append(" and (");
            String[] userTypeArr = userTypes.split(",");
            for (int i = 0; i < userTypeArr.length; ++i) {
                String userType = userTypeArr[i];
                if (i != 0) {
                    stringBuilder.append(" or ");
                }
                stringBuilder.append(" app.fusertype = '").append(userType).append("' ").append("  or app.fusertype like '").append(userType).append(",%' ").append("  or app.fusertype like '%,").append(userType).append("' ").append("  or app.fusertype like '%,").append(userType).append(",%' ");
            }
            stringBuilder.append(')');
        }
    }

    public void addFuncPermNode(String filterAppId) {
        this.addFuncPermNode(filterAppId, null);
    }

    public void addFuncPermNode(String filterAppId, List<Map<String, Object>> toAddAssignedEntity) {
        ArrayList<String> filterAppIds = new ArrayList<String>();
        String customFilterAppNumCache = this.permPageCacheUtil.get("FormShowParam_appNum");
        if (StringUtils.isNotEmpty((String)customFilterAppNumCache) && !"BASE".equals(customFilterAppNumCache) && !"SCP".equals(customFilterAppNumCache)) {
            if (customFilterAppNumCache.contains(",")) {
                this.addCustomApp(filterAppIds, customFilterAppNumCache);
            } else {
                filterAppIds.add(AppMetadataCache.getAppInfo((String)customFilterAppNumCache).getId());
            }
        }
        List<Map<String, Object>> selectedNodes = this.allFuncPermTreeView.getTreeState().getSelectedNodes();
        if (toAddAssignedEntity != null) {
            selectedNodes = toAddAssignedEntity;
        }
        this.permPageCacheUtil.put("selectNodes", SerializationUtils.toJsonString(selectedNodes));
        HashMap<String, String> appInfos = new HashMap<String, String>(16);
        HashMap<String, String> entityInfos = new HashMap<String, String>(16);
        HashMap<String, String> permItemInfos = new HashMap<String, String>(16);
        ArrayList<String> cloudIds = new ArrayList<String>(16);
        ArrayList<String> appIds = new ArrayList<String>(16);
        ArrayList<String> entityKeys = new ArrayList<String>(16);
        ArrayList<String> funcPermIds = new ArrayList<String>(16);
        this.collectNodeInfo(selectedNodes, appInfos, entityInfos, permItemInfos, cloudIds);
        String isSearchMode = this.permPageCacheUtil.get("isSearchMode");
        if (StringUtils.isEmpty((String)isSearchMode)) {
            this.handleNoSearchMode(appInfos, entityInfos, permItemInfos, cloudIds, appIds, entityKeys, funcPermIds);
        } else {
            this.handleSearChMode(appInfos, entityInfos, permItemInfos, cloudIds, appIds, entityKeys, funcPermIds);
        }
        this.loadDataFromDB(filterAppIds, cloudIds, appIds, entityKeys, funcPermIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataFromDB(List<String> filterAppIds, List<String> cloudIds, List<String> appIds, List<String> entityKeys, List<String> funcPermIds) {
        String langStr = RequestContext.get().getLang().name();
        String algoKeyPrefix = this.getClass().getName() + ".addFuncPermNode.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet entityDesignDS = null;
        DataSet appEntDS = null;
        DataSet funcPermDS = null;
        DataSet appEntPermItemDS = null;
        DataSet entDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        Object finalDS = null;
        DataSet copyDS = null;
        try {
            bizUnitRelFormDS = this.getBizUnitRelFormDS(algoKeyPrefix);
            bizObjAppDS = this.getBizObjAppDS(algoKeyPrefix);
            entityDesignDS = this.getEntityDesignDS(algoKeyPrefix);
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on("entapp_entnum", "ent_num").select(new String[]{"entapp_appid", "ent_id"}).finish();
            String forBidAppStr = this.permPageCacheUtil.get("forBidApps");
            List forBidApps = Lists.newArrayListWithExpectedSize((int)16);
            if (HRStringUtils.isNotEmpty((String)forBidAppStr)) {
                forBidApps = (List)SerializationUtils.fromJsonString((String)forBidAppStr, List.class);
            }
            String whereCondition = AllFuncPermTreeUtil.getHRCondition(forBidApps);
            LOGGER.info("Got HRCondition: {}.", (Object)whereCondition);
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS).where(whereCondition);
            funcPermDS = this.getFuncPermDS(langStr, algoKeyPrefix);
            appEntPermItemDS = appEntDS.join(funcPermDS).on("burf_formid", FUNCPERM_ENTID).select(new String[]{BURF_APPID}, new String[]{FUNCPERM_ENTID, FUNCPERM_ID, PERMITEM_NUM, PERMITEML_ID, PERMITEML_NAME}).finish();
            entDS = DB.queryDataSet((String)(algoKeyPrefix + "entDS"), (DBRoute)DBRoute.meta, (String)UserFuncPermTreeUtil.buildEntitySql().toString(), (Object[])new Object[]{langStr});
            appEntPermItemDS2 = appEntPermItemDS.join(entDS).on(FUNCPERM_ENTID, ENTD_ID).select(new String[]{BURF_APPID, FUNCPERM_ID, PERMITEM_NUM, PERMITEML_ID, PERMITEML_NAME, "entd_name"}, new String[]{ENTD_NUM, ENTD_ID}).finish();
            List forBids = (List)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get("forBids"), List.class);
            if (forBids.size() > 0) {
                HashMap<String, List> filterMap = new HashMap<String, List>(1);
                filterMap.put("valid", forBids);
                appEntPermItemDS2 = appEntPermItemDS2.filter("entd_num not in valid", filterMap);
            }
            StringBuilder sbCloudAppSql = this.buildCloudAppSql();
            this.appendAppFilter(sbCloudAppSql, filterAppIds);
            this.appendUserType(sbCloudAppSql);
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString(), (Object[])new Object[]{langStr});
            this.doSetDataToFunctree(appEntPermItemDS2, cloudAppDS, copyDS, cloudIds, appIds, entityKeys, funcPermIds);
        }
        catch (NullPointerException ex) {
            try {
                LOGGER.error(String.format(Locale.ROOT, "there is NullPointerException %s", ex.getMessage()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS, copyDS});
                throw throwable;
            }
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS, copyDS});
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS, copyDS});
    }

    private void doSetDataToFunctree(DataSet appEntPermItemDS2, DataSet cloudAppDS, DataSet copyDS, List<String> cloudIds, List<String> appIds, List<String> entityKeys, List<String> funcPermIds) {
        try (DataSet finalDS = appEntPermItemDS2.join(cloudAppDS).on(BURF_APPID, APP_ID).select(new String[]{FUNCPERM_ID, PERMITEM_NUM, PERMITEML_ID, PERMITEML_NAME, ENTD_NUM, ENTD_ID, "entd_name"}, new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY, "app_deploy"}).finish().orderBy(new String[]{CLOUDL_ID, APP_ID, ENTD_ID, ENTD_NUM, PERMITEM_NUM});){
            boolean addPermItemFlag;
            boolean addEntFlag;
            boolean addAppFlag;
            copyDS = finalDS.copy();
            boolean addCloudFlag = this.addCloudNodeDataToCache(cloudIds, copyDS);
            if (addCloudFlag) {
                copyDS = finalDS.copy();
            }
            if (addAppFlag = this.addAppNodeDataToCache(appIds, copyDS)) {
                copyDS = finalDS.copy();
            }
            if (!(addEntFlag = this.addEntNodeDataToCache(entityKeys, copyDS))) {
                copyDS.close();
            }
            if (!(addPermItemFlag = this.addPermItemNodeDataToCache(funcPermIds, finalDS))) {
                finalDS.close();
            }
            this.addRightTreeNode();
            this.allFuncPermTreeView.uncheckNode("root#FIRST");
            this.funcPermTreeView.uncheckNode("root#FIRST");
            this.updateCache();
        }
    }

    private StringBuilder buildCloudAppSql() {
        return new StringBuilder().append("select cloudl.fid cloudl_id, cloudl.fname cloudl_name, ").append(" app.FID app_id, app.fnumber app_num, app.findustry app_industry, app.FDEPLOYSTATUS app_deploy ").append(" from t_meta_bizapp app ").append(" INNER JOIN t_meta_bizcloud_l cloudl ON (app.fbizcloudid = cloudl.fid and cloudl.FLOCALEID = ?)").append(" WHERE NOT EXISTS (SELECT 1 FROM t_meta_appruntime appr ").append(" WHERE (app.fid = appr.fid OR app.fmasterid = appr.fid) AND appr.falluserapp = '1')").append(" AND app.fdeploystatus = '2' ");
    }

    private static StringBuilder buildEntitySql() {
        return new StringBuilder().append("select entd.FID entd_id, entdl.fname entd_name, entd.fnumber entd_num ").append("  from t_meta_entitydesign entd ").append(" INNER JOIN t_meta_entitydesign_l entdl on (entd.fid = entdl.fid and entdl.FLOCALEID = ?) ").append(" where entd.FISTEMPLATE = '0'");
    }

    private DataSet getFuncPermDS(String langStr, String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + "funcPermDS"), (DBRoute)DBRoute.permission, (String)this.buildFuncPermSql().toString(), (Object[])new Object[]{langStr});
    }

    private StringBuilder buildFuncPermSql() {
        return new StringBuilder().append("select distinct funcperm.FDENTITYTYPEID funcperm_entid, funcperm.fid funcperm_id, ").append(" permitem.fnumber permitem_num, permiteml.fid permiteml_id, permiteml.FNAME permiteml_name ").append(" from t_perm_functionperm funcperm ").append(" INNER JOIN t_perm_permitem permitem ON permitem.FID = funcperm.FPERMITEMID ").append(" INNER JOIN t_perm_permitem_l permiteml on (permiteml.FID = permitem.FID and permiteml.FLOCALEID = ?) ");
    }

    private DataSet getEntityDesignDS(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + "entityDesignDS"), (DBRoute)DBRoute.meta, (String)"select fid ent_id, fnumber ent_num from t_meta_entitydesign");
    }

    private DataSet getBizObjAppDS(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + "bizObjAppDS"), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
    }

    private DataSet getBizUnitRelFormDS(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + "bizUnitRelFormDS"), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid, fformid burf_formid FROM t_meta_bizunitrelform");
    }

    private void collectNodeInfo(List<Map<String, Object>> selectedNodes, Map<String, String> appInfos, Map<String, String> entityInfos, Map<String, String> permItemInfos, List<String> cloudIds) {
        for (Map<String, Object> selectNode : selectedNodes) {
            String nodeType;
            String id = selectNode.get("id").toString();
            String parentId = selectNode.get(PARENTID).toString();
            if (id.equals("root#FIRST")) continue;
            switch (nodeType = id.substring(id.indexOf(35))) {
                case "#cloud": {
                    String cloudId = id.substring(0, id.indexOf(35));
                    cloudIds.add(cloudId);
                    break;
                }
                case "#app": {
                    appInfos.put(id, parentId);
                    break;
                }
                case "#entity": {
                    entityInfos.put(id, parentId);
                    break;
                }
                case "#permItem": {
                    permItemInfos.put(id, parentId);
                    break;
                }
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void addCustomApp(List<String> filterAppIds, String customFilterAppNumCache) {
        List<String> customFilterAppNums = Arrays.asList(customFilterAppNumCache.split(","));
        if (!CollectionUtils.isEmpty(customFilterAppNums)) {
            for (String customFilterAppNum : customFilterAppNums) {
                if (StringUtils.isEmpty((String)customFilterAppNum)) continue;
                customFilterAppNum = customFilterAppNum.trim();
                filterAppIds.add(AppMetadataCache.getAppInfo((String)customFilterAppNum).getId());
            }
        }
    }

    private void handleNoSearchMode(Map<String, String> appInfos, Map<String, String> entityInfos, Map<String, String> permItemInfos, List<String> cloudIds, List<String> appIds, List<String> entityKeys, List<String> funcPermIds) {
        ArrayList permItemInfoRemoveList = Lists.newArrayListWithExpectedSize((int)16);
        this.removeEntitySelected(entityInfos, permItemInfos, funcPermIds, permItemInfoRemoveList);
        this.removeAppSelected(appInfos, entityInfos, entityKeys);
        this.removeCloudSelected(appInfos, cloudIds, appIds);
    }

    @ExcludeFromJacocoGeneratedReport
    private void removeCloudSelected(Map<String, String> appInfos, List<String> cloudIds, List<String> appIds) {
        ArrayList appInfosRemoveList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<String, String> entry : appInfos.entrySet()) {
            String nodeId = entry.getKey();
            String parentId = entry.getValue();
            String cloudId = parentId.substring(0, parentId.indexOf(35));
            String appId = nodeId.substring(0, nodeId.indexOf(35));
            if (cloudIds.contains(cloudId)) {
                appInfosRemoveList.add(nodeId);
                continue;
            }
            appIds.add(appId);
        }
        for (String key : appInfosRemoveList) {
            appInfos.remove(key);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void removeAppSelected(Map<String, String> appInfos, Map<String, String> entityInfos, List<String> entityKeys) {
        ArrayList entityInfosRemoveList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry<String, String> entry : entityInfos.entrySet()) {
            String nodeId = entry.getKey();
            String parentId = entry.getValue();
            String appId = parentId.substring(0, parentId.indexOf(35));
            String entityId = nodeId.substring(0, nodeId.indexOf(124));
            if (appInfos.containsKey(parentId)) {
                entityInfosRemoveList.add(nodeId);
                continue;
            }
            String entityKey = entityId + "@" + appId;
            entityKeys.add(entityKey);
        }
        for (String key : entityInfosRemoveList) {
            entityInfos.remove(key);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void removeEntitySelected(Map<String, String> entityInfos, Map<String, String> permItemInfos, List<String> funcPermIds, List<String> permItemInfoRemoveList) {
        for (Map.Entry<String, String> entry : permItemInfos.entrySet()) {
            String nodeId = entry.getKey();
            String parentId = entry.getValue();
            String appId = nodeId.substring(nodeId.indexOf(64) + 1, nodeId.indexOf(35));
            String funcPermId = nodeId.substring(0, nodeId.indexOf(124));
            if (entityInfos.containsKey(parentId)) {
                permItemInfoRemoveList.add(nodeId);
                continue;
            }
            funcPermIds.add(funcPermId + "@" + appId);
        }
        for (String key : permItemInfoRemoveList) {
            permItemInfos.remove(key);
        }
    }

    private void handleSearChMode(Map<String, String> appInfos, Map<String, String> entityInfos, Map<String, String> permItemInfos, List<String> cloudIds, List<String> appIds, List<String> entityKeys, List<String> funcPermIds) {
        String appId;
        String parentId;
        String nodeId;
        for (Map.Entry<String, String> entry : appInfos.entrySet()) {
            nodeId = entry.getKey();
            parentId = entry.getValue();
            String cloudId = parentId.substring(0, parentId.indexOf(35));
            appId = nodeId.substring(0, nodeId.indexOf(35));
            appIds.add(appId);
            cloudIds.remove(cloudId);
        }
        for (Map.Entry<String, String> entry : entityInfos.entrySet()) {
            nodeId = entry.getKey();
            parentId = entry.getValue();
            String appId2 = parentId.substring(0, parentId.indexOf(35));
            String entityId = nodeId.substring(0, nodeId.indexOf(124));
            String entityKey = entityId + "@" + appId2;
            entityKeys.add(entityKey);
            appIds.remove(appId2);
        }
        for (Map.Entry<String, String> entry : permItemInfos.entrySet()) {
            nodeId = entry.getKey();
            parentId = entry.getValue();
            String entityId = parentId.substring(0, parentId.indexOf(124));
            appId = parentId.substring(parentId.indexOf(64) + 1, parentId.indexOf(35));
            String funcPermId = nodeId.substring(0, nodeId.indexOf(124));
            String entityKey = entityId + "@" + appId;
            funcPermIds.add(funcPermId + "@" + appId);
            entityKeys.remove(entityKey);
        }
    }

    private boolean addCloudNodeDataToCache(List<String> cloudIds, DataSet ds) {
        if (CollectionUtils.isEmpty(cloudIds)) {
            return false;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)cloudIds.size());
        this.clouds.forEach(cloudId -> cloudIds.stream().filter(it -> HRStringUtils.equals((String)cloudId, (String)it)).findFirst().ifPresent(list::add));
        StringBuilder sbWhereExpr = new StringBuilder(" ");
        sbWhereExpr.append(" cloudl_id IN (");
        for (int i = 0; i < list.size(); ++i) {
            String id = (String)list.get(i);
            sbWhereExpr.append(" '").append(id).append("' ");
            if (i == list.size() - 1) continue;
            sbWhereExpr.append(',');
        }
        sbWhereExpr.append(')');
        ds = ds.where(sbWhereExpr.toString());
        ds = ds.orderBy(new String[]{CLOUDL_ID, APP_ID, ENTD_ID, ENTD_NUM, PERMITEM_NUM});
        this.queryDataBySQL(ds);
        return true;
    }

    private boolean addPermItemNodeDataToCache(List<String> funcPermIds, DataSet ds) {
        if (CollectionUtils.isEmpty(funcPermIds)) {
            return false;
        }
        StringBuilder sbWhereExpr = new StringBuilder(" ");
        HashMap<String, List> tempMap = new HashMap<String, List>();
        for (int i = 0; i < funcPermIds.size(); ++i) {
            String id = funcPermIds.get(i);
            String funcPermId = id.substring(0, id.indexOf(64));
            String appId = id.substring(id.indexOf(64) + 1);
            List extAppIds = (List)tempMap.get(appId);
            if (extAppIds == null) {
                extAppIds = PermFormCommonUtil.getAllExtAppId((String)appId);
                tempMap.put(appId, extAppIds);
            }
            sbWhereExpr.append("(funcperm_id = '").append(funcPermId).append("' ").append(" AND ((app_id = '").append(appId).append("' ").append(" AND app_deploy = '2' ) ");
            this.appendAppid(sbWhereExpr, extAppIds, " OR app_id in (", ")) ");
            if (i == funcPermIds.size() - 1) continue;
            sbWhereExpr.append(" OR ");
        }
        ds = ds.where(sbWhereExpr.toString());
        ds = ds.orderBy(new String[]{CLOUDL_ID, APP_ID, ENTD_ID, ENTD_NUM, PERMITEM_NUM});
        this.queryDataBySQL(ds);
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean addAppNodeDataToCache(List<String> appIds, DataSet ds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return false;
        }
        StringBuilder sbWhereExpr = new StringBuilder(" ");
        Map allExtAppIdMap = PermFormCommonUtil.getAllExtAppIds(appIds);
        sbWhereExpr.append(" app_id IN (");
        ArrayList<String> finalFilterAppIds = new ArrayList<String>(appIds);
        if (allExtAppIdMap != null && !allExtAppIdMap.isEmpty()) {
            for (String appId : appIds) {
                List extAppIds = (List)allExtAppIdMap.get(appId);
                if (extAppIds == null || extAppIds.isEmpty()) continue;
                finalFilterAppIds.addAll(extAppIds);
            }
        }
        for (int i = 0; i < finalFilterAppIds.size(); ++i) {
            String id = (String)finalFilterAppIds.get(i);
            sbWhereExpr.append(" '").append(id).append("' ");
            if (i == finalFilterAppIds.size() - 1) continue;
            sbWhereExpr.append(',');
        }
        sbWhereExpr.append(')');
        ds = ds.where(sbWhereExpr.toString());
        ds = ds.orderBy(new String[]{CLOUDL_ID, APP_ID, ENTD_ID, ENTD_NUM, PERMITEM_NUM});
        this.queryDataBySQL(ds);
        return true;
    }

    private boolean addEntNodeDataToCache(List<String> entityKeys, DataSet ds) {
        if (CollectionUtils.isEmpty(entityKeys)) {
            return false;
        }
        HashMap<String, List<String>> orgnlAppExtAppMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> appEntMap = new HashMap<String, List<String>>();
        for (String entityKey : entityKeys) {
            String entityId = entityKey.substring(0, entityKey.indexOf(64));
            String appId = entityKey.substring(entityKey.indexOf(64) + 1);
            appEntMap.computeIfAbsent(appId, key -> new ArrayList()).add(entityId);
        }
        StringBuilder sbWhereExpr = this.buildWhereSql(orgnlAppExtAppMap, appEntMap);
        ds = ds.where(sbWhereExpr.toString());
        ds = ds.orderBy(new String[]{CLOUDL_ID, APP_ID, ENTD_ID, ENTD_NUM, PERMITEM_NUM});
        this.queryDataBySQL(ds);
        return true;
    }

    private StringBuilder buildWhereSql(Map<String, List<String>> orgnlAppExtAppMap, Map<String, List<String>> appEntMap) {
        StringBuilder sbWhereExpr = new StringBuilder(" ");
        int index = 0;
        for (Map.Entry<String, List<String>> entry : appEntMap.entrySet()) {
            String appId = entry.getKey();
            List extAppIds = orgnlAppExtAppMap.get(appId);
            if (extAppIds == null) {
                extAppIds = PermFormCommonUtil.getAllExtAppId((String)appId);
                orgnlAppExtAppMap.put(appId, extAppIds);
            }
            extAppIds.add(appId);
            List<String> entityIds = entry.getValue();
            int subIndex = 0;
            for (String entityId : entityIds) {
                if (subIndex == 0) {
                    this.appendAppid(sbWhereExpr, extAppIds, " ( app_id in (", " AND entd_id in( ");
                }
                sbWhereExpr.append(" '").append(entityId).append("' ");
                if (subIndex != entityIds.size() - 1) {
                    sbWhereExpr.append(',');
                } else {
                    sbWhereExpr.append(" )) ");
                }
                ++subIndex;
            }
            if (index != appEntMap.size() - 1) {
                sbWhereExpr.append(" OR ");
            }
            ++index;
        }
        return sbWhereExpr;
    }

    private void appendAppid(StringBuilder sbWhereExpr, List<String> extAppIds, String preSql, String suffixSql) {
        if (extAppIds.size() > 0) {
            sbWhereExpr.append(preSql);
            for (int j = 0; j < extAppIds.size(); ++j) {
                String extAppId = extAppIds.get(j);
                sbWhereExpr.append(" '").append(extAppId).append("' ");
                if (j == extAppIds.size() - 1) continue;
                sbWhereExpr.append(',');
            }
            sbWhereExpr.append(')');
        }
        sbWhereExpr.append(suffixSql);
    }

    private void queryDataBySQL(DataSet ds) {
        Map industryMap = PermFormCommonUtil.getAllIndustryInfo();
        Map extAppAndOrgnlAppRel = PermFormCommonUtil.getExtAppAndOrgnlAppRel();
        HashMap appNumNameMap = Maps.newHashMapWithExpectedSize((int)16);
        String preAppNodeId = "";
        String preCloudId = "";
        String preEntityId = "";
        String prePermItemId = "";
        String allRelatedPermsStr = this.permPageCacheUtil.get("allRelatedPerms");
        Map allPermRelateInfo = (Map)SerializationUtils.fromJsonString((String)allRelatedPermsStr, Map.class);
        Map<String, Map<String, List<String>>> allIndependentPerm = this.getAllIndependentPerm();
        ArrayList<Map<String, Object>> toAddAssignedNodes = new ArrayList<Map<String, Object>>(16);
        HashSet<String> toAddAssignedEntity = new HashSet<String>(16);
        Map permItemMap = PermRoleDuplicateCodeUtil.getPermItemInfoMap((PermPageCacheUtil)this.permPageCacheUtil);
        String allRelatedPerms = this.permPageCacheUtil.get("AllRelatedPerms");
        String forBidAppEntityStr = this.permPageCacheUtil.get("forBidAppEntity");
        Map forbidEntityPerm = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get("entityPerm"), Map.class);
        Map appEntityPerm = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get("appEntityPerm"), Map.class);
        Map appEntity = new HashMap(16);
        if (HRStringUtils.isNotEmpty((String)forBidAppEntityStr)) {
            appEntity = (Map)SerializationUtils.fromJsonString((String)forBidAppEntityStr, Map.class);
        }
        Map entityPermMap = Maps.newHashMapWithExpectedSize((int)16);
        if (null != allRelatedPerms) {
            entityPermMap = (Map)SerializationUtils.fromJsonString((String)allRelatedPerms, Map.class);
        }
        List rolePerms = Optional.ofNullable(this.getRolePerms()).orElseGet(() -> new ArrayList(16));
        List<String> permStrs = rolePerms.stream().map(it -> (String)it.get("entityNumber") + "|" + (String)it.get("permItemId") + "@" + (String)it.get("appId") + "#permItem").collect(Collectors.toList());
        while (ds.hasNext()) {
            Row row = ds.next();
            if (!this.isEntityCtrlPerm(row.getString(ENTD_NUM))) continue;
            preCloudId = this.handleNewCloudNode(preCloudId, row);
            String newAppId = row.getString(APP_ID);
            newAppId = (String)extAppAndOrgnlAppRel.get(newAppId);
            preAppNodeId = this.handleNewAppNode(industryMap, appNumNameMap, preCloudId, preAppNodeId, row, newAppId);
            String newEntityNumber = row.getString(ENTD_NUM);
            if (appEntity.get(newAppId) != null && ((List)appEntity.get(newAppId)).contains(newEntityNumber)) continue;
            String permItemId = row.getString(PERMITEML_ID);
            if (forbidEntityPerm.containsKey(newEntityNumber) && ((List)forbidEntityPerm.get(newEntityNumber)).contains(permItemId) || appEntityPerm.containsKey(newAppId) && ((Map)appEntityPerm.get(newAppId)).containsKey(newEntityNumber) && ((List)((Map)appEntityPerm.get(newAppId)).get(newEntityNumber)).contains(permItemId)) continue;
            preEntityId = this.handleNewEntityNode(preAppNodeId, preEntityId, row, newAppId, newEntityNumber);
            String entityId = preEntityId.substring(preEntityId.indexOf(124) + 1, preEntityId.indexOf(64));
            if (entityPermMap.get(newAppId) != null && ((Map)entityPermMap.get(newAppId)).get(entityId) != null && ((List)((Map)entityPermMap.get(newAppId)).get(entityId)).contains(row.getString(PERMITEM_NUM))) continue;
            prePermItemId = this.handleNewPermItemNode(preEntityId, prePermItemId, permItemMap, row, newAppId, newEntityNumber);
            this.supplyIndependentPerm(allIndependentPerm, prePermItemId, allPermRelateInfo, toAddAssignedNodes, toAddAssignedEntity, permStrs);
        }
        this.removeNoPermEntityNode();
        this.updatePermItemInfoMap(permItemMap);
        if (toAddAssignedNodes.size() > 0) {
            LOGGER.info("queryDataBySQL have toAddAssignedNodes:{}", toAddAssignedNodes);
            if (this.invokeAddFuncPermNodeNumber >= 1) {
                LOGGER.info("queryDataBySQL have toAddAssignedNodes,invokeAddFuncPermNodeNumber:{},maybe have recursion.", (Object)this.invokeAddFuncPermNodeNumber);
                return;
            }
            ++this.invokeAddFuncPermNodeNumber;
            this.replaceNodes(toAddAssignedNodes, toAddAssignedEntity);
            this.addFuncPermNode(null, toAddAssignedNodes);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void supplyIndependentPerm(Map<String, Map<String, List<String>>> allIndependentPerm, String prePermItemId, Map<String, List<Map<String, String>>> allPermRelateInfo, ArrayList<Map<String, Object>> toAddAssignedNodes, Set<String> toAddAssignedEntity, List<String> permStrs) {
        if (MapUtils.isEmpty(allIndependentPerm)) {
            return;
        }
        List<Map<String, String>> maps = allPermRelateInfo.get(prePermItemId);
        if (CollectionUtils.isEmpty(maps)) {
            return;
        }
        if (permStrs.contains(prePermItemId)) {
            maps.removeIf(it -> !permStrs.contains((String)it.get("entityNumber") + "|" + (String)it.get("permItemId") + "@" + (String)it.get("appId") + "#permItem"));
        }
        for (Map<String, String> map : maps) {
            String entityId = map.get("entityId");
            String entityNum = map.get("entityNumber");
            String permItemId = map.get("permItemId");
            String permItemNum = map.get("permItemNumber");
            String appId = map.get("appId");
            if (allIndependentPerm.get(appId) == null || allIndependentPerm.get(appId).get(entityNum) == null || !allIndependentPerm.get(appId).get(entityNum).contains(permItemNum)) continue;
            LinkedHashMap<String, Object> temp = new LinkedHashMap<String, Object>(4);
            String nodeId = entityId + "|" + permItemId + "@" + appId + "#permItem";
            temp.put("id", nodeId);
            String parentId = map.get("entityId") + "|" + entityNum + "@" + appId + "#entity";
            temp.put(PARENTID, parentId);
            temp.put("isParent", Boolean.FALSE);
            temp.put("text", map.get("permItemName"));
            toAddAssignedNodes.add(temp);
            toAddAssignedEntity.add(entityId);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void replaceNodes(ArrayList<Map<String, Object>> toAddAssignedNodes, Set<String> toAddAssignedEntity) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_functionperm");
        DynamicObject[] objects = serviceHelper.query("id,entitytypeid,permitem", new QFilter[]{new QFilter("entitytypeid", "in", toAddAssignedEntity)});
        Map<String, String> funcPermMap = Arrays.stream(objects).collect(Collectors.toMap(it -> it.getString("entitytypeid") + "|" + it.getString("permitem.id"), it -> it.getString("id") + "|" + it.getString("permitem.id"), (newVal, oldVal) -> newVal));
        for (Map<String, Object> toAddAssignedNode : toAddAssignedNodes) {
            String id = (String)toAddAssignedNode.get("id");
            String prefix = id.split("@")[0];
            String permId = funcPermMap.get(prefix);
            if (!HRStringUtils.isNotEmpty((String)permId)) continue;
            toAddAssignedNode.put("id", id.replace(prefix, permId));
        }
    }

    private void removeNoPermEntityNode() {
        Map<String, String> childInfo;
        String appId;
        Set toDelEntityNodes;
        String nodeType;
        String key;
        HashMap toDelNode = new HashMap(16);
        for (Map.Entry<String, Map<String, String>> entry : this.nodeMap.entrySet()) {
            key = entry.getKey();
            nodeType = key.substring(key.indexOf(35));
            if (!"#app".equals(nodeType)) continue;
            toDelEntityNodes = entry.getValue().keySet().stream().filter(it -> this.nodeMap.get(it) == null).collect(Collectors.toSet());
            toDelNode.put(key, toDelEntityNodes);
        }
        for (Map.Entry<String, Map<String, String>> entry : toDelNode.entrySet()) {
            appId = entry.getKey();
            childInfo = this.nodeMap.get(appId);
            ((Set)((Object)entry.getValue())).forEach(it -> {
                String cfr_ignored_0 = (String)childInfo.remove(it);
            });
        }
        toDelNode.clear();
        for (Map.Entry<String, Map<String, String>> entry : this.nodeMap.entrySet()) {
            key = entry.getKey();
            nodeType = key.substring(key.indexOf(35));
            if (!"#cloud".equals(nodeType)) continue;
            toDelEntityNodes = entry.getValue().keySet().stream().filter(it -> CollectionUtils.isEmpty(this.nodeMap.get(it))).collect(Collectors.toSet());
            toDelNode.put(key, toDelEntityNodes);
        }
        for (Map.Entry<String, Map<String, String>> entry : toDelNode.entrySet()) {
            appId = entry.getKey();
            childInfo = this.nodeMap.get(appId);
            ((Set)((Object)entry.getValue())).forEach(it -> {
                String cfr_ignored_0 = (String)childInfo.remove(it);
            });
        }
    }

    private Map<String, List<Map<String, String>>> queryAllRelatedPerms() {
        Map permIdNumberMap = PermRelateServiceHelper.queryPermItems();
        Map<String, String> permIdName = this.getPermIdName();
        HRBaseServiceHelper relatedServiceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] relateds = relatedServiceHelper.loadDynamicObjectArray(new QFilter[0]);
        HashMap<String, List<Map<String, String>>> relatedPermMap = new HashMap<String, List<Map<String, String>>>(relateds.length);
        for (DynamicObject related : relateds) {
            String id = related.getString("entitytype.id") + related.getString("bizapp.id") + (String)permIdNumberMap.get(related.getString("mainpermitem"));
            String key = related.getString("entitytype.id") + "|" + (String)permIdNumberMap.get(related.getString("mainpermitem")) + "@" + related.getString("bizapp.id") + "#permItem";
            DynamicObjectCollection collection = related.getDynamicObjectCollection("entryentity");
            ArrayList entries = new ArrayList(collection.size());
            for (DynamicObject tmp : collection) {
                String[] permNumber;
                for (String number : permNumber = tmp.getString("permitemid").split(",")) {
                    HashMap<String, String> relatedPermInfo = new HashMap<String, String>(3);
                    relatedPermInfo.put("entityId", tmp.getString("entitytypeid.dentityid"));
                    relatedPermInfo.put("entityNumber", tmp.getString("entitytypeid.id"));
                    String permId = (String)permIdNumberMap.get(number);
                    String permName = permIdName.get(permId);
                    relatedPermInfo.put("permItemNumber", number);
                    relatedPermInfo.put("permItemId", permId);
                    relatedPermInfo.put("permItemName", permName);
                    relatedPermInfo.put("appId", tmp.getString("app.id"));
                    entries.add(relatedPermInfo);
                }
            }
            relatedPermMap.put(id, entries);
            relatedPermMap.put(key, entries);
        }
        return relatedPermMap;
    }

    private String handleNewPermItemNode(String preEntityId, String prePermItemId, Map<String, String> permItemInfoMap, Row row, String newAppId, String newEntityNum) {
        String permItemNum = row.getString(PERMITEM_NUM);
        String permItemId = row.getString(PERMITEML_ID);
        permItemInfoMap.put(permItemId, permItemNum);
        StringBuilder newPermItemIdSb = new StringBuilder(newEntityNum).append("|").append(permItemId).append("@").append(newAppId).append("#permItem");
        String newPermItemId = newPermItemIdSb.toString();
        if (!prePermItemId.equals(newPermItemId)) {
            Map<String, String> permItemMap = this.nodeMap.get(preEntityId);
            if (CollectionUtils.isEmpty(permItemMap)) {
                permItemMap = new HashMap<String, String>();
            }
            String newPermItemName = row.getString(PERMITEML_NAME);
            permItemMap.put(newPermItemId, newPermItemName);
            this.nodeMap.put(preEntityId, permItemMap);
            this.updateNodeParent(this.parentMap, newPermItemId, preEntityId, newPermItemName);
            prePermItemId = newPermItemId;
        }
        return prePermItemId;
    }

    private String handleNewEntityNode(String preAppNodeId, String preEntityId, Row row, String newAppId, String newEntityNum) {
        String newEntityName = row.getString("entd_name");
        String newEntityId = row.getString(ENTD_ID) + "|" + newEntityNum + "@" + newAppId + "#entity";
        if (!HRStringUtils.equals((String)preEntityId, (String)newEntityId)) {
            Map<String, String> entityMap = this.nodeMap.get(preAppNodeId);
            if (CollectionUtils.isEmpty(entityMap)) {
                entityMap = new HashMap<String, String>(16);
            }
            entityMap.put(newEntityId, newEntityName);
            this.nodeMap.put(preAppNodeId, entityMap);
            this.updateNodeParent(this.parentMap, newEntityId, preAppNodeId, newEntityName);
            preEntityId = newEntityId;
        }
        return preEntityId;
    }

    private String handleNewCloudNode(String preCloudId, Row row) {
        String newCloudId = row.getString(CLOUDL_ID) + "#cloud";
        if (!preCloudId.equals(newCloudId)) {
            Map<String, String> cloudMap = this.nodeMap.get("root#FIRST");
            if (CollectionUtils.isEmpty(cloudMap)) {
                cloudMap = new HashMap<String, String>();
            }
            String cloudName = row.getString(CLOUDL_NAME);
            cloudMap.put(newCloudId, cloudName);
            this.nodeMap.put("root#FIRST", cloudMap);
            this.updateNodeParent(this.parentMap, newCloudId, "root#FIRST", cloudName);
            preCloudId = newCloudId;
        }
        return preCloudId;
    }

    private String handleNewAppNode(Map<Long, String> industryMap, Map<String, String> appNumNameMap, String preCloudId, String preAppNodeId, Row row, String newAppId) {
        String newAppNodeId = newAppId + "#app";
        if (!preAppNodeId.equals(newAppNodeId)) {
            String industryName;
            Map<String, String> appMap = this.nodeMap.get(preCloudId);
            if (CollectionUtils.isEmpty(appMap)) {
                appMap = new HashMap<String, String>();
            }
            String curAppNum = row.getString(APP_NUM);
            String appNameFromMap = appNumNameMap.get(curAppNum);
            String newAppName = null;
            if (StringUtils.isEmpty((String)appNameFromMap)) {
                LocaleString name = AppMetadataCache.getAppInfo((String)curAppNum).getName();
                newAppName = name.getLocaleValue();
                newAppName = HRStringUtils.isEmpty((String)newAppName) ? name.getLocaleValue_zh_CN() : newAppName;
                appNumNameMap.put(curAppNum, newAppName);
            } else {
                newAppName = appNameFromMap;
            }
            Long appIndustryId = row.getLong(APP_INDUSTRY);
            if (appIndustryId != null && appIndustryId != 0L && StringUtils.isNotEmpty((String)(industryName = industryMap.get(appIndustryId)))) {
                newAppName = newAppName + "\uff08" + industryName + "\uff09";
            }
            appMap.put(newAppNodeId, newAppName);
            this.nodeMap.put(preCloudId, appMap);
            this.updateNodeParent(this.parentMap, newAppNodeId, preCloudId, newAppName);
            preAppNodeId = newAppNodeId;
        }
        return preAppNodeId;
    }

    private void updatePermItemInfoMap(Map<String, String> permItemInfoMap) {
        if (permItemInfoMap == null) {
            permItemInfoMap = new HashMap<String, String>();
        }
        this.permPageCacheUtil.put(PGCACHE_PERMITEMIDNUMMAP, SerializationUtils.toJsonString(permItemInfoMap));
    }

    private void addRightTreeNode() {
        String nodeType = null;
        List selectedNodes = this.allFuncPermTreeView.getTreeState().getSelectedNodes();
        String selectNodeStr = this.permPageCacheUtil.get("selectNodes");
        if (HRStringUtils.isNotEmpty((String)selectNodeStr)) {
            List assignedSelectedNodes = (List)SerializationUtils.fromJsonString((String)selectNodeStr, List.class);
            selectedNodes.addAll(assignedSelectedNodes);
        }
        HashSet<String> hasDoneEvents = new HashSet<String>(16);
        for (Map selectNode : selectedNodes) {
            String id = selectNode.get("id").toString();
            if (id.equals("root#FIRST")) continue;
            nodeType = id.substring(id.indexOf(35));
            String parentId = selectNode.get(PARENTID).toString();
            String name = selectNode.get("text").toString();
            ArrayList<TreeNode> addNodeList = new ArrayList<TreeNode>(16);
            switch (nodeType) {
                case "#cloud": {
                    TreeNode cloudNode = new TreeNode(parentId, id, name, true);
                    addNodeList.add(cloudNode);
                    this.userTreeAddNode(addNodeList, null, true, hasDoneEvents);
                    break;
                }
                case "#app": {
                    this.addAppNode(hasDoneEvents, id, parentId, name, addNodeList);
                    break;
                }
                case "#entity": {
                    this.addEntityNode(hasDoneEvents, id, parentId, name, addNodeList);
                    break;
                }
                case "#permItem": {
                    this.addPermItemNode(hasDoneEvents, id, parentId, name, addNodeList);
                    break;
                }
            }
        }
    }

    private static boolean isContainChinese(String str) {
        Matcher m = chinesePattern.matcher(str);
        return m.find();
    }

    private String getEntityRealName(String entityNum) {
        String entityName;
        if (UserFuncPermTreeUtil.isContainChinese(entityNum)) {
            return entityNum;
        }
        if (this.allEntNumAndNameMap == null) {
            this.allEntNumAndNameMap = FormHelper.getAllEntityNameMap((String)RequestContext.get().getLang().name());
        }
        if (StringUtils.isEmpty((String)(entityName = this.allEntNumAndNameMap.get(entityNum)))) {
            entityName = PermFormCommonUtil.getRuntimeFormName((String)entityNum);
        }
        return entityName;
    }

    @ExcludeFromJacocoGeneratedReport
    private void addPermItemNode(Set<String> hasDoneEvents, String id, String parentId, String name, List<TreeNode> addNodeList) {
        String entityNodeId = parentId;
        String permItemNodeId = id;
        if (!this.parentMap.containsKey(entityNodeId)) {
            return;
        }
        String appNodeId = this.parentMap.get(entityNodeId).get(PARENT_ID);
        String cloudNodeId = this.parentMap.get(appNodeId).get(PARENT_ID);
        String cloudName = this.parentMap.get(cloudNodeId).get("name");
        TreeNode cloudNode = new TreeNode("root#FIRST", cloudNodeId, cloudName, true);
        cloudNode.setIsOpened(true);
        addNodeList.add(cloudNode);
        String appName = this.parentMap.get(appNodeId).get("name");
        TreeNode appNode = new TreeNode(cloudNodeId, appNodeId, appName, true);
        appNode.setIsOpened(true);
        this.supplyOtherAppByCloud(hasDoneEvents, addNodeList, cloudNodeId, appNodeId, cloudNode, appNode);
        String entityName = this.parentMap.get(entityNodeId).get("name");
        entityName = this.getEntityRealName(entityName);
        TreeNode entityNode = new TreeNode(appNodeId, entityNodeId, entityName, true);
        entityNode.setIsOpened(true);
        this.supplyOtherEntityByApp(hasDoneEvents, addNodeList, appNodeId, entityNodeId, entityNode);
        TreeNode permItemNode = new TreeNode(entityNodeId, permItemNodeId, name, false);
        this.supplyOtherPermItemByApp(hasDoneEvents, addNodeList, entityNodeId, permItemNodeId, permItemNode);
        this.userTreeAddNode(addNodeList, null, false, hasDoneEvents);
    }

    @ExcludeFromJacocoGeneratedReport
    private void addEntityNode(Set<String> hasDoneEvents, String id, String parentId, String name, List<TreeNode> addNodeList) {
        String appNodeId = parentId;
        String entityNodeId = id;
        String cloudNodeId = null;
        String cloudName = null;
        try {
            cloudNodeId = this.parentMap.get(appNodeId).get(PARENT_ID);
        }
        catch (Exception e) {
            LOGGER.info(String.format(Locale.ROOT, this.getNodeNotExistMsg(), appNodeId));
            DynamicObject bizapp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)appNodeId.subSequence(0, appNodeId.indexOf("#app")))});
            cloudNodeId = bizapp.getString("bizcloud") + "#cloud";
        }
        try {
            cloudName = this.parentMap.get(cloudNodeId).get("name");
        }
        catch (Exception e) {
            LOGGER.info(String.format(Locale.ROOT, this.getNodeNotExistMsg(), cloudNodeId));
            DynamicObject bizcloud = QueryServiceHelper.queryOne((String)"bos_devportal_bizcloud", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cloudNodeId.subSequence(0, cloudNodeId.indexOf("#cloud")))});
            cloudName = bizcloud.getString("name");
        }
        TreeNode cloudNode = new TreeNode("root#FIRST", cloudNodeId, cloudName, true);
        cloudNode.setIsOpened(true);
        addNodeList.add(cloudNode);
        String appName = this.parentMap.get(appNodeId).get("name");
        TreeNode appNode = new TreeNode(cloudNodeId, appNodeId, appName, true);
        appNode.setIsOpened(true);
        this.supplyOtherAppByCloud(hasDoneEvents, addNodeList, cloudNodeId, appNodeId, cloudNode, appNode);
        TreeNode entityNode = new TreeNode(appNodeId, entityNodeId, name, true);
        this.supplyOtherEntityByApp(hasDoneEvents, addNodeList, appNodeId, entityNodeId, entityNode);
        this.userTreeAddNode(addNodeList, null, false, hasDoneEvents);
    }

    private void addAppNode(Set<String> hasDoneEvents, String id, String parentId, String name, List<TreeNode> addNodeList) {
        String cloudNodeName;
        String cloudNodeId = parentId;
        String appNodeId = id;
        try {
            cloudNodeName = this.parentMap.get(cloudNodeId).get("name");
        }
        catch (Exception e) {
            LOGGER.info(String.format(Locale.ROOT, this.getNodeNotExistMsg(), cloudNodeId));
            DynamicObject bizcloud = QueryServiceHelper.queryOne((String)"bos_devportal_bizcloud", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cloudNodeId.subSequence(0, cloudNodeId.indexOf("#cloud")))});
            cloudNodeName = bizcloud.getString("name");
        }
        TreeNode cloudNode = new TreeNode("root#FIRST", cloudNodeId, cloudNodeName, true);
        cloudNode.setIsOpened(true);
        addNodeList.add(cloudNode);
        TreeNode appNode = new TreeNode(cloudNodeId, appNodeId, name, true);
        this.supplyOtherAppByCloud(hasDoneEvents, addNodeList, cloudNodeId, appNodeId, cloudNode, appNode);
        this.userTreeAddNode(addNodeList, null, false, hasDoneEvents);
    }

    @ExcludeFromJacocoGeneratedReport
    private void supplyOtherPermItemByApp(Set<String> hasDoneEvents, List<TreeNode> addNodeList, String entityNodeId, String permItemNodeId, TreeNode permItemNode) {
        String hasSupplyOtherPermItemStr = "hasSupplyOtherPermItem_" + entityNodeId;
        if (hasDoneEvents.add(hasSupplyOtherPermItemStr)) {
            Map<String, String> permItemInfo = this.nodeMap.get(entityNodeId);
            List<Map.Entry<String, String>> permItemInfoEntryList = new ArrayList<Map.Entry<String, String>>(permItemInfo.entrySet());
            permItemInfoEntryList = PermRoleDuplicateCodeUtil.sortForAddNodes(permItemInfoEntryList, (PermPageCacheUtil)this.permPageCacheUtil);
            for (Map.Entry<String, String> permItemEntry : permItemInfoEntryList) {
                String tempPermItemNodeId = permItemEntry.getKey();
                if (tempPermItemNodeId.equals(permItemNodeId)) {
                    addNodeList.add(permItemNode);
                    continue;
                }
                String permItemNodeName = permItemEntry.getValue();
                TreeNode otherPermItemNode = new TreeNode(entityNodeId, tempPermItemNodeId, permItemNodeName, false);
                addNodeList.add(otherPermItemNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    public void searchUserFuncPermTreeByText(String text) {
        DataSet dataSet = null;
        try {
            HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
            QFilter filter = new QFilter("bizappid.bizcloud.id", "in", (Object)HRCloudServiceHelper.getAllHRCloudId()).and(new QFilter("name", "like", (Object)("%" + text + "%")));
            dataSet = entityHelper.queryDataSet(this.getClass().getName() + ".searchUserFuncPermTree." + text, "id,name", new QFilter[]{filter});
            String filterStr = AllFuncPermTreeUtil.buildEntityForBidFilterStr(this.permPageCacheUtil.get("forBids"), "id");
            if (filterStr != null) {
                dataSet = dataSet.filter(filterStr);
            }
            this.funcPermTreeView.deleteAllNodes();
            TreeNode rootNode = UserFuncPermTreeUtil.createRootNode();
            this.funcPermTreeView.addNode(rootNode);
            String rootNodeId = rootNode.getId();
            HashSet<String> cloudIds = new HashSet<String>();
            HashSet<String> appIds = new HashSet<String>();
            String appEntityStr = this.permPageCacheUtil.get("forBidAppEntity");
            Map appEntity = new HashMap(16);
            if (appEntityStr != null) {
                appEntity = (Map)SerializationUtils.fromJsonString((String)appEntityStr, Map.class);
            }
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String entityNum = row.getString("id");
                String entityName = row.getString("name");
                for (Map.Entry<String, Map<String, String>> entry : this.nodeMap.entrySet()) {
                    TreeNode cloudNode;
                    TreeNode entityNode;
                    TreeNode appNode;
                    String nodeKey = entry.getKey();
                    if (!nodeKey.endsWith("#entity") || !nodeKey.substring(nodeKey.indexOf(124) + 1, nodeKey.indexOf(64)).equals(entityNum)) continue;
                    String appId = this.parentMap.get(nodeKey).get(PARENT_ID);
                    String cloudId = this.parentMap.get(appId).get(PARENT_ID);
                    String appName = this.parentMap.get(appId).get("name");
                    String cloudName = this.parentMap.get(cloudId).get("name");
                    String app = appId.substring(0, appId.indexOf("#"));
                    if (appEntity.get(app) != null && ((List)appEntity.get(app)).contains(entityNum)) continue;
                    if (cloudIds.contains(cloudId)) {
                        if (appIds.contains(appId)) {
                            appNode = rootNode.getTreeNode(appId, 2);
                            entityNode = new TreeNode(appId, nodeKey, entityName, true);
                            appNode.addChild(entityNode);
                            this.funcPermTreeView.expand(appId);
                            continue;
                        }
                        cloudNode = rootNode.getTreeNode(cloudId, 1);
                        appNode = new TreeNode(cloudId, appId, appName, true);
                        appIds.add(appId);
                        cloudNode.addChild(appNode);
                        this.funcPermTreeView.expand(cloudId);
                        entityNode = new TreeNode(appId, nodeKey, entityName, true);
                        appNode.addChild(entityNode);
                        this.funcPermTreeView.expand(appId);
                        continue;
                    }
                    cloudNode = new TreeNode(rootNodeId, cloudId, cloudName, true);
                    cloudIds.add(cloudId);
                    rootNode.addChild(cloudNode);
                    this.funcPermTreeView.expand(rootNodeId);
                    appNode = new TreeNode(cloudId, appId, appName, true);
                    appIds.add(appId);
                    cloudNode.addChild(appNode);
                    this.funcPermTreeView.expand(cloudId);
                    entityNode = new TreeNode(appId, nodeKey, entityName, true);
                    appNode.addChild(entityNode);
                    this.funcPermTreeView.expand(appId);
                }
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{dataSet});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{dataSet});
    }

    @ExcludeFromJacocoGeneratedReport
    public void searchNull(TreeView resetTreeView) {
        resetTreeView.deleteAllNodes();
        TreeNode rootNode = UserFuncPermTreeUtil.createRootNode();
        resetTreeView.addNode(rootNode);
        String rootNodeId = rootNode.getId();
        for (Map.Entry<String, Map<String, String>> entry : this.nodeMap.entrySet()) {
            String nodeKey = entry.getKey();
            if (!nodeKey.endsWith("#cloud")) continue;
            String cloudName = this.parentMap.get(nodeKey).get("name");
            TreeNode cloudNode = new TreeNode(rootNodeId, nodeKey, cloudName, true);
            rootNode.addChild(cloudNode);
            resetTreeView.expand(rootNodeId);
        }
    }

    public void searchNullForField(boolean showSetup, boolean showRelated) {
        Map<String, Map<String, String>> parentMapTemp;
        Map<String, Map<String, String>> nodeMapTemp;
        this.fieldPermTreeView.deleteAllNodes();
        TreeNode rootNode = UserFuncPermTreeUtil.createRootNode();
        this.fieldPermTreeView.addNode(rootNode);
        String rootNodeId = rootNode.getId();
        Map fieldPermData = this.permPageCacheUtil.getFieldPermData();
        HashSet<String> cloudIds = new HashSet<String>(16);
        HashSet<String> appIds = new HashSet<String>(16);
        if (showRelated) {
            nodeMapTemp = new LinkedHashMap<String, Map<String, String>>(16);
            parentMapTemp = new LinkedHashMap<String, Map<String, String>>(16);
            this.addRelateEntity(nodeMapTemp, parentMapTemp);
        } else {
            nodeMapTemp = this.nodeMap;
            parentMapTemp = this.parentMap;
        }
        for (Map.Entry<String, Map<String, String>> entry : nodeMapTemp.entrySet()) {
            String nodeKey = entry.getKey();
            if (showSetup) {
                TreeNode cloudNode;
                TreeNode appNode;
                if (!nodeKey.endsWith("#entity")) continue;
                String entityNum = nodeKey.substring(nodeKey.indexOf(124) + 1, nodeKey.indexOf(64));
                String appId = nodeKey.substring(nodeKey.indexOf(64) + 1, nodeKey.indexOf(35));
                String fieldPermKey = appId + "@" + entityNum;
                UserRoleFieldPermInfo userRoleFieldPermInfo = (UserRoleFieldPermInfo)fieldPermData.get(fieldPermKey);
                if (Objects.isNull(userRoleFieldPermInfo) || CollectionUtils.isEmpty((Collection)userRoleFieldPermInfo.getFieldPermModelList())) continue;
                String appNodeId = parentMapTemp.get(nodeKey).get(PARENT_ID);
                Map<String, String> cloudNodeInfo = parentMapTemp.get(appNodeId);
                String cloudNodeId = cloudNodeInfo.get(PARENT_ID);
                String cloudName = parentMapTemp.get(cloudNodeId).get("name");
                String appName = parentMapTemp.get(appNodeId).get("name");
                if (cloudIds.contains(cloudNodeId)) {
                    if (appIds.contains(appNodeId)) {
                        appNode = rootNode.getTreeNode(appNodeId, 2);
                    } else {
                        cloudNode = rootNode.getTreeNode(cloudNodeId, 1);
                        appNode = new TreeNode(cloudNodeId, appNodeId, appName, true);
                        appIds.add(appNodeId);
                        cloudNode.addChild(appNode);
                        this.fieldPermTreeView.expand(cloudNodeId);
                    }
                } else {
                    cloudNode = new TreeNode(rootNodeId, cloudNodeId, cloudName, true);
                    cloudIds.add(cloudNodeId);
                    rootNode.addChild(cloudNode);
                    this.fieldPermTreeView.expand(rootNodeId);
                    appNode = new TreeNode(cloudNodeId, appNodeId, appName, true);
                    appIds.add(appNodeId);
                    cloudNode.addChild(appNode);
                    this.fieldPermTreeView.expand(cloudNodeId);
                }
                String entityName = parentMapTemp.get(nodeKey).get("name");
                TreeNode entityNode = new TreeNode(appNodeId, nodeKey, entityName, false);
                appNode.addChild(entityNode);
                this.fieldPermTreeView.expand(appNodeId);
                continue;
            }
            if (!nodeKey.endsWith("#cloud")) continue;
            String cloudName = parentMapTemp.get(nodeKey).get("name");
            TreeNode cloudNode = new TreeNode(rootNodeId, nodeKey, cloudName, true);
            rootNode.addChild(cloudNode);
            this.fieldPermTreeView.expand(rootNodeId);
        }
        this.fieldPermTreeView.focusNode(rootNode);
    }

    @ExcludeFromJacocoGeneratedReport
    private void addRelateEntity(Map<String, Map<String, String>> nodeMapTemp, Map<String, Map<String, String>> parentMapTemp) {
        nodeMapTemp.putAll(this.nodeMap);
        parentMapTemp.putAll(this.parentMap);
        HashSet<String> addedEntityNodes = new HashSet<String>(16);
        for (Map.Entry<String, Map<String, String>> entry : this.nodeMap.entrySet()) {
            String nodeKey = entry.getKey();
            if (!nodeKey.endsWith("#entity")) continue;
            String entityNum = nodeKey.substring(nodeKey.indexOf(124) + 1, nodeKey.indexOf(64));
            String appId = nodeKey.substring(nodeKey.indexOf(64) + 1, nodeKey.indexOf(35));
            String fieldPermKey = (String)appId + "@" + entityNum;
            addedEntityNodes.add(fieldPermKey);
        }
        List funcPermDataList = this.permPageCacheUtil.getFuncPermDataList();
        HashSet<String> funcPermData = new HashSet<String>(16);
        for (Map map : funcPermDataList) {
            funcPermData.add((String)map.get("appId") + "@" + (String)map.get("entityNumber"));
        }
        funcPermData.removeAll(addedEntityNodes);
        if (funcPermData.size() <= 0) {
            return;
        }
        HashSet<String> entityIds = new HashSet<String>(16);
        HashSet<String> appIds = new HashSet<String>(16);
        for (String funcPermDatum : funcPermData) {
            String[] split = funcPermDatum.split("@");
            appIds.add(split[0]);
            entityIds.add(split[1]);
        }
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject[] objects = entityHelper.queryOriginalArray("id,name,bizappid,dentityid", new QFilter[]{new QFilter("id", "in", entityIds)});
        HashMap entityInfos = new HashMap(objects.length);
        for (DynamicObject dynamicObject : objects) {
            HashMap<String, String> temp = new HashMap<String, String>(3);
            String entityNum = dynamicObject.getString("id");
            temp.put("entityId", dynamicObject.getString("dentityid"));
            temp.put("entityNum", entityNum);
            temp.put("name", dynamicObject.getString("name"));
            entityInfos.put(entityNum, temp);
        }
        HRBaseServiceHelper appHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObject[] apps = appHelper.query("id,name,bizcloud", new QFilter[]{new QFilter("id", "in", appIds)});
        HashMap appInfos = new HashMap(apps.length);
        for (DynamicObject app : apps) {
            HashMap<String, String> temp = new HashMap<String, String>(3);
            String appId = app.getString("id");
            temp.put("appId", appId);
            temp.put("appName", app.getString("name"));
            temp.put("cloudId", app.getString("bizcloud.id"));
            temp.put("cloudName", app.getString("bizcloud.name"));
            appInfos.put(appId, temp);
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(16);
        for (String funcPermDatum : funcPermData) {
            String[] split = funcPermDatum.split("@");
            LinkedHashMap map = new LinkedHashMap(16);
            if (appInfos.get(split[0]) == null || entityInfos.get(split[1]) == null) continue;
            map.putAll((Map)appInfos.get(split[0]));
            map.putAll((Map)entityInfos.get(split[1]));
            arrayList.add(map);
        }
        this.supplyMaps(arrayList, nodeMapTemp, parentMapTemp);
    }

    @ExcludeFromJacocoGeneratedReport
    private void supplyMaps(List<Map<String, String>> toSupplyNodeInfos, Map<String, Map<String, String>> nodeMapCopy, Map<String, Map<String, String>> parentMapCopy) {
        if (toSupplyNodeInfos.size() <= 0) {
            return;
        }
        nodeMapCopy.putAll(this.nodeMap);
        parentMapCopy.putAll(this.parentMap);
        for (Map<String, String> toSupplyNodeInfo : toSupplyNodeInfos) {
            String entityId = toSupplyNodeInfo.get("entityId");
            String entityNum = toSupplyNodeInfo.get("entityNum");
            String entityName = toSupplyNodeInfo.get("name");
            String appId = toSupplyNodeInfo.get("appId");
            String appName = toSupplyNodeInfo.get("appName");
            String cloudId = toSupplyNodeInfo.get("cloudId");
            String cloudName = toSupplyNodeInfo.get("cloudName");
            String entityNodeId = entityId + "|" + entityNum + "@" + appId + "#entity";
            String appNodeId = appId + "#app";
            String cloudNodeId = cloudId + "#cloud";
            LinkedHashMap<String, String> entityTemp = new LinkedHashMap<String, String>(16);
            nodeMapCopy.put(entityNodeId, new LinkedHashMap(16));
            entityTemp.put("name", entityName);
            entityTemp.put(PARENT_ID, appNodeId);
            parentMapCopy.put(entityNodeId, entityTemp);
            Map<String, String> appNodeInfoOld = nodeMapCopy.get(appNodeId);
            LinkedHashMap<String, String> appNodeInfos = new LinkedHashMap<String, String>(1);
            LinkedHashMap<String, String> appTemp = new LinkedHashMap<String, String>(2);
            if (null == appNodeInfoOld) {
                appTemp.put("name", appName);
                appTemp.put(PARENT_ID, cloudNodeId);
                parentMapCopy.put(appNodeId, appTemp);
            } else {
                appNodeInfos.putAll(appNodeInfoOld);
            }
            LinkedHashMap<String, String> temp = new LinkedHashMap<String, String>(1);
            temp.put(entityNodeId, entityName);
            appNodeInfos.putAll(temp);
            nodeMapCopy.put(appNodeId, appNodeInfos);
            Map<String, String> cloudNodeInfoOld = nodeMapCopy.get(cloudNodeId);
            LinkedHashMap<String, String> cloudNodeInfos = new LinkedHashMap<String, String>(1);
            LinkedHashMap<String, String> cloudTemp = new LinkedHashMap<String, String>(2);
            if (null == cloudNodeInfoOld) {
                cloudTemp.put("name", cloudName);
                appTemp.put(PARENT_ID, "root#FIRST");
                parentMapCopy.put(cloudNodeId, cloudTemp);
            } else {
                cloudNodeInfos.putAll(cloudNodeInfoOld);
            }
            temp = new LinkedHashMap(1);
            temp.put(appNodeId, appName);
            cloudNodeInfos.putAll(temp);
            nodeMapCopy.put(cloudNodeId, cloudNodeInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchFiledPermTreeByText(String text, boolean showSetup, boolean showRelated) {
        DataSet dataSet = null;
        try {
            Map<String, Map<String, String>> parentMapTemp;
            Map<String, Map<String, String>> nodeMapTemp;
            HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
            QFilter filter = new QFilter("bizappid.bizcloud.id", "in", this.clouds).and(new QFilter("name", "like", (Object)("%" + text + "%")));
            dataSet = entityHelper.queryDataSet(this.getClass().getName() + ".searchUserFuncPermTree." + text, "id,name", new QFilter[]{filter});
            Map fieldPermData = this.permPageCacheUtil.getFieldPermData();
            this.fieldPermTreeView.deleteAllNodes();
            TreeNode rootNode = UserFuncPermTreeUtil.createRootNode();
            this.fieldPermTreeView.addNode(rootNode);
            String rootNodeId = rootNode.getId();
            HashSet<String> cloudIds = new HashSet<String>();
            HashSet<String> appIds = new HashSet<String>();
            if (showRelated) {
                nodeMapTemp = new LinkedHashMap<String, Map<String, String>>(16);
                parentMapTemp = new LinkedHashMap<String, Map<String, String>>(16);
                this.addRelateEntity(nodeMapTemp, parentMapTemp);
            } else {
                nodeMapTemp = this.nodeMap;
                parentMapTemp = this.parentMap;
            }
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String entityNum = row.getString("id");
                String entityName = row.getString("name");
                for (Map.Entry<String, Map<String, String>> entry : nodeMapTemp.entrySet()) {
                    TreeNode cloudNode;
                    TreeNode appNode;
                    String nodeKey = entry.getKey();
                    if (!nodeKey.endsWith("#entity") || !nodeKey.substring(nodeKey.indexOf(124) + 1, nodeKey.indexOf(64)).equals(entityNum)) continue;
                    String appNodeId = parentMapTemp.get(nodeKey).get(PARENT_ID);
                    String cloudNodeId = parentMapTemp.get(appNodeId).get(PARENT_ID);
                    String[] appArray = appNodeId.split("#");
                    String appId = appArray[0];
                    String fieldPermKey = appId + "@" + entityNum;
                    UserRoleFieldPermInfo userRoleFieldPermInfo = (UserRoleFieldPermInfo)fieldPermData.get(fieldPermKey);
                    if (showSetup && (Objects.isNull(userRoleFieldPermInfo) || CollectionUtils.isEmpty((Collection)userRoleFieldPermInfo.getFieldPermModelList()))) continue;
                    String appName = parentMapTemp.get(appNodeId).get("name");
                    String cloudName = parentMapTemp.get(cloudNodeId).get("name");
                    if (cloudIds.contains(cloudNodeId)) {
                        if (appIds.contains(appNodeId)) {
                            appNode = rootNode.getTreeNode(appNodeId, 2);
                        } else {
                            cloudNode = rootNode.getTreeNode(cloudNodeId, 1);
                            appNode = new TreeNode(cloudNodeId, appNodeId, appName, true);
                            appIds.add(appNodeId);
                            cloudNode.addChild(appNode);
                            this.fieldPermTreeView.expand(cloudNodeId);
                        }
                    } else {
                        cloudNode = new TreeNode(rootNodeId, cloudNodeId, cloudName, true);
                        cloudIds.add(cloudNodeId);
                        rootNode.addChild(cloudNode);
                        this.fieldPermTreeView.expand(rootNodeId);
                        appNode = new TreeNode(cloudNodeId, appNodeId, appName, true);
                        appIds.add(appNodeId);
                        cloudNode.addChild(appNode);
                        this.fieldPermTreeView.expand(cloudNodeId);
                    }
                    TreeNode entityNode = new TreeNode(appNodeId, nodeKey, entityName, false);
                    appNode.addChild(entityNode);
                    this.fieldPermTreeView.expand(appNodeId);
                }
            }
            this.fieldPermTreeView.focusNode(rootNode);
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{dataSet});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{dataSet});
    }

    private void supplyOtherEntityByApp(Set<String> hasDoneEvents, List<TreeNode> addNodeList, String appNodeId, String entityNodeId, TreeNode entityNode) {
        String hasSupplyOtherEntityStr = "hasSupplyOtherEntity_" + appNodeId;
        if (hasDoneEvents.add(hasSupplyOtherEntityStr)) {
            Map<String, String> entityInfo = this.nodeMap.get(appNodeId);
            List<Map.Entry<String, String>> entityInfoEntryList = new ArrayList<Map.Entry<String, String>>(entityInfo.entrySet());
            entityInfoEntryList = PermRoleDuplicateCodeUtil.sortForAddNodes(entityInfoEntryList, (PermPageCacheUtil)this.permPageCacheUtil);
            for (Map.Entry<String, String> entityEntry : entityInfoEntryList) {
                String tempEntityNodeId = entityEntry.getKey();
                if (tempEntityNodeId.equals(entityNodeId)) {
                    addNodeList.add(entityNode);
                    continue;
                }
                String entityNodeName = this.getEntityRealName(entityEntry.getValue());
                TreeNode otherEntityNode = new TreeNode(appNodeId, tempEntityNodeId, entityNodeName, true);
                addNodeList.add(otherEntityNode);
            }
        }
    }

    private void supplyOtherAppByCloud(Set<String> hasDoneEvents, List<TreeNode> addNodeList, String cloudNodeId, String appNodeId, TreeNode cloudNode, TreeNode appNode) {
        String hasSupplyOtherAppStr = "hasSupplyOtherApp_" + cloudNodeId;
        if (hasDoneEvents.add(hasSupplyOtherAppStr)) {
            ArrayList<TreeNode> otherAppNodes = new ArrayList<TreeNode>();
            Map<String, String> appInfo = this.nodeMap.get(cloudNodeId);
            List<Map.Entry<String, String>> appInfoEntryList = new ArrayList<Map.Entry<String, String>>(appInfo.entrySet());
            appInfoEntryList = PermRoleDuplicateCodeUtil.sortForAddNodes(appInfoEntryList, (PermPageCacheUtil)this.permPageCacheUtil);
            for (Map.Entry<String, String> appEntry : appInfoEntryList) {
                String tempAppNodeId = appEntry.getKey();
                if (tempAppNodeId.equals(appNodeId)) {
                    otherAppNodes.add(appNode);
                    addNodeList.add(appNode);
                    continue;
                }
                String appNodeName = appEntry.getValue();
                TreeNode otherAppNode = new TreeNode(cloudNodeId, tempAppNodeId, appNodeName, true);
                otherAppNodes.add(otherAppNode);
                addNodeList.add(otherAppNode);
            }
            cloudNode.setChildren(otherAppNodes);
        }
    }

    private void updateNodeParent(Map<String, Map<String, String>> parentMap, String id, String parentId, String name) {
        Map map = parentMap.computeIfAbsent(id, key -> new HashMap());
        map.put(PARENT_ID, parentId);
        map.put("name", name);
        parentMap.put(id, map);
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        if (evt.getNodeId() == null) {
            return;
        }
        String nodeId = evt.getNodeId().toString();
        String isUserFuncPermTreeSearchMode = this.permPageCacheUtil.get("isUserFuncPermTreeSearchMode");
        if (isUserFuncPermTreeSearchMode != null && (nodeId.endsWith("#cloud") || nodeId.endsWith("#app"))) {
            return;
        }
        TreeView tv = (TreeView)evt.getSource();
        this.queryNode(nodeId, tv);
    }

    private void queryNode(String nodeId, TreeView treeView) {
        Map<String, String> childNodeMapTemp = this.nodeMap.get(nodeId);
        Map<String, String> childNodeMap = null == childNodeMapTemp ? new HashMap<String, String>(16) : new HashMap<String, String>(childNodeMapTemp);
        String curTreeViewKey = treeView.getKey();
        IFormView view = treeView.getView();
        boolean showRelated = (Boolean)view.getModel().getValue("fieldshowrelated");
        if (HRStringUtils.equals((String)curTreeViewKey, (String)"tree_fieldperm") && showRelated) {
            LinkedHashMap<String, Map<String, String>> nodeMapTemp = new LinkedHashMap<String, Map<String, String>>(16);
            LinkedHashMap<String, Map<String, String>> parentMapTemp = new LinkedHashMap<String, Map<String, String>>(16);
            this.addRelateEntity(nodeMapTemp, parentMapTemp);
            childNodeMap = (Map)nodeMapTemp.get(nodeId);
        }
        if (childNodeMap == null) {
            return;
        }
        ArrayList<Map.Entry<String, String>> childNodeMapList = new ArrayList<Map.Entry<String, String>>(childNodeMap.entrySet());
        this.loadDataByIfHasSet(treeView, childNodeMap, curTreeViewKey, childNodeMapList);
        List<TreeNode> addNodeList = this.getChildrenNode(nodeId, curTreeViewKey, childNodeMapList);
        if (nodeId.endsWith("#app") && addNodeList.size() > 0) {
            this.sortEntityNodes(nodeId.substring(0, nodeId.indexOf(35)), addNodeList);
        }
        this.userTreeAddNode(addNodeList, treeView, false, new HashSet<String>(16));
        if (nodeId.endsWith("#entity") && addNodeList.size() > 0) {
            this.sortPermItemNodes(nodeId, treeView);
        }
    }

    private void sortPermItemNodes(String nodeId, TreeView treeView) {
        Map<String, String> childNodeMapTemp = this.nodeMap.get(nodeId);
        String entityNum = nodeId.substring(nodeId.indexOf(124) + 1, nodeId.indexOf(64));
        ArrayList nodeIdList = Lists.newArrayList(childNodeMapTemp.keySet());
        ArrayList sortedNodeList = Lists.newArrayListWithExpectedSize((int)childNodeMapTemp.size());
        for (Map.Entry<String, String> entry : childNodeMapTemp.entrySet()) {
            sortedNodeList.add(new TreeNode(nodeId, entry.getKey(), entry.getValue()));
        }
        AllFuncPermTreeUtil.sortPermItemSeq(entityNum, sortedNodeList);
        treeView.deleteNodes((List)nodeIdList);
        treeView.addNodes((List)sortedNodeList);
    }

    @ExcludeFromJacocoGeneratedReport
    private void sortEntityNodes(String appId, List<TreeNode> addNodeList) {
        if (CollectionUtils.isEmpty(addNodeList)) {
            return;
        }
        final Map permTreeSeq = EntityCtrlServiceHelper.getPermTreeSeq((String)appId);
        if (permTreeSeq != null) {
            addNodeList.sort(new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode o1, TreeNode o2) {
                    String id1 = o1.getId();
                    String id2 = o2.getId();
                    Integer index1 = (Integer)permTreeSeq.get(id1.substring(id1.indexOf(124) + 1, id1.indexOf(64)));
                    Integer index2 = (Integer)permTreeSeq.get(id2.substring(id2.indexOf(124) + 1, id2.indexOf(64)));
                    if (null == index1) {
                        index1 = Integer.MAX_VALUE;
                    }
                    if (null == index2) {
                        index2 = Integer.MAX_VALUE;
                    }
                    if (Integer.MAX_VALUE == index1 && Integer.MAX_VALUE == index2) {
                        Collator cltr = Collator.getInstance(RequestContext.get().getLang().getLocale());
                        return cltr.compare(o1.getText(), o2.getText());
                    }
                    return index1.compareTo(index2);
                }
            });
        } else {
            final Collator cltr = Collator.getInstance(RequestContext.get().getLang().getLocale());
            addNodeList.sort(new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode o1, TreeNode o2) {
                    return cltr.compare(o1.getText(), o2.getText());
                }
            });
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void loadDataByIfHasSet(TreeView treeView, Map<String, String> childNodeMap, String curTreeViewKey, List<Map.Entry<String, String>> childNodeMapList) {
        boolean hasSetPerm = false;
        List<String> hasSetEntityKeyList = null;
        if (curTreeViewKey.equals("tree_dataperm")) {
            hasSetPerm = (Boolean)treeView.getModel().getValue("datashowsetup");
            hasSetEntityKeyList = StringUtils.isNotEmpty((String)(this.orgId + "")) && !"-1".equals(this.orgId) ? this.getHasSetPermEntityKeys("pageCache_hasSetDataPerm_" + this.orgId) : this.getHasSetPermEntityKeys("pageCache_hasSetDataPerm");
        }
        if (hasSetPerm) {
            this.getChildrenNode(childNodeMap, childNodeMapList, hasSetEntityKeyList);
        }
    }

    private List<TreeNode> getChildrenNode(String nodeId, String curTreeViewKey, List<Map.Entry<String, String>> childNodeMapList) {
        childNodeMapList = PermRoleDuplicateCodeUtil.sortForAddNodes(childNodeMapList, (PermPageCacheUtil)this.permPageCacheUtil);
        ArrayList<TreeNode> addNodeList = new ArrayList<TreeNode>(16);
        for (Map.Entry childEntry : childNodeMapList) {
            String newChildNodeId = (String)childEntry.getKey();
            boolean hasChild = true;
            if (newChildNodeId.contains("#permItem")) {
                hasChild = false;
            }
            if (newChildNodeId.contains("#entity") && (curTreeViewKey.equals("tree_fieldperm") || curTreeViewKey.equals("tree_dataperm"))) {
                hasChild = false;
            }
            String nodeName = (String)childEntry.getValue();
            if (newChildNodeId.endsWith("#entity")) {
                String entityId = newChildNodeId.substring(newChildNodeId.indexOf("|") + 1, newChildNodeId.indexOf("@"));
                nodeName = this.getEntityRealName(entityId);
            }
            TreeNode newChildNode = new TreeNode(nodeId, newChildNodeId, nodeName, hasChild);
            addNodeList.add(newChildNode);
        }
        return addNodeList;
    }

    @ExcludeFromJacocoGeneratedReport
    private void getChildrenNode(Map<String, String> childNodeMap, List<Map.Entry<String, String>> childNodeMapList, List<String> hasSetEntityKeys) {
        childNodeMapList.clear();
        for (Map.Entry<String, String> sonEntry : childNodeMap.entrySet()) {
            String newSonNodeId = sonEntry.getKey();
            String entityNum = "";
            String appId = "";
            String entityKey = "";
            if (newSonNodeId == null || !newSonNodeId.contains("#entity")) {
                entityNum = null;
            } else {
                entityNum = AllFuncPermTreeUtil.getEntityNumFromNodeId(newSonNodeId);
                appId = AllFuncPermTreeUtil.getAppIdFromNodeId(newSonNodeId);
                entityKey = entityNum + "@" + appId;
            }
            if (StringUtils.isNotEmpty((String)entityNum)) {
                this.handleEntityNotEmpty(sonEntry, hasSetEntityKeys, childNodeMapList, entityKey);
                continue;
            }
            this.getPermSetupList(newSonNodeId, sonEntry, hasSetEntityKeys, childNodeMapList);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void getPermSetupList(String newChildNodeId, Map.Entry<String, String> childEntry, List<String> hasSetEntityKeys, List<Map.Entry<String, String>> childNodeMapList) {
        Map<String, String> tempChildNodeMap = this.nodeMap.get(newChildNodeId);
        ArrayList<Map.Entry<String, String>> tempNodeMapList = new ArrayList<Map.Entry<String, String>>(tempChildNodeMap.entrySet());
        for (Map.Entry entry : tempNodeMapList) {
            String newChildSonNodeId = (String)entry.getKey();
            String entityNumber = "";
            String appId = "";
            String entityKey = "";
            if (newChildSonNodeId == null || !newChildSonNodeId.contains("#entity")) {
                entityNumber = null;
            } else {
                entityNumber = AllFuncPermTreeUtil.getEntityNumFromNodeId(newChildSonNodeId);
                appId = AllFuncPermTreeUtil.getAppIdFromNodeId(newChildSonNodeId);
                entityKey = entityNumber + "@" + appId;
            }
            if (!StringUtils.isNotEmpty((String)entityNumber)) continue;
            this.handleEntityNotEmpty(childEntry, hasSetEntityKeys, childNodeMapList, entityKey);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleEntityNotEmpty(Map.Entry<String, String> childEntry, List<String> hasSetEntityKeys, List<Map.Entry<String, String>> childNodeMapList, String entityKey) {
        for (String tempEntityKey : hasSetEntityKeys) {
            if (!entityKey.equals(tempEntityKey)) continue;
            childNodeMapList.add(childEntry);
        }
    }

    public List<Map<String, String>> getCurPermDataAll() {
        ArrayList<Map<String, String>> dataLists = new ArrayList<Map<String, String>>();
        Map allRelatedPerms = (Map)SerializationUtils.fromJsonString((String)this.permPageCacheUtil.get("allRelatedPerms"), Map.class);
        StringBuilder builderInfo = new StringBuilder();
        String roleId = (String)this.funcPermTreeView.getView().getFormShowParameter().getCustomParam("roleId");
        builderInfo.append("roleId = [").append(roleId).append(']');
        Map<String, Map<String, List<String>>> allIndependentPerm = this.getAllIndependentPerm();
        HashSet independentPerms = new HashSet(16);
        for (Map.Entry<String, Map<String, List<String>>> entry : allIndependentPerm.entrySet()) {
            String appId = entry.getKey();
            Map<String, List<String>> value = entry.getValue();
            for (Map.Entry<String, List<String>> entityEntry : value.entrySet()) {
                String entity = entityEntry.getKey();
                List<String> perms = entityEntry.getValue();
                perms.forEach(it -> independentPerms.add(entity + "|" + it + "@" + appId));
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.nodeMap.entrySet()) {
            String nodeId = entry.getKey();
            Map<String, Object> permItemMap = entry.getValue();
            if (permItemMap == null || !nodeId.contains("#entity")) continue;
            String entityNum = AllFuncPermTreeUtil.getEntityNumFromNodeId(nodeId);
            String appId = AllFuncPermTreeUtil.getAppIdFromNodeId(nodeId);
            for (String permItemId : permItemMap.keySet()) {
                HashMap<String, String> data = new HashMap<String, String>(3);
                permItemId = permItemId.substring(permItemId.indexOf(124) + 1, permItemId.indexOf(64));
                data.put("entityNumber", entityNum);
                data.put("permItemId", permItemId);
                data.put("appId", appId);
                dataLists.add(data);
                String mainPermId = entityNum + appId + permItemId;
                List maps = (List)allRelatedPerms.get(mainPermId);
                if (maps == null) continue;
                builderInfo.append(" main permId = ").append(mainPermId).append(" relate permId = ").append(maps.toString());
                maps.removeIf(it -> independentPerms.contains((String)it.get("entityNumber") + "|" + (String)it.get("permItemNumber") + "@" + (String)it.get("appId")));
                dataLists.addAll(maps);
            }
        }
        LOGGER.info(builderInfo.toString());
        return dataLists;
    }

    public List<Map<String, String>> getCurPermData() {
        ArrayList<Map<String, String>> dataLists = new ArrayList<Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : this.nodeMap.entrySet()) {
            String nodeId = entry.getKey();
            Map<String, String> permItemMap = entry.getValue();
            if (permItemMap == null || !nodeId.contains("#entity")) continue;
            String entityNum = AllFuncPermTreeUtil.getEntityNumFromNodeId(nodeId);
            String appId = AllFuncPermTreeUtil.getAppIdFromNodeId(nodeId);
            for (String permItemId : permItemMap.keySet()) {
                HashMap<String, String> data = new HashMap<String, String>(3);
                permItemId = permItemId.substring(permItemId.indexOf(124) + 1, permItemId.indexOf(64));
                data.put("entityNumber", entityNum);
                data.put("permItemId", permItemId);
                data.put("appId", appId);
                dataLists.add(data);
            }
        }
        return dataLists;
    }

    protected void checkRelatePerms() {
        List<Map<String, String>> curPermData = this.getCurPermData();
        IFormView view = this.funcPermTreeView.getView();
        if (curPermData.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u529f\u80fd\u6743\u9650\u6570\u636e\u3002", (String)"UserFuncPermTreeUtil_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        HashSet<String> permData = new HashSet<String>(curPermData.size());
        for (Map<String, String> curPermDatum : curPermData) {
            String permStr = curPermDatum.get("entityNumber") + "|" + curPermDatum.get("permItemId") + "@" + curPermDatum.get("appId") + "#permItem";
            permData.add(permStr);
        }
        String allRelatedPermsStr = this.permPageCacheUtil.get("allRelatedPerms");
        Map allRelatedPerms = (Map)SerializationUtils.fromJsonString((String)allRelatedPermsStr, Map.class);
        Set<String> allIndependentPermInfos = this.getAllIndependentPermInfos();
        HashMap toShowRelatedPerms = new HashMap(16);
        String roleId = (String)this.funcPermTreeView.getView().getFormShowParameter().getCustomParam("roleId");
        List<Object> newRelatePerm = new ArrayList(16);
        boolean flag = false;
        if (HRStringUtils.isNotEmpty((String)roleId) && (newRelatePerm = this.sortNewRelatePerm()).size() > 0) {
            flag = true;
        }
        List originPermIds = this.permPageCacheUtil.getOriginalFuncPermDataList().stream().map(it -> (String)it.get("entityNumber") + "|" + (String)it.get("permItemId") + "@" + (String)it.get("appId") + "#permItem").collect(Collectors.toList());
        for (String permDatum : permData) {
            List value = (List)allRelatedPerms.get(permDatum);
            if (null == value) continue;
            value = value.stream().filter(it -> !allIndependentPermInfos.contains((String)it.get("entityNumber") + "|" + (String)it.get("permItemNumber") + "@" + (String)it.get("appId"))).collect(Collectors.toList());
            if (flag && originPermIds.contains(permDatum)) {
                List<Object> finalNewRelatePerm = newRelatePerm;
                value = value.stream().filter(it -> !finalNewRelatePerm.contains((String)it.get("entityNumber") + "|" + (String)it.get("permItemId") + "@" + (String)it.get("appId")) && !allIndependentPermInfos.contains((String)it.get("entityNumber") + "|" + (String)it.get("permItemNumber") + "@" + (String)it.get("appId"))).collect(Collectors.toList());
            }
            if (value.size() <= 0) continue;
            toShowRelatedPerms.put(permDatum, value);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("hrcs_checkrelate");
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("840px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        fsp.setOpenStyle(style);
        fsp.setCustomParam("toShowRelatedPerms", toShowRelatedPerms);
        view.showForm(fsp);
    }

    private List<String> sortNewRelatePerm() {
        List newRelatePerm;
        String newRelatePermStr = this.permPageCacheUtil.get("newRelatePerm");
        if (HRStringUtils.isNotEmpty((String)newRelatePermStr)) {
            newRelatePerm = (List)SerializationUtils.fromJsonString((String)newRelatePermStr, List.class);
        } else {
            List<Map<String, String>> rolePerms = this.getRolePerms();
            List<Map<String, String>> curPermDataAll = this.getCurPermDataAll();
            List rolePermIds = rolePerms.stream().map(it -> (String)it.get("entityNumber") + "|" + (String)it.get("permItemId") + "@" + (String)it.get("appId")).collect(Collectors.toList());
            List curPermDataAllIds = curPermDataAll.stream().map(it -> (String)it.get("entityNumber") + "|" + (String)it.get("permItemId") + "@" + (String)it.get("appId")).collect(Collectors.toList());
            curPermDataAllIds.removeAll(rolePermIds);
            newRelatePerm = curPermDataAllIds;
            this.permPageCacheUtil.put("newRelatePerm", SerializationUtils.toJsonString(newRelatePerm));
        }
        return newRelatePerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> getRolePerms() {
        ArrayList<Map<String, String>> arrayList;
        String rolePermStr = this.permPageCacheUtil.get("rolePerms");
        if (HRStringUtils.isNotEmpty((String)rolePermStr)) {
            List res = (List)SerializationUtils.fromJsonString((String)rolePermStr, List.class);
            return res;
        }
        String roleId = (String)this.funcPermTreeView.getView().getFormShowParameter().getCustomParam("roleId");
        if (HRStringUtils.isEmpty((String)roleId)) {
            return null;
        }
        String langStr = RequestContext.get().getLang().name();
        String algoKeyPrefix = this.getClass().getName() + ".loadRolePermFromDB.";
        DataSet rolePermDS = null;
        DataSet entityDS = null;
        DataSet cloudAppDS = null;
        DataSet tempDS1 = null;
        DataSet tempDS2 = null;
        try {
            rolePermDS = UserFuncPermTreeUtil.getRolePermDS(roleId, algoKeyPrefix);
            cloudAppDS = UserFuncPermTreeUtil.getCloudAppDS(langStr, algoKeyPrefix);
            entityDS = UserFuncPermTreeUtil.getEntityDS(algoKeyPrefix);
            tempDS1 = rolePermDS.join(cloudAppDS).on(ROLEPD_APPID, APP_ID).select(new String[]{ROLEPD_ENTNUM, ROLEPD_PERMITEMID}, new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY}).finish();
            tempDS2 = tempDS1.join(entityDS).on(ROLEPD_ENTNUM, ENTD_NUM).select(new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY, ROLEPD_PERMITEMID, "entd_name"}, new String[]{ENTD_NUM, ENTD_ID}).finish();
            ArrayList<Map<String, String>> dataLists = new ArrayList<Map<String, String>>(16);
            while (tempDS2.hasNext()) {
                Row row = tempDS2.next();
                HashMap<String, String> data = new HashMap<String, String>(3);
                data.put("entityNumber", row.getString(ENTD_NUM));
                data.put("permItemId", row.getString(ROLEPD_PERMITEMID));
                data.put("appId", row.getString(APP_ID));
                dataLists.add(data);
            }
            long start = System.currentTimeMillis();
            String dataStr = SerializationUtils.toJsonString(dataLists);
            this.permPageCacheUtil.put("rolePerms", dataStr);
            long end = System.currentTimeMillis();
            LOGGER.info("PutRolePermsCoast: {}ms, dataStrLength: {}.", (Object)(end - start), (Object)dataStr.length());
            arrayList = dataLists;
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{rolePermDS, entityDS, cloudAppDS, tempDS1, tempDS2});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{rolePermDS, entityDS, cloudAppDS, tempDS1, tempDS2});
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRolePermFromDB(String roleId) {
        this.initRootNode();
        if (HRStringUtils.isEmpty((String)roleId)) {
            return;
        }
        String langStr = RequestContext.get().getLang().name();
        String algoKeyPrefix = this.getClass().getName() + ".loadRolePermFromDB.";
        DataSet permItemDS = null;
        DataSet finalDS = null;
        DataSet rolePermDS = null;
        DataSet entityDS = null;
        DataSet cloudAppDS = null;
        DataSet tempDS1 = null;
        DataSet tempDS2 = null;
        try {
            rolePermDS = UserFuncPermTreeUtil.getRolePermDS(roleId, algoKeyPrefix);
            cloudAppDS = UserFuncPermTreeUtil.getCloudAppDS(langStr, algoKeyPrefix);
            entityDS = UserFuncPermTreeUtil.getEntityDS(algoKeyPrefix);
            permItemDS = UserFuncPermTreeUtil.getPermItemDS(langStr, algoKeyPrefix);
            tempDS1 = rolePermDS.join(cloudAppDS).on(ROLEPD_APPID, APP_ID).select(new String[]{ROLEPD_ENTNUM, ROLEPD_PERMITEMID}, new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY}).finish();
            tempDS2 = tempDS1.join(entityDS).on(ROLEPD_ENTNUM, ENTD_NUM).select(new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY, ROLEPD_PERMITEMID, "entd_name"}, new String[]{ENTD_NUM, ENTD_ID}).finish();
            finalDS = UserFuncPermTreeUtil.getFinalDS(permItemDS, tempDS2);
            this.queryDataBySQL(finalDS);
            TreeNode rootNode = UserFuncPermTreeUtil.createRootNode();
            rootNode.setIsOpened(true);
            this.doSetDataToTree(new HashSet<String>(), rootNode);
            this.updateCache();
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{rolePermDS, entityDS, permItemDS, cloudAppDS, finalDS, tempDS1, tempDS2});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{rolePermDS, entityDS, permItemDS, cloudAppDS, finalDS, tempDS1, tempDS2});
    }

    private void initRootNode() {
        TreeNode funcPermTree = UserFuncPermTreeUtil.createRootNode();
        this.funcPermTreeView.deleteAllNodes();
        this.funcPermTreeView.addNode(funcPermTree);
        this.fieldPermTreeView.deleteAllNodes();
        this.fieldPermTreeView.addNode(funcPermTree);
    }

    public static DataSet getPermItemDS(String langStr, String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + PERM_ITEM_DS), (DBRoute)DBRoute.permission, (String)"  SELECT permiteml.fid permiteml_id, permiteml.FNAME permiteml_name, permitem.fnumber permitem_num  FROM t_perm_permitem permitem  INNER JOIN t_perm_permitem_l permiteml ON (permiteml.FID = permitem.FID AND permiteml.FLOCALEID = ?) ", (Object[])new Object[]{langStr});
    }

    public static DataSet getEntityDS(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + ENTITY_DS), (DBRoute)DBRoute.meta, (String)UserFuncPermTreeUtil.buildEntitySql().toString(), (Object[])new Object[]{RequestContext.get().getLang().name()});
    }

    public static DataSet getCloudAppDS(String langStr, String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)" SELECT  cloudl.fid cloudl_id, cloudl.fname cloudl_name,  app.fid app_id, app.fnumber app_num,  app.findustry app_industry  FROM t_meta_bizapp app  INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = app.FBIZCLOUDID and cloudl.FLOCALEID = ?)  WHERE app.FDEPLOYSTATUS = '2' ", (Object[])new Object[]{langStr});
    }

    public static DataSet getRolePermDS(String roleId, String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + "rolePermDS"), (DBRoute)DBRoute.permission, (String)" SELECT  rolepd.fentitytypeid rolepd_entnum,  rolepd.FBIZAPPID rolepd_appid,  rolepd.FPERMITEMID rolepd_permitemid  FROM t_perm_roleperm rolep  INNER JOIN t_perm_rolepermdetial rolepd ON (rolepd.FID = rolep.FID)  WHERE rolep.FROLEID = ?", (Object[])new Object[]{roleId});
    }

    @ExcludeFromJacocoGeneratedReport
    public static DataSet getFinalDS(DataSet permItemDS, DataSet tempDS2) {
        return tempDS2.join(permItemDS).on(ROLEPD_PERMITEMID, PERMITEML_ID).select(new String[]{CLOUDL_ID, CLOUDL_NAME, APP_ID, APP_NUM, APP_INDUSTRY, ENTD_NUM, ENTD_ID, "entd_name"}, new String[]{PERMITEML_ID, PERMITEM_NUM, PERMITEML_NAME}).finish().orderBy(new String[]{"cloudl_id   asc", "app_id   asc", "entd_num asc", "permiteml_id  asc"});
    }

    private void doSetDataToTree(Set<String> cloudSet, TreeNode rootNode) {
        List<String> cloudIds = this.extractCloudIds();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)cloudIds.size());
        this.clouds.forEach(cloudId -> cloudIds.stream().filter(it -> HRStringUtils.equals((String)cloudId, (String)it.substring(0, it.indexOf(35)))).findFirst().ifPresent(list::add));
        for (String tempCloudId : list) {
            if (cloudSet.size() > 0 && !cloudSet.contains(tempCloudId)) continue;
            Map<String, String> cloudInfo = this.nodeMap.get(tempCloudId);
            Iterator<String> appIds = cloudInfo.keySet().iterator();
            HashMap<String, Set> removedMap = new HashMap<String, Set>(16);
            while (appIds.hasNext()) {
                String appId = appIds.next();
                Iterator appInfo = this.nodeMap.get(appId);
                for (String entityId : appInfo.keySet()) {
                    if (null != this.nodeMap.get(entityId)) continue;
                    Set removedEntityIds = removedMap.computeIfAbsent(appId, k -> new HashSet(16));
                    removedEntityIds.add(entityId);
                }
            }
            HashSet<String> removedAppIds = new HashSet<String>(16);
            for (Map.Entry entry : removedMap.entrySet()) {
                String appId = (String)entry.getKey();
                Set removedIds = (Set)entry.getValue();
                Map<String, String> appInfo = this.nodeMap.get(appId);
                for (String removedId : removedIds) {
                    appInfo.remove(removedId);
                }
                if (!appInfo.isEmpty()) continue;
                this.nodeMap.remove(appId);
                removedAppIds.add(appId);
            }
            for (String string : removedAppIds) {
                cloudInfo.remove(string);
            }
            if (cloudInfo.isEmpty()) {
                this.nodeMap.remove(tempCloudId);
                continue;
            }
            String cloudName = this.parentMap.get(tempCloudId).get("name");
            TreeNode treeNode = new TreeNode("root#FIRST", tempCloudId, cloudName, true);
            rootNode.addChild(treeNode);
        }
        List addNodeList = rootNode.getChildren();
        this.doAddNodeToUserTree(cloudSet, addNodeList);
    }

    private void doAddNodeToUserTree(Set<String> cloudSet, List<TreeNode> addNodeList) {
        if (!CollectionUtils.isEmpty(addNodeList)) {
            this.userTreeAddNode(addNodeList, null, false, new HashSet<String>(16));
            if (CollectionUtils.isEmpty(cloudSet)) {
                this.funcPermTreeView.expand("root#FIRST");
            }
            if (!Objects.isNull(this.viewFuncPermTreeView)) {
                this.viewFuncPermTreeView.expand("root#FIRST");
            }
        }
    }

    private List<String> extractCloudIds() {
        ArrayList<String> cloudIds = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : this.parentMap.entrySet()) {
            String nodeId = entry.getKey();
            Map<String, String> map = entry.getValue();
            if (map == null || !map.get(PARENT_ID).equals("root#FIRST")) continue;
            cloudIds.add(nodeId);
        }
        return cloudIds;
    }

    private void updateCache() {
        LOGGER.info("Update cache with parentMapPgKey:[{}], parentMap:[{}]", (Object)this.parentMapPgKey, this.parentMap);
        this.permPageCacheUtil.put(this.nodeMapPgKey, SerializationUtils.toJsonString(this.nodeMap));
        this.permPageCacheUtil.put(this.parentMapPgKey, SerializationUtils.toJsonString(this.parentMap));
    }

    @ExcludeFromJacocoGeneratedReport
    public List<String> getHasSetPermEntityKeys(String hasSetCacheKey) {
        List<String> hasSetEntityKeys = new ArrayList<String>();
        String hasSetPermCache = this.permPageCacheUtil.get(hasSetCacheKey);
        if (StringUtils.isNotEmpty((String)hasSetPermCache)) {
            hasSetEntityKeys = SerializationUtils.fromJsonStringToList((String)hasSetPermCache, String.class);
        }
        return hasSetEntityKeys;
    }

    @ExcludeFromJacocoGeneratedReport
    private void appendAppFilter(StringBuilder sb, List<String> filterAppIds) {
        if (filterAppIds == null || filterAppIds.isEmpty()) {
            return;
        }
        Map allExtAppIdMap = PermFormCommonUtil.getAllExtAppIds(filterAppIds);
        sb.append(" AND app.FID IN (");
        ArrayList<String> finalFilterAppIds = new ArrayList<String>(filterAppIds);
        if (allExtAppIdMap != null && !allExtAppIdMap.isEmpty()) {
            for (String filterAppId : filterAppIds) {
                List extAppIds = (List)allExtAppIdMap.get(filterAppId);
                if (extAppIds == null || extAppIds.isEmpty()) continue;
                finalFilterAppIds.addAll(extAppIds);
            }
        }
        for (int i = 0; i < finalFilterAppIds.size(); ++i) {
            String id = (String)finalFilterAppIds.get(i);
            sb.append(" '").append(id).append("' ");
            if (i == finalFilterAppIds.size() - 1) continue;
            sb.append(',');
        }
        sb.append(')');
    }

    public void initRightTree() {
        TreeNode funcPermTree = UserFuncPermTreeUtil.createRootNode();
        this.funcPermTreeView.deleteAllNodes();
        this.funcPermTreeView.addNode(funcPermTree);
        this.fieldPermTreeView.deleteAllNodes();
        this.fieldPermTreeView.addNode(funcPermTree);
    }

    public void fieldTreeShowSetUp(IFormView view) {
        Search fieldTreeSearch = (Search)view.getControl("fieldtreesearch");
        String searchKey = fieldTreeSearch.getSearchKey();
        boolean showSetup = (Boolean)view.getModel().getValue("fieldshowsetup");
        boolean showRelated = (Boolean)view.getModel().getValue("fieldshowrelated");
        if (HRStringUtils.isEmpty((String)searchKey)) {
            this.searchNullForField(showSetup, showRelated);
        } else {
            this.searchFiledPermTreeByText(searchKey, showSetup, showRelated);
        }
        view.getModel().deleteEntryData("list_fieldperm");
        view.getModel().updateCache();
    }

    public void initTreeViewCtrl(IFormView formView, PermPageCacheUtil permPageCacheUtil, TreeView funcPermTreeView) {
        Search userTreeSearch = (Search)formView.getControl("searchap1");
        userTreeSearch.addEnterListener(searchEnterEvt -> {
            String searchText = searchEnterEvt.getText();
            if (StringUtils.isEmpty((String)searchText)) {
                this.searchNull(funcPermTreeView);
                permPageCacheUtil.remove("isUserFuncPermTreeSearchMode");
            } else {
                permPageCacheUtil.put("isUserFuncPermTreeSearchMode", "true");
                this.searchUserFuncPermTreeByText(searchText);
            }
        });
        Search filedTreeSearch = (Search)formView.getControl("fieldtreesearch");
        filedTreeSearch.addEnterListener(searchEnterEvt -> {
            String searchText = searchEnterEvt.getText();
            this.doSearchFieldPermTree(formView, searchText);
        });
    }

    private Map<String, String> getPermIdName() {
        String permIdNameStr = this.permPageCacheUtil.get("permIdName");
        if (HRStringUtils.isNotEmpty((String)permIdNameStr)) {
            Map idNameMap = (Map)SerializationUtils.fromJsonString((String)permIdNameStr, Map.class);
            return idNameMap;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_permitem");
        DynamicObject[] objects = serviceHelper.query("id,name", new QFilter[0]);
        Map<String, String> result = Arrays.stream(objects).filter(it -> HRStringUtils.isNotEmpty((String)it.getString("id")) && HRStringUtils.isNotEmpty((String)it.getLocaleString("name").getLocaleValue())).collect(Collectors.toMap(it -> it.getString("id"), it -> it.getLocaleString("name").getLocaleValue(), (oldValue, newValue) -> oldValue));
        this.permPageCacheUtil.put("permIdName", SerializationUtils.toJsonString(result));
        return result;
    }

    private Map<String, Map<String, List<String>>> getAllIndependentPerm() {
        Map result;
        String str = this.permPageCacheUtil.get(ALL_INDEPENDENT_PERM);
        if (HRStringUtils.isEmpty((String)str)) {
            result = PermRelateServiceHelper.queryAllIndependentPerm();
            this.permPageCacheUtil.put(ALL_INDEPENDENT_PERM, SerializationUtils.toJsonString((Object)result));
        } else {
            result = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        return result;
    }

    private Set<String> getAllIndependentPermInfos() {
        Map<String, Map<String, List<String>>> allIndependentPerm = this.getAllIndependentPerm();
        HashSet<String> infos = new HashSet<String>(16);
        for (Map.Entry<String, Map<String, List<String>>> appEntry : allIndependentPerm.entrySet()) {
            String appId = appEntry.getKey();
            for (Map.Entry<String, List<String>> entry : appEntry.getValue().entrySet()) {
                String entity = entry.getKey();
                List<String> perms = entry.getValue();
                perms.forEach(perm -> infos.add(entity + "|" + perm + "@" + appId));
            }
        }
        return infos;
    }
}

