/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.perm.role.component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.extpoint.permission.role.IRoleDimF7CustomFilterPlugin;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hrcs.bussiness.servicehelper.perm.ControlHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DimensionHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DynamicControlHelper;
import kd.hr.hrcs.bussiness.util.PermCheckUtil;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;

@ExcludeFromJacocoGeneratedReport
public class CustomCtrlPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener,
IRoleDimF7CustomFilterPlugin {
    private static final Log LOGGER = LogFactory.getLog(CustomCtrlPlugin.class);
    private static final String PREFIX_REVERT = "revert_";
    private static final String PREFIX_NEXT = "next_";

    public void getEntityType(GetEntityTypeEventArgs evt) {
        MainEntityType newMainType = DynamicControlHelper.registerProperty((GetEntityTypeEventArgs)evt, (IFormView)this.getView());
        evt.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs evt) {
        super.onGetControl(evt);
        String evtKey = evt.getKey();
        DynamicControlHelper.dinamicSetCtrl((IFormView)this.getView(), (IFormPlugin)this, (BeforeF7SelectListener)this, (OnGetControlArgs)evt, (String)evtKey);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
        String currentHRbuFunc = (String)this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        LOGGER.info("AfterCreateNewData start. Thread id:[{}], currentHrBuFunc:[{}].", (Object)Thread.currentThread().getId(), (Object)currentHRbuFunc);
        try (DLock lock = DLock.createReentrant((String)("loadRoleDataLockKey" + mainPageId));){
            boolean locked;
            LOGGER.info("AfterCreateNewData try get lock. Thread id:[{}], currentHrBuFunc:[{}].", (Object)Thread.currentThread().getId(), (Object)currentHRbuFunc);
            boolean hrRoleLockless = HRStringUtils.equals((String)"1", (String)System.getProperty("hr.role.lockless"));
            boolean bl = locked = hrRoleLockless || lock.tryLock(100000L);
            if (locked) {
                String groupId;
                LOGGER.info("AfterCreateNewData got lock. Thread id:[{}], currentHrBuFunc:[{}].", (Object)Thread.currentThread().getId(), (Object)currentHRbuFunc);
                IFormView formView = this.getView().getView(mainPageId);
                Map controlMap = (Map)this.getView().getFormShowParameter().getCustomParam("controlMap");
                PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(formView, false);
                Map parentControlMap = pageCacheUtil.getControlMap();
                if (CollectionUtils.isEmpty((Map)parentControlMap)) {
                    parentControlMap = Maps.newHashMapWithExpectedSize((int)controlMap.size());
                }
                if (HRStringUtils.isNotEmpty((String)(groupId = (String)this.getView().getFormShowParameter().getCustomParam("dimensionGroup")))) {
                    Map grpControlMap = pageCacheUtil.getGrpControlMap();
                    ArrayList list = (ArrayList)grpControlMap.get(groupId);
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        list = new ArrayList();
                    }
                    list.addAll(new ArrayList(controlMap.keySet()));
                    grpControlMap.put(groupId, list);
                    ControlHelper.setSyncGrpControlMap((PermPageCacheUtil)pageCacheUtil, (Map)grpControlMap);
                }
                parentControlMap.putAll(controlMap);
                ControlHelper.setSyncControlMap((PermPageCacheUtil)pageCacheUtil, (Map)parentControlMap);
            } else {
                LOGGER.info("AfterCreateNewData can not got lock. Thread id:[{}], currentHrBuFunc:[{}].", (Object)Thread.currentThread().getId(), (Object)currentHRbuFunc);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u89d2\u8272\u5931\u8d25\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u91cd\u8bd5\u3002", (String)"HRDataPermCtrlContainerPlugin_4", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
        LOGGER.info("AfterCreateNewData release lock. Thread id:[{}], currentHrBuFunc:[{}].", (Object)Thread.currentThread().getId(), (Object)currentHRbuFunc);
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforePropertyChanged(PropertyChangedArgs evt) {
        boolean adminScopeSwitch = PermCheckUtil.getSysParamLimitAssignDimRange();
        String property = evt.getProperty().getName();
        if (property.startsWith("cbx") && property.startsWith("cbxnotlimit")) {
            long dimId = Long.parseLong(property.substring(property.lastIndexOf("#") + 1));
            ChangeData changeData = evt.getChangeSet()[0];
            boolean oldValue = !Objects.isNull(changeData.getOldValue()) && (Boolean)changeData.getOldValue() != false;
            boolean newValue = !Objects.isNull(changeData.getNewValue()) && (Boolean)changeData.getNewValue() != false;
            long level = HRPermServiceHelper.getUserGroupMinLevel();
            if (!oldValue && newValue && level > 2L && adminScopeSwitch && !HRStringUtils.equals((String)"0", (String)this.getDimType(dimId))) {
                this.getPageCache().put(PREFIX_REVERT + property, "1");
                this.getPageCache().put(PREFIX_NEXT + property, "0");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u9009\u62e9\u4e0d\u9650\u3002", (String)"CustomCtrlPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
        String property = evt.getProperty().getName();
        boolean revert = HRStringUtils.equals((String)"1", (String)Optional.ofNullable(this.getPageCache().get(PREFIX_REVERT + property)).orElse("0"));
        if (revert) {
            this.getPageCache().put(PREFIX_REVERT + property, "0");
            this.getModel().setValue(property, (Object)false);
            return;
        }
        boolean next = HRStringUtils.equals((String)"1", (String)Optional.ofNullable(this.getPageCache().get(PREFIX_NEXT + property)).orElse("1"));
        if (!next) {
            this.getPageCache().put(PREFIX_NEXT + property, "1");
            return;
        }
        LOGGER.info("CustomCtrlPlugin.PropertyChanged start. Thread id:[{}]", (Object)Thread.currentThread().getId());
        try (DLock lock = DLock.createReentrant((String)("changeRoleDataLockKey" + mainPageId));){
            boolean locked;
            LOGGER.info("CustomCtrlPlugin.PropertyChanged try get lock. Thread id:[{}]", (Object)Thread.currentThread().getId());
            boolean hrRoleLockless = HRStringUtils.equals((String)"1", (String)System.getProperty("hr.role.lockless"));
            boolean bl = locked = hrRoleLockless || lock.tryLock(10000L);
            if (locked) {
                LOGGER.info("CustomCtrlPlugin.PropertyChanged got lock. Thread id:[{}]", (Object)Thread.currentThread().getId());
                DynamicControlHelper.handlePropertyChanged((IFormView)this.getView(), (PropertyChangedArgs)evt);
            } else {
                LOGGER.info("CustomCtrlPlugin.PropertyChanged can not got lock. Thread id:[{}]", (Object)Thread.currentThread().getId());
            }
        }
        LOGGER.info("CustomCtrlPlugin.PropertyChanged release lock. Thread id:[{}]", (Object)Thread.currentThread().getId());
    }

    @ExcludeFromJacocoGeneratedReport
    public void click(EventObject evt) {
        super.click(evt);
        Object sourceObj = evt.getSource();
        if (sourceObj instanceof Label) {
            Label source = (Label)sourceObj;
            String key = source.getKey();
            HRBaseServiceHelper dimensionServiceHelper = new HRBaseServiceHelper("hrcs_dimension");
            if (key.startsWith("customvector")) {
                String dynamicConditionIds = Arrays.stream(new HRBaseServiceHelper("hrcs_dynacond").query("id", new QFilter[]{new QFilter("applyscope", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")})).map(it -> it.getString("id")).reduce((acc, item) -> acc + "#" + item).orElse("0");
                Map controlMap = (Map)this.getView().getFormShowParameter().getCustomParam("controlMap");
                Map dimMap = (Map)controlMap.get(key);
                String entityNumber = (String)dimMap.get("entityNumber");
                if (!HRStringUtils.equals((String)"0", (String)dynamicConditionIds) && dimMap.containsKey("dimShowType")) {
                    long dimId = Long.parseLong((String)dimMap.get("dimId"));
                    String dimensionName = dimensionServiceHelper.queryOne((Object)dimId).getString("name");
                    this.showDimValueSelector(dimensionName, key, entityNumber, dynamicConditionIds);
                } else {
                    DynamicControlHelper.doCustomVectorAction((String)key, (IFormView)this.getView(), (IFormPlugin)this);
                }
            } else if (key.startsWith("customteamblock")) {
                Map controlMap = (Map)this.getView().getFormShowParameter().getCustomParam("controlMap");
                Map dimMap = (Map)controlMap.get(key);
                long structProject = Long.parseLong(key.split("#")[4]);
                DynamicObject otClassify = new HRBaseServiceHelper("haos_structproject").queryOne("otclassify", new QFilter[]{new QFilter("id", "=", (Object)structProject)});
                String dynamicConditionIds = Arrays.stream(new HRBaseServiceHelper("hrcs_dynacond").query("id", new QFilter[]{new QFilter("applyteamcls.fbasedataid", "=", (Object)otClassify.getLong("otclassify.id")).or(new QFilter("applyscope", "=", (Object)"1")), new QFilter("enable", "=", (Object)"1")})).map(it -> it.getString("id")).reduce((acc, item) -> acc + "#" + item).orElse("0");
                if (!HRStringUtils.equals((String)"0", (String)dynamicConditionIds)) {
                    long dimId = Long.parseLong((String)dimMap.get("dimId"));
                    String dimensionName = dimensionServiceHelper.queryOne((Object)dimId).getString("name");
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
                    DynamicObject struct = serviceHelper.queryOne("name", (Object)structProject);
                    String structName = struct.getString("name");
                    this.showDimValueSelector(dimensionName + "_" + structName, key, "", dynamicConditionIds);
                } else {
                    DynamicControlHelper.doCustomTeamBlockAction((String)key, (IFormView)this.getView(), (IFormPlugin)this);
                }
            } else if (key.startsWith("dynabasedatavector")) {
                Map controlMap = (Map)this.getView().getFormShowParameter().getCustomParam("controlMap");
                Map dimMap = (Map)controlMap.get(key);
                String entityNumber = (String)dimMap.get("entityNumber");
                String dynamicConditionIds = Arrays.stream(new HRBaseServiceHelper("hrcs_dynacond").query("id", new QFilter[]{new QFilter("applybdtype.fbasedataid", "=", (Object)entityNumber).or(new QFilter("applyscope", "=", (Object)"1")), new QFilter("enable", "=", (Object)"1")})).map(it -> it.getString("id")).reduce((acc, item) -> acc + "#" + item).orElse("0");
                long dimId = Long.parseLong((String)dimMap.get("dimId"));
                String dimensionName = dimensionServiceHelper.queryOne((Object)dimId).getString("name");
                this.showDimValueSelector(dimensionName, key, entityNumber, dynamicConditionIds);
            } else if (key.startsWith("dynacheckboxvector")) {
                Map controlMap = (Map)this.getView().getFormShowParameter().getCustomParam("controlMap");
                Map dimMap = (Map)controlMap.get(key);
                String dynamicConditionIds = Arrays.stream(new HRBaseServiceHelper("hrcs_dynacond").query("id", new QFilter[]{new QFilter("applyscope", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")})).map(it -> it.getString("id")).reduce((acc, item) -> acc + "#" + item).orElse("0");
                long dimId = Long.parseLong((String)dimMap.get("dimId"));
                String dimensionName = dimensionServiceHelper.queryOne((Object)dimId).getString("name");
                this.showDimValueSelector(dimensionName, key, "", dynamicConditionIds);
            } else if (key.startsWith("customview")) {
                this.showOrgTeamPreviewForm(key);
            } else if (key.startsWith("orgcustomview")) {
                this.showBizOrgPreviewForm(key);
            } else if (key.startsWith("funcdimcustomview")) {
                this.showFunctionDimensionPreviewForm(key);
            } else if (key.startsWith("basedatadimcustomview")) {
                this.showBaseDataDimensionPreviewForm(key);
            }
        }
    }

    private void showDimValueSelector(String caption, String originalKey, String entityNumber, String dynamicConditionIds) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrcs_dimvalueselector");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(caption);
        parameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        parameter.setCustomParam("originalKey", (Object)originalKey);
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("dynamicConditionIds", (Object)dynamicConditionIds);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hrcs_permotlazytreef7"));
        this.getView().showForm(parameter);
    }

    @ExcludeFromJacocoGeneratedReport
    private String getDimType(long dimId) {
        String result = "0";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject item = serviceHelper.queryOne("datasource,entitytype", new QFilter[]{new QFilter("id", "=", (Object)dimId)});
        if (Objects.nonNull(item)) {
            String dataSource = item.getString("datasource");
            if (HRStringUtils.equals((String)"hrbu", (String)dataSource)) {
                result = "1";
            } else if (HRStringUtils.equals((String)"basedata", (String)dataSource)) {
                String entityNumber = item.getString("entitytype.number");
                if (HRStringUtils.equals((String)"hbss_empgroup", (String)entityNumber)) {
                    result = "2";
                } else {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    String mainEntityInheritPath = mainEntityType.getInheritPath();
                    HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entitymeta");
                    QFilter entityQFilter = new QFilter("id", "in", Arrays.stream(mainEntityInheritPath.split(",")).collect(Collectors.toList()));
                    DynamicObject[] dys = helper.queryOriginalArray("number", new QFilter[]{entityQFilter});
                    Set entityNumbers = Arrays.stream(dys).map(dy -> dy.getString("number")).collect(Collectors.toSet());
                    String property = mainEntityType.getMainOrg();
                    LOGGER.info("Got main org:{}.", (Object)property);
                    if (HRStringUtils.isEmpty((String)property) && HRStringUtils.equals((String)"DIM_ORG", (String)mainEntityType.getPermissionControlType().getDimension())) {
                        property = mainEntityType.getPermissionControlType().getDataDimensionField();
                    }
                    if (entityNumbers.contains("bos_baseorgtpl")) {
                        result = "3";
                    } else if (mainEntityType.getPermissionControlType().isControlFunction() && HRStringUtils.isNotEmpty((String)property)) {
                        result = "4";
                    }
                }
            }
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    private void showBaseDataDimensionPreviewForm(String key) {
        String[] split;
        IFormView mainPageView = this.getView().getView((String)this.getView().getFormShowParameter().getCustomParam("mainPageId"));
        String HRbuFunc = DimensionHelper.getHrbuFunc((IPageCache)mainPageView.getPageCache());
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(mainPageView, false);
        RoleDataPermModel permModel = (RoleDataPermModel)permPageCacheUtil.getDataPermMap().get(HRbuFunc);
        String dimId = key.split("#")[3];
        DynamicObject dimension = new HRBaseServiceHelper("hrcs_dimension").queryOne("number,name,entitytype", (Object)Long.parseLong(dimId));
        String dimensionName = dimension.getString("name");
        String previewLabelName = ResManager.loadKDString((String)"\u9884\u89c8", (String)"CustomCtrlPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String caption = dimensionName + previewLabelName;
        String tips = dimensionName;
        String ot = "1010";
        String entityNumber = dimension.getString("entitytype.number");
        Map dimGroupMap = permModel.getDimGroupMap();
        DimGrpModel dimGrpModel = (DimGrpModel)dimGroupMap.get((split = key.split("#"))[2]);
        if (Objects.isNull(dimGrpModel)) {
            return;
        }
        String dimNumber = dimension.getString("number");
        TreeMap dimMap = dimGrpModel.getDimMap();
        DimModel dimModel = (DimModel)dimMap.get(dimNumber);
        if (Objects.isNull(dimModel)) {
            return;
        }
        Set nodeIds = dimModel.getDimValues().values().stream().map(it -> Long.parseLong((String)it.get("id"))).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        Set hasChildrenOrg = Arrays.stream(serviceHelper.query("parent.id", new QFilter[]{new QFilter("parent", "in", nodeIds)})).map(it -> it.getString("parent.id")).collect(Collectors.toSet());
        List list = dimModel.getDimValues().values().stream().map(it -> {
            HashMap<String, String> node = new HashMap<String, String>();
            node.put("nodeId", (String)it.get("id"));
            node.put("nodeName", (String)it.get("name"));
            node.put("nodeType", "1010");
            node.put("nodeIcon", "kdfont kdfont-shitizuzhi");
            node.put("otSub", (Boolean)it.get("includeSub") != false ? "1" : "0");
            node.put("crossOtSub", "0");
            node.put("hasChildren", hasChildrenOrg.contains(node.get("nodeId")) ? "1" : "0");
            return node;
        }).collect(Collectors.toList());
        HashMap<String, Object> otherParam = new HashMap<String, Object>();
        otherParam.put("entityNumber", entityNumber);
        otherParam.put("currentHRbuCaFunc", this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc"));
        otherParam.put("tips", tips);
        otherParam.put("isAll", "1");
        this.showPreviewForm(SerializationUtils.toJsonString(list), ot, ot, caption, "common", otherParam);
    }

    @ExcludeFromJacocoGeneratedReport
    private void showFunctionDimensionPreviewForm(String key) {
        String[] split;
        IFormView mainPageView = this.getView().getView((String)this.getView().getFormShowParameter().getCustomParam("mainPageId"));
        String HRbuFunc = DimensionHelper.getHrbuFunc((IPageCache)mainPageView.getPageCache());
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(mainPageView, false);
        RoleDataPermModel permModel = (RoleDataPermModel)permPageCacheUtil.getDataPermMap().get(HRbuFunc);
        String dimId = key.split("#")[3];
        DynamicObject dimension = new HRBaseServiceHelper("hrcs_dimension").queryOne("number,name,entitytype,hrbu", (Object)Long.parseLong(dimId));
        String dimensionName = dimension.getString("name");
        String previewLabelName = ResManager.loadKDString((String)"\u9884\u89c8", (String)"CustomCtrlPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String caption = dimensionName + previewLabelName;
        String tips = dimensionName;
        String ot = "1010";
        String formHrBuFuncParam = dimension.getString("hrbu.number");
        Map dimGroupMap = permModel.getDimGroupMap();
        DimGrpModel dimGrpModel = (DimGrpModel)dimGroupMap.get((split = key.split("#"))[2]);
        if (Objects.isNull(dimGrpModel)) {
            return;
        }
        String dimNumber = dimension.getString("number");
        TreeMap dimMap = dimGrpModel.getDimMap();
        DimModel dimModel = (DimModel)dimMap.get(dimNumber);
        if (Objects.isNull(dimModel)) {
            return;
        }
        Set nodeIds = dimModel.getDimValues().values().stream().map(it -> Long.parseLong((String)it.get("id"))).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        Set hasChildrenOrg = Arrays.stream(serviceHelper.query("parent.id", new QFilter[]{new QFilter("parent", "in", nodeIds)})).map(it -> it.getString("parent.id")).collect(Collectors.toSet());
        List list = dimModel.getDimValues().values().stream().map(it -> {
            HashMap<String, String> node = new HashMap<String, String>();
            node.put("nodeId", (String)it.get("id"));
            node.put("nodeName", (String)it.get("name"));
            node.put("nodeType", "1010");
            node.put("nodeIcon", "kdfont kdfont-shitizuzhi");
            node.put("otSub", (Boolean)it.get("includeSub") != false ? "1" : "0");
            node.put("crossOtSub", "0");
            node.put("hasChildren", hasChildrenOrg.contains(node.get("nodeId")) ? "1" : "0");
            return node;
        }).collect(Collectors.toList());
        HashMap<String, Object> otherParam = new HashMap<String, Object>();
        otherParam.put("entityNumber", "bos_org");
        otherParam.put("currentHRbuCaFunc", formHrBuFuncParam);
        otherParam.put("tips", tips);
        otherParam.put("isAll", "1");
        this.showPreviewForm(SerializationUtils.toJsonString(list), ot, ot, caption, "funcDim", otherParam);
    }

    @ExcludeFromJacocoGeneratedReport
    private void showBizOrgPreviewForm(String key) {
        IFormView mainPageView = this.getView().getView((String)this.getView().getFormShowParameter().getCustomParam("mainPageId"));
        String HRbuFunc = DimensionHelper.getHrbuFunc((IPageCache)mainPageView.getPageCache());
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(mainPageView, false);
        RoleDataPermModel permModel = (RoleDataPermModel)permPageCacheUtil.getDataPermMap().get(HRbuFunc);
        Map assignedHrBuCaMap = permPageCacheUtil.getAssignedHrBuCaMap();
        String caption = (String)((Map)assignedHrBuCaMap.get(HRbuFunc)).get("name");
        String tips = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"HRDataPermCtrlContainerPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        String ot = "1010";
        Set nodeIds = permModel.getOrgMap().values().stream().map(it -> Long.parseLong((String)it.get("id"))).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        Set hasChildrenOrg = Arrays.stream(serviceHelper.query("parent.id", new QFilter[]{new QFilter("parent", "in", nodeIds)})).map(it -> it.getString("parent.id")).collect(Collectors.toSet());
        List list = permModel.getOrgMap().values().stream().map(it -> {
            HashMap<String, String> node = new HashMap<String, String>();
            node.put("nodeId", (String)it.get("id"));
            node.put("nodeName", (String)it.get("name"));
            node.put("nodeType", "1010");
            node.put("nodeIcon", "kdfont kdfont-shitizuzhi");
            node.put("otSub", (Boolean)it.get("includeSub") != false ? "1" : "0");
            node.put("crossOtSub", "0");
            node.put("hasChildren", hasChildrenOrg.contains(node.get("nodeId")) ? "1" : "0");
            return node;
        }).collect(Collectors.toList());
        HashMap<String, Object> otherParam = new HashMap<String, Object>();
        otherParam.put("entityNumber", "bos_org");
        otherParam.put("currentHRbuCaFunc", this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc"));
        otherParam.put("tips", tips);
        otherParam.put("isAll", "1");
        this.showPreviewForm(SerializationUtils.toJsonString(list), ot, ot, caption, "bizOrg", otherParam);
    }

    @ExcludeFromJacocoGeneratedReport
    private void showOrgTeamPreviewForm(String key) {
        String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
        String HRbuFunc = (String)this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        IFormView formView = this.getView().getView(mainPageId);
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView, false);
        RoleDataPermModel model = (RoleDataPermModel)permPageCacheUtil.getDataPermMap().get(HRbuFunc);
        Map dimGroupMap = model.getDimGroupMap();
        String controlId = key;
        String[] split = controlId.split("#");
        String dimId = split[3];
        String ot = split[4];
        DimGrpModel dimGrpModel = (DimGrpModel)dimGroupMap.get(split[2]);
        if (Objects.isNull(dimGrpModel)) {
            return;
        }
        TreeMap dimMap = dimGrpModel.getDimMap();
        Optional<Collection> optionalDimValues = dimMap.values().stream().filter(it -> it.getDimId().equals(dimId)).map(it -> it.getDimValues()).findFirst().filter(it -> it.keySet().stream().anyMatch(itKey -> itKey.endsWith(ot))).map(it -> it.values());
        LOGGER.info("Got dimMap: {}.", (Object)dimMap);
        if (optionalDimValues.isPresent()) {
            LOGGER.info("Got dimValues: {}.", (Object)optionalDimValues.get());
            Long structProjectId = Long.parseLong(key.substring(key.lastIndexOf("#") + 1));
            DynamicObject structProject = new HRBaseServiceHelper("haos_structproject").queryOne((Object)structProjectId);
            String structProjectName = structProject.getString("name");
            String isCustomProjectStruct = "0";
            long teamTypeId = structProject.getLong("otclassify.teamtype.id");
            HRBaseServiceHelper teamTypeServiceHelper = new HRBaseServiceHelper("hbss_teamtype");
            DynamicObject teamType = teamTypeServiceHelper.queryOne("iscustom", new QFilter[]{new QFilter("id", "=", (Object)teamTypeId)});
            if (null != teamType && HRStringUtils.isNotEmpty((String)teamType.getString("iscustom"))) {
                isCustomProjectStruct = teamType.getString("iscustom");
            } else {
                LOGGER.info("Can not get iscustom property with team type id: {}.", (Object)teamTypeId);
            }
            DynamicObject dimension = new HRBaseServiceHelper("hrcs_dimension").queryOne((Object)dimId);
            String dimensionName = dimension.getString("name");
            String previewLabelName = ResManager.loadKDString((String)"\u9884\u89c8", (String)"CustomCtrlPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            String caption = dimensionName + "_" + structProjectName + previewLabelName;
            List newDimValues = optionalDimValues.get().stream().filter(it -> {
                Object tempStructProject = it.get("structProject");
                if (null == tempStructProject) {
                    return false;
                }
                if (tempStructProject instanceof String) {
                    return HRStringUtils.equals((String)((String)it.get("structProject")), (String)ot);
                }
                return HRStringUtils.equals((String)String.valueOf(((Map)tempStructProject).get("id")), (String)ot);
            }).collect(Collectors.toList());
            Set<Long> nodeIds = newDimValues.stream().map(it -> Long.parseLong(String.valueOf(it.get("id")))).collect(Collectors.toSet());
            ArrayList<Long> allStructProjectId = new ArrayList<Long>();
            allStructProjectId.add(Long.parseLong(ot));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
            DynamicObject relyOnStructProject = serviceHelper.queryOne("relyonstructproject.id", (Object)Long.parseLong(ot));
            if (null != relyOnStructProject && 0L != relyOnStructProject.getLong("relyonstructproject.id")) {
                allStructProjectId.add(relyOnStructProject.getLong("relyonstructproject.id"));
            }
            serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
            Set hasChildrenOrg = Arrays.stream(serviceHelper.query("parentorgteam.id", new QFilter[]{new QFilter("parentorgteam", "in", nodeIds), new QFilter("structproject", "in", allStructProjectId)})).map(it -> it.getString("parentorgteam.id")).collect(Collectors.toSet());
            HashMap relyOnMap = new HashMap();
            nodeIds.forEach(nodeId -> relyOnMap.put(nodeId, "kdfont kdfont-shitizuzhi"));
            AtomicReference<String> relyOnStructProjectId = new AtomicReference<String>();
            if (null != relyOnStructProject) {
                relyOnStructProjectId.set(relyOnStructProject.getString("relyonstructproject.id"));
                Arrays.stream(serviceHelper.queryOriginalArray("orgteam.id", new QFilter[]{new QFilter("orgteam.id", "in", nodeIds), new QFilter("structproject", "=", (Object)Long.parseLong(ot))})).forEach(orgTeam -> relyOnMap.put(orgTeam.getLong("orgteam.id"), "kdfont kdfont-xiangmuxingtuandui"));
            }
            String showCompanyName = "0";
            HRBaseServiceHelper structProjectServiceHelper = new HRBaseServiceHelper("haos_structure");
            DynamicObject item = structProjectServiceHelper.queryOne("id", new QFilter[]{new QFilter("id", "=", (Object)structProjectId), new QFilter("id", "!=", (Object)1010L), new QFilter("otclassify", "=", (Object)1010L)});
            if (null != item) {
                showCompanyName = "1";
            }
            List list = newDimValues.stream().map(it -> {
                Object currentOtStructProject = it.get("currentstructproject");
                String nodeType = currentOtStructProject instanceof String ? (String)currentOtStructProject : String.valueOf(((Map)it.get("currentstructproject")).get("id"));
                HashMap<String, String> node = new HashMap<String, String>();
                node.put("nodeId", String.valueOf(it.get("id")));
                node.put("nodeName", String.valueOf(it.get("name")));
                node.put("nodeType", nodeType);
                node.put("nodeIcon", (String)relyOnMap.get(it.get("id")));
                node.put("otSub", (Boolean)it.get("includeSub") != false ? "1" : "0");
                node.put("crossOtSub", (Boolean)it.get("includeSubAdminOrg") != false ? "1" : "0");
                node.put("hasChildren", hasChildrenOrg.contains(node.get("nodeId")) ? "1" : "0");
                node.put("currentstructproject", ot);
                node.put("currentstructprojectrelyon", (String)relyOnStructProjectId.get());
                return node;
            }).collect(Collectors.toList());
            HashMap<String, Object> otherParam = new HashMap<String, Object>();
            otherParam.put("isAll", "1");
            otherParam.put("fromStructProject", ot);
            otherParam.put("showCompanyName", showCompanyName);
            otherParam.put("customStructProject", isCustomProjectStruct);
            this.showPreviewForm(SerializationUtils.toJsonString(list), ot, ot, caption, "orgTeam", otherParam);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void showPreviewForm(String nodes, String nodeType, String ot, String caption, String identify, Map<String, Object> otherParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrcs_ottreepreview");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("nodes", (Object)nodes);
        parameter.setCustomParam("type", (Object)nodeType);
        parameter.setCustomParam("from", (Object)ot);
        parameter.setCustomParam("identify", (Object)identify);
        parameter.getCustomParams().putAll(otherParams);
        parameter.setCaption(caption);
        this.getView().showForm(parameter);
    }

    @ExcludeFromJacocoGeneratedReport
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
        IFormView formView = this.getView().getView(mainPageId);
        if (HRStringUtils.equals((String)"hrcs_permcommontreef7", (String)actionId) && null != evt.getReturnData()) {
            formView.showLoading(null, 10000);
            Map returnData = (Map)evt.getReturnData();
            LOGGER.info("Got returnData {}.", (Object)returnData);
            if (Objects.isNull(returnData)) {
                return;
            }
            DynamicObjectCollection collection = (DynamicObjectCollection)returnData.get("collection");
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)collection.size());
            String dimId = (String)returnData.get("dimId");
            String controlKey = (String)returnData.get("htmlControlKey");
            this.writeHtmlControl4CloseCallback(controlKey, collection, dataMap);
            LOGGER.info("Prepare data to parent {}.", (Object)dataMap);
            this.setDataToParent(dimId, dataMap);
            formView.hideLoading();
        } else if (HRStringUtils.equals((String)"hrcs_permotlazytreef7", (String)actionId)) {
            Map returnData = (Map)evt.getReturnData();
            LOGGER.info("Got returnData: {}.", evt.getReturnData());
            if (null != returnData) {
                DynamicObjectCollection collection = (DynamicObjectCollection)returnData.get("collection");
                HashMap dataMap = Maps.newHashMapWithExpectedSize((int)collection.size());
                String dimId = (String)returnData.get("dimId");
                String controlKey = (String)returnData.get("htmlControlKey");
                this.writeHtmlControl4CloseCallback(controlKey, collection, dataMap);
                this.setDataToParent(dimId, dataMap, (dimModel, dimValues) -> {
                    if (controlKey.startsWith("customhtmlteamblock")) {
                        String otClassify = controlKey.substring(controlKey.lastIndexOf("#") + 1);
                        Map oldDimValues = dimModel.getDimValues();
                        oldDimValues.entrySet().removeIf(entry -> ((String)entry.getKey()).endsWith(otClassify));
                        dimValues.putAll(oldDimValues);
                    }
                });
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void writeHtmlControl4CloseCallback(String htmlControlKey, DynamicObjectCollection collection, Map<String, Map<String, Object>> dataMap) {
        String includeChildrenText = ResManager.loadKDString((String)"\uff08\u5305\u542b\u4e0b\u7ea7\uff09", (String)"DimValueSelectorPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        StringBuilder title = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"item\">");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynacond");
        if (null != collection && !collection.isEmpty()) {
            for (DynamicObject dynamicObject : collection) {
                DynamicObject dynamicCondition;
                String valueType = "1";
                String dynamicConditionId = "1";
                if (dynamicObject.containsProperty("valtype")) {
                    valueType = Optional.ofNullable((String)dynamicObject.get("valtype")).orElse("1");
                    dynamicConditionId = dynamicObject.getString("dynacond");
                }
                if (HRStringUtils.isEmpty((String)valueType)) {
                    valueType = "1";
                }
                String orgName = dynamicObject.getString("name");
                String orgId = HRStringUtils.equals((String)"2", (String)valueType) ? dynamicConditionId : dynamicObject.getString("id");
                HashMap tempMap = Maps.newHashMapWithExpectedSize((int)2);
                tempMap.put("valueType", valueType);
                tempMap.put("dynamicCondition", dynamicConditionId);
                if (dynamicObject.getBoolean("includeSub")) {
                    tempMap.put("includeSub", Boolean.TRUE);
                } else {
                    tempMap.put("includeSub", Boolean.FALSE);
                }
                if (dynamicObject.getDynamicObjectType().getProperties().stream().anyMatch(property -> "admincontainssub".equalsIgnoreCase(property.getName()))) {
                    tempMap.put("includeSubAdminOrg", dynamicObject.getBoolean("admincontainssub"));
                }
                if (htmlControlKey.startsWith("customhtmlteamblock")) {
                    tempMap.put("otClassify", htmlControlKey.split("#")[4]);
                    tempMap.put("currentotclassify", String.valueOf(dynamicObject.getLong("currentotclassifyid")));
                    tempMap.put("structProject", htmlControlKey.split("#")[4]);
                    tempMap.put("currentstructproject", String.valueOf(dynamicObject.getLong("currentstructprojectid")));
                }
                tempMap.put("id", orgId);
                tempMap.put("name", orgName);
                Object struct = tempMap.get("structProject");
                if (Objects.nonNull(struct)) {
                    dataMap.put(orgId + "#" + struct, tempMap);
                } else {
                    dataMap.put(orgId, tempMap);
                }
                boolean isDynaCondition = false;
                if (HRStringUtils.equals((String)"2", (String)valueType) && HRStringUtils.isNotEmpty((String)dynamicConditionId) && null != (dynamicCondition = serviceHelper.queryOne((Object)dynamicConditionId))) {
                    orgName = orgName + dynamicCondition.getString("name");
                    isDynaCondition = true;
                }
                boolean containIncludeSubKey = dynamicObject.containsProperty("includesub");
                boolean containAdminContainsSubKey = dynamicObject.containsProperty("admincontainssub");
                boolean include = containIncludeSubKey && dynamicObject.getBoolean("includesub") || containAdminContainsSubKey && dynamicObject.getBoolean("admincontainssub");
                sb.append("<div class=\"itemtext\">").append(orgName).append(include && !isDynaCondition ? includeChildrenText : "").append("</div>").append('\uff1b');
                title.append(orgName).append(include && !isDynaCondition ? includeChildrenText : "").append('\uff1b');
            }
        }
        sb.append("</div>");
        String htmlContent = String.format("<div class=\"hrcs_datapermcontainer\" title=\"%s\">%s</div>", title, sb);
        Html html = (Html)this.getControl(htmlControlKey);
        html.setConent(htmlContent);
    }

    protected void writeHtmlControl(String htmlControlKey, String vectorKey, String viewKey, Map<String, Map<String, Object>> dataMap, Boolean isEnable) {
        String includeChildrenText = ResManager.loadKDString((String)"\uff08\u5305\u542b\u4e0b\u7ea7\uff09", (String)"DimValueSelectorPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        StringBuilder title = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"item\">");
        boolean nullValue = true;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynacond");
        List items = dataMap.entrySet().stream().sorted((it1, it2) -> {
            Map it1Map = (Map)it1.getValue();
            Map it2Map = (Map)it2.getValue();
            String value1 = it1Map.getOrDefault("valueType", "1");
            String value2 = it2Map.getOrDefault("valueType", "1");
            return value2.compareTo(value1);
        }).collect(Collectors.toList());
        for (Map.Entry dataEntry : items) {
            String dynaConditionId;
            String key = (String)dataEntry.getKey();
            if (HRStringUtils.isEmpty((String)key)) continue;
            nullValue = false;
            Map orgInfo = (Map)dataEntry.getValue();
            String orgName = (String)orgInfo.get("name");
            boolean isDynaCondition = false;
            if (HRStringUtils.equals((String)"2", (String)((Map)dataEntry.getValue()).getOrDefault("valueType", "1")) && HRStringUtils.isNotEmpty((String)(dynaConditionId = (String)((Map)dataEntry.getValue()).get("dynamicCondition")))) {
                orgName = Optional.ofNullable(serviceHelper.queryOne((Object)dynaConditionId)).map(it -> it.getString("name")).orElse("-");
                isDynaCondition = true;
            }
            boolean include = orgInfo.getOrDefault("includeSub", false) != false || orgInfo.getOrDefault("includeSubAdminOrg", false) != false;
            sb.append("<div class=\"itemtext\">").append(orgName).append(include && !isDynaCondition ? includeChildrenText : "").append("</div>");
            title.append(orgName).append(include && !isDynaCondition ? includeChildrenText : "");
            sb.append('\uff1b');
            title.append('\uff1b');
        }
        sb.append("</div>");
        String htmlFrame = isEnable != false ? "<div class=\"hrcs_datapermcontainer\" title=\"%s\">%s</div>" : "<div class=\"hrcs_datapermcontainer readonly\" title=\"%s\">%s</div>";
        this.getView().setVisible(isEnable, new String[]{vectorKey});
        if (HRStringUtils.isNotEmpty((String)viewKey)) {
            if (nullValue) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{viewKey});
            } else {
                this.getView().setVisible(Boolean.valueOf(isEnable == false), new String[]{viewKey});
            }
        }
        String htmlContent = String.format(htmlFrame, title, sb);
        Html html = (Html)this.getControl(htmlControlKey);
        html.setConent(htmlContent);
    }

    @ExcludeFromJacocoGeneratedReport
    protected void setDataToParent(String dimId, Map<String, Map<String, Object>> dimensionValue) {
        this.setDataToParent(dimId, dimensionValue, null);
    }

    @ExcludeFromJacocoGeneratedReport
    private void setDataToParent(String dimId, Map<String, Map<String, Object>> dimensionValue, BiConsumer<DimModel, Map<String, Map<String, Object>>> consumer) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String dimensionGroup = (String)formShowParameter.getCustomParam("dimensionGroup");
        String currentHRbuFunc = (String)formShowParameter.getCustomParam("currentHRbuCaFunc");
        String mainPageId = (String)formShowParameter.getCustomParam("mainPageId");
        IFormView mainPage = this.getView().getView(mainPageId);
        DimensionHelper.cacheDim((IFormView)mainPage, (String)currentHRbuFunc, (String)dimensionGroup, (String)dimId, dimensionValue, null, consumer);
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        String currentHRbuCaFunc = (String)this.getView().getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        if (fieldKey.startsWith("dynbasedata") && evt.getSource() instanceof MulBasedataEdit) {
            boolean adminScopeSwitch = PermCheckUtil.getSysParamLimitAssignDimRange();
            ((ListShowParameter)evt.getFormShowParameter()).setShowUsed(false);
            String entityNumber = ((MulBasedataProp)((MulBasedataEdit)evt.getSource()).getProperty()).getBaseEntityId();
            if ("bos_org".equalsIgnoreCase(entityNumber)) {
                Long dimensionId = Long.parseLong(fieldKey.substring(fieldKey.lastIndexOf("#") + 1));
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_dimension");
                Optional.ofNullable(helper.queryOne("hrbu.id", (Object)dimensionId)).ifPresent(item -> evt.getFormShowParameter().setCustomParam("orgFuncId", (Object)item.getString("hrbu.id")));
            } else if ("haos_adminorghr".equals(entityNumber)) {
                long structProjectId = 1010L;
                ArrayList structProjects = Lists.newArrayList((Object[])new Long[]{structProjectId});
                evt.getFormShowParameter().setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString((Object)structProjects));
                long level = HRPermServiceHelper.getUserGroupMinLevel();
                if (level < 0L || level > 2L) {
                    HashSet nodeIds = new HashSet(HRPermServiceHelper.getAdminGroupOrgTeams((List)structProjects));
                    HRBaseServiceHelper adminOrgStructServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
                    QFilter structLongNumberFilter = Arrays.stream(adminOrgStructServiceHelper.query("structlongnumber", new QFilter[]{new QFilter("adminorg.id", "in", nodeIds), new QFilter("structproject.id", "=", (Object)structProjectId), new QFilter("status", "=", (Object)"C"), new QFilter("datastatus", "=", (Object)"1"), new QFilter("initstatus", "=", (Object)"2"), new QFilter("iscurrentversion", "=", (Object)"1")})).map(it -> new QFilter("structlongnumber", "like", (Object)(it.getString("structlongnumber") + "%"))).reduce((acc, item) -> acc.or(item)).orElseGet(() -> QFilter.of((String)"1!=1", (Object[])new Object[0]));
                    Set newNodeIds = Arrays.stream(adminOrgStructServiceHelper.query("adminorg.id", new QFilter[]{structLongNumberFilter, new QFilter("structproject.id", "=", (Object)structProjectId), new QFilter("status", "=", (Object)"C"), new QFilter("datastatus", "=", (Object)"1"), new QFilter("initstatus", "=", (Object)"2"), new QFilter("iscurrentversion", "=", (Object)"1")})).map(it -> it.getLong("adminorg.id")).collect(Collectors.toSet());
                    evt.getCustomQFilters().add(new QFilter("id", "in", newNodeIds));
                    LOGGER.info("Got haos_adminorghr filter params with nodeIds:[{}], newNodeIds:[{}].", nodeIds, newNodeIds);
                }
            } else if ("hbss_empgroup".equalsIgnoreCase(entityNumber)) {
                ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
                QFilter filter = new QFilter("bussinessfield.controlfuntype", "in", (Object)Long.valueOf(currentHRbuCaFunc));
                lsp.getListFilterParameter().getQFilters().add(filter);
            } else {
                long level = HRPermServiceHelper.getUserGroupMinLevel();
                boolean auth = -1L == level || level > 2L;
                List adminGroupFunList = new ArrayList(10);
                if (auth) {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    LOGGER.info("Got permission control type control function: {}, dimension: {}, data dimension: {}.", new Object[]{mainEntityType.getPermissionControlType().isControlFunction(), mainEntityType.getPermissionControlType().getDimension(), mainEntityType.getPermissionControlType().getDataDimension()});
                    String mainEntityInheritPath = mainEntityType.getInheritPath();
                    LOGGER.info("Got inherit path: {} with entity: {}.", (Object)mainEntityInheritPath, (Object)entityNumber);
                    HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entitymeta");
                    QFilter entityQFilter = new QFilter("id", "in", Arrays.stream(mainEntityInheritPath.split(",")).collect(Collectors.toList()));
                    DynamicObject[] dys = helper.queryOriginalArray("number", new QFilter[]{entityQFilter});
                    Set entityNumbers = Arrays.stream(dys).map(dy -> dy.getString("number")).collect(Collectors.toSet());
                    LOGGER.info("Got parent entity numbers: {} with entity: {}.", entityNumbers, (Object)entityNumber);
                    if (entityNumbers.contains("bos_baseorgtpl")) {
                        LOGGER.info("Enter control base data.");
                        if (adminScopeSwitch) {
                            String property = mainEntityType.getMainOrg();
                            if (HRStringUtils.isNotEmpty((String)property)) {
                                long buFunc = Long.parseLong(Optional.ofNullable(((OrgProp)mainEntityType.getProperty(property)).getOrgFunc()).orElse("0"));
                                if (0L != buFunc) {
                                    adminGroupFunList = HRPermServiceHelper.getAdminGroupFunc((long)buFunc);
                                    QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, adminGroupFunList, (boolean)true);
                                    if (null == qFilter) {
                                        LOGGER.info("Base data filter is null.");
                                        evt.getCustomQFilters().add(QFilter.of((String)" 1 != 1", (Object[])new Object[0]));
                                    } else {
                                        LOGGER.info("Base data filter is not null.");
                                        evt.getCustomQFilters().add(qFilter);
                                    }
                                } else {
                                    LOGGER.info("Main org's[{}] org func is null.", (Object)property);
                                    evt.getCustomQFilters().add(QFilter.of((String)" 1 != 1", (Object[])new Object[0]));
                                }
                            } else {
                                LOGGER.info("Main org is null with entity:{}.", (Object)entityNumber);
                                evt.getCustomQFilters().add(QFilter.of((String)" 1 != 1", (Object[])new Object[0]));
                            }
                        } else {
                            LOGGER.info("Skip base data permission control with adminScopeSwitch false.");
                        }
                    } else if (mainEntityType.getPermissionControlType().isControlFunction()) {
                        if (adminScopeSwitch) {
                            String property = mainEntityType.getMainOrg();
                            LOGGER.info("Got main org:{}.", (Object)property);
                            if (HRStringUtils.isEmpty((String)property) && HRStringUtils.equals((String)"DIM_ORG", (String)mainEntityType.getPermissionControlType().getDimension())) {
                                property = mainEntityType.getPermissionControlType().getDataDimensionField();
                            }
                            if (HRStringUtils.isNotEmpty((String)property)) {
                                long buFunc = Long.parseLong(Optional.ofNullable(((OrgProp)mainEntityType.getProperty(property)).getOrgFunc()).orElse("0"));
                                adminGroupFunList = HRPermServiceHelper.getAdminGroupFunc((long)buFunc);
                                if (null == adminGroupFunList || adminGroupFunList.isEmpty()) {
                                    LOGGER.info("Got empty adminGroupFunList.");
                                    evt.getCustomQFilters().add(QFilter.of((String)" 1 != 1", (Object[])new Object[0]));
                                } else {
                                    evt.getCustomQFilters().add(new QFilter(property, "in", adminGroupFunList));
                                }
                            }
                        } else {
                            LOGGER.info("Skip bu dim permission control with adminScopeSwitch false.");
                        }
                    } else {
                        LOGGER.info("{} permission control type is not control function.", (Object)entityNumber);
                    }
                }
                LOGGER.info("Got admin group fun list:{}.", adminGroupFunList);
            }
            LOGGER.info("Got custom filters:{}.", (Object)evt.getCustomQFilters());
            String dimId = fieldKey.substring(fieldKey.lastIndexOf("#") + 1);
            HRPluginProxy proxy = new HRPluginProxy((Object)this, IRoleDimF7CustomFilterPlugin.class, "kd.hr.hrcs.formplugin.web.perm.role.component.CustomCtrlPlugin#beforeF7Select", null);
            proxy.callAfter(p -> {
                p.addBDDimCustomFilters(evt, currentHRbuCaFunc, dimId);
                return null;
            });
            LOGGER.info("Got last custom filters:{}.", (Object)evt.getCustomQFilters());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void addBDDimCustomFilters(BeforeF7SelectEvent evt, String currentHRbuCaFunc, String dimId) {
    }

    @ExcludeFromJacocoGeneratedReport
    public Map<String, String> addEnumDimCustomFilters(String currentHRbuFunc, String dimId, Map<String, String> enumMap) {
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public boolean enableNotLimitCheckBox(String currentHRbuFunc, String dimId, boolean originalValue) {
        return originalValue;
    }
}

