/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.privacy.edit;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.TextEdit;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hrcs.common.constants.PrivacyConstants;

public class AnonymousRuleEdit
extends HRBaseDataCommonEdit
implements PrivacyConstants {
    private static final String HRMP_HRCS_FORMPLUGIN = "hrmp-hrcs-formplugin";
    private static final String FIELD_PARAMS = "params";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_CLASS = "handleclass";
    private static final String FIELD_ANONYMOUS_TYPE = "anonymoustype";
    private static HashMap<String, HashMap<String, String>> anonymousRuleMap = Maps.newHashMapWithExpectedSize((int)4);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (null != this.getModel().getValue(FIELD_ANONYMOUS_TYPE)) {
            this.pageChange(this.getModel().getValue(FIELD_ANONYMOUS_TYPE).toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (HRStringUtils.equals((String)FIELD_ANONYMOUS_TYPE, (String)key)) {
            String anonymousType = (String)e.getChangeSet()[0].getNewValue();
            if (HRStringUtils.isEmpty((String)anonymousType)) {
                return;
            }
            HashMap<String, String> ruleConfigMap = anonymousRuleMap.get(anonymousType);
            this.getModel().setValue(FIELD_PARAMS, (Object)ruleConfigMap.get(FIELD_PARAMS));
            this.getModel().setValue(FIELD_DESCRIPTION, (Object)ruleConfigMap.get(FIELD_DESCRIPTION));
            this.getModel().setValue(FIELD_CLASS, (Object)ruleConfigMap.get(FIELD_CLASS));
            this.pageChange(anonymousType);
        }
    }

    private void pageChange(String anonymousType) {
        this.getView().setVisible(Boolean.valueOf(!HRStringUtils.equals((String)"B", (String)anonymousType)), new String[]{FIELD_PARAMS});
        this.getView().setEnable(Boolean.valueOf(HRStringUtils.equals((String)"C", (String)anonymousType)), new String[]{FIELD_CLASS});
        TextEdit params = (TextEdit)this.getControl(FIELD_PARAMS);
        params.setMustInput(HRStringUtils.equals((String)"A", (String)anonymousType));
        LocaleString caption = HRStringUtils.equals((String)"A", (String)anonymousType) ? ResManager.getLocaleString((String)"\u56fa\u5b9a\u503c\u5e38\u91cf", (String)"AnonymousRuleEdit_2", (String)HRMP_HRCS_FORMPLUGIN) : ResManager.getLocaleString((String)"\u89c4\u5219\u53c2\u6570", (String)"AnonymousRuleEdit_3", (String)HRMP_HRCS_FORMPLUGIN);
        params.setCaption(caption);
    }

    static {
        HashMap fixed = Maps.newHashMapWithExpectedSize((int)4);
        fixed.put(FIELD_PARAMS, "");
        fixed.put(FIELD_DESCRIPTION, "");
        fixed.put(FIELD_CLASS, "kd.hr.hbp.formplugin.web.privacy.rule.PrivacyFixedRule");
        anonymousRuleMap.put("A", fixed);
        HashMap clear = Maps.newHashMapWithExpectedSize((int)4);
        clear.put(FIELD_PARAMS, "");
        clear.put(FIELD_DESCRIPTION, ResManager.loadKDString((String)"\u6e05\u7a7a\u5b57\u6bb5\u503c", (String)"AnonymousRuleEdit_1", (String)HRMP_HRCS_FORMPLUGIN, (Object[])new Object[0]));
        clear.put(FIELD_CLASS, "kd.hr.hbp.formplugin.web.privacy.rule.PrivacyClearRule");
        anonymousRuleMap.put("B", clear);
        HashMap custom = Maps.newHashMapWithExpectedSize((int)4);
        custom.put(FIELD_PARAMS, "");
        custom.put(FIELD_DESCRIPTION, "");
        custom.put(FIELD_CLASS, "");
        anonymousRuleMap.put("C", custom);
    }
}

