/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.privacy.edit;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hrcs.common.constants.PrivacyConstants;

public class PrivacySaveConfigEdit
extends HRBaseDataCommonEdit
implements PrivacyConstants,
BeforeF7SelectListener {
    private static final String FIELD_BIZ_APP = "bizappid";
    private static final String FIELD_ENTITY_ID = "entity";
    private static final String FIELD_PRIVACY_KEY = "privacyfield";
    private static final String FIELD_FOREIGN_KEY = "personfield";
    private static final String FIELD_TABLE = "table";
    private static final String FIELD_PRIMARY_KEY = "primarykey";
    private static final String FIELD_KEY_DESCRIPTION = "keydescription";
    private static final String ENTITY_ENTRY_KEY = "entityentry";

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (HRStringUtils.equals((String)FIELD_ENTITY_ID, (String)key)) {
            ChangeData changeData = e.getChangeSet()[0];
            if (null == changeData.getNewValue()) {
                return;
            }
            String entityNumber = ((DynamicObject)changeData.getNewValue()).getString("number");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String table = mainEntityType.getAlias();
            String primaryKey = mainEntityType.getPrimaryKey().getAlias();
            this.getModel().setValue(FIELD_TABLE, (Object)table, changeData.getRowIndex());
            this.getModel().setValue(FIELD_PRIMARY_KEY, (Object)primaryKey, changeData.getRowIndex());
        } else if (HRStringUtils.equals((String)FIELD_BIZ_APP, (String)key)) {
            int row = e.getChangeSet()[0].getRowIndex();
            this.getModel().setValue(FIELD_ENTITY_ID, null, row);
            this.getModel().setValue(FIELD_TABLE, null, row);
            this.getModel().setValue(FIELD_PRIMARY_KEY, null, row);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit privacykey = (TextEdit)this.getControl(FIELD_PRIVACY_KEY);
        privacykey.addClickListener((ClickListener)this);
        TextEdit foreignkey = (TextEdit)this.getControl(FIELD_FOREIGN_KEY);
        foreignkey.addClickListener((ClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(FIELD_ENTITY_ID);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)evt.getSource();
            String field = textEdit.getKey();
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTITY_ENTRY_KEY);
            DynamicObject entityDy = (DynamicObject)this.getModel().getValue(FIELD_ENTITY_ID, currentRow);
            if (null == entityDy) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u6807\u8bc6\u3002", (String)"PrivacySaveConfigEdit_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter fsp = ShowFormHelper.createShowListForm((String)"hrcs_basedatafield", (boolean)false, (int)0, (boolean)true);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.genActionId(field, currentRow)));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("entityNumber", (Object)entityDy.getString("number"));
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCol;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ((actionId.startsWith(FIELD_PRIVACY_KEY) || actionId.startsWith(FIELD_FOREIGN_KEY)) && (selectedCol = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            String[] str = actionId.split("_");
            this.getModel().setValue(str[0], (Object)selectedCol.get(0).getNumber(), Integer.parseInt(str[1]));
            if (FIELD_PRIVACY_KEY.equals(str[0])) {
                this.getModel().setValue(FIELD_KEY_DESCRIPTION, (Object)selectedCol.get(0).getName(), Integer.parseInt(str[1]));
            }
        }
    }

    private String genActionId(String field, int row) {
        return String.format(Locale.ROOT, "%s_%s", field, row);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        int row = beforeF7SelectEvent.getRow();
        DynamicObject bizAppDy = (DynamicObject)this.getModel().getValue(FIELD_BIZ_APP, row);
        if (null == bizAppDy) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4f7f\u7528\u7684\u5e94\u7528\u3002", (String)"PrivacySaveConfigEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        QFilter bizAppQfilter = new QFilter(FIELD_BIZ_APP, "in", (Object)HRAppServiceHelper.getAppIdsAndExcId((String)bizAppDy.getString("id")));
        showParameter.setFormId("bos_listf7");
        showParameter.getListFilterParameter().getQFilters().add(bizAppQfilter);
    }
}

