/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.prompt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.service.prompt.PromptImportService;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;

@ExcludeFromJacocoGeneratedReport
public class PromptBatchImportPlugin
implements HRImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(PromptBatchImportPlugin.class);

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        PromptImportService.addField((List)args.getHeaderWriterFormats());
    }

    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        HashMap ignoreValidateMap = Maps.newHashMapWithExpectedSize((int)10);
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLang = intService.getEnabledLang();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)enabledLang.size());
        for (EnabledLang lang : enabledLang) {
            String key = "promptcontent." + lang.getNumber();
            list.add(key);
        }
        ignoreValidateMap.put("hrcs_prompt", list);
        args.setIgnoreValidateMap((Map)ignoreValidateMap);
    }

    public void afterValidate(AfterValidateEventArgs args) {
        List billData = args.getBillDatas();
        ConcurrentHashMap customParams = args.getCustomParams();
        if (!CollectionUtils.isEmpty((Collection)billData)) {
            Map richTextMap = (Map)customParams.get("richText");
            if (richTextMap == null) {
                richTextMap = Maps.newHashMapWithExpectedSize((int)1000);
            }
            for (ImportBillData billDatum : billData) {
                JSONObject jsonObject = billDatum.getData();
                JSONObject entityData = jsonObject.getJSONObject("hrcs_prompt");
                JSONObject promptContent = entityData.getJSONObject("promptcontent");
                promptContent = promptContent == null ? new JSONObject() : promptContent;
                richTextMap.put(entityData.getString("number"), promptContent);
            }
            customParams.put("richText", richTextMap);
        }
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        Map operateOptions = args.getOperateOptions();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("richText", SerializationUtils.toJsonString(args.getCustomParams().get("richText")));
        operateOptions.put("hrcs_prompt", operateOption);
    }

    public void afterInitContext(AfterInitContextArgs args) {
        args.setSubmitOP("importsave");
    }
}

