/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.prompt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.hr.hrcs.bussiness.servicehelper.prompt.PromptServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class PromptInitPlugin
extends HRBaseDataCommonEdit {
    public void afterLoadData(EventObject e) {
        Optional.ofNullable(this.getModel().getDataEntity().getPkValue()).ifPresent(pkId -> {
            HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_promptrule");
            DynamicObject[] promptRuleDys = ruleHelper.query("id,number,controlname,name,businessobject,controltype,description", new QFilter[]{new QFilter("entryentity.entryprompt", "=", pkId)});
            this.initEntryGrid(promptRuleDys);
        });
        this.setSelectContent();
        this.setCache();
    }

    public void afterCreateNewData(EventObject e) {
        this.setSelectContent();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setLocale();
        this.getModel().setDataChanged(false);
    }

    protected List<String> getUnCheckField() {
        ArrayList uncheckFieldList = Lists.newArrayListWithExpectedSize((int)16);
        uncheckFieldList.add("businessobject");
        uncheckFieldList.add("cloud");
        uncheckFieldList.add("app");
        uncheckFieldList.add("number");
        return uncheckFieldList;
    }

    private void setLocale() {
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        Tab tab = (Tab)this.getView().getControl("tabap");
        ArrayList items = Lists.newArrayListWithExpectedSize((int)enabledLangList.size());
        for (EnabledLang enabledLang : enabledLangList) {
            TabPageAp tabPageAp = new TabPageAp();
            String langId = enabledLang.getId();
            tabPageAp.setKey(langId);
            tabPageAp.setName(new LocaleString(enabledLang.getName()));
            Map tabPageMap = tabPageAp.createControl();
            tabPageMap.put(langId, tabPageAp);
            items.add(tabPageMap);
            if (!Lang.get().name().equals(enabledLang.getNumber())) continue;
            tab.activeTab(langId);
        }
        tab.addControls((List)items);
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getFocusNode();
        }
    }

    private void getFocusNode() {
        String nodeId = "";
        if (!ObjectUtils.isEmpty((Object)this.getView().getParentView())) {
            nodeId = this.getView().getParentView().getPageCache().get("nodeId");
        }
        if (!HRStringUtils.isEmpty((String)nodeId)) {
            String[] split;
            if (!"1010".equals(nodeId)) {
                this.initCategorize(nodeId);
            }
            if ((split = nodeId.split("#")).length == 3) {
                this.getModel().setValue("businessobject", (Object)split[2]);
            }
        }
    }

    private void initEntityCategorize(String param) {
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject entityDy = entityHelper.queryOne("id,name,number,bizappid", new QFilter[]{new QFilter("dentityid", "=", (Object)param)});
        String appId = entityDy.getString("bizappid.id");
        DynamicObject cloudDy = BizCloudServiceHelp.getBizCloudByAppID((String)appId);
        this.getModel().setValue("cloud", (Object)cloudDy.getString("id"));
        this.getModel().setValue("app", (Object)appId);
        this.getModel().setValue("businessobject", (Object)entityDy.getString("id"));
    }

    private void initCategorize(String param) {
        String[] split = param.split("_split_");
        switch (split[0]) {
            case "1": {
                this.getModel().setValue("cloud", (Object)split[1]);
                break;
            }
            case "2": {
                DynamicObject cloudDy = BizCloudServiceHelp.getBizCloudByAppID((String)split[1]);
                this.getModel().setValue("cloud", (Object)cloudDy.getString("id"));
                this.getModel().setValue("app", (Object)split[1]);
                break;
            }
            case "3": {
                this.initEntityCategorize(split[1]);
                break;
            }
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.setVisible();
    }

    private void setVisible() {
        DynamicObject busObj = (DynamicObject)this.getModel().getValue("businessobject");
        PromptServiceHelper.setFieldVisible((IFormView)this.getView(), (DynamicObject)busObj);
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_promptrule");
        boolean promptExists = ruleHelper.isExists(new QFilter("entryentity.entryprompt", "=", this.getModel().getDataEntity().getPkValue()));
        this.getView().setVisible(Boolean.valueOf(promptExists), new String[]{"tabpageap1"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Object selectValue = this.getModel().getValue("selectcontent");
        boolean isSysPreset = (Boolean)this.getModel().getValue("issyspreset");
        boolean isSelectSys = "1".equals(selectValue);
        this.setCaption(isSysPreset, status, isSelectSys);
        this.setVisibleBySelectContentAndLangType();
    }

    private void setVisibleBySelectContentAndLangType() {
        Object selectValue = this.getModel().getValue("selectcontent");
        boolean isSysPreset = (Boolean)this.getModel().getValue("issyspreset");
        boolean isSelectSys = "1".equals(selectValue);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        ILocaleString sysLangText = (ILocaleString)this.getModel().getValue("syslangcontent");
        boolean isRichType = "1".equals(this.getModel().getValue("langtype"));
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
            if (isSelectSys) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4", "flexpanelap1", "promptlangcontent"});
                if (!isSysPreset) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap"});
                }
                if (HRStringUtils.isEmpty((String)sysLangText.getLocaleValue())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"syslangcontent"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap10", "tabap"});
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap10", "syslangcontent"});
                if (isRichType) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"promptlangcontent"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1", "tabap"});
                }
            }
        } else {
            if (isSelectSys) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap", "flexpanelap4", "flexpanelap1", "promptlangcontent"});
                if (HRStringUtils.isEmpty((String)sysLangText.getLocaleValue())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"syslangcontent"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap10", "tabap"});
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap10", "syslangcontent"});
                if (isRichType) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"promptlangcontent"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1", "tabap", "flexpanelap"});
                }
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap"});
        }
        this.getView().setVisible(Boolean.valueOf(isSysPreset), new String[]{"flexpanelap6"});
    }

    private void initEntryGrid(DynamicObject[] promptRuleDys) {
        if (ArrayUtils.isNotEmpty((Object[])promptRuleDys)) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", promptRuleDys.length);
            for (int tag = 0; tag < promptRuleDys.length; ++tag) {
                ILocaleString description;
                ILocaleString controlType;
                DynamicObject promptRuleDy = promptRuleDys[tag];
                this.getModel().setValue("ruleid", (Object)promptRuleDy.getString("id"), tag);
                this.getModel().setValue("rulenumber", (Object)promptRuleDy.getString("number"), tag);
                this.getModel().setValue("rulename", (Object)promptRuleDy.getLocaleString("name").getLocaleValue(), tag);
                this.getModel().setValue("rulecontrol", promptRuleDy.get("controlname"), tag);
                DynamicObject formDy = promptRuleDy.getDynamicObject("businessobject");
                if (Objects.nonNull(formDy)) {
                    this.getModel().setValue("ruleform", (Object)formDy.getLocaleString("name"), tag);
                }
                if (Objects.nonNull(controlType = promptRuleDy.getLocaleString("controltype"))) {
                    this.getModel().setValue("controltype", (Object)controlType.getLocaleValue(), tag);
                }
                if (!Objects.nonNull(description = promptRuleDy.getLocaleString("description"))) continue;
                this.getModel().setValue("ruledescription", (Object)description.getLocaleValue(), tag);
            }
            this.getView().sendFormAction(this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        this.getView().getPageCache().remove("LocaleContent");
    }

    private void setCache() {
        ILocaleString sysLangText;
        boolean isSysLangEmpty;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HRBaseServiceHelper contentHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        Object[] contentDys = contentHelper.query("promptcontent,locale,locale.number,syscontent", new QFilter[]{new QFilter("prompt", "=", dataEntity.getPkValue())});
        boolean isSys = (Boolean)this.getModel().getValue("issyspreset");
        boolean isDiyEmpty = false;
        if (isSys) {
            int noRichEmptyCount = 0;
            InteServiceImpl intService = new InteServiceImpl();
            Set langIdList = intService.getEnabledLang().stream().map(EnabledLang::getId).map(Long::valueOf).collect(Collectors.toSet());
            for (Object contentDy : contentDys) {
                String promptContent = contentDy.getString("promptcontent");
                if (StringUtils.isEmpty((CharSequence)promptContent) || !langIdList.contains(contentDy.getLong("locale.id"))) continue;
                ++noRichEmptyCount;
            }
            boolean isLangEmpty = false;
            if (CollectionUtils.isEmpty((Map)dataEntity.getLocaleString("promptlangcontent"))) {
                isLangEmpty = true;
            } else {
                int noEmptyCount = 0;
                for (Map.Entry entry : dataEntity.getLocaleString("promptlangcontent").entrySet()) {
                    if (HRStringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                    ++noEmptyCount;
                }
                if (noEmptyCount == 0) {
                    isLangEmpty = true;
                }
            }
            if (noRichEmptyCount == 0 && isLangEmpty) {
                isDiyEmpty = true;
            }
        }
        if (!(isSysLangEmpty = HRStringUtils.isEmpty((String)(sysLangText = dataEntity.getLocaleString("syslangcontent")).getLocaleValue())) && isDiyEmpty) {
            this.getModel().setValue("promptlangcontent", (Object)sysLangText);
        }
        if (ArrayUtils.isNotEmpty((Object[])contentDys)) {
            HashMap localeContent = Maps.newHashMapWithExpectedSize((int)4);
            Hint hint = (Hint)this.getControl("hintap");
            RichTextEditor edit = (RichTextEditor)this.getView().getControl("promptcontent");
            for (Object contentDy : contentDys) {
                String sysContent = contentDy.getString("syscontent");
                String diyContent = contentDy.getString("promptcontent");
                HashMap contentMap = Maps.newHashMapWithExpectedSize((int)4);
                if (isDiyEmpty && isSysLangEmpty) {
                    diyContent = sysContent;
                }
                contentMap.put("2", diyContent);
                contentMap.put("1", sysContent);
                localeContent.put(contentDy.getString("locale.id"), contentMap);
                if (!Objects.equals(Lang.get().name(), contentDy.getString("locale.number"))) continue;
                hint.setHintContent(StringUtils.isEmpty((CharSequence)sysContent) ? "" : sysContent);
                this.getPageCache().put("syscontent", sysContent);
                if (StringUtils.isEmpty((CharSequence)diyContent)) continue;
                edit.setText(diyContent);
            }
            this.getPageCache().put("LocaleContent", SerializationUtils.toJsonString((Object)localeContent));
        }
    }

    private void setSelectContent() {
        String value = (String)this.getModel().getValue("selectcontent");
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.getModel().setValue("selectcontent", (Object)"2");
        }
    }

    private void setCaption(boolean isSysPreset, OperationStatus status, boolean isSelectSys) {
        String captionStr;
        if (OperationStatus.VIEW.equals((Object)status) && isSelectSys) {
            captionStr = ResManager.loadKDString((String)"\u7cfb\u7edf\u6587\u6848", (String)"PromptInitPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        } else if (isSysPreset && !OperationStatus.VIEW.equals((Object)status)) {
            captionStr = ResManager.loadKDString((String)"\u6587\u6848\u914d\u7f6e", (String)"PromptInitPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        } else {
            return;
        }
        HashMap captionMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap caption = Maps.newHashMapWithExpectedSize((int)3);
        captionMap.put(Lang.get().name(), captionStr);
        caption.put("text", captionMap);
        this.getView().updateControlMetadata("advconap", (Map)caption);
    }
}

