/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.prompt;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.constants.ProjectNameConstants;
import kd.hr.hrcs.formplugin.web.prompt.utils.HRPromptTreeSearchServiceHelper;

public class PromptLeftTreeHelper {
    private static final int ENTITY_MAP_INITIALCAPACITY = 300;
    private static final String ENTITY_MODEL_TYPE = "'BillFormModel', 'BaseFormModel', 'DynamicFormModel', 'MobileFormModel'";
    private static final String SYS_CLOUD_ID = "83bfebc800000bac";

    public static List<Map<String, String>> getBizCloud() {
        String localeid = RequestContext.get().getLang().name();
        List cloudIdsSortList = HRCloudServiceHelper.getAllHRCommonCloudIdsSort();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, al.fname ");
        sql.append(" from t_meta_bizcloud a ");
        sql.append(" inner join t_meta_bizcloud_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(" where ").append("a.fid in (").append(HRPromptTreeSearchServiceHelper.list2JoinStr(cloudIdsSortList)).append(')');
        sql.append(" and al.flocaleid = '").append(localeid).append("' ");
        sql.append(" and a.fvisible = '1' ");
        String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (HRStringUtils.isNotEmpty((String)cloudBlacklist)) {
            sql.append(" and a.fid not in (").append(cloudBlacklist).append(") ");
        }
        sql.append(" and ( exists ( ");
        sql.append("   select 1 from t_meta_entitydesign e ");
        sql.append("   left join t_meta_bizunitrelform b ");
        sql.append("   on e.fid = b.fformid ");
        sql.append("   left join t_meta_bizapp c ");
        sql.append("   on b.fbizappid = c.fid  ");
        sql.append("   LEFT JOIN t_meta_mainentityinfo f  ");
        sql.append("   on f.fdentityid = b.fformid  ");
        sql.append("   where e.fmodeltype IN (");
        sql.append(ENTITY_MODEL_TYPE);
        sql.append(") ");
        sql.append("   and  c.fbizcloudid = a.fid ");
        sql.append("   and  c.fvisible = '1' ");
        sql.append("   and  e.fistemplate = '0' ) ");
        sql.append(" ) order by a.fseq asc");
        List bizCloudList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            ArrayList<Map> result = new ArrayList<Map>(10);
            while (rs.next()) {
                HashMap<String, String> bizCloudMap = new HashMap<String, String>(16);
                bizCloudMap.put("id", "1_split_" + rs.getString(1));
                bizCloudMap.put("name", rs.getString(2));
                result.add(bizCloudMap);
            }
            result.sort(Comparator.comparing(x -> {
                String cloudId = ((String)x.get("id")).substring(8);
                return cloudIdsSortList.indexOf(cloudId);
            }));
            return result;
        });
        return bizCloudList;
    }

    public static Set<String> getAllHRCloudId() {
        String sql = "SELECT FID FROM T_HRCS_HRCLOUD ";
        return (Set)HRDBUtil.query((DBRoute)ProjectNameConstants.DB_ROUTE_HRCS, (String)sql, (Object[])new Object[0], rs -> {
            HashSet set = Sets.newHashSetWithExpectedSize((int)16);
            while (rs.next()) {
                set.add(rs.getString(1));
            }
            return set;
        });
    }

    public static String getAllHRCloudIdInStr() {
        Set<String> hrCloudIds = PromptLeftTreeHelper.getAllHRCloudId();
        if (CollectionUtils.isEmpty(hrCloudIds)) {
            return "''";
        }
        return hrCloudIds.stream().map(hrcloudId -> '\'' + hrcloudId + '\'').collect(Collectors.joining(", "));
    }

    public static Map<String, String> getBizObjectById(String entityId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.fid, b.fname from t_meta_mainentityinfo a ");
        sql.append(" INNER JOIN t_meta_mainentityinfo_l b on (a.fid = b.fid and b.flocaleid = ?) ");
        sql.append(" where a.fdentityid = ? ");
        sql.append(" and a.fistemplate = '0'  ");
        sql.append(" and a.fmodeltype in (");
        sql.append(ENTITY_MODEL_TYPE);
        sql.append(") ");
        Object[] filters = new String[]{RequestContext.get().getLang().name(), entityId};
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(16);
            while (rs.next()) {
                result.put("number", rs.getString("fid"));
                result.put("name", rs.getString("fname"));
            }
            return result;
        });
    }

    public static List<String> getEntityNumByCloudId(String cloudId) {
        String sql = "select a.fnumber from t_meta_entitydesign a  left join t_meta_bizunitrelform b on a.fid = b.fformid  left join t_meta_bizapp c on b.fbizappid = c.fid  where c.fbizcloudid = ?  and  c.fvisible = '1' and a.fistemplate = '0' ";
        String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
        if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
            sql = sql + " and c.fid not in (" + appBlacklist + ")";
        }
        Object[] filters = new String[]{cloudId};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])filters, rs -> {
            ArrayList<String> result = new ArrayList<String>(300);
            while (rs.next()) {
                result.add(rs.getString("fnumber"));
            }
            return result;
        });
    }

    public static List<String> getAllExtAppId(String appId) {
        ArrayList<String> result = new ArrayList<String>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter filter = new QFilter("id", "=", (Object)appId);
        DynamicObject app = serviceHelper.queryOne("id,inheritpath,masterid", filter);
        result.add(appId);
        String inheritPath = app.getString("inheritpath");
        if (!StringUtils.isEmpty((Object)inheritPath)) {
            String[] split = inheritPath.split(",");
            Collections.addAll(result, split);
        }
        return result;
    }

    public static Map<String, String> getBizObjectName(Set<String> entityIds) {
        HashMap<String, String> result = new HashMap<String, String>(entityIds.size());
        if (!CollectionUtils.isEmpty(entityIds)) {
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT a.fid,a.fdentityid, b.fname from t_meta_mainentityinfo a ");
            sql.append(" INNER JOIN t_meta_mainentityinfo_l b on (a.fid = b.fid and b.flocaleid = ?) ");
            sql.append(" where a.fdentityid in (");
            ArrayList paramList = Lists.newArrayListWithExpectedSize((int)entityIds.size());
            paramList.add(RequestContext.get().getLang().name());
            entityIds.forEach(entityId -> sql.append("?,"));
            sql.delete(sql.length() - 1, sql.length());
            paramList.addAll(entityIds);
            sql.append(") ");
            sql.append(" and a.fistemplate = '0'  ");
            sql.append(" and a.fmodeltype in (");
            sql.append(ENTITY_MODEL_TYPE);
            sql.append(") ");
            return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
                while (rs.next()) {
                    result.put(rs.getString("fdentityid"), rs.getString("fname"));
                }
                return result;
            });
        }
        return result;
    }
}

