/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.prompt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.prompt.PromptServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class PromptViewPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        Long promptPkValue = (Long)this.getView().getFormShowParameter().getCustomParam("prompt");
        String entityStr = (String)this.getView().getFormShowParameter().getCustomParam("businessobject");
        HRBaseServiceHelper contentHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        DynamicObject[] contentColl = contentHelper.query("promptcontent,locale,syscontent", new QFilter[]{new QFilter("prompt", "=", (Object)promptPkValue)});
        DynamicObject[] prompts = PromptServiceHelper.getPrompts((List)Lists.newArrayList((Object[])new Long[]{promptPkValue}));
        DynamicObject prompt = prompts[0];
        String selContent = prompt.getString("selectcontent");
        boolean isSys = "1".equals(selContent);
        Map<String, String> localeContent = Arrays.stream(contentColl).collect(Collectors.toMap(dy -> dy.getDynamicObject("locale").getString("id"), dy -> {
            String content = isSys ? dy.getString("syscontent") : dy.getString("promptcontent");
            content = PromptServiceHelper.parseDiyVariable((String)content);
            Optional.ofNullable(entityStr).ifPresent(contentStr -> {
                HRBaseServiceHelper entityServiceHelper = new HRBaseServiceHelper(entityStr);
                PromptServiceHelper.parsePromptContent((String)entityStr, (String)contentStr, (DynamicObject)entityServiceHelper.generateEmptyDynamicObject());
            });
            return content == null ? "" : content;
        }));
        InteServiceImpl intService = new InteServiceImpl();
        Object[] langIdList = intService.getEnabledLang().stream().map(EnabledLang::getId).map(Long::valueOf).toArray();
        HRBaseServiceHelper languageHelper = new HRBaseServiceHelper("inte_language");
        DynamicObject[] languageDys = languageHelper.loadDynamicObjectArray(langIdList);
        ComboEdit combo = (ComboEdit)this.getControl("locale");
        ArrayList languageList = Lists.newArrayListWithCapacity((int)languageDys.length);
        String currentLangId = null;
        boolean isLang = "2".equals(prompt.getString("langtype"));
        ILocaleString sysLang = prompt.getLocaleString("syslangcontent");
        ILocaleString promptLang = prompt.getLocaleString("promptlangcontent");
        for (DynamicObject languageDy : languageDys) {
            if (Lang.get().name().equals(languageDy.getString("number"))) {
                currentLangId = languageDy.getString("id");
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(languageDy.getLocaleString("name").getLocaleValue()));
            comboItem.setValue(languageDy.getString("id"));
            languageList.add(comboItem);
            if (isSys) {
                if (PromptServiceHelper.isMulLangEmpty((ILocaleString)sysLang)) continue;
                localeContent.put(languageDy.getString("id"), (String)sysLang.get((Object)languageDy.getString("number")));
                continue;
            }
            if (!isLang) continue;
            localeContent.put(languageDy.getString("id"), (String)promptLang.get((Object)languageDy.getString("number")));
        }
        combo.setComboItems((List)languageList);
        this.getModel().setValue("locale", currentLangId);
        Hint hint = (Hint)this.getControl("hintap");
        hint.setContent(promptPkValue, localeContent.get(currentLangId) == null ? "" : localeContent.get(currentLangId));
        this.getView().getPageCache().put("LocaleContent", SerializationUtils.toJsonString(localeContent));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String changeKey = args.getProperty().getName();
        Hint hint = (Hint)this.getView().getControl("hintap");
        if ("locale".equals(changeKey)) {
            ChangeData changeData;
            String contentCache = this.getPageCache().get("LocaleContent");
            Map localeContent = (Map)SerializationUtils.fromJsonString((String)contentCache, Map.class);
            String newContent = (String)localeContent.get((changeData = args.getChangeSet()[0]).getNewValue());
            hint.setConent(HRStringUtils.isNotEmpty((String)newContent) ? newContent : null);
        }
    }
}

