/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.prompt.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class HRPromptTreeSearchServiceHelper {
    public static void reBuildTreeBySearchKey(TreeView treeView, String searchText) {
        treeView.deleteAllNodes();
        List<Map<String, String>> entities = HRPromptTreeSearchServiceHelper.getEntitiesBySearchKey(searchText);
        Set<String> appIds = entities.stream().map(entity -> (String)entity.get("appId")).collect(Collectors.toSet());
        List<Map<String, String>> apps = HRPromptTreeSearchServiceHelper.getAppsByIds(appIds);
        Set<String> cloudIds = apps.stream().map(app -> (String)app.get("cloudId")).collect(Collectors.toSet());
        List<Map<String, String>> clouds = HRPromptTreeSearchServiceHelper.getCloudsByIds(cloudIds);
        HRPromptTreeSearchServiceHelper.addTreeNodeByLists(treeView, clouds, apps, entities);
    }

    public static TreeNode buildRootNode() {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"HREntityTreeListPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "1010", rootName, true);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private static void addTreeNodeByLists(TreeView treeView, List<Map<String, String>> clouds, List<Map<String, String>> apps, List<Map<String, String>> entitys) {
        TreeNode node;
        String parentId;
        String id;
        TreeNode rootNode = HRPromptTreeSearchServiceHelper.buildRootNode();
        treeView.addNode(rootNode);
        if (CollectionUtils.isEmpty(clouds)) {
            return;
        }
        ArrayList childNodeList = Lists.newArrayListWithExpectedSize((int)clouds.size());
        for (Map<String, String> cloud : clouds) {
            id = "1_split_" + cloud.get("id");
            TreeNode node2 = new TreeNode("1010", id, cloud.get("name"), true);
            node2.setIsOpened(true);
            childNodeList.add(node2);
        }
        for (Map<String, String> app : apps) {
            id = "2_split_" + app.get("id");
            parentId = "1_split_" + app.get("cloudId");
            node = new TreeNode(parentId, id, app.get("name"), true);
            node.setIsOpened(true);
            childNodeList.add(node);
        }
        for (Map<String, String> entity : entitys) {
            id = "3_split_" + entity.get("id");
            parentId = "2_split_" + entity.get("appId");
            node = new TreeNode(parentId, id, entity.get("name"), false);
            childNodeList.add(node);
        }
        treeView.addNodes((List)childNodeList);
    }

    private static List<Map<String, String>> getEntitiesBySearchKey(String searchText) {
        List originAppIdList = HRAppServiceHelper.getSortedHRAppIds();
        Set<String> allAppId = HRPromptTreeSearchServiceHelper.getAllAppId(originAppIdList);
        String sql = " select a.fdentityid,b.fname,a.fbizappid,c.fmasterid,c.finheritpath from t_meta_mainentityinfo a  left join t_meta_mainentityinfo_l b on (a.fid = b.fid and b.flocaleid=?)  left join t_meta_bizapp c on c.fid = a.fbizappid  where a.fbizappid in (" + HRPromptTreeSearchServiceHelper.list2JoinStr(new HashSet<String>(allAppId)) + ") and a.fmodeltype in (" + "'BillFormModel', 'BaseFormModel', 'DynamicFormModel', 'MobileFormModel'" + ")  and a.fistemplate = '0' and b.fname like ? ";
        String entityBlacklist = RunModeServiceHelper.getEntityIdFromBlacklist();
        if (HRStringUtils.isNotEmpty((String)entityBlacklist)) {
            sql = sql + " and a.fdentityid not in (" + entityBlacklist + ")";
        }
        String langStr = RequestContext.get().getLang().name();
        Object[] params = new String[]{langStr, '%' + searchText + '%'};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
            HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)16);
            while (rs.next()) {
                String id = rs.getString("fdentityid");
                String bizAppId = rs.getString("fbizappid");
                String masterId = rs.getString("fmasterid");
                HashMap entityMap = Maps.newHashMapWithExpectedSize((int)3);
                entityMap.put("id", id);
                entityMap.put("name", rs.getString("fname"));
                if (!StringUtils.isEmpty((CharSequence)masterId)) {
                    entityMap.put("appId", masterId);
                } else {
                    entityMap.put("appId", bizAppId);
                }
                appIdSet.add(entityMap.get("appId"));
                result.add(entityMap);
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
            QFilter qFilter = new QFilter("masterid", "in", (Object)appIdSet);
            DynamicObject[] apps = serviceHelper.query("id,inheritpath,masterid", new QFilter[]{qFilter});
            HashMap deepestExtMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject app : apps) {
                String id = app.getString("id");
                String masterId = app.getString("masterid");
                String inheritPath = app.getString("inheritpath");
                if (StringUtils.isEmpty((CharSequence)masterId)) continue;
                HRPromptTreeSearchServiceHelper.findDeepestExtAndReplace(id, masterId, inheritPath, deepestExtMap);
            }
            result.forEach(map -> {
                String[] ext = (String[])deepestExtMap.get(map.get("appId"));
                if (ext != null) {
                    map.put("appId", ext[0]);
                }
            });
            return result;
        });
    }

    private static List<Map<String, String>> getAppsByIds(Set<String> appIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter qFilter = new QFilter("id", "in", appIds);
        qFilter.and(new QFilter("deploystatus", "=", (Object)"2")).and(new QFilter("id", "not in", RunModeServiceHelper.getAppBlacklist().keySet()));
        DynamicObject[] apps = serviceHelper.query("id,inheritpath,masterid,name,bizcloud", new QFilter[]{qFilter});
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        for (DynamicObject app : apps) {
            String id = app.getString("id");
            HashMap appMap = Maps.newHashMapWithExpectedSize((int)3);
            appMap.put("id", id);
            appMap.put("name", app.getString("name"));
            appMap.put("cloudId", app.getString("bizcloud.id"));
            result.add(appMap);
        }
        return result;
    }

    private static List<Map<String, String>> getCloudsByIds(Set<String> cloudIds) {
        List cloudIdSortList = HRCloudServiceHelper.getAllHRCommonCloudIdsSort();
        String cloudIdStr = HRPromptTreeSearchServiceHelper.list2JoinStr(cloudIds);
        String sql = "select a.fid,b.fname from t_meta_bizcloud a  left join t_meta_bizcloud_l b on (a.fid=b.fid and b.flocaleid=?)  where a.fid in (" + cloudIdStr + ") and a.fvisible='1' ";
        String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (HRStringUtils.isNotEmpty((String)cloudBlacklist)) {
            sql = sql + " and a.fid not in (" + cloudBlacklist + ")";
        }
        String langStr = RequestContext.get().getLang().name();
        Object[] params = new String[]{langStr};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            ArrayList<Map> result = new ArrayList<Map>(16);
            while (rs.next()) {
                HashMap cloudMap = Maps.newHashMapWithExpectedSize((int)3);
                cloudMap.put("id", rs.getString("fid"));
                cloudMap.put("name", rs.getString("fname"));
                result.add(cloudMap);
                result.sort(Comparator.comparing(x -> cloudIdSortList.indexOf(x.get("id"))));
            }
            return result;
        });
    }

    public static String list2JoinStr(Collection<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "''";
        }
        return list.stream().map(str -> "'" + str + "'").collect(Collectors.joining(", "));
    }

    private static Set<String> getAllAppId(List<String> originAppIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObject[] results = serviceHelper.query("id,masterid,inheritpath", new QFilter[]{new QFilter("masterid", "in", originAppIdList), new QFilter("visible", "=", (Object)true), new QFilter("deploystatus", "=", (Object)"2")});
        HashSet originAppIdSet = Sets.newHashSet(originAppIdList);
        for (DynamicObject result : results) {
            originAppIdSet.add(result.getString("id"));
        }
        return originAppIdSet;
    }

    public static void findDeepestExtAndReplace(String id, String masterId, String inheritPath, Map<String, String[]> extMap) {
        String[] ext = extMap.get(masterId);
        if (ext != null) {
            if (ext[1].length() < inheritPath.length()) {
                ext[0] = id;
                ext[1] = inheritPath;
            }
        } else {
            extMap.put(masterId, new String[]{id, inheritPath});
        }
    }

    public static void addAppIdByTree(String id, String masterId, String inheritPath, Set<String> appIdSet, Map<String, String[]> extMap) {
        if (!StringUtils.isEmpty((CharSequence)masterId)) {
            HRPromptTreeSearchServiceHelper.findDeepestExtAndReplace(id, masterId, inheritPath, extMap);
        } else {
            appIdSet.add(id);
        }
    }
}

