/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.prompt.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRStandardTreeList;
import kd.hr.hrcs.formplugin.web.prompt.PromptLeftTreeHelper;
import kd.hr.hrcs.formplugin.web.prompt.utils.HRPromptTreeSearchServiceHelper;
import kd.hr.hrcs.formplugin.web.prompt.utils.HRPromptTreeServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class PromptTreeList
extends HRStandardTreeList {
    private HRPromptTreeServiceHelper treeHelper;

    public PromptTreeList(String entityName) {
        super(entityName);
    }

    public void initialize() {
        super.initialize();
        TreeView treeView = this.getTreeView();
        this.treeHelper = new HRPromptTreeServiceHelper(treeView);
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeview");
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (HRStringUtils.isEmpty((String)searchText)) {
            this.treeHelper.reBuildWholeTree();
        } else {
            TreeView treeView = this.getTreeView();
            HRPromptTreeSearchServiceHelper.reBuildTreeBySearchKey(treeView, searchText);
        }
        this.getView().updateView("treeview");
    }

    protected DynamicObject genTreeDyo() {
        MainEntityType rootDyoEntityType = new MainEntityType();
        rootDyoEntityType.setName("treeDyo");
        rootDyoEntityType.setDbIgnore(true);
        rootDyoEntityType.registerSimpleProperty(new DynamicSimpleProperty("id", String.class, (Object)""));
        rootDyoEntityType.registerSimpleProperty(new DynamicSimpleProperty("name", String.class, (Object)""));
        rootDyoEntityType.registerSimpleProperty(new DynamicSimpleProperty("longnumber", String.class, (Object)""));
        rootDyoEntityType.registerSimpleProperty(new DynamicSimpleProperty("parent", String.class, (Object)""));
        rootDyoEntityType.registerSimpleProperty(new DynamicSimpleProperty("isleaf", Boolean.class, (Object)Boolean.FALSE));
        return (DynamicObject)rootDyoEntityType.createInstance();
    }

    protected DynamicObject getRootDynamicObject() {
        DynamicObject treeRootDyo = this.genTreeDyo();
        treeRootDyo.set("id", (Object)"1010");
        treeRootDyo.set("name", (Object)ResManager.loadKDString((String)"\u5168\u90e8", (String)"TreeUtils_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        treeRootDyo.set("longnumber", (Object)"1010");
        return treeRootDyo;
    }

    public void beforeItemClick(BeforeItemClickEvent itemClick) {
        super.beforeItemClick(itemClick);
        TreeView tv = (TreeView)this.getControl("treeview");
        String itemKey = itemClick.getItemKey();
        if (HRStringUtils.equals((String)"tblnew", (String)itemKey)) {
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            this.getView().getPageCache().put("nodeId", focusNodeId);
        }
    }

    protected DynamicObjectCollection getTreeViewCollection(String entityName, String parentId) {
        if (HRStringUtils.equals((String)parentId, (String)"1010")) {
            return this.getBizCloudNode(parentId);
        }
        String nodeIdPrefix = parentId.split("_split_")[0];
        String parentTrueId = parentId.split("_split_")[1];
        DynamicObjectCollection nodes = new DynamicObjectCollection();
        if (HRStringUtils.equals((String)"1", (String)nodeIdPrefix)) {
            Set<String> appIdSet = this.filterLeftCloud(parentTrueId);
            String localeId = RequestContext.get().getLang().name();
            nodes.addAll((Collection)this.getCloudTreeNodes(parentId, localeId, appIdSet));
        } else if (HRStringUtils.equals((String)"2", (String)nodeIdPrefix)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
            QFilter filter = new QFilter("id", "=", (Object)parentTrueId);
            boolean exists = serviceHelper.isExists(filter);
            if (!exists) {
                this.treeHelper.reBuildWholeTree();
            } else {
                Set<String> entityIdSet = this.filterLeftApp(parentTrueId);
                if (!CollectionUtils.isEmpty(entityIdSet)) {
                    nodes.addAll((Collection)this.getAppTreeNode(parentId, entityIdSet));
                }
            }
        }
        return nodes;
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        super.beforeShowBill(evt);
        TreeView tv = (TreeView)this.getControl("treeview");
        Map map = tv.getTreeState().getFocusNode();
        BillShowParameter bsp = evt.getParameter();
        if (bsp.getStatus().equals((Object)OperationStatus.ADDNEW) && map != null && map.get("id") != null && "3".equals(String.valueOf(map.get("id")).split("_split_")[0])) {
            String entityId = String.valueOf(map.get("id")).split("_split_")[1];
            String appId = String.valueOf(map.get("parentid")).split("_split_")[1];
            if (bsp.getCustomParams() == null) {
                bsp.setCustomParams(Collections.emptyMap());
            }
            Map<String, String> entityInfoMap = PromptLeftTreeHelper.getBizObjectById(entityId);
            bsp.setCustomParam("fsp_custom_param_appId", (Object)appId);
            bsp.setCustomParam("fsp_custom_param_entitynum", (Object)entityInfoMap.get("number"));
        }
    }

    private DynamicObjectCollection getCloudTreeNodes(String parentId, String localeId, Set<String> appIdSet) {
        DynamicObjectCollection treeDyoColl = new DynamicObjectCollection();
        for (String appId : appIdSet) {
            DynamicObject treeRootDyo = this.genTreeDyo();
            String id = "2_split_" + appId;
            String name = (String)AppMetadataCache.getAppInfo((String)appId).getName().get((Object)localeId);
            treeRootDyo.set("id", (Object)id);
            treeRootDyo.set("name", (Object)name);
            treeRootDyo.set("parent", (Object)parentId);
            treeRootDyo.set("isleaf", (Object)Boolean.FALSE);
            treeDyoColl.add((Object)treeRootDyo);
        }
        return treeDyoColl;
    }

    private DynamicObjectCollection getAppTreeNode(String parentId, Set<String> entityIdSet) {
        DynamicObjectCollection treeDyoColl = new DynamicObjectCollection();
        if (CollectionUtils.isEmpty(entityIdSet)) {
            return treeDyoColl;
        }
        Map<String, String> bizObjectMap = PromptLeftTreeHelper.getBizObjectName(entityIdSet);
        for (Map.Entry<String, String> bizObjectEntry : bizObjectMap.entrySet()) {
            DynamicObject treeRootDyo = this.genTreeDyo();
            String id = "3_split_" + bizObjectEntry.getKey();
            String name = bizObjectEntry.getValue();
            treeRootDyo.set("id", (Object)id);
            treeRootDyo.set("name", (Object)name);
            treeRootDyo.set("parent", (Object)parentId);
            treeRootDyo.set("isleaf", (Object)Boolean.TRUE);
            treeDyoColl.add((Object)treeRootDyo);
        }
        return treeDyoColl;
    }

    private DynamicObjectCollection getBizCloudNode(String parentId) {
        List<Map<String, String>> bizCloudList = PromptLeftTreeHelper.getBizCloud();
        DynamicObjectCollection treeDyoColl = new DynamicObjectCollection();
        for (Map<String, String> bizCloudNode : bizCloudList) {
            DynamicObject treeRootDyo = this.genTreeDyo();
            String id = bizCloudNode.get("id");
            String name = bizCloudNode.get("name");
            treeRootDyo.set("id", (Object)id);
            treeRootDyo.set("name", (Object)name);
            treeRootDyo.set("parent", (Object)parentId);
            treeRootDyo.set("isleaf", (Object)Boolean.FALSE);
            treeDyoColl.add((Object)treeRootDyo);
        }
        return treeDyoColl;
    }

    private Set<String> filterLeftCloud(String parentTrueId) {
        DynamicObject[] results;
        List appIdList = HRAppServiceHelper.getSortedHRAppIds();
        QFilter filter = new QFilter("bizcloud", "=", (Object)parentTrueId);
        QFilter filter1 = new QFilter("id", "in", (Object)appIdList);
        filter1.or(new QFilter("masterid", "in", (Object)appIdList));
        QFilter filter2 = new QFilter("deploystatus", "=", (Object)"2");
        QFilter[] qFilters = new QFilter[]{filter, filter1, filter2};
        qFilters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])qFilters, (String)"id");
        HashMap extMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject result : results = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,masterid,inheritpath", (QFilter[])qFilters, (String)"sequence")) {
            String id = result.getString("id");
            String masterId = result.getString("masterid");
            String inheritPath = result.getString("inheritpath");
            HRPromptTreeSearchServiceHelper.addAppIdByTree(id, masterId, inheritPath, appIdSet, extMap);
        }
        appIdSet.removeAll(extMap.keySet());
        extMap.forEach((key, value) -> appIdSet.add(value[0]));
        return appIdSet;
    }

    private Set<String> filterLeftApp(String parentTrueId) {
        List<String> allExtAppId = PromptLeftTreeHelper.getAllExtAppId(parentTrueId);
        allExtAppId.add(parentTrueId);
        QFilter[] qfArr = new QFilter[]{new QFilter("bizapp", "in", allExtAppId)};
        qfArr = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])qfArr, (String)"form");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_unitrelform", (String)"form", (QFilter[])qfArr);
        int loadSize = load.length;
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)loadSize);
        for (DynamicObject dynamicObject : load) {
            idSet.add(dynamicObject.getString("form"));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("dentityid", "in", (Object)idSet)};
        DynamicObject[] entityArr = BusinessDataServiceHelper.load((String)"bos_entityinfo", (String)"id,modeltype,dentityid", (QFilter[])qFilters);
        idSet.clear();
        for (DynamicObject dynamicObject : entityArr) {
            idSet.add(dynamicObject.getString("dentityid"));
        }
        return idSet;
    }

    protected QFilter getNodeFilter(String nodeId) {
        String[] split = nodeId.split("_split_");
        String nodeLevel = split[0];
        String id = split[1];
        QFilter filter = null;
        switch (nodeLevel) {
            case "3": {
                filter = new QFilter("businessobject.dentityid", "=", (Object)id);
                break;
            }
            case "2": {
                HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)64);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
                QFilter qFilter = new QFilter("id", "=", (Object)id);
                DynamicObject result = serviceHelper.queryOne("id,masterid", new QFilter[]{qFilter});
                if (result == null) {
                    this.treeHelper.reBuildWholeTree();
                } else {
                    String masterId = result.getString("masterid");
                    if (!StringUtils.isEmpty((CharSequence)masterId)) {
                        DynamicObject[] results;
                        QFilter qFilter2 = new QFilter("masterid", "=", (Object)masterId);
                        qFilter2.or(new QFilter("id", "=", (Object)masterId));
                        for (DynamicObject dynamicObject : results = serviceHelper.query(new QFilter[]{qFilter2})) {
                            appIdSet.add(dynamicObject.getString("id"));
                        }
                    } else {
                        appIdSet.add(id);
                    }
                }
                filter = new QFilter("app", "in", (Object)appIdSet);
                break;
            }
            case "1": {
                filter = new QFilter("cloud", "=", (Object)id);
                break;
            }
        }
        return filter;
    }
}

