/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.query;

import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.query.QueryTreeListPlugin;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.TemplateTextListColumn;
import kd.bos.list.column.TemplateTextItem;
import kd.bos.list.events.ListHyperLinkClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.enums.query.BizApplyTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.aisearch.EsSyncSchemeConfigService;
import kd.hr.hrcs.bussiness.service.multientity.EntityReleaseInfoService;
import kd.hr.hrcs.formplugin.web.query.SortTreeNode;
import org.apache.commons.lang3.StringUtils;

public class HRQueryTreeListPlugin
extends QueryTreeListPlugin {
    private static final Log logger = LogFactory.getLog(HRQueryTreeListPlugin.class);
    private static final String HRCS_FORMPLUGIN = "hrmp-hrcs-formplugin";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private Map<String, String> ksqlquerytypeMap;
    private Map<String, String> essyncSchemeMap;
    private Map<String, String> bizapplytypeMap;
    private Map<String, DynamicObject> metaMap;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                HRQueryTreeListPlugin.this.ksqlquerytypeMap = HRQueryTreeListPlugin.this.getKsqlquerytype(rows);
                HRQueryTreeListPlugin.this.essyncSchemeMap = HRQueryTreeListPlugin.this.getEsSyncScheme(rows);
                HRQueryTreeListPlugin.this.bizapplytypeMap = HRQueryTreeListPlugin.this.getBizapplytype(rows);
                HRQueryTreeListPlugin.this.metaMap = HRQueryTreeListPlugin.this.getMetaInfo(rows);
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"queryscheme")) {
            String s = this.ksqlquerytypeMap.get(e.getRowData().getString("number"));
            e.setFormatValue((Object)(StringUtils.isEmpty((CharSequence)s) ? "ALGO" : s));
        } else if (HRStringUtils.equals((String)fieldKey, (String)"templatetext")) {
            TemplateTextItem templateTextItem = new TemplateTextItem();
            templateTextItem.setTem("#{essyncscheme}");
            ArrayList data = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", "essyncscheme");
            map.put("text", this.essyncSchemeMap.get(e.getRowData().getString("number")));
            data.add(map);
            templateTextItem.setData(data);
            e.setFormatValue((Object)templateTextItem);
        } else if (HRStringUtils.equals((String)fieldKey, (String)"bizapplytype")) {
            String s = this.bizapplytypeMap.get(e.getRowData().getString("number"));
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = this.bizapplytypeMap.get("default");
            }
            e.setFormatValue((Object)s);
        } else if (HRStringUtils.equals((String)fieldKey, (String)"isvinfo")) {
            DynamicObject object = this.metaMap.get((String)e.getRowData().getPkValue());
            if (object == null) {
                return;
            }
            e.setFormatValue((Object)object.getString("isv"));
        } else if (HRStringUtils.equals((String)fieldKey, (String)"isextended")) {
            DynamicObject object = this.metaMap.get((String)e.getRowData().getPkValue());
            if (object == null) {
                return;
            }
            String inheritpath = object.getString("inheritpath");
            e.setFormatValue((Object)(!StringUtils.isEmpty((CharSequence)inheritpath) ? 1 : 0));
        } else if (HRStringUtils.equals((String)fieldKey, (String)"extentsource")) {
            DynamicObject object = this.metaMap.get((String)e.getRowData().getPkValue());
            if (object == null) {
                return;
            }
            String inheritpath = object.getString("inheritpath");
            if (StringUtils.isNotBlank((CharSequence)inheritpath)) {
                try {
                    MainEntityType entityType = EntityMetadataCache.getDataEntityTypeById((String)inheritpath);
                    e.setFormatValue((Object)entityType.getName());
                }
                catch (Exception ex) {
                    logger.info("dirty data!", (Object)ex.getMessage());
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (evt.getOperationKey().equals("delquery")) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteQueryConfig", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5f53\u524d\u9009\u62e9\u7684\u67e5\u8be2\u914d\u7f6e\u4fe1\u606f\u5417\uff1f", (String)"HRQueryTreeListPlugin_3", (String)HRCS_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            Donothing op = (Donothing)args.getSource();
            String key = op.getOperateKey();
            this.executeOp(key, args);
        }
    }

    private void openEsConfigSchemeForm() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hrcs_essyncschemecfig");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection listSelectedData = listView.getSelectedRows();
        ListSelectedRow row = listSelectedData.get(0);
        DynamicObject object = EsSyncSchemeConfigService.loadByQueryentityId((String)((String)row.getPrimaryKeyValue()));
        showParameter.setPkId(object.getPkValue());
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeOp(String key, BeforeDoOperationEventArgs args) {
        if (!"addquery".equals(key)) return;
        args.setCancel(true);
        Object currentNodeObj = this.getTreeModel().getCurrentNodeId();
        if (currentNodeObj == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u4e91\u4e0b\u7684\u5e94\u7528\u8282\u70b9\u3002", (String)"HRQueryTreeListPlugin_2", (String)HRCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String nodeId = currentNodeObj.toString();
        DynamicObjectCollection dynColl = this.getBizCloudDynamicObjectCollectionByAPPId(nodeId);
        if (!dynColl.isEmpty()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrcs_querydynsource");
            showParameter.getCustomParams().put("currentBizAppId", nodeId);
            showParameter.setCustomParam("sources", this.getView().getFormShowParameter().getCustomParam("sources"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tblnew"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
            return;
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u4fa7\u6811\u5f62\u83dc\u5355\u4e2d\u7684\u4e1a\u52a1\u4e91\u5e94\u7528\u8282\u70b9\u3002", (String)"HRQueryTreeListPlugin_1", (String)HRCS_FORMPLUGIN, (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        if (arg0.getCallBackId().equals("deleteQueryConfig")) {
            if (MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
                this.getView().invokeOperation("delquery");
                StringBuilder errorTip = new StringBuilder();
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                for (ListSelectedRow listSelectedRow : selectedRows) {
                }
                IListView iListView = (IListView)this.getView();
                iListView.refresh();
                if (errorTip.length() > 0) {
                    this.getView().showErrorNotification(errorTip.toString());
                }
            }
        } else {
            super.confirmCallBack(arg0);
        }
    }

    private DynamicObjectCollection getBizCloudDynamicObjectCollectionByAPPId(String id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{qFilter};
        String selectFields = "id";
        DynamicObjectCollection dynObjColl = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        return dynObjColl;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String sources = (String)this.getView().getFormShowParameter().getCustomParam("sources");
        if (StringUtils.isNotBlank((CharSequence)sources)) {
            List list = EntityReleaseInfoService.findQueryentitynameByBizapplytype((String)sources);
            e.addCustomQFilter(new QFilter("number", "in", (Object)list));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        IListView listView = (IListView)this.getView();
        if (!listView.getRootControl().getKey().endsWith("f7")) {
            evt.setCancel(true);
            String queryEntityId = (String)listView.getFocusRowPkId();
            this.openPage(queryEntityId);
        }
    }

    public void hyperLinkClick(ListHyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        if (evt.getKey().equals("essyncscheme")) {
            this.openEsConfigSchemeForm();
        }
    }

    private void openPage(String queryEntityId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_querydynsource");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String queryEntityNumber = MetadataDao.getNumberById((String)queryEntityId);
        showParameter.setCustomParam("queryEntityNumber", (Object)queryEntityNumber);
        showParameter.setCustomParam("queryEntityId", (Object)queryEntityId);
        Map<String, String> appMap = this.getBizAppMap(queryEntityId);
        showParameter.setCustomParam("currentBizAppId", (Object)appMap.get("appId"));
        showParameter.setCustomParam("currentUnitId", (Object)appMap.get("unitId"));
        this.getView().showForm(showParameter);
    }

    private Map<String, String> getBizAppMap(String queryEntityId) {
        String sql = "select a.FBIZAPPID,b.FBIZUNITID from t_meta_formdesign a left join t_meta_bizunitrelform b on a.FBIZAPPID = b.FBIZAPPID and a.fid = b.fformid where a.FID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)queryEntityId)};
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, String> bizUnitMap = new HashMap<String, String>();
            try {
                if (rs.next()) {
                    bizUnitMap.put("appId", rs.getString(1));
                    bizUnitMap.put("unitId", rs.getString(2));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", e.getMessage())});
            }
            return bizUnitMap;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    public void refreshNode(RefreshNodeEvent evt) {
        List<TreeNode> childNodes = this.getChildNodes(evt.getNodeId());
        evt.setChildNodes(childNodes);
    }

    public void initializeTree(EventObject evt) {
        this.intiTree();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        TemplateTextListColumn templateTextListColumn = new TemplateTextListColumn();
        templateTextListColumn.setListFieldKey("templatetext");
        templateTextListColumn.setKey("templatetext");
        templateTextListColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"ES\u540c\u6b65\u65b9\u6848", (String)"HRQueryTreeListPlugin_6", (String)HRCS_FORMPLUGIN, (Object[])new Object[0])));
        args.getListColumns().add(args.getListColumns().size() - 3, templateTextListColumn);
        super.beforeCreateListColumns(args);
    }

    private List<TreeNode> getChildNodes(Object parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getCloudNodes();
            for (TreeNode treeNode : cloudNodes) {
                List<TreeNode> groupNodes = this.getAppNodes(treeNode.getId());
                this.addChildNode(treeNode, groupNodes);
            }
        } else {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode((String)parentId, 20);
            if (node != null) {
                return node.getChildren();
            }
        }
        return cloudNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    private List<TreeNode> getAppNodes(String cloudId) {
        HRBaseServiceHelper cloudAppHelper = new HRBaseServiceHelper("hbss_cloud_app");
        DynamicObject[] apps = cloudAppHelper.queryOriginalArray("app,index", new QFilter[0]);
        Set appIdSet = Arrays.stream(apps).map(el -> el.getString("app")).collect(Collectors.toSet());
        Map<String, Integer> appIndexMap = Arrays.stream(apps).collect(Collectors.toMap(el -> el.getString("app"), dyo -> dyo.getInt("index"), (k1, k2) -> k1));
        ArrayList<SortTreeNode> sortTreeNodeList = new ArrayList<SortTreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            SortTreeNode node = new SortTreeNode(cloudId, refAppId, refAppName, 999);
            sortTreeNodeList.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
            dynamicObjects = this.getMergeAppCollection(dynamicObjects);
            for (DynamicObject dynamicObject : dynamicObjects) {
                String nodeId = dynamicObject.getString("id");
                String masterId = dynamicObject.getString("masterid");
                int index = 0;
                if (appIdSet.contains(nodeId)) {
                    index = appIndexMap.get(nodeId);
                } else {
                    if (!appIdSet.contains(masterId)) continue;
                    index = appIndexMap.get(masterId);
                }
                SortTreeNode node = new SortTreeNode(index);
                node.setId(nodeId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(cloudId);
                node.setData(masterId);
                sortTreeNodeList.add(node);
            }
        }
        sortTreeNodeList.sort(Comparator.comparingInt(SortTreeNode::getIndex));
        return new ArrayList<TreeNode>(sortTreeNodeList);
    }

    private DynamicObjectCollection getMergeAppCollection(DynamicObjectCollection dynamicObjects) {
        HashSet<String> removeAppIdSet = new HashSet<String>();
        for (DynamicObject dynObj : dynamicObjects) {
            String masterId = dynObj.getString("masterid");
            if (StringUtils.isEmpty((CharSequence)masterId)) continue;
            removeAppIdSet.add(masterId);
        }
        DynamicObjectCollection appCollection = new DynamicObjectCollection();
        for (DynamicObject dynObj : dynamicObjects) {
            if (removeAppIdSet.contains(dynObj.getString("id"))) continue;
            appCollection.add((Object)dynObj);
        }
        return appCollection;
    }

    private void intiTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"HRQueryTreeListPlugin_0", (String)HRCS_FORMPLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        for (TreeNode treeNode : cloudNodes) {
            List<TreeNode> groupNodes = this.getAppNodes(treeNode.getId());
            this.addChildNode(treeNode, groupNodes);
        }
        root.addChildren(cloudNodes);
        this.getPageCache().put("treenodecache", SerializationUtils.toJsonString((Object)root));
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DEL});
        }
    }

    private List<TreeNode> getCloudNodes() {
        ArrayList<SortTreeNode> sortTreeNodeList = new ArrayList<SortTreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if ("extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)refAppId);
            SortTreeNode node = new SortTreeNode("-1", cloudObject.getString("id"), cloudObject.getLocaleString("name").getLocaleValue(), 0);
            sortTreeNodeList.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
            HRBaseServiceHelper cloudHelper = new HRBaseServiceHelper("hbss_cloud");
            DynamicObject[] clouds = cloudHelper.queryOriginalArray("cloud,index", new QFilter[0]);
            Set cloudIdSet = Arrays.stream(clouds).map(el -> el.getString("cloud")).collect(Collectors.toSet());
            Map<String, Integer> cloudIndex = Arrays.stream(clouds).collect(Collectors.toMap(el -> el.getString("cloud"), dyo -> dyo.getInt("index"), (k1, k2) -> k1));
            for (DynamicObject dynamicObject : dynamicObjects) {
                String cloudId = dynamicObject.getString("id");
                if (!cloudIdSet.contains(cloudId)) continue;
                int index = cloudIndex.get(cloudId);
                SortTreeNode node = new SortTreeNode(index);
                node.setId(cloudId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid("-1");
                sortTreeNodeList.add(node);
            }
        }
        sortTreeNodeList.sort(Comparator.comparingInt(SortTreeNode::getIndex));
        return new ArrayList<TreeNode>(sortTreeNodeList);
    }

    private Map<String, String> getKsqlquerytype(DynamicObjectCollection rows) {
        ArrayList<String> numbers = new ArrayList<String>(rows.size());
        for (DynamicObject row : rows) {
            numbers.add(row.getString("number"));
        }
        DynamicObject[] entityReleaseInfoListByName = EntityReleaseInfoService.getEntityReleaseInfoListByName(numbers);
        HashMap<String, String> map = new HashMap<String, String>(Maps.newHashMapWithExpectedSize((int)rows.size()));
        for (DynamicObject row : entityReleaseInfoListByName) {
            map.put(row.getString("queryentityname"), row.getString("datasourcetype"));
        }
        return map;
    }

    private Map<String, String> getEsSyncScheme(DynamicObjectCollection rows) {
        ArrayList<String> numbers = new ArrayList<String>(rows.size());
        for (DynamicObject row : rows) {
            numbers.add(row.getString("number"));
        }
        DynamicObjectCollection esschemes = EsSyncSchemeConfigService.findByQueryEntity(numbers);
        HashMap<String, String> map = new HashMap<String, String>(Maps.newHashMapWithExpectedSize((int)rows.size()));
        for (DynamicObject row : esschemes) {
            map.put(row.getString("queryentity.number"), row.getString("name"));
        }
        return map;
    }

    private Map<String, String> getBizapplytype(DynamicObjectCollection rows) {
        ArrayList<String> numbers = new ArrayList<String>(rows.size());
        for (DynamicObject row : rows) {
            numbers.add(row.getString("number"));
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hrcs_entityreleaseinfo");
        Map allFields = dataEntityType.getAllFields();
        IDataEntityProperty enable = (IDataEntityProperty)allFields.get("bizapplytype");
        ComboProp temp = (ComboProp)enable;
        DynamicObject[] entityReleaseInfoListByName = EntityReleaseInfoService.getEntityReleaseInfoListByName(numbers);
        HashMap<String, String> map = new HashMap<String, String>(Maps.newHashMapWithExpectedSize((int)rows.size()));
        map.put("default", temp.getItemByName(BizApplyTypeEnum.Query.getValue()));
        for (DynamicObject row : entityReleaseInfoListByName) {
            String value = temp.getItemByName(row.getString("bizapplytype"));
            map.put(row.getString("queryentityname"), value);
        }
        return map;
    }

    private Map<String, DynamicObject> getMetaInfo(DynamicObjectCollection rows) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"fid,isv,inheritpath", (QFilter[])new QFilter[]{new QFilter("modeltype", "=", (Object)"QueryListModel")});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(Maps.newHashMapWithExpectedSize((int)rows.size()));
        for (DynamicObject row : objs) {
            map.put(row.getString("id"), row);
        }
        return map;
    }
}

