/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.queryf7;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.designer.property.FiltersNewPlugin;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.FilterGrid;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.IBasedataField;

public class HRFiltersNewPlugin
extends FiltersNewPlugin {
    private static final String CONTEXT = "context";
    private static final String FILTER_GRIDAP = "filtergridap";
    private static final String FOR_LIST = "forlist";
    private static final String ENTITY_ID = "entityId";
    private FilterCondition condition;

    public void beforeBindData(EventObject e) {
        this.initFilterCondition2();
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRIDAP);
        QueryEntityType entityType = this.getBaseEntityType2();
        if (entityType == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a,\u9875\u9762\u521d\u59cb\u5316\u5931\u8d25", (String)"FiltersNewPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0])});
        }
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(this.getFilterColumns2(entityType));
        EntityMetadata entityMetadata = this.getEntityMetadata2();
        EntityMetadataUtil entityMetadataUtil = new EntityMetadataUtil();
        List fieldColumns = entityMetadataUtil.getFilterColumns(entityMetadata);
        filterGrid.setFieldColumns(fieldColumns);
        if (this.condition != null) {
            this.getModel().setValue(FOR_LIST, (Object)this.condition.isForList());
        }
    }

    public void afterBindData(EventObject e) {
        this.setFilterCondition2();
    }

    private void setFilterCondition2() {
        if (this.condition == null) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRIDAP);
        List<Map<String, Object>> filterColumns = this.getFilterColumns2();
        block0: for (SimpleFilterRow simpleFilterRow : this.condition.getFilterRow()) {
            for (Map<String, Object> map : filterColumns) {
                String fieldName = (String)map.get("fieldName");
                String compareType = simpleFilterRow.getCompareType();
                if (!fieldName.equals(simpleFilterRow.getFieldName())) continue;
                List compareTypeDtos = (List)map.get("compareTypes");
                for (CompareTypeDto compareTypeDto : compareTypeDtos) {
                    if (!compareType.equals(compareTypeDto.getId()) || !compareTypeDto.isFieldCompare()) continue;
                    FilterValue filterValue = (FilterValue)simpleFilterRow.getValue().get(0);
                    filterValue.setValue((Object)filterValue.getValue().toString().replace("GetValue(", "").replace(")", ""));
                    continue block0;
                }
                continue block0;
            }
        }
        filterGrid.SetValue(this.condition);
    }

    private EntityMetadata getEntityMetadata2() {
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        List context = (List)formContext.get(0);
        return EntityMetadataUtil.getEntityMetadata((List)context);
    }

    private QueryEntityType getBaseEntityType2() {
        String entityId = this.getPageCache().get(ENTITY_ID);
        if (entityId == null) {
            List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
            List item = (List)contextList.get(1);
            if (item == null || item.isEmpty()) {
                return null;
            }
            entityId = this.getEntityId2(item);
            if (StringUtils.isBlank((CharSequence)entityId)) {
                return null;
            }
            this.getPageCache().put(ENTITY_ID, entityId);
        }
        return (QueryEntityType)EntityMetadataCache.getDataEntityTypeById((String)entityId);
    }

    private void initFilterCondition2() {
        Object valJson = null;
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (value != null && !StringUtils.isEmpty((CharSequence)value.toString())) {
            valJson = value;
        }
        if (valJson instanceof Map) {
            Map filterConditionMap = valJson;
            ArrayList dts = Lists.newArrayListWithExpectedSize((int)16);
            dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
            dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
            DcJsonSerializer ser = new DcJsonSerializer((Iterable)dts);
            this.condition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        }
    }

    private String getEntityId2(List<Map<String, Object>> item) {
        String entityId = "";
        Object ctrl = this.getSourceControl2(item);
        if (ctrl instanceof IBasedataField) {
            entityId = ((IBasedataField)ctrl).getBaseEntityId();
        }
        return MetadataDao.getMasterId((String)entityId);
    }

    private List<Map<String, Object>> getFilterColumns2() {
        QueryEntityType entityType = this.getBaseEntityType2();
        if (null == entityType) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        return this.getFilterColumns2(entityType);
    }

    private List<Map<String, Object>> getFilterColumns2(QueryEntityType entityType) {
        if (null == entityType) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterColumns = entityTypeUtil.createFilterColumns((IDataEntityType)entityType, true);
        List selectFields = entityType.getSelectFields();
        Map<String, QuerySelectField> fieldMap = selectFields.stream().collect(Collectors.toMap(QuerySelectField::getAlias, Function.identity()));
        List fieldName3 = filterColumns.stream().map(map -> (String)map.get("fieldName")).collect(Collectors.toList());
        ArrayList shaodeList = Lists.newArrayListWithExpectedSize((int)100);
        for (String key : fieldMap.keySet()) {
            if (fieldName3.contains(key)) continue;
            shaodeList.add(key);
        }
        ArrayList addList = Lists.newArrayListWithExpectedSize((int)10);
        List<CompareTypeDto> compareTypes = this.getBasedataCompareTypes();
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)selectFields.size());
        for (Map column : filterColumns) {
            String key;
            String fieldName = (String)column.get("fieldName");
            QuerySelectField querySelectField = (QuerySelectField)fieldMap.get(fieldName);
            if (querySelectField == null) continue;
            column.put("fieldCaption", querySelectField.getDisplayName());
            if (fieldName.contains(".")) {
                String[] names = fieldName.split("\\.");
                if (names.length == 2) {
                    BasedataProp basedataProp;
                    BasedataEntityType basedataEntityType;
                    String propName;
                    DynamicProperty property = entityType.getProperty(names[0]);
                    if (property instanceof JoinProperty && entityType.getProperty(propName = ((JoinProperty)property).getFKProperty().getName()) != null && entityType.getProperty(propName) instanceof BasedataProp && (basedataEntityType = (BasedataEntityType)(basedataProp = (BasedataProp)entityType.getProperty(propName)).getComplexType()).getProperty(names[1]) != null) {
                        column.put("fieldName", propName + "." + names[1]);
                    }
                } else if (names.length > 2 && this.addColumn(entityType, names, fieldMap, fieldName, compareTypes, columns, addList)) continue;
            }
            if (addList.contains(key = (String)column.get("fieldName"))) continue;
            addList.add((String)column.get("fieldName"));
            columns.add(column);
        }
        if (!shaodeList.isEmpty()) {
            for (String fieldName : shaodeList) {
                IDataEntityType iDataEntityType;
                if (addList.contains(fieldName) || addList.contains(fieldName + ".name") || addList.contains(fieldName + ".number")) continue;
                if (fieldName.contains(".")) {
                    String[] names = fieldName.split("\\.");
                    if (names.length <= 2) continue;
                    this.addColumn(entityType, names, fieldMap, fieldName, compareTypes, columns, addList);
                    continue;
                }
                DynamicProperty property1 = entityType.getProperty(fieldName);
                if (!(property1 instanceof BasedataProp) || !((iDataEntityType = ((BasedataProp)property1).getComplexType()) instanceof RefEntityType)) continue;
                String entityId = ((BasedataProp)property1).getBaseEntityId();
                String name = ((RefEntityType)iDataEntityType).getNameProperty();
                String number = ((RefEntityType)iDataEntityType).getNumberProperty();
                this.addNameAndNumber(entityType, entityId, name, number, fieldMap, fieldName, compareTypes, columns, addList);
            }
        }
        return columns;
    }

    private void addNameAndNumber(QueryEntityType entityType, String entityId, String name, String number, Map<String, QuerySelectField> fieldMap, String fieldName, List<CompareTypeDto> compareTypes, List<Map<String, Object>> columns, List<String> addList) {
        String nameKey = fieldName + "." + name;
        if (StringUtils.isNotEmpty((CharSequence)name) && !addList.contains(nameKey)) {
            String fieldCaption = this.getNameCaption(fieldMap.get(fieldName).getDisplayName());
            columns.add(this.getBasedataColumn(entityType.getName(), nameKey, fieldCaption, compareTypes, entityId));
            addList.add(nameKey);
        }
        String numberKey = fieldName + "." + number;
        if (StringUtils.isNotEmpty((CharSequence)number) && !addList.contains(numberKey)) {
            String fieldCaption = this.getNumberCaption(fieldMap.get(fieldName).getDisplayName());
            columns.add(this.getBasedataColumn(entityType.getName(), numberKey, fieldCaption, compareTypes, entityId));
            addList.add(numberKey);
        }
    }

    private boolean addColumn(QueryEntityType entityType, String[] names, Map<String, QuerySelectField> fieldMap, String fieldName, List<CompareTypeDto> compareTypes, List<Map<String, Object>> columns, List<String> addList) {
        IDataEntityType iDataEntityType;
        Object property3;
        Object property2;
        int length = addList.size();
        DynamicProperty property1 = entityType.getProperty(names[0]);
        if (property1 instanceof BasedataProp && (property2 = ((BasedataProp)property1).getComplexType().getProperties().get((Object)names[1])) instanceof BasedataProp && (property3 = ((BasedataProp)property2).getComplexType().getProperties().get((Object)names[2])) instanceof BasedataProp && (iDataEntityType = ((BasedataProp)property3).getComplexType()) instanceof RefEntityType) {
            String entityId = ((BasedataProp)property3).getBaseEntityId();
            String name = ((RefEntityType)iDataEntityType).getNameProperty();
            String number = ((RefEntityType)iDataEntityType).getNumberProperty();
            if (names.length == 3) {
                this.addNameAndNumber(entityType, entityId, name, number, fieldMap, fieldName, compareTypes, columns, addList);
            } else if ((names[3].equals(name) || names[3].equals(number)) && !addList.contains(fieldName)) {
                Map<String, Object> nameColumn = this.getBasedataColumn(entityType.getName(), fieldName, fieldMap.get(fieldName).getDisplayName(), compareTypes, entityId);
                columns.add(nameColumn);
                addList.add(fieldName);
            }
        }
        return addList.size() > length;
    }

    private String getNameCaption(String fieldCaption) {
        return String.format(ResManager.loadKDString((String)"%s.\u540d\u79f0", (String)"HRFiltersNewPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), fieldCaption);
    }

    private String getNumberCaption(String fieldCaption) {
        return String.format(ResManager.loadKDString((String)"%s.\u7f16\u7801", (String)"HRFiltersNewPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]), fieldCaption);
    }

    private Map<String, Object> getBasedataColumn(String entryEntity, String fieldName, String fieldCaption, List<CompareTypeDto> compareTypes, String entityId) {
        HashMap numberColumn = Maps.newHashMapWithExpectedSize((int)8);
        numberColumn.put("entryEntity", entryEntity);
        numberColumn.put("fieldName", fieldName);
        numberColumn.put("compareGroupID", "0,1,2,3,4");
        numberColumn.put("fieldCaption", fieldCaption);
        numberColumn.put("compareTypes", compareTypes);
        numberColumn.put(ENTITY_ID, entityId);
        numberColumn.put("type", "basedata");
        numberColumn.put("fieldType", -9);
        return numberColumn;
    }

    private List<CompareTypeDto> getBasedataCompareTypes() {
        List myCompareTypes = Lists.newArrayListWithExpectedSize((int)18);
        myCompareTypes.addAll(FilterMetadata.get().getCompareTypes("0,1,2,3,4"));
        myCompareTypes = EntityTypeUtil.setCompareTypes((List)myCompareTypes, (boolean)true, (boolean)true, (boolean)false);
        return FilterUtil.getCompareTypeDtos((List)myCompareTypes);
    }

    private Object getSourceControl2(List<Map<String, Object>> item) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        IFormTemplate template = FormTemplateFactory.createTemplate((String)modelType);
        return template.deserializeFromMap(item.get(0), null);
    }
}

