/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.formplugin.web.queryf7;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class HRQueryListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(HRQueryListPlugin.class);
    private static final String BASEENTITYID = "BaseEntityId";
    private static final String CONTEXT = "context";

    public void registerListener(EventObject e) {
        Button btn = (Button)this.getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        if (((Button)evt.getSource()).getKey().equals("btnok")) {
            this.returnData();
        }
        this.getView().close();
    }

    private void returnData() {
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null) {
            this.getView().returnDataToParent(row);
        }
    }

    private Map<String, Object> getCurrentSelector() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0) {
            HashMap para = Maps.newHashMapWithExpectedSize((int)8);
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", selectedRows.get(0).getNumber());
            return para;
        }
        return null;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        ListShowParameter parameter;
        if (e.getFormShowParameter() instanceof ListShowParameter && null != (parameter = (ListShowParameter)e.getFormShowParameter()).getCustomParam("propertyName")) {
            LOGGER.info("propertyName:{}", (Object)parameter.getCustomParam("propertyName").toString());
            String baseEntityId = this.getBaseEntityId(parameter);
            if ("viewDetailList".equals(parameter.getCustomParam("propertyName").toString())) {
                QFilter baseFormModel = new QFilter("modeltype", "=", (Object)"BaseFormModel");
                QFilter parentId = new QFilter("parentid", "=", (Object)baseEntityId);
                QFilter dynamicFormModel = new QFilter("modeltype", "=", (Object)"DynamicFormModel");
                parameter.getListFilterParameter().getQFilters().add(baseFormModel.and(parentId).or(dynamicFormModel));
            } else if ("billFormId".equals(parameter.getCustomParam("propertyName").toString())) {
                QFilter queryListModel = new QFilter("modeltype", "=", (Object)"QueryListModel");
                QFilter entityId = new QFilter("basedatafield", "=", (Object)baseEntityId);
                QFilter id = new QFilter("id", "!=", (Object)baseEntityId);
                parameter.getListFilterParameter().getQFilters().add(queryListModel.and(entityId).and(id));
            }
            LOGGER.info("filter:{}", (Object)parameter.getListFilterParameter().getQFilters().toString());
        }
    }

    private String getBaseEntityId(ListShowParameter parameter) {
        List contextList = (List)parameter.getCustomParam(CONTEXT);
        for (Map context : contextList) {
            if (!((String)context.get("Id")).equals(parameter.getCustomParam("itemId"))) continue;
            if (null != context.get(BASEENTITYID)) {
                return (String)context.get(BASEENTITYID);
            }
            if (null == context.get("personEntityName")) continue;
            return (String)context.get("personEntityName");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u67e5\u8be2\u5b9e\u4f53\u3002", (String)"HRDisplayPropsEdit_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
    }
}

